/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;

public class JDBCBlobFile
implements Blob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_blob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private List m_streams = new ArrayList();

    public long length() throws SQLException {
        this.checkClosed();
        try {
            return this.m_file.length();
        }
        catch (Exception e) {
            throw Util.sqlException(e);
        }
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        int initialBufferSize = Math.min(8192, length);
        try {
            is = this.getBinaryStream(pos, length);
            baos = new ByteArrayOutputStream(initialBufferSize);
            InOutUtil.copy(is, baos, (long)length);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return baos.toByteArray();
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, Long.MAX_VALUE);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (pattern == null || pattern.length == 0 || start > this.length()) {
            return -1L;
        }
        InputStream is = null;
        try {
            is = this.getBinaryStream(start, Long.MAX_VALUE);
            long matchOffset = KMPSearchAlgorithm.search(is, pattern, KMPSearchAlgorithm.computeTable(pattern));
            long l = matchOffset == -1L ? -1L : start + matchOffset;
            return l;
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        long patternLength = pattern == null ? 0L : pattern.length();
        if (patternLength == 0L || start > this.length()) {
            return -1L;
        }
        if (patternLength > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("pattern.length(): " + patternLength);
        }
        byte[] bytePattern = pattern instanceof JDBCBlob ? ((JDBCBlob)pattern).data() : pattern.getBytes(1L, (int)patternLength);
        return this.position(bytePattern, start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes == null ? 0 : bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (bytes == null) {
            throw Util.nullArgument("bytes");
        }
        OutputStream os = this.setBinaryStream(pos);
        try {
            os.write(bytes, offset, len);
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception ex) {}
        }
        return len;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        OutputStreamAdapter adapter;
        if (pos < 1L) {
            throw Util.invalidArgument("pos: " + pos);
        }
        this.checkClosed();
        this.createFile();
        try {
            adapter = new OutputStreamAdapter(this.m_file, pos - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.m_streams.add(adapter);
        BufferedOutputStream result = new BufferedOutputStream(adapter);
        return result;
    }

    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw Util.invalidArgument("len: " + len);
        }
        this.checkClosed();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(len);
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList streams = new ArrayList();
        streams.addAll(this.m_streams);
        this.m_streams = null;
        for (Object stream : streams) {
            if (stream instanceof InputStream) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Exception ex) {}
                continue;
            }
            if (!(stream instanceof OutputStream)) continue;
            try {
                ((OutputStream)stream).close();
            }
            catch (Exception ex) {}
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        InputStreamAdapter result;
        if (pos < 1L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        this.checkClosed();
        try {
            result = new InputStreamAdapter(this.m_file, pos - 1L, length){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.m_streams.add(result);
        return result;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean deleteOnFree) {
        this.m_deleteOnFree = deleteOnFree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    public JDBCBlobFile() throws SQLException {
        this(true);
    }

    public JDBCBlobFile(boolean deleteOnFree) throws SQLException {
        this.m_deleteOnFree = deleteOnFree;
        try {
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX).getCanonicalFile();
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
    }

    public JDBCBlobFile(File file) throws SQLException {
        this(file, false);
    }

    public JDBCBlobFile(File file, boolean deleteOnFree) throws SQLException {
        this.m_deleteOnFree = deleteOnFree;
        try {
            this.m_file = file.getCanonicalFile();
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.checkIsFile(false);
    }

    protected final void checkIsFile(boolean checkExists) throws SQLException {
        boolean exists = false;
        boolean isFile = false;
        try {
            exists = this.m_file.exists();
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        if (exists) {
            try {
                isFile = this.m_file.isFile();
            }
            catch (Exception ex) {
                throw Util.sqlException(ex);
            }
        }
        if (exists) {
            if (!isFile) {
                throw Util.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (checkExists) {
            throw Util.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw Util.sqlException(1251);
        }
    }

    private void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.checkIsFile(true);
    }

    static class InputStreamAdapter
    extends InputStream {
        private final CountdownInputStream m_countdownInputStream;

        InputStreamAdapter(File file, long pos, long length) throws FileNotFoundException, IOException {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            if (length < 0L) {
                throw new IllegalArgumentException("length: " + length);
            }
            FileInputStream fis = new FileInputStream(file);
            if (pos > 0L) {
                long actualPos = fis.skip(pos);
            }
            BufferedInputStream bis = new BufferedInputStream(fis);
            CountdownInputStream cis = new CountdownInputStream(bis);
            cis.setCount(length);
            this.m_countdownInputStream = cis;
        }

        public int available() throws IOException {
            return this.m_countdownInputStream.available();
        }

        public int read() throws IOException {
            return this.m_countdownInputStream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.m_countdownInputStream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.m_countdownInputStream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.m_countdownInputStream.skip(n);
        }

        public void close() throws IOException {
            this.m_countdownInputStream.close();
        }
    }

    protected static class OutputStreamAdapter
    extends OutputStream {
        private final RandomAccessFile m_randomAccessFile;

        public OutputStreamAdapter(File file, long pos) throws FileNotFoundException, IOException {
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(pos);
        }

        public void write(int b) throws IOException {
            this.m_randomAccessFile.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.m_randomAccessFile.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.m_randomAccessFile.write(b, off, len);
        }

        public void flush() throws IOException {
            this.m_randomAccessFile.getFD().sync();
        }

        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }
    }
}

