/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TypeInvariants;
import org.hsqldb.dbinfo.DITableInfo;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

class DatabaseInformationMain
extends DatabaseInformation {
    static Type CARDINAL_NUMBER = TypeInvariants.CARDINAL_NUMBER;
    static Type YES_OR_NO = TypeInvariants.YES_OR_NO;
    static Type CHARACTER_DATA = TypeInvariants.CHARACTER_DATA;
    static Type SQL_IDENTIFIER = TypeInvariants.SQL_IDENTIFIER;
    static Type TIME_STAMP = TypeInvariants.TIME_STAMP;
    protected static final HsqlNameManager.HsqlName[] sysTableHsqlNames;
    protected static final boolean[] sysTableSessionDependent;
    protected static final HashSet nonCachedTablesSet;
    protected static final String[] tableTypes;
    protected final Table[] sysTables = new Table[sysTableNames.length];

    DatabaseInformationMain(Database db) {
        super(db);
        Session session = db.sessionManager.getSysSession();
        this.init(session);
    }

    protected final void addColumn(Table t, String name, Type type) {
        HsqlNameManager cfr_ignored_0 = this.database.nameManager;
        HsqlNameManager.HsqlName cn = HsqlNameManager.newInfoSchemaColumnName(name, t.getName());
        ColumnSchema c = new ColumnSchema(cn, type, true, false, null);
        t.addColumn(c);
    }

    protected final Iterator allTables() {
        return new WrapperIterator(this.database.schemaManager.databaseObjectIterator(3), new WrapperIterator(this.sysTables, true));
    }

    protected final void cacheClear(Session session) {
        int i = this.sysTables.length;
        while (i-- > 0) {
            Table t = this.sysTables[i];
            if (t == null) continue;
            t.clearAllData(session);
        }
    }

    protected Table generateTable(Session session, PersistentStore store, int tableIndex) {
        switch (tableIndex) {
            case 0: {
                return this.SYSTEM_BESTROWIDENTIFIER(session, store);
            }
            case 1: {
                return this.SYSTEM_COLUMNS(session, store);
            }
            case 18: {
                return this.SYSTEM_CONNECTION_PROPERTIES(session, store);
            }
            case 2: {
                return this.SYSTEM_CROSSREFERENCE(session, store);
            }
            case 3: {
                return this.SYSTEM_INDEXINFO(session, store);
            }
            case 4: {
                return this.SYSTEM_PRIMARYKEYS(session, store);
            }
            case 5: {
                return this.SYSTEM_PROCEDURECOLUMNS(session, store);
            }
            case 6: {
                return this.SYSTEM_PROCEDURES(session, store);
            }
            case 7: {
                return this.SYSTEM_SCHEMAS(session, store);
            }
            case 14: {
                return this.SYSTEM_SEQUENCES(session, store);
            }
            case 8: {
                return this.SYSTEM_TABLES(session, store);
            }
            case 9: {
                return this.SYSTEM_TABLETYPES(session, store);
            }
            case 10: {
                return this.SYSTEM_TYPEINFO(session, store);
            }
            case 12: {
                return this.SYSTEM_USERS(session, store);
            }
            case 11: {
                return this.SYSTEM_UDTS(session, store);
            }
            case 13: {
                return this.SYSTEM_VERSIONCOLUMNS(session, store);
            }
            case 33: {
                return this.COLUMN_PRIVILEGES(session, store);
            }
            case 69: {
                return this.SEQUENCES(session, store);
            }
            case 77: {
                return this.TABLE_PRIVILEGES(session, store);
            }
            case 43: {
                return this.INFORMATION_SCHEMA_CATALOG_NAME(session, store);
            }
        }
        return null;
    }

    protected final void init(Session session) {
        for (int i = 0; i < this.sysTables.length; ++i) {
            this.sysTables[i] = this.generateTable(session, null, i);
            Table t = this.sysTables[i];
            if (t == null) continue;
            t.setDataReadOnly(true);
        }
        GranteeManager gm = this.database.getGranteeManager();
        Right right = new Right();
        right.set(1, null);
        for (int i = 0; i < sysTableHsqlNames.length; ++i) {
            if (this.sysTables[i] == null) continue;
            gm.grantSystemToPublic(this.sysTables[i], right);
        }
        right = Right.fullRights;
        gm.grantSystemToPublic(TypeInvariants.YES_OR_NO, right);
        gm.grantSystemToPublic(TypeInvariants.TIME_STAMP, right);
        gm.grantSystemToPublic(TypeInvariants.CARDINAL_NUMBER, right);
        gm.grantSystemToPublic(TypeInvariants.CHARACTER_DATA, right);
        gm.grantSystemToPublic(TypeInvariants.SQL_CHARACTER, right);
        gm.grantSystemToPublic(TypeInvariants.SQL_IDENTIFIER_CHARSET, right);
        gm.grantSystemToPublic(TypeInvariants.SQL_IDENTIFIER, right);
        gm.grantSystemToPublic(TypeInvariants.SQL_TEXT, right);
    }

    protected final boolean isAccessibleTable(Session session, Table table) {
        return session.getGrantee().isAccessible(table);
    }

    protected final Table createBlankTable(HsqlNameManager.HsqlName name) {
        Table table = new Table(this.database, name, 1);
        return table;
    }

    public final Table getSystemTable(Session session, String name) {
        if (!this.isSystemTable(name)) {
            return null;
        }
        int tableIndex = DatabaseInformationMain.getSysTableID(name);
        Table t = this.sysTables[tableIndex];
        if (t == null) {
            return t;
        }
        if (!this.withContent) {
            return t;
        }
        return t;
    }

    public boolean isNonCachedTable(String name) {
        return nonCachedTablesSet.contains(name);
    }

    public final void setStore(Session session, Table table, PersistentStore store) {
        long dbscts = this.database.schemaManager.getSchemaChangeTimestamp();
        if (store.getTimestamp() == dbscts && !this.isNonCachedTable(table.getName().name)) {
            return;
        }
        store.removeAll();
        store.setTimestamp(dbscts);
        int tableIndex = DatabaseInformationMain.getSysTableID(table.getName().name);
        this.generateTable(session, store, tableIndex);
    }

    final Table SYSTEM_BESTROWIDENTIFIER(Session session, PersistentStore store) {
        Table t = this.sysTables[0];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[0]);
            this.addColumn(t, "SCOPE", Type.SQL_SMALLINT);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_SIZE", Type.SQL_INTEGER);
            this.addColumn(t, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "DECIMAL_DIGITS", Type.SQL_SMALLINT);
            this.addColumn(t, "PSEUDO_COLUMN", Type.SQL_SMALLINT);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(t, "IN_KEY", Type.SQL_BOOLEAN);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[0].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 8, 9, 10, 1}, false);
            return t;
        }
        boolean iscope = false;
        boolean icolumn_name = true;
        int idata_type = 2;
        int itype_name = 3;
        int icolumn_size = 4;
        int ibuffer_length = 5;
        int idecimal_digits = 6;
        int ipseudo_column = 7;
        int itable_cat = 8;
        int itable_schem = 9;
        int itable_name = 10;
        int inullable = 11;
        int iinKey = 12;
        DITableInfo ti = new DITableInfo();
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        boolean translateTTI = this.database.sqlTranslateTTI;
        while (tables.hasNext()) {
            int[] cols;
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table) || (cols = table.getBestRowIdentifiers()) == null) continue;
            ti.setTable(table);
            Boolean inKey = ValuePool.getBoolean(table.isBestRowIdentifiersStrict());
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getName().name;
            Type[] types = table.getColumnTypes();
            Integer scope = ti.getBRIScope();
            Integer pseudo = ti.getBRIPseudo();
            for (int i = 0; i < cols.length; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = types[i];
                if (translateTTI) {
                    if (type.isIntervalType()) {
                        type = ((IntervalType)type).getCharacterType();
                    } else if (type.isDateTimeTypeWithZone()) {
                        type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                    }
                }
                Object[] row = t.getEmptyRowData();
                row[0] = scope;
                row[1] = column.getName().name;
                row[2] = ValuePool.getInt(type.getJDBCTypeCode());
                row[3] = type.getNameString();
                row[4] = ValuePool.getInt(type.getJDBCPrecision());
                row[5] = null;
                row[6] = type.acceptsScale() ? ValuePool.getInt(type.getJDBCScale()) : null;
                row[7] = pseudo;
                row[8] = tableCatalog;
                row[9] = tableSchema;
                row[10] = tableName;
                row[11] = ValuePool.getInt(column.getNullability());
                row[12] = inKey;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table SYSTEM_COLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[1];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[1]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_SIZE", Type.SQL_INTEGER);
            this.addColumn(t, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "DECIMAL_DIGITS", Type.SQL_INTEGER);
            this.addColumn(t, "NUM_PREC_RADIX", Type.SQL_INTEGER);
            this.addColumn(t, "NULLABLE", Type.SQL_INTEGER);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "COLUMN_DEF", CHARACTER_DATA);
            this.addColumn(t, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(t, "CHAR_OCTET_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "ORDINAL_POSITION", Type.SQL_INTEGER);
            this.addColumn(t, "IS_NULLABLE", YES_OR_NO);
            this.addColumn(t, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_TABLE", SQL_IDENTIFIER);
            this.addColumn(t, "SOURCE_DATA_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "IS_AUTOINCREMENT", YES_OR_NO);
            this.addColumn(t, "IS_GENERATEDCOLUMN", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[1].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 16}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int icolumn_name = 3;
        int idata_type = 4;
        int itype_name = 5;
        int icolumn_size = 6;
        int ibuffer_length = 7;
        int idecimal_digits = 8;
        int inum_prec_radix = 9;
        int inullable = 10;
        int iremark = 11;
        int icolumn_def = 12;
        int isql_data_type = 13;
        int isql_datetime_sub = 14;
        int ichar_octet_length = 15;
        int iordinal_position = 16;
        int iis_nullable = 17;
        int iscope_cat = 18;
        int iscope_schem = 19;
        int iscope_table = 20;
        int isource_data_type = 21;
        int iis_autoinc = 22;
        int iis_generated = 23;
        Iterator tables = this.allTables();
        DITableInfo ti = new DITableInfo();
        boolean translateTTI = this.database.sqlTranslateTTI;
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(session, table)) continue;
            ti.setTable(table);
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getName().name;
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = column.getDataType();
                if (translateTTI) {
                    if (type.isIntervalType()) {
                        type = ((IntervalType)type).getCharacterType();
                    } else if (type.isDateTimeTypeWithZone()) {
                        type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                    }
                }
                Object[] row = t.getEmptyRowData();
                row[0] = tableCatalog;
                row[1] = tableSchema;
                row[2] = tableName;
                row[3] = column.getName().name;
                row[4] = ValuePool.getInt(type.getJDBCTypeCode());
                row[5] = type.getNameString();
                row[6] = ValuePool.INTEGER_0;
                row[15] = ValuePool.INTEGER_0;
                if (type.isArrayType()) {
                    row[5] = type.getDefinition();
                }
                if (type.isCharacterType()) {
                    row[6] = ValuePool.getInt(type.getJDBCPrecision());
                    row[15] = ValuePool.getInt(type.getJDBCPrecision());
                }
                if (type.isBinaryType()) {
                    row[6] = ValuePool.getInt(type.getJDBCPrecision());
                    row[15] = ValuePool.getInt(type.getJDBCPrecision());
                }
                if (type.isNumberType()) {
                    row[6] = ValuePool.getInt(((NumberType)type).getNumericPrecisionInRadix());
                    row[9] = ValuePool.getInt(type.getPrecisionRadix());
                    if (type.isExactNumberType()) {
                        row[8] = ValuePool.getLong(type.scale);
                    }
                }
                if (type.isDateTimeType()) {
                    int size = column.getDataType().displaySize();
                    row[6] = ValuePool.getInt(size);
                    row[14] = ValuePool.getInt(((DateTimeType)type).getSqlDateTimeSub());
                }
                row[10] = ValuePool.getInt(column.getNullability());
                row[11] = ti.getColRemarks(i);
                row[12] = column.getDefaultSQL();
                row[13] = ValuePool.getInt(type.typeCode);
                row[16] = ValuePool.getInt(i + 1);
                Object object = row[17] = column.isNullable() ? "YES" : "NO";
                if (type.isDistinctType()) {
                    row[21] = type.getName().getSchemaQualifiedStatementName();
                }
                row[22] = column.isIdentity() ? "YES" : "NO";
                row[23] = column.isGenerated() ? "YES" : "NO";
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table SYSTEM_CROSSREFERENCE(Session session, PersistentStore store) {
        Constraint constraint;
        int i;
        Table t = this.sysTables[2];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[2]);
            this.addColumn(t, "PKTABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "PKTABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "PKTABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PKCOLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "FKTABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "FKTABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "FKTABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "FKCOLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "KEY_SEQ", Type.SQL_SMALLINT);
            this.addColumn(t, "UPDATE_RULE", Type.SQL_SMALLINT);
            this.addColumn(t, "DELETE_RULE", Type.SQL_SMALLINT);
            this.addColumn(t, "FK_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PK_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DEFERRABILITY", Type.SQL_SMALLINT);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[2].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{4, 5, 6, 8, 11}, false);
            return t;
        }
        boolean ipk_table_cat = false;
        boolean ipk_table_schem = true;
        int ipk_table_name = 2;
        int ipk_column_name = 3;
        int ifk_table_cat = 4;
        int ifk_table_schem = 5;
        int ifk_table_name = 6;
        int ifk_column_name = 7;
        int ikey_seq = 8;
        int iupdate_rule = 9;
        int idelete_rule = 10;
        int ifk_name = 11;
        int ipk_name = 12;
        int ideferrability = 13;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        HsqlArrayList fkConstraintsList = new HsqlArrayList();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table)) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            for (i = 0; i < constraintCount; ++i) {
                constraint = constraints[i];
                if (constraint.getConstraintType() != 0 || !this.isAccessibleTable(session, constraint.getRef())) continue;
                fkConstraintsList.add(constraint);
            }
        }
        for (i = 0; i < fkConstraintsList.size(); ++i) {
            constraint = (Constraint)fkConstraintsList.get(i);
            Table pkTable = constraint.getMain();
            String pkTableName = pkTable.getName().name;
            Table fkTable = constraint.getRef();
            String fkTableName = fkTable.getName().name;
            String pkTableCatalog = pkTable.getCatalogName().name;
            String pkTableSchema = pkTable.getSchemaName().name;
            String fkTableCatalog = fkTable.getCatalogName().name;
            String fkTableSchema = fkTable.getSchemaName().name;
            int[] mainCols = constraint.getMainColumns();
            int[] refCols = constraint.getRefColumns();
            int columnCount = refCols.length;
            String fkName = constraint.getRefName().name;
            String pkName = constraint.getUniqueName().name;
            Integer deferrability = ValuePool.getInt(constraint.getDeferability());
            Integer deleteRule = ValuePool.getInt(constraint.getDeleteAction());
            Integer updateRule = ValuePool.getInt(constraint.getUpdateAction());
            for (int j = 0; j < columnCount; ++j) {
                Integer keySequence = ValuePool.getInt(j + 1);
                String pkColumnName = pkTable.getColumn(mainCols[j]).getNameString();
                String fkColumnName = fkTable.getColumn(refCols[j]).getNameString();
                Object[] row = t.getEmptyRowData();
                row[0] = pkTableCatalog;
                row[1] = pkTableSchema;
                row[2] = pkTableName;
                row[3] = pkColumnName;
                row[4] = fkTableCatalog;
                row[5] = fkTableSchema;
                row[6] = fkTableName;
                row[7] = fkColumnName;
                row[8] = keySequence;
                row[9] = updateRule;
                row[10] = deleteRule;
                row[11] = fkName;
                row[12] = pkName;
                row[13] = deferrability;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    final Table SYSTEM_INDEXINFO(Session session, PersistentStore store) {
        Table t = this.sysTables[3];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[3]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NON_UNIQUE", Type.SQL_BOOLEAN);
            this.addColumn(t, "INDEX_QUALIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "INDEX_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "ORDINAL_POSITION", Type.SQL_SMALLINT);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ASC_OR_DESC", CHARACTER_DATA);
            this.addColumn(t, "CARDINALITY", Type.SQL_INTEGER);
            this.addColumn(t, "PAGES", Type.SQL_INTEGER);
            this.addColumn(t, "FILTER_CONDITION", CHARACTER_DATA);
            this.addColumn(t, "ROW_CARDINALITY", Type.SQL_INTEGER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[3].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 7}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int inon_unique = 3;
        int iindex_qualifier = 4;
        int iindex_name = 5;
        int itype = 6;
        int iordinal_position = 7;
        int icolumn_name = 8;
        int iasc_or_desc = 9;
        int icardinality = 10;
        int ipages = 11;
        int ifilter_condition = 12;
        int irow_cardinality = 13;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table)) continue;
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getName().name;
            Object filterCondition = null;
            String indexQualifier = tableCatalog;
            int indexCount = table.getIndexCount();
            for (int i = 0; i < indexCount; ++i) {
                Index index = table.getIndex(i);
                int colCount = table.getIndex(i).getColumnCount();
                if (colCount < 1) continue;
                String indexName = index.getName().name;
                Boolean nonUnique = index.isUnique() ? Boolean.FALSE : Boolean.TRUE;
                Object cardinality = null;
                Integer pages = ValuePool.INTEGER_0;
                Object rowCardinality = null;
                int[] cols = index.getColumns();
                Integer indexType = ValuePool.getInt(3);
                for (int k = 0; k < colCount; ++k) {
                    int col = cols[k];
                    Object[] row = t.getEmptyRowData();
                    row[0] = tableCatalog;
                    row[1] = tableSchema;
                    row[2] = tableName;
                    row[3] = nonUnique;
                    row[4] = indexQualifier;
                    row[5] = indexName;
                    row[6] = indexType;
                    row[7] = ValuePool.getInt(k + 1);
                    row[8] = table.getColumn((int)cols[k]).getName().name;
                    row[9] = "A";
                    row[10] = cardinality;
                    row[11] = pages;
                    row[13] = rowCardinality;
                    row[12] = filterCondition;
                    t.insertSys(session, store, row);
                }
            }
        }
        return t;
    }

    final Table SYSTEM_PRIMARYKEYS(Session session, PersistentStore store) {
        Table t = this.sysTables[4];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[4]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "KEY_SEQ", Type.SQL_SMALLINT);
            this.addColumn(t, "PK_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[4].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 2, 1, 0}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int icolumn_name = 3;
        int ikey_seq = 4;
        int ipk_name = 5;
        HsqlDatabaseProperties p = this.database.getProperties();
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !this.isAccessibleTable(session, table) || !table.hasPrimaryKey()) continue;
            Constraint constraint = table.getPrimaryConstraint();
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            String tableName = table.getName().name;
            String primaryKeyName = constraint.getName().name;
            int[] cols = constraint.getMainColumns();
            int colCount = cols.length;
            for (int j = 0; j < colCount; ++j) {
                Object[] row = t.getEmptyRowData();
                row[0] = tableCatalog;
                row[1] = tableSchema;
                row[2] = tableName;
                row[3] = table.getColumn((int)cols[j]).getName().name;
                row[4] = ValuePool.getInt(j + 1);
                row[5] = primaryKeyName;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table SYSTEM_PROCEDURECOLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[5];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[5]);
            this.addColumn(t, "PROCEDURE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRECISION", Type.SQL_INTEGER);
            this.addColumn(t, "LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "SCALE", Type.SQL_SMALLINT);
            this.addColumn(t, "RADIX", Type.SQL_SMALLINT);
            this.addColumn(t, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "COLUMN_DEF", CHARACTER_DATA);
            this.addColumn(t, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(t, "CHAR_OCTET_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "ORDINAL_POSITION", Type.SQL_INTEGER);
            this.addColumn(t, "IS_NULLABLE", CHARACTER_DATA);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[5].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 19, 17}, false);
            return t;
        }
        boolean specific_cat = false;
        boolean specific_schem = true;
        int procedure_name = 2;
        int parameter_name = 3;
        int parameter_mode = 4;
        int data_type_sql_id = 5;
        int data_type = 6;
        int numeric_precision = 7;
        int byte_length = 8;
        int numeric_scale = 9;
        int numeric_precision_radix = 10;
        int nullable = 11;
        int remark = 12;
        int default_val = 13;
        int sql_data_type = 14;
        int sql_datetime_sub = 15;
        int character_octet_length = 16;
        int ordinal_position = 17;
        int is_nullable = 18;
        int specific_name = 19;
        boolean translateTTI = this.database.sqlTranslateTTI;
        Iterator routines = this.database.schemaManager.databaseObjectIterator(18);
        while (routines.hasNext()) {
            RoutineSchema routineSchema = (RoutineSchema)routines.next();
            if (!session.getGrantee().isAccessible(routineSchema)) continue;
            Routine[] specifics = routineSchema.getSpecificRoutines();
            for (int i = 0; i < specifics.length; ++i) {
                Routine routine = specifics[i];
                int columnCount = routine.getParameterCount();
                for (int j = 0; j < columnCount; ++j) {
                    ColumnSchema column = routine.getParameter(j);
                    Object[] row = t.getEmptyRowData();
                    Type type = column.getDataType();
                    if (translateTTI) {
                        if (type.isIntervalType()) {
                            type = ((IntervalType)type).getCharacterType();
                        } else if (type.isDateTimeTypeWithZone()) {
                            type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                        }
                    }
                    row[0] = this.database.getCatalogName().name;
                    row[1] = routine.getSchemaName().name;
                    row[19] = routine.getSpecificName().name;
                    row[2] = routine.getName().name;
                    row[3] = column.getName().name;
                    row[17] = ValuePool.getInt(j + 1);
                    row[4] = ValuePool.getInt(column.getParameterMode());
                    row[6] = type.getFullNameString();
                    row[5] = ValuePool.getInt(type.getJDBCTypeCode());
                    row[7] = ValuePool.INTEGER_0;
                    row[16] = ValuePool.INTEGER_0;
                    if (type.isCharacterType()) {
                        row[7] = ValuePool.getInt(type.getJDBCPrecision());
                        row[16] = ValuePool.getInt(type.getJDBCPrecision());
                    }
                    if (type.isBinaryType()) {
                        row[7] = ValuePool.getInt(type.getJDBCPrecision());
                        row[16] = ValuePool.getInt(type.getJDBCPrecision());
                    }
                    if (type.isNumberType()) {
                        row[7] = ValuePool.getInt(((NumberType)type).getNumericPrecisionInRadix());
                        row[10] = ValuePool.getLong(type.getPrecisionRadix());
                        if (type.isExactNumberType()) {
                            row[9] = ValuePool.getLong(type.scale);
                        }
                    }
                    if (type.isDateTimeType()) {
                        int size = column.getDataType().displaySize();
                        row[7] = ValuePool.getInt(size);
                    }
                    row[14] = ValuePool.getInt(column.getDataType().typeCode);
                    row[11] = ValuePool.getInt(column.getNullability());
                    row[18] = column.isNullable() ? "YES" : "NO";
                    t.insertSys(session, store, row);
                }
            }
        }
        return t;
    }

    Table SYSTEM_PROCEDURES(Session session, PersistentStore store) {
        Table t = this.sysTables[6];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[6]);
            this.addColumn(t, "PROCEDURE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "PROCEDURE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COL_4", Type.SQL_INTEGER);
            this.addColumn(t, "COL_5", Type.SQL_INTEGER);
            this.addColumn(t, "COL_6", Type.SQL_INTEGER);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "PROCEDURE_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[6].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 8}, false);
            return t;
        }
        boolean procedure_catalog = false;
        boolean procedure_schema = true;
        int procedure_name = 2;
        int col_4 = 3;
        int col_5 = 4;
        int col_6 = 5;
        int remarks = 6;
        int procedure_type = 7;
        int specific_name = 8;
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = routine.getSchemaName().name;
            row[2] = routine.getName().name;
            row[7] = routine.isProcedure() ? ValuePool.INTEGER_1 : ValuePool.INTEGER_2;
            row[8] = routine.getSpecificName().name;
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_CONNECTION_PROPERTIES(Session session, PersistentStore store) {
        Table t = this.sysTables[18];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[18]);
            this.addColumn(t, "NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MAX_LEN", Type.SQL_INTEGER);
            this.addColumn(t, "DEFAULT_VALUE", SQL_IDENTIFIER);
            this.addColumn(t, "DESCRIPTION", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[4].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        boolean iname = false;
        boolean imax_len = true;
        int idefault_value = 2;
        int idescription = 3;
        Iterator it = HsqlDatabaseProperties.getPropertiesMetaIterator();
        while (it.hasNext()) {
            Object[] meta = (Object[])it.next();
            int propType = (Integer)meta[1];
            if (propType == 1) {
                if (!"readonly".equals(meta[0]) && !"files_readonly".equals(meta[0])) continue;
            } else if (propType != 2) continue;
            Object[] row = t.getEmptyRowData();
            Object def = meta[4];
            row[0] = meta[0];
            row[1] = ValuePool.getInt(8);
            row[2] = def == null ? null : def.toString();
            row[3] = "see HyperSQL guide";
            t.insertSys(session, store, row);
        }
        return t;
    }

    protected void addProcRows(Session session, Table t, HsqlArrayList l, String cat, String schem, String pName, Integer ip, Integer op, Integer rs, String remark, Integer pType, String specificName, String origin) {
        PersistentStore store = t.getRowStore(session);
        boolean icat = false;
        boolean ischem = true;
        int ipname = 2;
        int iinput_parms = 3;
        int ioutput_parms = 4;
        int iresult_sets = 5;
        int iremark = 6;
        int iptype = 7;
        int isn = 8;
        int iporigin = 9;
        Object[] row = t.getEmptyRowData();
        row[0] = cat;
        row[1] = schem;
        row[2] = pName;
        row[3] = ip;
        row[4] = op;
        row[5] = rs;
        row[6] = remark;
        row[7] = pType;
        row[9] = origin;
        row[8] = specificName;
        t.insertSys(session, store, row);
        if (l != null) {
            int size = l.size();
            for (int i = 0; i < size; ++i) {
                row = t.getEmptyRowData();
                pName = (String)l.get(i);
                row[0] = cat;
                row[1] = schem;
                row[2] = pName;
                row[3] = ip;
                row[4] = op;
                row[5] = rs;
                row[6] = remark;
                row[7] = pType;
                row[9] = "ALIAS";
                row[8] = specificName;
                t.insertSys(session, store, row);
            }
        }
    }

    protected void addPColRows(Session session, Table t, HsqlArrayList l, String cat, String schem, String pName, String cName, Integer cType, Integer dType, String tName, Integer prec, Integer len, Integer scale, Integer radix, Integer nullability, String remark, String colDefault, Integer sqlDataType, Integer sqlDateTimeSub, Integer charOctetLength, Integer ordinalPosition, String isNullable, String specificName) {
        PersistentStore store = t.getRowStore(session);
        boolean icat = false;
        boolean ischem = true;
        int iname = 2;
        int icol_name = 3;
        int icol_type = 4;
        int idata_type = 5;
        int itype_name = 6;
        int iprec = 7;
        int ilength = 8;
        int iscale = 9;
        int iradix = 10;
        int inullable = 11;
        int iremark = 12;
        int icol_default = 13;
        int isql_data_type = 14;
        int isql_datetime_sub = 15;
        int ichar_octet_len = 16;
        int iordinal_position = 17;
        int iis_nullable = 18;
        int ispecific_name = 19;
        Object[] row = t.getEmptyRowData();
        row[0] = cat;
        row[1] = schem;
        row[2] = pName;
        row[3] = cName;
        row[4] = cType;
        row[5] = dType;
        row[6] = tName;
        row[7] = prec;
        row[8] = len;
        row[9] = scale;
        row[10] = radix;
        row[11] = nullability;
        row[12] = remark;
        row[13] = colDefault;
        row[14] = sqlDataType;
        row[15] = sqlDateTimeSub;
        row[16] = charOctetLength;
        row[17] = ordinalPosition;
        row[18] = isNullable;
        row[19] = specificName;
        t.insertSys(session, store, row);
        if (l != null) {
            int size = l.size();
            for (int i = 0; i < size; ++i) {
                row = t.getEmptyRowData();
                pName = (String)l.get(i);
                row[0] = cat;
                row[1] = schem;
                row[2] = pName;
                row[3] = cName;
                row[4] = cType;
                row[5] = dType;
                row[6] = tName;
                row[7] = prec;
                row[8] = len;
                row[9] = scale;
                row[10] = radix;
                row[11] = nullability;
                row[12] = remark;
                row[13] = colDefault;
                row[14] = sqlDataType;
                row[15] = sqlDateTimeSub;
                row[16] = charOctetLength;
                row[17] = ordinalPosition;
                row[18] = isNullable;
                row[19] = specificName;
                t.insertSys(session, store, row);
            }
        }
    }

    final Table SYSTEM_SCHEMAS(Session session, PersistentStore store) {
        Table t = this.sysTables[7];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[7]);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "IS_DEFAULT", Type.SQL_BOOLEAN);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[7].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        String[] schemas = this.database.schemaManager.getSchemaNamesArray();
        String defschema = this.database.schemaManager.getDefaultSchemaHsqlName().name;
        for (int i = 0; i < schemas.length; ++i) {
            Object[] row = t.getEmptyRowData();
            String schema = schemas[i];
            row[0] = schema;
            row[1] = this.database.getCatalogName().name;
            row[2] = schema.equals(defschema) ? Boolean.TRUE : Boolean.FALSE;
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_TABLES(Session session, PersistentStore store) {
        Table t = this.sysTables[8];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[8]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "TYPE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SELF_REFERENCING_COL_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "REF_GENERATION", CHARACTER_DATA);
            this.addColumn(t, "HSQLDB_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "READ_ONLY", Type.SQL_BOOLEAN);
            this.addColumn(t, "COMMIT_ACTION", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[8].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 1, 2, 0}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int itable_type = 3;
        int iremark = 4;
        int itype_cat = 5;
        int itype_schem = 6;
        int itype_name = 7;
        int isref_cname = 8;
        int iref_gen = 9;
        int ihsqldb_type = 10;
        int iread_only = 11;
        int icommit_action = 12;
        Iterator tables = this.allTables();
        DITableInfo ti = new DITableInfo();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(session, table)) continue;
            ti.setTable(table);
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getName().name;
            row[3] = ti.getJDBCStandardType();
            row[4] = ti.getRemark();
            row[10] = ti.getHsqlType();
            Object object = row[11] = table.isDataReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            row[12] = table.isTemp() ? (table.onCommitPreserve() ? "PRESERVE" : "DELETE") : null;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SYSTEM_TABLETYPES(Session session, PersistentStore store) {
        Table t = this.sysTables[9];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[9]);
            this.addColumn(t, "TABLE_TYPE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[9].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        for (int i = 0; i < tableTypes.length; ++i) {
            Object[] row = t.getEmptyRowData();
            row[0] = tableTypes[i];
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_TYPEINFO(Session session, PersistentStore store) {
        Object[] row;
        Table t = this.sysTables[10];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[10]);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "PRECISION", Type.SQL_INTEGER);
            this.addColumn(t, "LITERAL_PREFIX", CHARACTER_DATA);
            this.addColumn(t, "LITERAL_SUFFIX", CHARACTER_DATA);
            this.addColumn(t, "CREATE_PARAMS", CHARACTER_DATA);
            this.addColumn(t, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(t, "CASE_SENSITIVE", Type.SQL_BOOLEAN);
            this.addColumn(t, "SEARCHABLE", Type.SQL_INTEGER);
            this.addColumn(t, "UNSIGNED_ATTRIBUTE", Type.SQL_BOOLEAN);
            this.addColumn(t, "FIXED_PREC_SCALE", Type.SQL_BOOLEAN);
            this.addColumn(t, "AUTO_INCREMENT", Type.SQL_BOOLEAN);
            this.addColumn(t, "LOCAL_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MINIMUM_SCALE", Type.SQL_SMALLINT);
            this.addColumn(t, "MAXIMUM_SCALE", Type.SQL_SMALLINT);
            this.addColumn(t, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(t, "NUM_PREC_RADIX", Type.SQL_INTEGER);
            this.addColumn(t, "INTERVAL_PRECISION", Type.SQL_INTEGER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[10].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{1, 0}, true);
            return t;
        }
        boolean itype_name = false;
        boolean idata_type = true;
        int iprecision = 2;
        int iliteral_prefix = 3;
        int iliteral_suffix = 4;
        int icreate_params = 5;
        int inullable = 6;
        int icase_sensitive = 7;
        int isearchable = 8;
        int iunsigned_attribute = 9;
        int ifixed_prec_scale = 10;
        int iauto_increment = 11;
        int ilocal_type_name = 12;
        int iminimum_scale = 13;
        int imaximum_scale = 14;
        int isql_data_type = 15;
        int isql_datetime_sub = 16;
        int inum_prec_radix = 17;
        int iinterval_precision = 18;
        Iterator it = Type.typeNames.keySet().iterator();
        boolean translateTTI = this.database.sqlTranslateTTI;
        while (it.hasNext()) {
            String typeName = (String)it.next();
            int typeCode = Type.typeNames.get(typeName);
            Type type = Type.getDefaultType(typeCode);
            if (type == null) continue;
            if (translateTTI) {
                if (type.isIntervalType()) {
                    type = ((IntervalType)type).getCharacterType();
                } else if (type.isDateTimeTypeWithZone()) {
                    type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                }
            }
            row = t.getEmptyRowData();
            row[0] = typeName;
            row[1] = ValuePool.getInt(type.getJDBCTypeCode());
            long maxPrecision = type.getMaxPrecision();
            Object object = row[2] = maxPrecision > Integer.MAX_VALUE ? ValuePool.INTEGER_MAX : ValuePool.getInt((int)maxPrecision);
            if (type.isBinaryType() || type.isCharacterType() || type.isDateTimeType() || type.isIntervalType()) {
                row[3] = "'";
                row[4] = "'";
            }
            if (type.acceptsPrecision() && type.acceptsScale()) {
                row[5] = "PRECISION,SCALE";
            } else if (type.acceptsPrecision()) {
                row[5] = type.isNumberType() ? "PRECISION" : "LENGTH";
            } else if (type.acceptsScale()) {
                row[5] = "SCALE";
            }
            row[6] = ValuePool.INTEGER_1;
            Object object2 = row[7] = type.isCharacterType() && type.typeCode != 100 ? Boolean.TRUE : Boolean.FALSE;
            row[8] = type.isLobType() ? ValuePool.INTEGER_0 : (type.isCharacterType() || type.isBinaryType() && !type.isBitType() ? ValuePool.getInt(3) : ValuePool.getInt(2));
            row[9] = Boolean.FALSE;
            row[10] = type.typeCode == 2 || type.typeCode == 3 ? Boolean.TRUE : Boolean.FALSE;
            row[11] = type.isIntegralType() ? Boolean.TRUE : Boolean.FALSE;
            row[12] = null;
            row[13] = ValuePool.INTEGER_0;
            row[14] = ValuePool.getInt(type.getMaxScale());
            row[15] = null;
            row[16] = null;
            row[17] = ValuePool.getInt(type.getPrecisionRadix());
            if (type.isIntervalType()) {
                row[18] = null;
            }
            t.insertSys(session, store, row);
        }
        row = t.getEmptyRowData();
        row[0] = "DISTINCT";
        row[1] = ValuePool.getInt(2001);
        return t;
    }

    Table SYSTEM_UDTS(Session session, PersistentStore store) {
        Table t = this.sysTables[11];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[11]);
            this.addColumn(t, "TYPE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CLASS_NAME", CHARACTER_DATA);
            this.addColumn(t, "DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(t, "REMARKS", CHARACTER_DATA);
            this.addColumn(t, "BASE_TYPE", Type.SQL_SMALLINT);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[11].name, false, 20);
            t.createPrimaryKeyConstraint(name, null, false);
            return t;
        }
        boolean translateTTI = this.database.sqlTranslateTTI;
        boolean type_catalog = false;
        boolean type_schema = true;
        int type_name = 2;
        int class_name = 3;
        int data_type = 4;
        int remarks = 5;
        int base_type = 6;
        Iterator it = this.database.schemaManager.databaseObjectIterator(12);
        while (it.hasNext()) {
            Type distinct = (Type)it.next();
            if (!distinct.isDistinctType()) continue;
            Object[] data = t.getEmptyRowData();
            Type type = distinct;
            if (translateTTI) {
                if (type.isIntervalType()) {
                    type = ((IntervalType)type).getCharacterType();
                } else if (type.isDateTimeTypeWithZone()) {
                    type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                }
            }
            data[0] = this.database.getCatalogName().name;
            data[1] = distinct.getSchemaName().name;
            data[2] = distinct.getName().name;
            data[3] = type.getJDBCClassName();
            data[4] = ValuePool.getInt(2001);
            data[5] = null;
            data[6] = ValuePool.getInt(type.getJDBCTypeCode());
            t.insertSys(session, store, data);
        }
        return t;
    }

    Table SYSTEM_VERSIONCOLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[13];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[13]);
            this.addColumn(t, "SCOPE", Type.SQL_INTEGER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(t, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_SIZE", Type.SQL_SMALLINT);
            this.addColumn(t, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(t, "DECIMAL_DIGITS", Type.SQL_SMALLINT);
            this.addColumn(t, "PSEUDO_COLUMN", Type.SQL_SMALLINT);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[13].name, false, 20);
            t.createPrimaryKeyConstraint(name, null, false);
            return t;
        }
        return t;
    }

    Table SYSTEM_USERS(Session session, PersistentStore store) {
        Table t = this.sysTables[12];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[12]);
            this.addColumn(t, "USER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ADMIN", Type.SQL_BOOLEAN);
            this.addColumn(t, "INITIAL_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "AUTHENTICATION", SQL_IDENTIFIER);
            this.addColumn(t, "PASSWORD_DIGEST", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[12].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        HsqlArrayList users = this.database.getUserManager().listVisibleUsers(session);
        for (int i = 0; i < users.size(); ++i) {
            Object[] row = t.getEmptyRowData();
            User user = (User)users.get(i);
            HsqlNameManager.HsqlName initialSchema = user.getInitialSchema();
            row[0] = user.getName().getNameString();
            row[1] = ValuePool.getBoolean(user.isAdmin());
            Object object = row[2] = initialSchema == null ? null : initialSchema.name;
            row[3] = user.isLocalOnly ? "LOCAL" : (user.isExternalOnly ? "EXTERNAL" : "ANY");
            row[4] = user.getPasswordDigest();
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table COLUMN_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[33];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[33]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[33].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{2, 3, 4, 5, 6, 1, 0}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int table_catalog = 2;
        int table_schema = 3;
        int table_name = 4;
        int column_name = 5;
        int privilege_type = 6;
        int is_grantable = 7;
        OrderedHashSet grantees = session.getGrantee().getGranteeAndAllRolesWithPublic();
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            String tableName = table.getName().name;
            String tableCatalog = this.database.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(table);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(table);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    for (int k = 0; k < Right.privilegeTypes.length; ++k) {
                        OrderedHashSet columnList = right.getColumnsForPrivilege(table, Right.privilegeTypes[k]);
                        OrderedHashSet grantableList = grantableRight.getColumnsForPrivilege(table, Right.privilegeTypes[k]);
                        for (int l = 0; l < columnList.size(); ++l) {
                            HsqlNameManager.HsqlName fullName = (HsqlNameManager.HsqlName)columnList.get(l);
                            Object[] row = t.getEmptyRowData();
                            row[0] = right.getGrantor().getName().name;
                            row[1] = right.getGrantee().getName().name;
                            row[2] = tableCatalog;
                            row[3] = tableSchema;
                            row[4] = tableName;
                            row[5] = fullName.name;
                            row[6] = Right.privilegeNames[k];
                            row[7] = right.getGrantee() == table.getOwner() || grantableList.contains(fullName) ? "YES" : "NO";
                            try {
                                t.insertSys(session, store, row);
                                continue;
                            }
                            catch (HsqlException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return t;
    }

    final Table SEQUENCES(Session session, PersistentStore store) {
        Table t = this.sysTables[69];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[69]);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "MAXIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "MINIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "INCREMENT", CHARACTER_DATA);
            this.addColumn(t, "CYCLE_OPTION", YES_OR_NO);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "START_WITH", CHARACTER_DATA);
            this.addColumn(t, "NEXT_VALUE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[69].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean sequence_catalog = false;
        boolean sequence_schema = true;
        int sequence_name = 2;
        int data_type = 3;
        int numeric_precision = 4;
        int numeric_precision_radix = 5;
        int numeric_scale = 6;
        int maximum_value = 7;
        int minimum_value = 8;
        int increment = 9;
        int cycle_option = 10;
        int declared_data_type = 11;
        int declared_numeric_precision = 12;
        int declared_numeric_scale = 13;
        int start_with = 14;
        int next_value = 15;
        Iterator it = this.database.schemaManager.databaseObjectIterator(7);
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            if (!session.getGrantee().isAccessible(sequence)) continue;
            Object[] row = t.getEmptyRowData();
            NumberType type = (NumberType)sequence.getDataType();
            int radix = type.typeCode == 2 || type.typeCode == 3 ? 10 : 2;
            row[0] = this.database.getCatalogName().name;
            row[1] = sequence.getSchemaName().name;
            row[2] = sequence.getName().name;
            row[3] = sequence.getDataType().getFullNameString();
            row[4] = ValuePool.getInt(type.getPrecision());
            row[5] = ValuePool.getInt(radix);
            row[6] = ValuePool.INTEGER_0;
            row[7] = String.valueOf(sequence.getMaxValue());
            row[8] = String.valueOf(sequence.getMinValue());
            row[9] = String.valueOf(sequence.getIncrement());
            row[10] = sequence.isCycle() ? "YES" : "NO";
            row[11] = row[3];
            row[12] = row[4];
            row[13] = row[13];
            row[14] = String.valueOf(sequence.getStartValue());
            row[15] = String.valueOf(sequence.peek());
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table SYSTEM_SEQUENCES(Session session, PersistentStore store) {
        Table t = this.sysTables[14];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[14]);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "MAXIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "MINIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(t, "INCREMENT", CHARACTER_DATA);
            this.addColumn(t, "CYCLE_OPTION", YES_OR_NO);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "START_WITH", CHARACTER_DATA);
            this.addColumn(t, "NEXT_VALUE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[14].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean sequence_catalog = false;
        boolean sequence_schema = true;
        int sequence_name = 2;
        int data_type = 3;
        int numeric_precision = 4;
        int numeric_precision_radix = 5;
        int numeric_scale = 6;
        int maximum_value = 7;
        int minimum_value = 8;
        int increment = 9;
        int cycle_option = 10;
        int declared_data_type = 11;
        int declared_numeric_precision = 12;
        int declared_numeric_scale = 13;
        int start_with = 14;
        int next_value = 15;
        Iterator it = this.database.schemaManager.databaseObjectIterator(7);
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            if (!session.getGrantee().isAccessible(sequence)) continue;
            Object[] row = t.getEmptyRowData();
            NumberType type = (NumberType)sequence.getDataType();
            int radix = type.typeCode == 2 || type.typeCode == 3 ? 10 : 2;
            row[0] = this.database.getCatalogName().name;
            row[1] = sequence.getSchemaName().name;
            row[2] = sequence.getName().name;
            row[3] = sequence.getDataType().getFullNameString();
            row[4] = ValuePool.getInt(type.getPrecision());
            row[5] = ValuePool.getInt(radix);
            row[6] = ValuePool.INTEGER_0;
            row[7] = String.valueOf(sequence.getMaxValue());
            row[8] = String.valueOf(sequence.getMinValue());
            row[9] = String.valueOf(sequence.getIncrement());
            row[10] = sequence.isCycle() ? "YES" : "NO";
            row[11] = row[3];
            row[12] = row[4];
            row[13] = row[13];
            row[14] = String.valueOf(sequence.getStartValue());
            row[15] = String.valueOf(sequence.peek());
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table TABLE_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[77];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[77]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            this.addColumn(t, "WITH_HIERARCHY", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[69].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int table_catalog = 2;
        int table_schema = 3;
        int table_name = 4;
        int privilege_type = 5;
        int is_grantable = 6;
        int with_hierarchy = 7;
        OrderedHashSet grantees = session.getGrantee().getGranteeAndAllRolesWithPublic();
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            String tableName = table.getName().name;
            String tableCatalog = table.getCatalogName().name;
            String tableSchema = table.getSchemaName().name;
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(table);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(table);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    for (int k = 0; k < Right.privilegeTypes.length; ++k) {
                        if (!right.canAccessFully(Right.privilegeTypes[k])) continue;
                        String privilege = Right.privilegeNames[k];
                        Object[] row = t.getEmptyRowData();
                        row[0] = right.getGrantor().getName().name;
                        row[1] = right.getGrantee().getName().name;
                        row[2] = tableCatalog;
                        row[3] = tableSchema;
                        row[4] = tableName;
                        row[5] = privilege;
                        row[6] = right.getGrantee() == table.getOwner() || grantableRight.canAccessFully(Right.privilegeTypes[k]) ? "YES" : "NO";
                        row[7] = "NO";
                        try {
                            t.insertSys(session, store, row);
                            continue;
                        }
                        catch (HsqlException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return t;
    }

    Table TABLES(Session session, PersistentStore store) {
        Table t = this.sysTables[78];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[78]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "SELF_REFERENCING_COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "REFERENCE_GENERATION", CHARACTER_DATA);
            this.addColumn(t, "USER_DEFINED_TYPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_INSERTABLE_INTO", YES_OR_NO);
            this.addColumn(t, "IS_TYPED", YES_OR_NO);
            this.addColumn(t, "COMMIT_ACTION", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[78].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean table_catalog = false;
        boolean table_schema = true;
        int table_name = 2;
        int table_type = 3;
        int self_referencing_column_name = 4;
        int reference_generation = 5;
        int user_defined_type_catalog = 6;
        int user_defined_type_schema = 7;
        int user_defined_type_name = 8;
        int is_insertable_into = 9;
        int is_typed = 10;
        int commit_action = 11;
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!this.isAccessibleTable(session, table)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getName().name;
            switch (table.getTableType()) {
                case 1: 
                case 8: {
                    row[3] = "VIEW";
                    row[9] = table.isInsertable() ? "YES" : "NO";
                    break;
                }
                case 3: 
                case 6: {
                    row[3] = "GLOBAL TEMPORARY";
                    row[9] = "YES";
                    break;
                }
                default: {
                    row[3] = "BASE TABLE";
                    row[9] = table.isInsertable() ? "YES" : "NO";
                }
            }
            row[4] = null;
            row[5] = null;
            row[6] = null;
            row[7] = null;
            row[8] = null;
            row[10] = "NO";
            row[11] = table.isTemp() ? (table.onCommitPreserve() ? "PRESERVE" : "DELETE") : null;
            t.insertSys(session, store, row);
        }
        return t;
    }

    final Table INFORMATION_SCHEMA_CATALOG_NAME(Session session, PersistentStore store) {
        Table t = this.sysTables[43];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[43]);
            this.addColumn(t, "CATALOG_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[43].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        Object[] row = t.getEmptyRowData();
        row[0] = this.database.getCatalogName().name;
        t.insertSys(session, store, row);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        sysTableSessionDependent = new boolean[sysTableNames.length];
        tableTypes = new String[]{"GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW"};
        Class<DatabaseInformationMain> clazz = DatabaseInformationMain.class;
        synchronized (DatabaseInformationMain.class) {
            nonCachedTablesSet = new HashSet();
            sysTableHsqlNames = new HsqlNameManager.HsqlName[sysTableNames.length];
            for (int i = 0; i < sysTableNames.length; ++i) {
                DatabaseInformationMain.sysTableHsqlNames[i] = HsqlNameManager.newInfoSchemaTableName(sysTableNames[i]);
                DatabaseInformationMain.sysTableHsqlNames[i].schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
                DatabaseInformationMain.sysTableSessionDependent[i] = true;
            }
            nonCachedTablesSet.add("SYSTEM_CACHEINFO");
            nonCachedTablesSet.add("SYSTEM_SESSIONINFO");
            nonCachedTablesSet.add("SYSTEM_SESSIONS");
            nonCachedTablesSet.add("SYSTEM_PROPERTIES");
            nonCachedTablesSet.add("SYSTEM_SEQUENCES");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

