/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TextTable;
import org.hsqldb.TriggerDef;
import org.hsqldb.View;
import org.hsqldb.dbinfo.DITableInfo;
import org.hsqldb.dbinfo.DatabaseInformationMain;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TextCache;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.Right;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

final class DatabaseInformationFull
extends DatabaseInformationMain {
    static final HashMappedList statementMap;

    DatabaseInformationFull(Database db) {
        super(db);
    }

    protected Table generateTable(Session session, PersistentStore store, int tableIndex) {
        switch (tableIndex) {
            case 15: {
                return this.SYSTEM_CACHEINFO(session, store);
            }
            case 16: {
                return this.SYSTEM_COLUMN_SEQUENCE_USAGE(session, store);
            }
            case 17: {
                return this.SYSTEM_COMMENTS(session, store);
            }
            case 20: {
                return this.SYSTEM_SESSIONINFO(session, store);
            }
            case 19: {
                return this.SYSTEM_PROPERTIES(session, store);
            }
            case 21: {
                return this.SYSTEM_SESSIONS(session, store);
            }
            case 22: {
                return this.SYSTEM_TEXTTABLES(session, store);
            }
            case 23: {
                return this.ADMINISTRABLE_ROLE_AUTHORIZATIONS(session, store);
            }
            case 24: {
                return this.APPLICABLE_ROLES(session, store);
            }
            case 25: {
                return this.ASSERTIONS(session, store);
            }
            case 26: {
                return this.AUTHORIZATIONS(session, store);
            }
            case 27: {
                return this.CHARACTER_SETS(session, store);
            }
            case 28: {
                return this.CHECK_CONSTRAINT_ROUTINE_USAGE(session, store);
            }
            case 29: {
                return this.CHECK_CONSTRAINTS(session, store);
            }
            case 30: {
                return this.COLLATIONS(session, store);
            }
            case 31: {
                return this.COLUMN_COLUMN_USAGE(session, store);
            }
            case 32: {
                return this.COLUMN_DOMAIN_USAGE(session, store);
            }
            case 34: {
                return this.COLUMN_UDT_USAGE(session, store);
            }
            case 36: {
                return this.CONSTRAINT_COLUMN_USAGE(session, store);
            }
            case 37: {
                return this.CONSTRAINT_TABLE_USAGE(session, store);
            }
            case 35: {
                return this.COLUMNS(session, store);
            }
            case 38: {
                return this.DATA_TYPE_PRIVILEGES(session, store);
            }
            case 39: {
                return this.DOMAIN_CONSTRAINTS(session, store);
            }
            case 40: {
                return this.DOMAINS(session, store);
            }
            case 41: {
                return this.ELEMENT_TYPES(session, store);
            }
            case 42: {
                return this.ENABLED_ROLES(session, store);
            }
            case 44: {
                return this.JAR_JAR_USAGE(session, store);
            }
            case 45: {
                return this.JARS(session, store);
            }
            case 46: {
                return this.KEY_COLUMN_USAGE(session, store);
            }
            case 47: {
                return this.METHOD_SPECIFICATIONS(session, store);
            }
            case 48: {
                return this.MODULE_COLUMN_USAGE(session, store);
            }
            case 49: {
                return this.MODULE_PRIVILEGES(session, store);
            }
            case 50: {
                return this.MODULE_TABLE_USAGE(session, store);
            }
            case 51: {
                return this.MODULES(session, store);
            }
            case 52: {
                return this.PARAMETERS(session, store);
            }
            case 53: {
                return this.REFERENTIAL_CONSTRAINTS(session, store);
            }
            case 54: {
                return this.ROLE_AUTHORIZATION_DESCRIPTORS(session, store);
            }
            case 55: {
                return this.ROLE_COLUMN_GRANTS(session, store);
            }
            case 57: {
                return this.ROLE_ROUTINE_GRANTS(session, store);
            }
            case 58: {
                return this.ROLE_TABLE_GRANTS(session, store);
            }
            case 60: {
                return this.ROLE_USAGE_GRANTS(session, store);
            }
            case 59: {
                return this.ROLE_UDT_GRANTS(session, store);
            }
            case 61: {
                return this.ROUTINE_COLUMN_USAGE(session, store);
            }
            case 62: {
                return this.ROUTINE_JAR_USAGE(session, store);
            }
            case 63: {
                return this.ROUTINE_PRIVILEGES(session, store);
            }
            case 64: {
                return this.ROUTINE_ROUTINE_USAGE(session, store);
            }
            case 65: {
                return this.ROUTINE_SEQUENCE_USAGE(session, store);
            }
            case 66: {
                return this.ROUTINE_TABLE_USAGE(session, store);
            }
            case 67: {
                return this.ROUTINES(session, store);
            }
            case 68: {
                return this.SCHEMATA(session, store);
            }
            case 69: {
                return this.SEQUENCES(session, store);
            }
            case 70: {
                return this.SQL_FEATURES(session, store);
            }
            case 71: {
                return this.SQL_IMPLEMENTATION_INFO(session, store);
            }
            case 72: {
                return this.SQL_PACKAGES(session, store);
            }
            case 73: {
                return this.SQL_PARTS(session, store);
            }
            case 74: {
                return this.SQL_SIZING(session, store);
            }
            case 75: {
                return this.SQL_SIZING_PROFILES(session, store);
            }
            case 76: {
                return this.TABLE_CONSTRAINTS(session, store);
            }
            case 78: {
                return this.TABLES(session, store);
            }
            case 79: {
                return this.TRANSLATIONS(session, store);
            }
            case 84: {
                return this.TRIGGERED_UPDATE_COLUMNS(session, store);
            }
            case 80: {
                return this.TRIGGER_COLUMN_USAGE(session, store);
            }
            case 81: {
                return this.TRIGGER_ROUTINE_USAGE(session, store);
            }
            case 82: {
                return this.TRIGGER_SEQUENCE_USAGE(session, store);
            }
            case 83: {
                return this.TRIGGER_TABLE_USAGE(session, store);
            }
            case 85: {
                return this.TRIGGERS(session, store);
            }
            case 87: {
                return this.UDT_PRIVILEGES(session, store);
            }
            case 88: {
                return this.USAGE_PRIVILEGES(session, store);
            }
            case 89: {
                return this.USER_DEFINED_TYPES(session, store);
            }
            case 90: {
                return this.VIEW_COLUMN_USAGE(session, store);
            }
            case 91: {
                return this.VIEW_ROUTINE_USAGE(session, store);
            }
            case 92: {
                return this.VIEW_TABLE_USAGE(session, store);
            }
            case 93: {
                return this.VIEWS(session, store);
            }
        }
        return super.generateTable(session, store, tableIndex);
    }

    Table SYSTEM_CACHEINFO(Session session, PersistentStore store) {
        Table t = this.sysTables[15];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[15]);
            this.addColumn(t, "CACHE_FILE", CHARACTER_DATA);
            this.addColumn(t, "MAX_CACHE_COUNT", CARDINAL_NUMBER);
            this.addColumn(t, "MAX_CACHE_BYTES", CARDINAL_NUMBER);
            this.addColumn(t, "CACHE_SIZE", CARDINAL_NUMBER);
            this.addColumn(t, "CACHE_BYTES", CARDINAL_NUMBER);
            this.addColumn(t, "FILE_FREE_BYTES", CARDINAL_NUMBER);
            this.addColumn(t, "FILE_FREE_COUNT", CARDINAL_NUMBER);
            this.addColumn(t, "FILE_FREE_POS", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[15].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        boolean icache_file = false;
        boolean imax_cache_sz = true;
        int imax_cache_bytes = 2;
        int icache_size = 3;
        int icache_length = 4;
        int ifree_bytes = 5;
        int ifree_count = 6;
        int ifree_pos = 7;
        DataFileCache cache = null;
        HashSet cacheSet = new HashSet();
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            PersistentStore currentStore = table.getRowStore(session);
            if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) continue;
            if (currentStore != null) {
                cache = currentStore.getCache();
            }
            if (cache == null) continue;
            cacheSet.add(cache);
        }
        Iterator caches = cacheSet.iterator();
        while (caches.hasNext()) {
            cache = (DataFileCache)caches.next();
            Object[] row = t.getEmptyRowData();
            row[0] = FileUtil.getFileUtil().canonicalOrAbsolutePath(cache.getFileName());
            row[1] = ValuePool.getLong(cache.capacity());
            row[2] = ValuePool.getLong(cache.bytesCapacity());
            row[3] = ValuePool.getLong(cache.getCachedObjectCount());
            row[4] = ValuePool.getLong(cache.getTotalCachedBlockSize());
            row[5] = ValuePool.getLong(cache.getTotalFreeBlockSize());
            row[6] = ValuePool.getLong(cache.getFreeBlockCount());
            row[7] = ValuePool.getLong(cache.getFileFreePos());
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SYSTEM_COLUMN_SEQUENCE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[16];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[16]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[16].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4}, false);
            return t;
        }
        boolean table_cat = false;
        boolean table_schem = true;
        int table_name = 2;
        int column_name = 3;
        int sequence_catalog = 4;
        int sequence_schema = 5;
        int sequence_name = 6;
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            OrderedHashSet columnList;
            Table table = (Table)tables.next();
            if (!table.hasIdentityColumn() || (columnList = session.getGrantee().getColumnsForAllPrivileges(table)).isEmpty()) continue;
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                NumberSequence sequence;
                ColumnSchema column = table.getColumn(i);
                if (!column.isIdentity() || (sequence = column.getIdentitySequence()).getName() == null || !columnList.contains(column.getName())) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = table.getName().name;
                row[3] = column.getName().name;
                row[4] = this.database.getCatalogName().name;
                row[5] = sequence.getSchemaName().name;
                row[6] = sequence.getName().name;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table SYSTEM_COMMENTS(Session session, PersistentStore store) {
        Object[] row;
        Table t = this.sysTables[17];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[17]);
            this.addColumn(t, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COMMENT", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[17].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4}, false);
            return t;
        }
        boolean catalog = false;
        boolean schema = true;
        int name = 2;
        int type = 3;
        int column_name = 4;
        int remark = 5;
        DITableInfo ti = new DITableInfo();
        Iterator it = this.allTables();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (!session.getGrantee().isAccessible(table)) continue;
            ti.setTable(table);
            int colCount = table.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                if (column.getName().comment == null) continue;
                row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = table.getName().name;
                row[3] = "COLUMN";
                row[4] = column.getName().name;
                row[5] = column.getName().comment;
                t.insertSys(session, store, row);
            }
            if (table.getTableType() != 1 && table.getName().comment == null) continue;
            row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getName().name;
            row[3] = table.isView() || table.getTableType() == 1 ? "VIEW" : "TABLE";
            row[4] = null;
            row[5] = ti.getRemark();
            t.insertSys(session, store, row);
        }
        it = this.database.schemaManager.databaseObjectIterator(18);
        while (it.hasNext()) {
            SchemaObject object = (SchemaObject)it.next();
            if (!session.getGrantee().isAccessible(object) || object.getName().comment == null) continue;
            row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = object.getSchemaName().name;
            row[2] = object.getName().name;
            row[3] = "ROUTINE";
            row[4] = null;
            row[5] = object.getName().comment;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SYSTEM_PROPERTIES(Session session, PersistentStore store) {
        Table t = this.sysTables[19];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[19]);
            this.addColumn(t, "PROPERTY_SCOPE", CHARACTER_DATA);
            this.addColumn(t, "PROPERTY_NAMESPACE", CHARACTER_DATA);
            this.addColumn(t, "PROPERTY_NAME", CHARACTER_DATA);
            this.addColumn(t, "PROPERTY_VALUE", CHARACTER_DATA);
            this.addColumn(t, "PROPERTY_CLASS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[19].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, true);
            return t;
        }
        boolean iscope = false;
        boolean ins = true;
        int iname = 2;
        int ivalue = 3;
        int iclass = 4;
        String scope = "SESSION";
        HsqlDatabaseProperties props = this.database.getProperties();
        String nameSpace = "database.properties";
        Iterator it = props.getUserDefinedPropertyData().iterator();
        while (it.hasNext()) {
            Object[] metaData = (Object[])it.next();
            Object[] row = t.getEmptyRowData();
            row[0] = scope;
            row[1] = nameSpace;
            row[2] = metaData[0];
            row[3] = this.database.logger.getValueStringForProperty((String)row[2]);
            if (row[3] == null) {
                row[3] = props.getPropertyString((String)row[2]);
            }
            row[4] = metaData[2];
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SYSTEM_SESSIONINFO(Session session, PersistentStore store) {
        Table t = this.sysTables[20];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[20]);
            this.addColumn(t, "KEY", CHARACTER_DATA);
            this.addColumn(t, "VALUE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[20].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        Object[] row = t.getEmptyRowData();
        row[0] = "SESSION ID";
        row[1] = String.valueOf(session.getId());
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "AUTOCOMMIT";
        row[1] = session.isAutoCommit() ? "TRUE" : "FALSE";
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "USER";
        row[1] = session.getUsername();
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "SESSION READONLY";
        row[1] = session.isReadOnlyDefault() ? "TRUE" : "FALSE";
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "DATABASE READONLY";
        row[1] = this.database.isReadOnly() ? "TRUE" : "FALSE";
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "DATABASE";
        row[1] = this.database.getURI();
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "IDENTITY";
        row[1] = String.valueOf(session.getLastIdentity());
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "CURRENT SCHEMA";
        row[1] = String.valueOf(session.getSchemaName(null));
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "ISOLATION LEVEL";
        row[1] = String.valueOf(session.getIsolation());
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "IGNORECASE";
        row[1] = String.valueOf(session.isIgnorecase());
        t.insertSys(session, store, row);
        row = t.getEmptyRowData();
        row[0] = "CURRENT STATEMENT";
        row[1] = "";
        Statement st = session.sessionContext.currentStatement;
        if (st != null) {
            row[1] = st.getSQL();
        }
        t.insertSys(session, store, row);
        return t;
    }

    Table SYSTEM_SESSIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[21];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[21]);
            this.addColumn(t, "SESSION_ID", CARDINAL_NUMBER);
            this.addColumn(t, "CONNECTED", TIME_STAMP);
            this.addColumn(t, "USER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_ADMIN", Type.SQL_BOOLEAN);
            this.addColumn(t, "AUTOCOMMIT", Type.SQL_BOOLEAN);
            this.addColumn(t, "READONLY", Type.SQL_BOOLEAN);
            this.addColumn(t, "LAST_IDENTITY", CARDINAL_NUMBER);
            this.addColumn(t, "SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRANSACTION", Type.SQL_BOOLEAN);
            this.addColumn(t, "TRANSACTION_SIZE", CARDINAL_NUMBER);
            this.addColumn(t, "WAITING_FOR_THIS", CHARACTER_DATA);
            this.addColumn(t, "THIS_WAITING_FOR", CHARACTER_DATA);
            this.addColumn(t, "CURRENT_STATEMENT", CHARACTER_DATA);
            this.addColumn(t, "LATCH_COUNT", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[21].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        boolean isid = false;
        boolean ict = true;
        int iuname = 2;
        int iis_admin = 3;
        int iautocmt = 4;
        int ireadonly = 5;
        int ilast_id = 6;
        int it_schema = 7;
        int it_tx = 8;
        int it_size = 9;
        int it_waiting = 10;
        int it_waited = 11;
        int it_statement = 12;
        int it_latch_count = 13;
        Session[] sessions = this.database.sessionManager.getVisibleSessions(session);
        for (int i = 0; i < sessions.length; ++i) {
            Statement st;
            int j;
            Object[] array;
            StringBuffer sb;
            if (sessions[i].isClosed()) continue;
            Session s = sessions[i];
            Object[] row = t.getEmptyRowData();
            row[0] = ValuePool.getLong(s.getId());
            row[1] = new TimestampData(s.getConnectTime() / 1000L);
            row[2] = s.getUsername();
            row[3] = ValuePool.getBoolean(s.isAdmin());
            row[4] = s.sessionContext.isAutoCommit;
            row[5] = s.isReadOnlyDefault;
            Number lastId = s.getLastIdentity();
            if (lastId != null) {
                row[6] = ValuePool.getLong(lastId.longValue());
            }
            row[8] = s.isInMidTransaction();
            row[9] = ValuePool.getLong(s.getTransactionSize());
            HsqlNameManager.HsqlName name = s.getCurrentSchemaHsqlName();
            if (name != null) {
                row[7] = name.name;
            }
            row[10] = "";
            row[11] = "";
            if (s.waitingSessions.size() > 0) {
                sb = new StringBuffer();
                array = new Session[s.waitingSessions.size()];
                s.waitingSessions.toArray(array);
                for (j = 0; j < array.length; ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(((Session)array[j]).getId());
                }
                row[10] = sb.toString();
            }
            if (s.waitedSessions.size() > 0) {
                sb = new StringBuffer();
                array = new Session[s.waitedSessions.size()];
                s.waitedSessions.toArray(array);
                for (j = 0; j < array.length; ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(((Session)array[j]).getId());
                }
                row[11] = sb.toString();
            }
            row[12] = (st = s.sessionContext.currentStatement) == null ? "" : st.getSQL();
            row[13] = new Long(s.latch.getCount());
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SYSTEM_TEXTTABLES(Session session, PersistentStore store) {
        Table t = this.sysTables[22];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[22]);
            this.addColumn(t, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_SOURCE_DEFINTION", CHARACTER_DATA);
            this.addColumn(t, "FILE_PATH", CHARACTER_DATA);
            this.addColumn(t, "FILE_ENCODING", CHARACTER_DATA);
            this.addColumn(t, "FIELD_SEPARATOR", CHARACTER_DATA);
            this.addColumn(t, "VARCHAR_SEPARATOR", CHARACTER_DATA);
            this.addColumn(t, "LONGVARCHAR_SEPARATOR", CHARACTER_DATA);
            this.addColumn(t, "IS_IGNORE_FIRST", Type.SQL_BOOLEAN);
            this.addColumn(t, "IS_ALL_QUOTED", Type.SQL_BOOLEAN);
            this.addColumn(t, "IS_QUOTED", Type.SQL_BOOLEAN);
            this.addColumn(t, "IS_DESC", Type.SQL_BOOLEAN);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[22].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean itable_cat = false;
        boolean itable_schem = true;
        int itable_name = 2;
        int idsd = 3;
        int ifile_path = 4;
        int ifile_enc = 5;
        int ifs = 6;
        int ivfs = 7;
        int ilvfs = 8;
        int iif = 9;
        int iiq = 10;
        int iiaq = 11;
        int iid = 12;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            PersistentStore currentStore = table.getRowStore(session);
            if (!table.isText() || !this.isAccessibleTable(session, table)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getName().name;
            row[3] = ((TextTable)table).getDataSource();
            TextCache cache = (TextCache)currentStore.getCache();
            if (cache != null) {
                row[4] = FileUtil.getFileUtil().canonicalOrAbsolutePath(cache.getFileName());
                row[5] = cache.stringEncoding;
                row[6] = cache.fs;
                row[7] = cache.vs;
                row[8] = cache.lvs;
                row[9] = ValuePool.getBoolean(cache.ignoreFirst);
                row[10] = ValuePool.getBoolean(cache.isQuoted);
                row[11] = ValuePool.getBoolean(cache.isAllQuoted);
                row[12] = ((TextTable)table).isDescDataSource() ? Boolean.TRUE : Boolean.FALSE;
            }
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table ADMINISTRABLE_ROLE_AUTHORIZATIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[23];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[23]);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "ROLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_GRANTABLE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[23].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        if (session.isAdmin()) {
            this.insertRoles(session, t, session.getGrantee(), true);
        }
        return t;
    }

    Table APPLICABLE_ROLES(Session session, PersistentStore store) {
        Table t = this.sysTables[24];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[24]);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "ROLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_GRANTABLE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[24].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        this.insertRoles(session, t, session.getGrantee(), session.isAdmin());
        return t;
    }

    private void insertRoles(Session session, Table t, Grantee role, boolean isGrantable) {
        boolean grantee = false;
        boolean role_name = true;
        int is_grantable = 2;
        PersistentStore store = t.getRowStore(session);
        if (isGrantable) {
            Set roles = this.database.getGranteeManager().getRoleNames();
            Iterator it = roles.iterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                Object[] row = t.getEmptyRowData();
                row[0] = role.getName().getNameString();
                row[1] = roleName;
                row[2] = "YES";
                t.insertSys(session, store, row);
            }
        } else {
            OrderedHashSet roles = role.getDirectRoles();
            for (int i = 0; i < roles.size(); ++i) {
                String roleName = (String)roles.get(i);
                Object[] row = t.getEmptyRowData();
                row[0] = role.getName().getNameString();
                row[1] = roleName;
                row[2] = "NO";
                t.insertSys(session, store, row);
                role = this.database.getGranteeManager().getRole(roleName);
                this.insertRoles(session, t, role, isGrantable);
            }
        }
    }

    Table ASSERTIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[25];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[25]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_DEFERRABLE", YES_OR_NO);
            this.addColumn(t, "INITIALLY_DEFERRED", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[25].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int is_deferrable = 3;
        int initially_deferred = 4;
        return t;
    }

    Table AUTHORIZATIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[26];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[26]);
            this.addColumn(t, "AUTHORIZATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "AUTHORIZATION_TYPE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[26].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        Iterator grantees = session.getGrantee().visibleGrantees().iterator();
        while (grantees.hasNext()) {
            Grantee grantee = (Grantee)grantees.next();
            Object[] row = t.getEmptyRowData();
            row[0] = grantee.getName().getNameString();
            row[1] = grantee.isRole() ? "ROLE" : "USER";
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table CHARACTER_SETS(Session session, PersistentStore store) {
        Table t = this.sysTables[27];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[27]);
            this.addColumn(t, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_REPERTOIRE", SQL_IDENTIFIER);
            this.addColumn(t, "FORM_OF_USE", SQL_IDENTIFIER);
            this.addColumn(t, "DEFAULT_COLLATE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "DEFAULT_COLLATE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "DEFAULT_COLLATE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[27].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean character_set_catalog = false;
        boolean character_set_schema = true;
        int character_set_name = 2;
        int character_repertoire = 3;
        int form_of_use = 4;
        int default_collate_catalog = 5;
        int default_collate_schema = 6;
        int default_collate_name = 7;
        Iterator it = this.database.schemaManager.databaseObjectIterator(14);
        while (it.hasNext()) {
            Charset charset = (Charset)it.next();
            if (!session.getGrantee().isAccessible(charset)) continue;
            Object[] data = t.getEmptyRowData();
            data[0] = this.database.getCatalogName().name;
            data[1] = charset.getSchemaName().name;
            data[2] = charset.getName().name;
            data[3] = "UCS";
            data[4] = "UTF16";
            data[5] = data[0];
            if (charset.base == null) {
                data[6] = data[1];
                data[7] = data[2];
            } else {
                data[6] = charset.base.schema.name;
                data[7] = charset.base.name;
            }
            t.insertSys(session, store, data);
        }
        return t;
    }

    Table CHECK_CONSTRAINT_ROUTINE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[28];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[28]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[28].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int specific_catalog = 3;
        int specific_schema = 4;
        int specific_name = 5;
        Iterator constraints = this.database.schemaManager.databaseObjectIterator(5);
        block8: while (constraints.hasNext()) {
            Constraint constraint;
            HsqlNameManager.HsqlName constraintName = (HsqlNameManager.HsqlName)constraints.next();
            if (constraintName.parent == null) continue;
            switch (constraintName.parent.type) {
                case 3: {
                    Table table;
                    try {
                        table = (Table)this.database.schemaManager.getSchemaObject(constraintName.parent.name, constraintName.parent.schema.name, 3);
                    }
                    catch (Exception e) {
                        continue block8;
                    }
                    constraint = table.getConstraint(constraintName.name);
                    if (constraint.getConstraintType() == 3) break;
                    continue block8;
                }
                case 13: {
                    Type domain;
                    try {
                        domain = (Type)this.database.schemaManager.getSchemaObject(constraintName.parent.name, constraintName.parent.schema.name, 13);
                    }
                    catch (Exception e) {
                        continue block8;
                    }
                    constraint = domain.userTypeModifier.getConstraint(constraintName.name);
                }
                default: {
                    continue block8;
                }
            }
            OrderedHashSet references = constraint.getReferences();
            for (int i = 0; i < references.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)references.get(i);
                if (name.type != 24 || !session.getGrantee().isFullyAccessibleByRole(name)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = constraint.getSchemaName().name;
                row[2] = constraint.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = name.schema.name;
                row[5] = name.name;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table CHECK_CONSTRAINTS(Session session, PersistentStore store) {
        Object[] row;
        Table t = this.sysTables[29];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[29]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CHECK_CLAUSE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[29].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{2, 1, 0}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int check_clause = 3;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !session.getGrantee().isFullyAccessibleByRole(table.getName())) continue;
            for (Constraint constraint : table.getConstraints()) {
                if (constraint.getConstraintType() != 3) continue;
                row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = constraint.getName().name;
                try {
                    row[3] = constraint.getCheckSQL();
                }
                catch (Exception e) {
                    // empty catch block
                }
                t.insertSys(session, store, row);
            }
        }
        Iterator it = this.database.schemaManager.databaseObjectIterator(13);
        while (it.hasNext()) {
            Type domain = (Type)it.next();
            if (!domain.isDomainType() || !session.getGrantee().isFullyAccessibleByRole(domain.getName())) continue;
            for (Constraint constraint : domain.userTypeModifier.getConstraints()) {
                row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = domain.getSchemaName().name;
                row[2] = constraint.getName().name;
                try {
                    row[3] = constraint.getCheckSQL();
                }
                catch (Exception e) {
                    // empty catch block
                }
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table COLLATIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[30];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[30]);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PAD_ATTRIBUTE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[30].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean collation_catalog = false;
        boolean collation_schema = true;
        int collation_name = 2;
        int pad_attribute = 3;
        String collationSchema = "PUBLIC";
        String padAttribute = "NO PAD";
        Iterator collations = Collation.nameToJavaName.keySet().iterator();
        while (collations.hasNext()) {
            Object[] row = t.getEmptyRowData();
            String collation = (String)collations.next();
            row[0] = this.database.getCatalogName().name;
            row[1] = collationSchema;
            row[2] = collation;
            row[3] = padAttribute;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table COLUMN_COLUMN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[31];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[31]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DEPENDENT_COLUMN", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[31].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4}, false);
            return t;
        }
        boolean table_catalog = false;
        boolean table_schema = true;
        int table_name = 2;
        int column_name = 3;
        int dependent_column = 4;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !session.getGrantee().isFullyAccessibleByRole(table.getName()) || !table.hasGeneratedColumn()) continue;
            HsqlNameManager.HsqlName name = table.getName();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                OrderedHashSet set;
                ColumnSchema column = table.getColumn(i);
                if (!column.isGenerated() || (set = column.getGeneratedColumnReferences()) == null) continue;
                for (int j = 0; j < set.size(); ++j) {
                    Object[] row = t.getEmptyRowData();
                    row[0] = this.database.getCatalogName().name;
                    row[1] = name.schema.name;
                    row[2] = name.name;
                    row[3] = ((HsqlNameManager.HsqlName)set.get((int)j)).name;
                    row[4] = column.getName().name;
                    t.insertSys(session, store, row);
                }
            }
        }
        return t;
    }

    Table COLUMN_DOMAIN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[32];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[32]);
            this.addColumn(t, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[32].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean domain_catalog = false;
        boolean domain_schema = true;
        int domain_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        int column_name = 6;
        Iterator tables = this.allTables();
        Grantee grantee = session.getGrantee();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            int columnCount = table.getColumnCount();
            HsqlNameManager.HsqlName tableName = table.getName();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = column.getDataType();
                if (!type.isDomainType() || !grantee.isFullyAccessibleByRole(type.getName())) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = type.getSchemaName().name;
                row[2] = type.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = tableName.schema.name;
                row[5] = tableName.name;
                row[6] = column.getNameString();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table COLUMN_UDT_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[34];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[34]);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[34].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean udt_catalog = false;
        boolean udt_schema = true;
        int udt_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        int column_name = 6;
        Iterator tables = this.allTables();
        Grantee grantee = session.getGrantee();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            int columnCount = table.getColumnCount();
            HsqlNameManager.HsqlName tableName = table.getName();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = column.getDataType();
                if (!type.isDistinctType() || !grantee.isFullyAccessibleByRole(type.getName())) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = type.getSchemaName().name;
                row[2] = type.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = tableName.schema.name;
                row[5] = tableName.name;
                row[6] = column.getNameString();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table COLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[35];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[35]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(t, "COLUMN_DEFAULT", CHARACTER_DATA);
            this.addColumn(t, "IS_NULLABLE", YES_OR_NO);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_SET_CATALOG", CHARACTER_DATA);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "IS_SELF_REFERENCING", YES_OR_NO);
            this.addColumn(t, "IS_IDENTITY", YES_OR_NO);
            this.addColumn(t, "IDENTITY_GENERATION", CHARACTER_DATA);
            this.addColumn(t, "IDENTITY_START", CHARACTER_DATA);
            this.addColumn(t, "IDENTITY_INCREMENT", CHARACTER_DATA);
            this.addColumn(t, "IDENTITY_MAXIMUM", CHARACTER_DATA);
            this.addColumn(t, "IDENTITY_MINIMUM", CHARACTER_DATA);
            this.addColumn(t, "IDENTITY_CYCLE", YES_OR_NO);
            this.addColumn(t, "IS_GENERATED", CHARACTER_DATA);
            this.addColumn(t, "GENERATION_EXPRESSION", CHARACTER_DATA);
            this.addColumn(t, "IS_UPDATABLE", YES_OR_NO);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[35].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 2, 1, 4}, false);
            return t;
        }
        boolean table_cat = false;
        boolean table_schem = true;
        int table_name = 2;
        int column_name = 3;
        int ordinal_position = 4;
        int column_default = 5;
        int is_nullable = 6;
        int data_type = 7;
        int character_maximum_length = 8;
        int character_octet_length = 9;
        int numeric_precision = 10;
        int numeric_precision_radix = 11;
        int numeric_scale = 12;
        int datetime_precision = 13;
        int interval_type = 14;
        int interval_precision = 15;
        int character_set_catalog = 16;
        int character_set_schema = 17;
        int character_set_name = 18;
        int collation_catalog = 19;
        int collation_schema = 20;
        int collation_name = 21;
        int domain_catalog = 22;
        int domain_schema = 23;
        int domain_name = 24;
        int udt_catalog = 25;
        int udt_schema = 26;
        int udt_name = 27;
        int scope_catalog = 28;
        int scope_schema = 29;
        int scope_name = 30;
        int maximum_cardinality = 31;
        int dtd_identifier = 32;
        int is_self_referencing = 33;
        int is_identity = 34;
        int identity_generation = 35;
        int identity_start = 36;
        int identity_increment = 37;
        int identity_maximum = 38;
        int identity_minimum = 39;
        int identity_cycle = 40;
        int is_generated = 41;
        int generation_expression = 42;
        int is_updatable = 43;
        int declared_data_type = 44;
        int declared_numeric_precision = 45;
        int declared_numeric_scale = 46;
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            OrderedHashSet columnList = session.getGrantee().getColumnsForAllPrivileges(table);
            if (columnList.isEmpty()) continue;
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                Type type = column.getDataType();
                if (!columnList.contains(column.getName())) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = table.getName().name;
                row[3] = column.getName().name;
                row[4] = ValuePool.getLong(i + 1);
                row[5] = column.getDefaultSQL();
                row[6] = column.isNullable() ? "YES" : "NO";
                row[7] = type.getFullNameString();
                if (type.isCharacterType()) {
                    row[8] = ValuePool.getLong(type.precision);
                    row[9] = ValuePool.getLong(type.precision * 2L);
                    row[16] = this.database.getCatalogName().name;
                    row[17] = ((CharacterType)type).getCharacterSet().getSchemaName().name;
                    row[18] = ((CharacterType)type).getCharacterSet().getName().name;
                    row[19] = this.database.getCatalogName().name;
                    row[20] = ((CharacterType)type).getCollation().getSchemaName().name;
                    row[21] = ((CharacterType)type).getCollation().getName().name;
                } else if (type.isNumberType()) {
                    row[10] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    row[45] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    if (type.isExactNumberType()) {
                        row[12] = row[46] = ValuePool.getLong(type.scale);
                    }
                    row[11] = ValuePool.getLong(type.getPrecisionRadix());
                } else if (!type.isBooleanType()) {
                    if (type.isDateTimeType()) {
                        row[13] = ValuePool.getLong(type.scale);
                    } else if (type.isIntervalType()) {
                        row[7] = "INTERVAL";
                        IntervalType cfr_ignored_0 = (IntervalType)type;
                        row[14] = IntervalType.getQualifier(type.typeCode);
                        row[15] = ValuePool.getLong(type.precision);
                        row[13] = ValuePool.getLong(type.scale);
                    } else if (type.isBinaryType()) {
                        row[8] = ValuePool.getLong(type.precision);
                        row[9] = ValuePool.getLong(type.precision);
                    } else if (type.isBitType()) {
                        row[8] = ValuePool.getLong(type.precision);
                        row[9] = ValuePool.getLong(type.precision);
                    } else if (type.isArrayType()) {
                        row[31] = ValuePool.getLong(type.arrayLimitCardinality());
                        row[7] = "ARRAY";
                    }
                }
                if (type.isDomainType()) {
                    row[22] = this.database.getCatalogName().name;
                    row[23] = type.getSchemaName().name;
                    row[24] = type.getName().name;
                }
                if (type.isDistinctType()) {
                    row[25] = this.database.getCatalogName().name;
                    row[26] = type.getSchemaName().name;
                    row[27] = type.getName().name;
                }
                row[28] = null;
                row[29] = null;
                row[30] = null;
                row[32] = type.getDefinition();
                row[33] = null;
                Object object = row[34] = column.isIdentity() ? "YES" : "NO";
                if (column.isIdentity()) {
                    NumberSequence sequence = column.getIdentitySequence();
                    row[35] = sequence.isAlways() ? "ALWAYS" : "BY DEFAULT";
                    row[36] = Long.toString(sequence.getStartValue());
                    row[37] = Long.toString(sequence.getIncrement());
                    row[38] = Long.toString(sequence.getMaxValue());
                    row[39] = Long.toString(sequence.getMinValue());
                    row[40] = sequence.isCycle() ? "YES" : "NO";
                }
                row[41] = "NEVER";
                if (column.isGenerated()) {
                    row[41] = "ALWAYS";
                    row[42] = column.getGeneratingExpression().getSQL();
                }
                row[43] = table.isWritable() ? "YES" : "NO";
                row[44] = row[7];
                if (type.isNumberType()) {
                    row[45] = row[10];
                    row[46] = row[12];
                }
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table CONSTRAINT_COLUMN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[36];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[36]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[36].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean table_catalog = false;
        boolean table_schema = true;
        int table_name = 2;
        int column_name = 3;
        int constraint_catalog = 4;
        int constraint_schema = 5;
        int constraint_name = 6;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !session.getGrantee().isFullyAccessibleByRole(table.getName())) continue;
            Constraint[] constraints = table.getConstraints();
            int constraintCount = constraints.length;
            String constraintCatalog = this.database.getCatalogName().name;
            String constraintSchema = table.getSchemaName().name;
            block9: for (int i = 0; i < constraintCount; ++i) {
                Constraint constraint = constraints[i];
                String constraintName = constraint.getName().name;
                switch (constraint.getConstraintType()) {
                    case 3: {
                        Object[] row;
                        OrderedHashSet expressions = constraint.getCheckColumnExpressions();
                        if (expressions == null) continue block9;
                        Iterator iterator = expressions.iterator();
                        while (iterator.hasNext()) {
                            ExpressionColumn expr = (ExpressionColumn)iterator.next();
                            HsqlNameManager.HsqlName name = expr.getBaseColumnHsqlName();
                            if (name.type != 9) continue;
                            row = t.getEmptyRowData();
                            row[0] = this.database.getCatalogName().name;
                            row[1] = name.schema.name;
                            row[2] = name.parent.name;
                            row[3] = name.name;
                            row[4] = constraintCatalog;
                            row[5] = constraintSchema;
                            row[6] = constraintName;
                            try {
                                t.insertSys(session, store, row);
                            }
                            catch (HsqlException e) {}
                        }
                        continue block9;
                    }
                    case 0: 
                    case 2: 
                    case 4: {
                        Object[] row;
                        Table target = table;
                        int[] cols = constraint.getMainColumns();
                        if (constraint.getConstraintType() == 0) {
                            cols = constraint.getRefColumns();
                        }
                        for (int j = 0; j < cols.length; ++j) {
                            row = t.getEmptyRowData();
                            row[0] = this.database.getCatalogName().name;
                            row[1] = constraintSchema;
                            row[2] = target.getName().name;
                            row[3] = target.getColumn((int)cols[j]).getName().name;
                            row[4] = constraintCatalog;
                            row[5] = constraintSchema;
                            row[6] = constraintName;
                            try {
                                t.insertSys(session, store, row);
                                continue;
                            }
                            catch (HsqlException e) {
                                // empty catch block
                            }
                        }
                        continue block9;
                    }
                }
            }
        }
        return t;
    }

    Table CONSTRAINT_TABLE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[37];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[37]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[37].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result rs = sys.executeDirectStatement("select DISTINCT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME from INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE");
        t.insertSys(session, store, rs);
        sys.close();
        return t;
    }

    Table DATA_TYPE_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[38];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[38]);
            this.addColumn(t, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[38].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String sql = (String)statementMap.get("/*data_type_privileges*/");
        Result rs = sys.executeDirectStatement(sql);
        t.insertSys(session, store, rs);
        sys.close();
        return t;
    }

    Table DOMAIN_CONSTRAINTS(Session session, PersistentStore store) {
        Table t = this.sysTables[39];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[39]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_DEFERRABLE", YES_OR_NO);
            this.addColumn(t, "INITIALLY_DEFERRED", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[39].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 4, 5, 6}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int domain_catalog = 3;
        int domain_schema = 4;
        int domain_name = 5;
        int is_deferrable = 6;
        int initially_deferred = 7;
        Iterator it = this.database.schemaManager.databaseObjectIterator(13);
        while (it.hasNext()) {
            Type domain = (Type)it.next();
            if (!domain.isDomainType() || !session.getGrantee().isFullyAccessibleByRole(domain.getName())) continue;
            Constraint[] constraints = domain.userTypeModifier.getConstraints();
            for (int i = 0; i < constraints.length; ++i) {
                Object[] data = t.getEmptyRowData();
                data[0] = data[3] = this.database.getCatalogName().name;
                data[1] = data[4] = domain.getSchemaName().name;
                data[2] = constraints[i].getName().name;
                data[5] = domain.getName().name;
                data[6] = "NO";
                data[7] = "NO";
                t.insertSys(session, store, data);
            }
        }
        return t;
    }

    Table DOMAINS(Session session, PersistentStore store) {
        Table t = this.sysTables[40];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[40]);
            this.addColumn(t, "DOMAIN_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "DOMAIN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DOMAIN_DEFAULT", CHARACTER_DATA);
            this.addColumn(t, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[40].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 4, 5, 6}, false);
            return t;
        }
        boolean domain_catalog = false;
        boolean domain_schema = true;
        int domain_name = 2;
        int data_type = 3;
        int character_maximum_length = 4;
        int character_octet_length = 5;
        int character_set_catalog = 6;
        int character_set_schema = 7;
        int character_set_name = 8;
        int collation_catalog = 9;
        int collation_schema = 10;
        int collation_name = 11;
        int numeric_precision = 12;
        int numeric_precision_radix = 13;
        int numeric_scale = 14;
        int datetime_precision = 15;
        int interval_type = 16;
        int interval_precision = 17;
        int domain_default = 18;
        int maximum_cardinality = 19;
        int dtd_identifier = 20;
        int declared_data_type = 21;
        int declared_numeric_precision = 22;
        int declared_numeric_scale = 23;
        Iterator it = this.database.schemaManager.databaseObjectIterator(13);
        while (it.hasNext()) {
            Type type = (Type)it.next();
            if (!type.isDomainType() || !session.getGrantee().isAccessible(type)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = type.getSchemaName().name;
            row[2] = type.getName().name;
            row[3] = type.getFullNameString();
            if (type.isCharacterType()) {
                row[4] = ValuePool.getLong(type.precision);
                row[5] = ValuePool.getLong(type.precision * 2L);
                row[6] = this.database.getCatalogName().name;
                row[7] = ((CharacterType)type).getCharacterSet().getSchemaName().name;
                row[8] = ((CharacterType)type).getCharacterSet().getName().name;
                row[9] = this.database.getCatalogName().name;
                row[10] = ((CharacterType)type).getCollation().getSchemaName().name;
                row[11] = ((CharacterType)type).getCollation().getName().name;
            } else if (type.isNumberType()) {
                row[12] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                row[22] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                if (type.isExactNumberType()) {
                    row[14] = row[23] = ValuePool.getLong(type.scale);
                }
                row[13] = ValuePool.getLong(type.getPrecisionRadix());
            } else if (!type.isBooleanType()) {
                if (type.isDateTimeType()) {
                    row[15] = ValuePool.getLong(type.scale);
                } else if (type.isIntervalType()) {
                    row[3] = "INTERVAL";
                    IntervalType cfr_ignored_0 = (IntervalType)type;
                    row[16] = IntervalType.getQualifier(type.typeCode);
                    row[17] = ValuePool.getLong(type.precision);
                    row[15] = ValuePool.getLong(type.scale);
                } else if (type.isBinaryType()) {
                    row[4] = ValuePool.getLong(type.precision);
                    row[5] = ValuePool.getLong(type.precision);
                } else if (type.isBitType()) {
                    row[4] = ValuePool.getLong(type.precision);
                    row[5] = ValuePool.getLong(type.precision);
                } else if (type.isArrayType()) {
                    row[19] = ValuePool.getLong(type.arrayLimitCardinality());
                    row[3] = "ARRAY";
                }
            }
            row[20] = type.getDefinition();
            row[21] = row[3];
            Expression defaultExpression = type.userTypeModifier.getDefaultClause();
            if (defaultExpression != null) {
                row[18] = defaultExpression.getSQL();
            }
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table ELEMENT_TYPES(Session session, PersistentStore store) {
        Object[] row;
        Type type;
        Table t = this.sysTables[41];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[41]);
            this.addColumn(t, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "COLLECTION_TYPE_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[41].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 4, 5, 6}, false);
            return t;
        }
        boolean object_catalog = false;
        boolean object_schema = true;
        int object_name = 2;
        int object_type = 3;
        int collection_type_identifier = 4;
        int udt_catalog = 20;
        int udt_schema = 21;
        int udt_name = 22;
        int scope_catalog = 23;
        int scope_schema = 24;
        int scope_name = 25;
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            OrderedHashSet columnList = session.getGrantee().getColumnsForAllPrivileges(table);
            if (columnList.isEmpty()) continue;
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                ColumnSchema column = table.getColumn(i);
                if (!columnList.contains(column.getName()) || (type = column.getDataType()).isDistinctType() || type.isDomainType() || !type.isArrayType()) continue;
                row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = table.getName().name;
                row[3] = "TABLE";
                row[4] = type.getDefinition();
                this.addTypeInfo(row, ((ArrayType)type).collectionBaseType());
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        Iterator it = this.database.schemaManager.databaseObjectIterator(13);
        while (it.hasNext()) {
            type = (Type)it.next();
            if (!type.isDomainType() || !type.isArrayType() || !session.getGrantee().isAccessible(type)) continue;
            row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = type.getSchemaName().name;
            row[2] = type.getName().name;
            row[3] = "DOMAIN";
            row[4] = type.getDefinition();
            this.addTypeInfo(row, ((ArrayType)type).collectionBaseType());
            t.insertSys(session, store, row);
        }
        it = this.database.schemaManager.databaseObjectIterator(12);
        while (it.hasNext()) {
            type = (Type)it.next();
            if (!type.isDistinctType() || !type.isArrayType() || !session.getGrantee().isAccessible(type)) continue;
            row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = type.getSchemaName().name;
            row[2] = type.getName().name;
            row[3] = "USER-DEFINED TYPE";
            row[4] = type.getDefinition();
            this.addTypeInfo(row, ((ArrayType)type).collectionBaseType());
            try {
                t.insertSys(session, store, row);
            }
            catch (HsqlException e) {}
        }
        it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            if (!session.getGrantee().isAccessible(routine)) continue;
            Type type2 = type = routine.isProcedure() ? null : routine.getReturnType();
            if (type != null && !type.isDistinctType() && !type.isDomainType() && type.isArrayType()) {
                row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = routine.getSchemaName().name;
                row[2] = routine.getName().name;
                row[3] = "ROUTINE";
                row[4] = type.getDefinition();
                this.addTypeInfo(row, ((ArrayType)type).collectionBaseType());
                try {
                    t.insertSys(session, store, row);
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
            Type returnType = type;
            int paramCount = routine.getParameterCount();
            for (int i = 0; i < paramCount; ++i) {
                ColumnSchema param = routine.getParameter(i);
                type = param.getDataType();
                if (type.isDistinctType() || type.isDomainType() || !type.isArrayType() || type.equals(returnType)) continue;
                row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = routine.getSchemaName().name;
                row[2] = routine.getName().name;
                row[3] = "ROUTINE";
                row[4] = type.getDefinition();
                this.addTypeInfo(row, ((ArrayType)type).collectionBaseType());
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    void addTypeInfo(Object[] row, Type type) {
        int data_type = 5;
        int character_maximum_length = 6;
        int character_octet_length = 7;
        int character_set_catalog = 8;
        int character_set_schema = 9;
        int character_set_name = 10;
        int collation_catalog = 11;
        int collation_schema = 12;
        int collation_name = 13;
        int numeric_precision = 14;
        int numeric_precision_radix = 15;
        int numeric_scale = 16;
        int datetime_precision = 17;
        int interval_type = 18;
        int interval_precision = 19;
        int maximum_cardinality = 26;
        int dtd_identifier = 27;
        int declared_data_type = 28;
        int declared_numeric_precision = 29;
        int declared_numeric_scale = 30;
        row[5] = type.getFullNameString();
        if (type.isCharacterType()) {
            row[6] = ValuePool.getLong(type.precision);
            row[7] = ValuePool.getLong(type.precision * 2L);
            row[8] = this.database.getCatalogName().name;
            row[9] = ((CharacterType)type).getCharacterSet().getSchemaName().name;
            row[10] = ((CharacterType)type).getCharacterSet().getName().name;
            row[11] = this.database.getCatalogName().name;
            row[12] = ((CharacterType)type).getCollation().getSchemaName().name;
            row[13] = ((CharacterType)type).getCollation().getName().name;
        } else if (type.isNumberType()) {
            row[14] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
            row[29] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
            if (type.isExactNumberType()) {
                row[16] = row[30] = ValuePool.getLong(type.scale);
            }
            row[15] = ValuePool.getLong(type.getPrecisionRadix());
        } else if (!type.isBooleanType()) {
            if (type.isDateTimeType()) {
                row[17] = ValuePool.getLong(type.scale);
            } else if (type.isIntervalType()) {
                row[5] = "INTERVAL";
                IntervalType cfr_ignored_0 = (IntervalType)type;
                row[18] = IntervalType.getQualifier(type.typeCode);
                row[19] = ValuePool.getLong(type.precision);
                row[17] = ValuePool.getLong(type.scale);
            } else if (type.isBinaryType()) {
                row[6] = ValuePool.getLong(type.precision);
                row[7] = ValuePool.getLong(type.precision);
            } else if (type.isBitType()) {
                row[6] = ValuePool.getLong(type.precision);
                row[7] = ValuePool.getLong(type.precision);
            } else if (type.isArrayType()) {
                row[26] = ValuePool.getLong(type.arrayLimitCardinality());
            }
        }
        row[27] = type.getDefinition();
        row[28] = row[5];
    }

    Table ENABLED_ROLES(Session session, PersistentStore store) {
        Table t = this.sysTables[42];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[42]);
            this.addColumn(t, "ROLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[42].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, true);
            return t;
        }
        Iterator grantees = session.getGrantee().getAllRoles().iterator();
        while (grantees.hasNext()) {
            Grantee grantee = (Grantee)grantees.next();
            Object[] row = t.getEmptyRowData();
            row[0] = grantee.getName().getNameString();
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table JAR_JAR_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[44];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[44]);
            this.addColumn(t, "PATH_JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "PATH_JAR_SCHAMA", SQL_IDENTIFIER);
            this.addColumn(t, "PATH_JAR_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[44].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean path_jar_catalog = false;
        boolean path_jar_schema = true;
        int path_jar_name = 2;
        int jar_catalog = 3;
        int jar_schema = 4;
        int jar_name = 5;
        return t;
    }

    Table JARS(Session session, PersistentStore store) {
        Table t = this.sysTables[45];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[45]);
            this.addColumn(t, "JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_PATH", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[45].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3}, false);
            return t;
        }
        boolean jar_catalog = false;
        boolean jar_schema = true;
        int jar_name = 2;
        int jar_path = 3;
        return t;
    }

    Table KEY_COLUMN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[46];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[46]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(t, "POSITION_IN_UNIQUE_CONSTRAINT", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[46].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{2, 1, 0, 6, 7}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        int column_name = 6;
        int ordinal_position = 7;
        int position_in_unique_constraint = 8;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            String tableCatalog = this.database.getCatalogName().name;
            HsqlNameManager.HsqlName tableName = table.getName();
            if (table.isView() || !session.getGrantee().isAccessible(tableName)) continue;
            Constraint[] constraints = table.getConstraints();
            for (int i = 0; i < constraints.length; ++i) {
                Constraint constraint = constraints[i];
                if (constraint.getConstraintType() != 4 && constraint.getConstraintType() != 2 && constraint.getConstraintType() != 0) continue;
                String constraintName = constraint.getName().name;
                int[] cols = constraint.getMainColumns();
                int[] uniqueColMap = null;
                if (constraint.getConstraintType() == 0) {
                    Table uniqueConstTable = constraint.getMain();
                    Constraint uniqueConstraint = uniqueConstTable.getConstraint(constraint.getUniqueName().name);
                    int[] uniqueConstIndexes = uniqueConstraint.getMainColumns();
                    uniqueColMap = new int[cols.length];
                    for (int j = 0; j < cols.length; ++j) {
                        uniqueColMap[j] = ArrayUtil.find(uniqueConstIndexes, cols[j]);
                    }
                    cols = constraint.getRefColumns();
                }
                if (!session.getGrantee().hasColumnRights(table, cols)) continue;
                for (int j = 0; j < cols.length; ++j) {
                    Object[] row = t.getEmptyRowData();
                    row[0] = tableCatalog;
                    row[1] = tableName.schema.name;
                    row[2] = constraintName;
                    row[3] = tableCatalog;
                    row[4] = tableName.schema.name;
                    row[5] = tableName.name;
                    row[6] = table.getColumn((int)cols[j]).getName().name;
                    row[7] = ValuePool.getLong(j + 1);
                    if (constraint.getConstraintType() == 0) {
                        row[8] = ValuePool.getInt(uniqueColMap[j] + 1);
                    }
                    t.insertSys(session, store, row);
                }
            }
        }
        return t;
    }

    Table METHOD_SPECIFICATION_PARAMETERS(Session session, PersistentStore store) {
        return null;
    }

    Table METHOD_SPECIFICATIONS(Session session, PersistentStore store) {
        return null;
    }

    Table MODULE_COLUMN_USAGE(Session session, PersistentStore store) {
        return null;
    }

    Table MODULE_PRIVILEGES(Session session, PersistentStore store) {
        return null;
    }

    Table MODULE_TABLE_USAGE(Session session, PersistentStore store) {
        return null;
    }

    Table MODULES(Session session, PersistentStore store) {
        return null;
    }

    Table PARAMETERS(Session session, PersistentStore store) {
        Table t = this.sysTables[52];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[52]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ORDINAL_POSITION", CARDINAL_NUMBER);
            this.addColumn(t, "PARAMETER_MODE", CHARACTER_DATA);
            this.addColumn(t, "IS_RESULT", YES_OR_NO);
            this.addColumn(t, "AS_LOCATOR", YES_OR_NO);
            this.addColumn(t, "PARAMETER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "FROM_SQL_SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "FROM_SQL_SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "FROM_SQL_SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TO_SQL_SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TO_SQL_SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TO_SQL_SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_SET_CATALOG", CHARACTER_DATA);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[52].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3}, false);
            return t;
        }
        boolean specific_cat = false;
        boolean specific_schem = true;
        int specific_name = 2;
        int ordinal_position = 3;
        int parameter_mode = 4;
        int is_result = 5;
        int as_locator = 6;
        int parameter_name = 7;
        int from_specific_catalog = 8;
        int from_specific_schema = 9;
        int from_specific_name = 10;
        int to_specific_catalog = 11;
        int to_specific_schema = 12;
        int to_specific_name = 13;
        int data_type = 14;
        int character_maximum_length = 15;
        int character_octet_length = 16;
        int character_set_catalog = 17;
        int character_set_schema = 18;
        int character_set_name = 19;
        int collation_catalog = 20;
        int collation_schema = 21;
        int collation_name = 22;
        int numeric_precision = 23;
        int numeric_precision_radix = 24;
        int numeric_scale = 25;
        int datetime_precision = 26;
        int interval_type = 27;
        int interval_precision = 28;
        int udt_catalog = 29;
        int udt_schema = 30;
        int udt_name = 31;
        int scope_catalog = 32;
        int scope_schema = 33;
        int scope_name = 34;
        int maximum_cardinality = 35;
        int dtd_identifier = 36;
        Iterator routines = this.database.schemaManager.databaseObjectIterator(18);
        while (routines.hasNext()) {
            RoutineSchema routineSchema = (RoutineSchema)routines.next();
            if (!session.getGrantee().isAccessible(routineSchema)) continue;
            Routine[] specifics = routineSchema.getSpecificRoutines();
            for (int i = 0; i < specifics.length; ++i) {
                Routine routine = specifics[i];
                int columnCount = routine.getParameterCount();
                for (int j = 0; j < columnCount; ++j) {
                    ColumnSchema column = routine.getParameter(j);
                    Type type = column.getDataType();
                    Object[] row = t.getEmptyRowData();
                    row[0] = this.database.getCatalogName().name;
                    row[1] = routine.getSchemaName().name;
                    row[2] = routine.getSpecificName().name;
                    row[7] = column.getName().name;
                    row[3] = ValuePool.getLong(j + 1);
                    switch (column.getParameterMode()) {
                        case 1: {
                            row[4] = "IN";
                            break;
                        }
                        case 4: {
                            row[4] = "OUT";
                            break;
                        }
                        case 2: {
                            row[4] = "INOUT";
                        }
                    }
                    row[5] = "NO";
                    row[6] = "NO";
                    row[14] = type.getFullNameString();
                    if (type.isCharacterType()) {
                        row[15] = ValuePool.getLong(type.precision);
                        row[16] = ValuePool.getLong(type.precision * 2L);
                        row[17] = this.database.getCatalogName().name;
                        row[18] = ((CharacterType)type).getCharacterSet().getSchemaName().name;
                        row[19] = ((CharacterType)type).getCharacterSet().getName().name;
                        row[20] = this.database.getCatalogName().name;
                        row[21] = ((CharacterType)type).getCollation().getSchemaName().name;
                        row[22] = ((CharacterType)type).getCollation().getName().name;
                    } else if (type.isNumberType()) {
                        row[23] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                        row[24] = ValuePool.getLong(type.getPrecisionRadix());
                    } else if (!type.isBooleanType()) {
                        if (type.isDateTimeType()) {
                            row[26] = ValuePool.getLong(type.scale);
                        } else if (type.isIntervalType()) {
                            row[14] = "INTERVAL";
                            IntervalType cfr_ignored_0 = (IntervalType)type;
                            row[27] = IntervalType.getQualifier(type.typeCode);
                            row[28] = ValuePool.getLong(type.precision);
                            row[26] = ValuePool.getLong(type.scale);
                        } else if (type.isBinaryType()) {
                            row[15] = ValuePool.getLong(type.precision);
                            row[16] = ValuePool.getLong(type.precision);
                        } else if (type.isBitType()) {
                            row[15] = ValuePool.getLong(type.precision);
                            row[16] = ValuePool.getLong(type.precision);
                        } else if (type.isArrayType()) {
                            row[35] = ValuePool.getLong(type.arrayLimitCardinality());
                            row[14] = "ARRAY";
                        }
                    }
                    if (type.isDistinctType()) {
                        row[29] = this.database.getCatalogName().name;
                        row[30] = type.getSchemaName().name;
                        row[31] = type.getName().name;
                    }
                    row[36] = type.getDefinition();
                    t.insertSys(session, store, row);
                }
            }
        }
        return t;
    }

    Table REFERENTIAL_CONSTRAINTS(Session session, PersistentStore store) {
        Table t = this.sysTables[53];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[53]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "UNIQUE_CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UNIQUE_CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UNIQUE_CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MATCH_OPTION", CHARACTER_DATA);
            this.addColumn(t, "UPDATE_RULE", CHARACTER_DATA);
            this.addColumn(t, "DELETE_RULE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[53].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int unique_constraint_catalog = 3;
        int unique_constraint_schema = 4;
        int unique_constraint_name = 5;
        int match_option = 6;
        int update_rule = 7;
        int delete_rule = 8;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.isView() || !session.getGrantee().hasNonSelectTableRight(table)) continue;
            Constraint[] constraints = table.getConstraints();
            for (int i = 0; i < constraints.length; ++i) {
                Constraint constraint = constraints[i];
                if (constraint.getConstraintType() != 0) continue;
                HsqlNameManager.HsqlName uniqueName = constraint.getUniqueName();
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = constraint.getSchemaName().name;
                row[2] = constraint.getName().name;
                if (this.isAccessibleTable(session, constraint.getMain())) {
                    row[3] = this.database.getCatalogName().name;
                    row[4] = uniqueName.schema.name;
                    row[5] = uniqueName.name;
                }
                row[6] = "NONE";
                row[7] = constraint.getUpdateActionString();
                row[8] = constraint.getDeleteActionString();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table ROLE_COLUMN_GRANTS(Session session, PersistentStore store) {
        Table t = this.sysTables[55];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[55]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[55].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{5, 6, 1, 0, 4, 3, 2}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result rs = sys.executeDirectStatement("SELECT GRANTOR, GRANTEE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, PRIVILEGE_TYPE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON GRANTEE = ROLE_NAME;");
        t.insertSys(session, store, rs);
        sys.close();
        return t;
    }

    Table ROLE_ROUTINE_GRANTS(Session session, PersistentStore store) {
        Table t = this.sysTables[57];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[57]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[57].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result rs = sys.executeDirectStatement("SELECT GRANTOR, GRANTEE, SPECIFIC_CATALOG, SPECIFIC_SCHEMA, SPECIFIC_NAME, ROUTINE_CATALOG, ROUTINE_SCHEMA, ROUTINE_NAME, PRIVILEGE_TYPE, IS_GRANTABLE FROM INFORMATION_SCHEMA.ROUTINE_PRIVILEGES JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON GRANTEE = ROLE_NAME;");
        t.insertSys(session, store, rs);
        sys.close();
        boolean grantor = false;
        boolean grantee = true;
        int table_name = 2;
        int specific_catalog = 3;
        int specific_schema = 4;
        int specific_name = 5;
        int routine_catalog = 6;
        int routine_schema = 7;
        int routine_name = 8;
        int privilege_type = 9;
        int is_grantable = 10;
        return t;
    }

    Table ROLE_TABLE_GRANTS(Session session, PersistentStore store) {
        Table t = this.sysTables[58];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[58]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            this.addColumn(t, "WITH_HIERARCHY", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[58].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 4, 5, 0, 1}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result rs = sys.executeDirectStatement("SELECT GRANTOR, GRANTEE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, PRIVILEGE_TYPE, IS_GRANTABLE, 'NO' FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON GRANTEE = ROLE_NAME;");
        t.insertSys(session, store, rs);
        sys.close();
        return t;
    }

    Table ROLE_UDT_GRANTS(Session session, PersistentStore store) {
        Table t = this.sysTables[59];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[59]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[58].name, false, 20);
            t.createPrimaryKeyConstraint(name, null, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result rs = sys.executeDirectStatement("SELECT GRANTOR, GRANTEE, UDT_CATALOG, UDT_SCHEMA, UDT_NAME, PRIVILEGE_TYPE, IS_GRANTABLE FROM INFORMATION_SCHEMA.UDT_PRIVILEGES JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON GRANTEE = ROLE_NAME;");
        t.insertSys(session, store, rs);
        sys.close();
        return t;
    }

    Table ROLE_USAGE_GRANTS(Session session, PersistentStore store) {
        Table t = this.sysTables[60];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[60]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_TYPE", CHARACTER_DATA);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[60].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6, 7}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        Result rs = sys.executeDirectStatement("SELECT GRANTOR, GRANTEE, OBJECT_CATALOG, OBJECT_SCHEMA, OBJECT_NAME, OBJECT_TYPE, PRIVILEGE_TYPE, IS_GRANTABLE FROM INFORMATION_SCHEMA.USAGE_PRIVILEGES JOIN INFORMATION_SCHEMA.APPLICABLE_ROLES ON GRANTEE = ROLE_NAME;");
        t.insertSys(session, store, rs);
        sys.close();
        return t;
    }

    Table ROUTINE_COLUMN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[61];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[61]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[61].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 4, 5, 0, 1, 2, 6, 7, 8, 9}, false);
            return t;
        }
        boolean specific_catalog = false;
        boolean specific_schema = true;
        int specific_name = 2;
        int routine_catalog = 3;
        int routine_schema = 4;
        int routine_name = 5;
        int table_catalog = 6;
        int table_schema = 7;
        int table_name = 8;
        int column_name = 9;
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            OrderedHashSet set = routine.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 9 || !session.getGrantee().isFullyAccessibleByRole(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = routine.getSchemaName().name;
                row[2] = routine.getSpecificName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = routine.getSchemaName().name;
                row[5] = routine.getName().name;
                row[6] = this.database.getCatalogName().name;
                row[7] = refName.parent.schema.name;
                row[8] = refName.parent.name;
                row[9] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table ROUTINE_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[63];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[63]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[63].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int specific_catalog = 2;
        int specific_schema = 3;
        int specific_name = 4;
        int routine_catalog = 5;
        int routine_schema = 6;
        int routine_name = 7;
        int privilege_type = 8;
        int is_grantable = 9;
        OrderedHashSet grantees = session.getGrantee().visibleGrantees();
        Iterator routines = this.database.schemaManager.databaseObjectIterator(24);
        while (routines.hasNext()) {
            Routine routine = (Routine)routines.next();
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(routine);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(routine);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    if (!right.canAccessFully(32)) continue;
                    String privilege = "EXECUTE";
                    Object[] row = t.getEmptyRowData();
                    row[0] = right.getGrantor().getName().name;
                    row[1] = right.getGrantee().getName().name;
                    row[2] = this.database.getCatalogName().name;
                    row[3] = routine.getSchemaName().name;
                    row[4] = routine.getSpecificName().name;
                    row[5] = this.database.getCatalogName().name;
                    row[6] = routine.getSchemaName().name;
                    row[7] = routine.getName().name;
                    row[8] = privilege;
                    row[9] = right.getGrantee() == routine.getOwner() || grantableRight.canAccessFully(32) ? "YES" : "NO";
                    try {
                        t.insertSys(session, store, row);
                        continue;
                    }
                    catch (HsqlException e) {
                        // empty catch block
                    }
                }
            }
        }
        return t;
    }

    Table ROUTINE_JAR_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[62];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[62]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "JAR_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[62].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean specific_catalog = false;
        boolean specific_schema = true;
        int specific_name = 2;
        int jar_catalog = 3;
        int jar_schema = 4;
        int jar_name = 5;
        if (!session.isAdmin()) {
            return t;
        }
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            if (routine.getLanguage() != 1) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = routine.getSchemaName().name;
            row[2] = routine.getSpecificName().name;
            row[3] = this.database.getCatalogName().name;
            row[4] = this.database.schemaManager.getSQLJSchemaHsqlName();
            row[5] = "CLASSPATH";
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table ROUTINE_ROUTINE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[64];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[64]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[64].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean specific_catalog = false;
        boolean specific_schema = true;
        int specific_name = 2;
        int routine_catalog = 3;
        int routine_schema = 4;
        int routine_name = 5;
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            OrderedHashSet set = routine.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 24 || !session.getGrantee().isFullyAccessibleByRole(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = routine.getSchemaName().name;
                row[2] = routine.getSpecificName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table ROUTINE_SEQUENCE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[65];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[65]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[65].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean specific_catalog = false;
        boolean specific_schema = true;
        int specific_name = 2;
        int sequence_catalog = 3;
        int sequence_schema = 4;
        int sequence_name = 5;
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            OrderedHashSet set = routine.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 7 || !session.getGrantee().isFullyAccessibleByRole(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = routine.getSchemaName().name;
                row[2] = routine.getSpecificName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table ROUTINE_TABLE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[66];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[66]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[66].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 4, 5, 0, 1, 2, 6, 7, 8}, false);
            return t;
        }
        boolean specific_catalog = false;
        boolean specific_schema = true;
        int specific_name = 2;
        int routine_catalog = 3;
        int routine_schema = 4;
        int routine_name = 5;
        int table_catalog = 6;
        int table_schema = 7;
        int table_name = 8;
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            OrderedHashSet set = routine.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 3 && refName.type != 4 || !session.getGrantee().isFullyAccessibleByRole(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = routine.getSchemaName().name;
                row[2] = routine.getSpecificName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = routine.getSchemaName().name;
                row[5] = routine.getName().name;
                row[6] = this.database.getCatalogName().name;
                row[7] = refName.schema.name;
                row[8] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table ROUTINES(Session session, PersistentStore store) {
        Table t = this.sysTables[67];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[67]);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "MODULE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "MODULE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "MODULE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "TYPE_UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TYPE_UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "DTD_IDENTIFIER", SQL_IDENTIFIER);
            this.addColumn(t, "ROUTINE_BODY", CHARACTER_DATA);
            this.addColumn(t, "ROUTINE_DEFINITION", CHARACTER_DATA);
            this.addColumn(t, "EXTERNAL_NAME", CHARACTER_DATA);
            this.addColumn(t, "EXTERNAL_LANGUAGE", CHARACTER_DATA);
            this.addColumn(t, "PARAMETER_STYLE", CHARACTER_DATA);
            this.addColumn(t, "IS_DETERMINISTIC", YES_OR_NO);
            this.addColumn(t, "SQL_DATA_ACCESS", CHARACTER_DATA);
            this.addColumn(t, "IS_NULL_CALL", YES_OR_NO);
            this.addColumn(t, "SQL_PATH", CHARACTER_DATA);
            this.addColumn(t, "SCHEMA_LEVEL_ROUTINE", YES_OR_NO);
            this.addColumn(t, "MAX_DYNAMIC_RESULT_SETS", CARDINAL_NUMBER);
            this.addColumn(t, "IS_USER_DEFINED_CAST", YES_OR_NO);
            this.addColumn(t, "IS_IMPLICITLY_INVOCABLE", YES_OR_NO);
            this.addColumn(t, "SECURITY_TYPE", CHARACTER_DATA);
            this.addColumn(t, "TO_SQL_SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TO_SQL_SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TO_SQL_SPECIFIC_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "AS_LOCATOR", YES_OR_NO);
            this.addColumn(t, "CREATED", TIME_STAMP);
            this.addColumn(t, "LAST_ALTERED", TIME_STAMP);
            this.addColumn(t, "NEW_SAVEPOINT_LEVEL", YES_OR_NO);
            this.addColumn(t, "IS_UDT_DEPENDENT", YES_OR_NO);
            this.addColumn(t, "RESULT_CAST_FROM_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "RESULT_CAST_AS_LOCATOR", YES_OR_NO);
            this.addColumn(t, "RESULT_CAST_CHAR_MAX_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_CHAR_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_CHAR_SET_CATALOG", CHARACTER_DATA);
            this.addColumn(t, "RESULT_CAST_CHAR_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_NUMERIC_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "RESULT_CAST_INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_TYPE_UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_TYPE_UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_TYPE_UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_SCOPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "RESULT_CAST_MAX_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_DTD_IDENTIFIER", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_FROM_DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "RESULT_CAST_DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "RESULT_CAST_DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[67].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{3, 4, 5, 0, 1, 2}, false);
            return t;
        }
        boolean specific_catalog = false;
        boolean specific_schema = true;
        int specific_name = 2;
        int routine_catalog = 3;
        int routine_schema = 4;
        int routine_name = 5;
        int routine_type = 6;
        int module_catalog = 7;
        int module_schema = 8;
        int module_name = 9;
        int udt_catalog = 10;
        int udt_schema = 11;
        int udt_name = 12;
        int data_type = 13;
        int character_maximum_length = 14;
        int character_octet_length = 15;
        int character_set_catalog = 16;
        int character_set_schema = 17;
        int character_set_name = 18;
        int collation_catalog = 19;
        int collation_schema = 20;
        int collation_name = 21;
        int numeric_precision = 22;
        int numeric_precision_radix = 23;
        int numeric_scale = 24;
        int datetime_precision = 25;
        int interval_type = 26;
        int interval_precision = 27;
        int type_udt_catalog = 28;
        int type_udt_schema = 29;
        int type_udt_name = 30;
        int scope_catalog = 31;
        int scope_schema = 32;
        int scope_name = 33;
        int maximum_cardinality = 34;
        int dtd_identifier = 35;
        int routine_body = 36;
        int routine_definition = 37;
        int external_name = 38;
        int external_language = 39;
        int parameter_style = 40;
        int is_deterministic = 41;
        int sql_data_access = 42;
        int is_null_call = 43;
        int sql_path = 44;
        int schema_level_routine = 45;
        int max_dynamic_result_sets = 46;
        int is_user_defined_cast = 47;
        int is_implicitly_invocable = 48;
        int security_type = 49;
        int to_sql_specific_catalog = 50;
        int to_sql_specific_schema = 51;
        int to_sql_specific_name = 52;
        int as_locator = 53;
        int created = 54;
        int last_altered = 55;
        int new_savepoint_level = 56;
        int is_udt_dependent = 57;
        int result_cast_from_data_type = 58;
        int result_cast_as_locator = 59;
        int result_cast_char_max_length = 60;
        int result_cast_char_octet_length = 61;
        int result_cast_char_set_catalog = 62;
        int result_cast_char_set_schema = 63;
        int result_cast_character_set_name = 64;
        int result_cast_collation_catalog = 65;
        int result_cast_collation_schema = 66;
        int result_cast_collation_name = 67;
        int result_cast_numeric_precision = 68;
        int result_cast_numeric_radix = 69;
        int result_cast_numeric_scale = 70;
        int result_cast_datetime_precision = 71;
        int result_cast_interval_type = 72;
        int result_cast_interval_precision = 73;
        int result_cast_type_udt_catalog = 74;
        int result_cast_type_udt_schema = 75;
        int result_cast_type_udt_name = 76;
        int result_cast_scope_catalog = 77;
        int result_cast_scope_schema = 78;
        int result_cast_scope_name = 79;
        int result_cast_max_cardinality = 80;
        int result_cast_dtd_identifier = 81;
        int declared_data_type = 82;
        int declared_numeric_precision = 83;
        int declared_numeric_scale = 84;
        int result_cast_from_declared_data_type = 85;
        int result_cast_declared_numeric_precision = 86;
        int result_cast_declared_numeric_scale = 87;
        Iterator it = this.database.schemaManager.databaseObjectIterator(24);
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            if (!session.getGrantee().isAccessible(routine)) continue;
            boolean isFullyAccessible = session.getGrantee().isFullyAccessibleByRole(routine.getName());
            Object[] row = t.getEmptyRowData();
            Type type = routine.isProcedure() ? null : routine.getReturnType();
            row[0] = this.database.getCatalogName().name;
            row[1] = routine.getSchemaName().name;
            row[2] = routine.getSpecificName().name;
            row[3] = this.database.getCatalogName().name;
            row[4] = routine.getSchemaName().name;
            row[5] = routine.getName().name;
            row[6] = routine.isProcedure() ? "PROCEDURE" : "FUNCTION";
            row[7] = null;
            row[8] = null;
            row[9] = null;
            row[10] = null;
            row[11] = null;
            row[12] = null;
            Object object = row[13] = type == null ? null : type.getNameString();
            if (type != null) {
                if (type.isCharacterType()) {
                    row[14] = ValuePool.getLong(type.precision);
                    row[15] = ValuePool.getLong(type.precision * 2L);
                    row[16] = this.database.getCatalogName().name;
                    row[17] = ((CharacterType)type).getCharacterSet().getSchemaName().name;
                    row[18] = ((CharacterType)type).getCharacterSet().getName().name;
                    row[19] = this.database.getCatalogName().name;
                    row[20] = ((CharacterType)type).getCollation().getSchemaName().name;
                    row[21] = ((CharacterType)type).getCollation().getName().name;
                } else if (type.isNumberType()) {
                    row[22] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    row[83] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                    if (type.isExactNumberType()) {
                        row[24] = row[84] = ValuePool.getLong(type.scale);
                    }
                    row[23] = ValuePool.getLong(type.getPrecisionRadix());
                } else if (!type.isBooleanType()) {
                    if (type.isDateTimeType()) {
                        row[25] = ValuePool.getLong(type.scale);
                    } else if (type.isIntervalType()) {
                        row[13] = "INTERVAL";
                        IntervalType cfr_ignored_0 = (IntervalType)type;
                        row[26] = IntervalType.getQualifier(type.typeCode);
                        row[27] = ValuePool.getLong(type.precision);
                        row[25] = ValuePool.getLong(type.scale);
                    } else if (type.isBinaryType()) {
                        row[14] = ValuePool.getLong(type.precision);
                        row[15] = ValuePool.getLong(type.precision);
                    } else if (type.isBitType()) {
                        row[14] = ValuePool.getLong(type.precision);
                        row[15] = ValuePool.getLong(type.precision);
                    } else if (type.isArrayType()) {
                        row[34] = ValuePool.getLong(type.arrayLimitCardinality());
                        row[13] = "ARRAY";
                    }
                }
                row[35] = type.getDefinition();
                row[82] = row[13];
            }
            row[28] = null;
            row[29] = null;
            row[30] = null;
            row[31] = null;
            row[32] = null;
            row[33] = null;
            row[36] = routine.getLanguage() == 1 ? "EXTERNAL" : "SQL";
            row[37] = isFullyAccessible ? routine.getSQL() : null;
            row[38] = routine.getExternalName();
            row[39] = routine.getLanguage() == 1 ? "JAVA" : null;
            row[40] = routine.getLanguage() == 1 ? "JAVA" : null;
            row[41] = routine.isDeterministic() ? "YES" : "NO";
            row[42] = routine.getDataImpactString();
            row[43] = type == null ? null : (routine.isNullInputOutput() ? "YES" : "NO");
            row[44] = null;
            row[45] = "YES";
            row[46] = ValuePool.getLong(0L);
            row[47] = type == null ? null : "NO";
            row[48] = null;
            row[49] = "DEFINER";
            row[50] = null;
            row[51] = null;
            row[52] = null;
            row[53] = type == null ? null : "NO";
            row[54] = null;
            row[55] = null;
            row[56] = "YES";
            row[57] = null;
            row[58] = null;
            row[59] = null;
            row[60] = null;
            row[61] = null;
            row[62] = null;
            row[63] = null;
            row[64] = null;
            row[65] = null;
            row[66] = null;
            row[67] = null;
            row[68] = null;
            row[69] = null;
            row[70] = null;
            row[71] = null;
            row[72] = null;
            row[73] = null;
            row[74] = null;
            row[75] = null;
            row[76] = null;
            row[77] = null;
            row[78] = null;
            row[79] = null;
            row[80] = null;
            row[81] = null;
            row[82] = row[13];
            row[83] = row[22];
            row[84] = row[24];
            row[85] = null;
            row[86] = null;
            row[87] = null;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SCHEMATA(Session session, PersistentStore store) {
        Table t = this.sysTables[68];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[68]);
            this.addColumn(t, "CATALOG_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SCHEMA_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SCHEMA_OWNER", SQL_IDENTIFIER);
            this.addColumn(t, "DEFAULT_CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "DEFAULT_CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "DEFAULT_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SQL_PATH", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[68].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, false);
            return t;
        }
        String dcsSchema = "INFORMATION_SCHEMA";
        String dcsName = ValuePool.getString("UTF16");
        Object sqlPath = null;
        Grantee user = session.getGrantee();
        boolean schema_catalog = false;
        boolean schema_name = true;
        int schema_owner = 2;
        int default_character_set_catalog = 3;
        int default_character_set_schema = 4;
        int default_character_set_name = 5;
        int sql_path = 6;
        Schema[] schemas = this.database.schemaManager.getAllSchemas();
        for (int i = 0; i < schemas.length; ++i) {
            Schema schema = schemas[i];
            if (!user.hasSchemaUpdateOrGrantRights(schema.getName().getNameString())) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = schema.getName().getNameString();
            row[2] = schema.getOwner().getName().getNameString();
            row[3] = this.database.getCatalogName().name;
            row[4] = dcsSchema;
            row[5] = dcsName;
            row[6] = sqlPath;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table SQL_FEATURES(Session session, PersistentStore store) {
        Table t = this.sysTables[70];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[70]);
            this.addColumn(t, "FEATURE_ID", CHARACTER_DATA);
            this.addColumn(t, "FEATURE_NAME", CHARACTER_DATA);
            this.addColumn(t, "SUB_FEATURE_ID", CHARACTER_DATA);
            this.addColumn(t, "SUB_FEATURE_NAME", CHARACTER_DATA);
            this.addColumn(t, "IS_SUPPORTED", YES_OR_NO);
            this.addColumn(t, "IS_VERIFIED_BY", CHARACTER_DATA);
            this.addColumn(t, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[70].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 2}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String sql = (String)statementMap.get("/*sql_features*/");
        Result rs = sys.executeDirectStatement(sql);
        t.insertSys(session, store, rs);
        return t;
    }

    Table SQL_IMPLEMENTATION_INFO(Session session, PersistentStore store) {
        Table t = this.sysTables[71];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[71]);
            this.addColumn(t, "IMPLEMENTATION_INFO_ID", CARDINAL_NUMBER);
            this.addColumn(t, "IMPLEMENTATION_INFO_NAME", CHARACTER_DATA);
            this.addColumn(t, "INTEGER_VALUE", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_VALUE", CHARACTER_DATA);
            this.addColumn(t, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[71].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String sql = (String)statementMap.get("/*sql_implementation_info*/");
        Result rs = sys.executeDirectStatement(sql);
        t.insertSys(session, store, rs);
        return t;
    }

    Table SQL_PACKAGES(Session session, PersistentStore store) {
        Table t = this.sysTables[72];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[72]);
            this.addColumn(t, "ID", CHARACTER_DATA);
            this.addColumn(t, "NAME", CHARACTER_DATA);
            this.addColumn(t, "IS_SUPPORTED", YES_OR_NO);
            this.addColumn(t, "IS_VERIFIED_BY", CHARACTER_DATA);
            this.addColumn(t, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[72].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String sql = (String)statementMap.get("/*sql_packages*/");
        Result rs = sys.executeDirectStatement(sql);
        t.insertSys(session, store, rs);
        return t;
    }

    Table SQL_PARTS(Session session, PersistentStore store) {
        Table t = this.sysTables[73];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[73]);
            this.addColumn(t, "PART", CHARACTER_DATA);
            this.addColumn(t, "NAME", CHARACTER_DATA);
            this.addColumn(t, "IS_SUPPORTED", YES_OR_NO);
            this.addColumn(t, "IS_VERIFIED_BY", CHARACTER_DATA);
            this.addColumn(t, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[73].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String sql = (String)statementMap.get("/*sql_parts*/");
        Result rs = sys.executeDirectStatement(sql);
        t.insertSys(session, store, rs);
        return t;
    }

    Table SQL_SIZING(Session session, PersistentStore store) {
        Table t = this.sysTables[74];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[74]);
            this.addColumn(t, "SIZING_ID", CARDINAL_NUMBER);
            this.addColumn(t, "SIZING_NAME", CHARACTER_DATA);
            this.addColumn(t, "SUPPORTED_VALUE", CARDINAL_NUMBER);
            this.addColumn(t, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[74].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        String sql = (String)statementMap.get("/*sql_sizing*/");
        Result rs = sys.executeDirectStatement(sql);
        t.insertSys(session, store, rs);
        return t;
    }

    Table SQL_SIZING_PROFILES(Session session, PersistentStore store) {
        Table t = this.sysTables[75];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[75]);
            this.addColumn(t, "SIZING_ID", CARDINAL_NUMBER);
            this.addColumn(t, "SIZING_NAME", CHARACTER_DATA);
            this.addColumn(t, "PROFILE_ID", CARDINAL_NUMBER);
            this.addColumn(t, "PROFILE_NAME", CHARACTER_DATA);
            this.addColumn(t, "REQUIRED_VALUE", CARDINAL_NUMBER);
            this.addColumn(t, "COMMENTS", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[75].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0}, false);
            return t;
        }
        Session sys = this.database.sessionManager.newSysSession(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, session.getUser());
        return t;
    }

    Table TABLE_CONSTRAINTS(Session session, PersistentStore store) {
        Table t = this.sysTables[76];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[76]);
            this.addColumn(t, "CONSTRAINT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "CONSTRAINT_TYPE", CHARACTER_DATA);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "IS_DEFERRABLE", YES_OR_NO);
            this.addColumn(t, "INITIALLY_DEFERRED", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[76].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 4, 5, 6}, false);
            return t;
        }
        boolean constraint_catalog = false;
        boolean constraint_schema = true;
        int constraint_name = 2;
        int constraint_type = 3;
        int table_catalog = 4;
        int table_schema = 5;
        int table_name = 6;
        int is_deferable = 7;
        int initially_deferred = 8;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        Table table = null;
        while (tables.hasNext()) {
            table = (Table)tables.next();
            if (table.isView() || !session.getGrantee().hasNonSelectTableRight(table)) continue;
            block7: for (Constraint constraint : table.getConstraints()) {
                Object[] row = t.getEmptyRowData();
                switch (constraint.getConstraintType()) {
                    case 3: {
                        row[3] = "CHECK";
                        break;
                    }
                    case 2: {
                        row[3] = "UNIQUE";
                        break;
                    }
                    case 0: {
                        row[3] = "FOREIGN KEY";
                        table = constraint.getRef();
                        break;
                    }
                    case 4: {
                        row[3] = "PRIMARY KEY";
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                String cat = this.database.getCatalogName().name;
                String schem = table.getSchemaName().name;
                row[0] = cat;
                row[1] = schem;
                row[2] = constraint.getName().name;
                row[4] = cat;
                row[5] = schem;
                row[6] = table.getName().name;
                row[7] = "NO";
                row[8] = "NO";
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table TRANSLATIONS(Session session, PersistentStore store) {
        Table t = this.sysTables[79];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[79]);
            this.addColumn(t, "TRANSLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRANSLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRANSLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SOURCE_CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SOURCE_CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SOURCE_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TARGET_CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TARGET_CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TARGET_CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TRANSLATION_SOURCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRANSLATION_SOURCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRANSLATION_SOURCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[79].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        return t;
    }

    Table TRIGGER_COLUMN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[80];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[80]);
            this.addColumn(t, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[80].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean trigger_catalog = false;
        boolean trigger_schema = true;
        int trigger_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        int column_name = 6;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            TriggerDef trigger = (TriggerDef)it.next();
            if (!session.getGrantee().isFullyAccessibleByRole(trigger.getName())) continue;
            OrderedHashSet set = trigger.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 9 || !session.getGrantee().isAccessible(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = trigger.getSchemaName().name;
                row[2] = trigger.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.parent.schema.name;
                row[5] = refName.parent.name;
                row[6] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table TRIGGER_ROUTINE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[81];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[81]);
            this.addColumn(t, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[81].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean trigger_catalog = false;
        boolean trigger_schema = true;
        int trigger_name = 2;
        int specific_catalog = 3;
        int specific_schema = 4;
        int specific_name = 5;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            TriggerDef trigger = (TriggerDef)it.next();
            if (!session.getGrantee().isFullyAccessibleByRole(trigger.getName())) continue;
            OrderedHashSet set = trigger.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 24) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = trigger.getSchemaName().name;
                row[2] = trigger.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table TRIGGER_SEQUENCE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[82];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[82]);
            this.addColumn(t, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SEQUENCE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[82].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean trigger_catalog = false;
        boolean trigger_schema = true;
        int trigger_name = 2;
        int sequence_catalog = 3;
        int sequence_schema = 4;
        int sequence_name = 5;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            TriggerDef trigger = (TriggerDef)it.next();
            if (!session.getGrantee().isFullyAccessibleByRole(trigger.getName())) continue;
            OrderedHashSet set = trigger.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 7) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = trigger.getSchemaName().name;
                row[2] = trigger.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table TRIGGER_TABLE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[83];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[83]);
            this.addColumn(t, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[83].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean trigger_catalog = false;
        boolean trigger_schema = true;
        int trigger_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            TriggerDef trigger = (TriggerDef)it.next();
            if (!session.getGrantee().isFullyAccessibleByRole(trigger.getName())) continue;
            OrderedHashSet set = trigger.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 3 && refName.type != 4) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = trigger.getSchemaName().name;
                row[2] = trigger.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table TRIGGERS(Session session, PersistentStore store) {
        Table t = this.sysTables[85];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[85]);
            this.addColumn(t, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_MANIPULATION", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_TABLE", SQL_IDENTIFIER);
            this.addColumn(t, "ACTION_ORDER", CARDINAL_NUMBER);
            this.addColumn(t, "ACTION_CONDITION", CHARACTER_DATA);
            this.addColumn(t, "ACTION_STATEMENT", CHARACTER_DATA);
            this.addColumn(t, "ACTION_ORIENTATION", CHARACTER_DATA);
            this.addColumn(t, "ACTION_TIMING", CHARACTER_DATA);
            this.addColumn(t, "ACTION_REFERENCE_OLD_TABLE", SQL_IDENTIFIER);
            this.addColumn(t, "ACTION_REFERENCE_NEW_TABLE", SQL_IDENTIFIER);
            this.addColumn(t, "ACTION_REFERENCE_OLD_ROW", SQL_IDENTIFIER);
            this.addColumn(t, "ACTION_REFERENCE_NEW_ROW", SQL_IDENTIFIER);
            this.addColumn(t, "CREATED", TIME_STAMP);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[85].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2}, false);
            return t;
        }
        boolean trigger_catalog = false;
        boolean trigger_schema = true;
        int trigger_name = 2;
        int event_manipulation = 3;
        int event_object_catalog = 4;
        int event_object_schema = 5;
        int event_object_table = 6;
        int action_order = 7;
        int action_condition = 8;
        int action_statement = 9;
        int action_orientation = 10;
        int action_timing = 11;
        int action_reference_old_table = 12;
        int action_reference_new_table = 13;
        int action_reference_old_row = 14;
        int action_reference_new_row = 15;
        int created = 16;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            TriggerDef trigger = (TriggerDef)it.next();
            boolean isFullAccess = session.getGrantee().isFullyAccessibleByRole(trigger.getName());
            if (!session.getGrantee().hasNonSelectTableRight(trigger.getTable())) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = trigger.getSchemaName().name;
            row[2] = trigger.getName().name;
            row[3] = trigger.getEventTypeString();
            row[4] = this.database.getCatalogName().name;
            row[5] = trigger.getTable().getSchemaName().name;
            row[6] = trigger.getTable().getName().name;
            int order = trigger.getTable().getTriggerIndex(trigger.getName().name);
            row[7] = ValuePool.getLong(order);
            row[8] = isFullAccess ? trigger.getConditionSQL() : null;
            row[9] = isFullAccess ? trigger.getProcedureSQL() : null;
            row[10] = trigger.getActionOrientationString();
            row[11] = trigger.getActionTimingString();
            row[12] = trigger.getOldTransitionTableName();
            row[13] = trigger.getNewTransitionTableName();
            row[14] = trigger.getOldTransitionRowName();
            row[15] = trigger.getNewTransitionRowName();
            row[16] = null;
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table TRIGGERED_UPDATE_COLUMNS(Session session, PersistentStore store) {
        Table t = this.sysTables[84];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[84]);
            this.addColumn(t, "TRIGGER_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TRIGGER_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_TABLE", SQL_IDENTIFIER);
            this.addColumn(t, "EVENT_OBJECT_COLUMN", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[84].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean trigger_catalog = false;
        boolean trigger_schema = true;
        int trigger_name = 2;
        int event_object_catalog = 3;
        int event_object_schema = 4;
        int event_object_table = 5;
        int event_object_column = 6;
        Iterator it = this.database.schemaManager.databaseObjectIterator(8);
        while (it.hasNext()) {
            int[] colIndexes;
            TriggerDef trigger = (TriggerDef)it.next();
            if (!session.getGrantee().isAccessible(trigger) || (colIndexes = trigger.getUpdateColumnIndexes()) == null) continue;
            for (int i = 0; i < colIndexes.length; ++i) {
                ColumnSchema column = trigger.getTable().getColumn(colIndexes[i]);
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = trigger.getSchemaName().name;
                row[2] = trigger.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = trigger.getTable().getSchemaName().name;
                row[5] = trigger.getTable().getName().name;
                row[6] = column.getNameString();
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    Table UDT_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[87];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[87]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "UDT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[87].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int udt_catalog = 2;
        int udt_schema = 3;
        int udt_name = 4;
        int privilege_type = 5;
        int is_grantable = 6;
        Iterator objects = this.database.schemaManager.databaseObjectIterator(12);
        OrderedHashSet grantees = session.getGrantee().getGranteeAndAllRolesWithPublic();
        while (objects.hasNext()) {
            SchemaObject object = (SchemaObject)objects.next();
            if (object.getType() != 12) continue;
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(object);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(object);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    Object[] row = t.getEmptyRowData();
                    row[0] = right.getGrantor().getName().name;
                    row[1] = right.getGrantee().getName().name;
                    row[2] = this.database.getCatalogName().name;
                    row[3] = object.getSchemaName().name;
                    row[4] = object.getName().name;
                    row[5] = "USAGE";
                    row[6] = right.getGrantee() == object.getOwner() || grantableRight.isFull() ? "YES" : "NO";
                    try {
                        t.insertSys(session, store, row);
                        continue;
                    }
                    catch (HsqlException e) {
                        // empty catch block
                    }
                }
            }
        }
        return t;
    }

    Table USAGE_PRIVILEGES(Session session, PersistentStore store) {
        Table t = this.sysTables[88];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[88]);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "OBJECT_TYPE", CHARACTER_DATA);
            this.addColumn(t, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[88].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6, 7}, false);
            return t;
        }
        boolean grantor = false;
        boolean grantee = true;
        int object_catalog = 2;
        int object_schema = 3;
        int object_name = 4;
        int object_type = 5;
        int privilege_type = 6;
        int is_grantable = 7;
        WrapperIterator objects = new WrapperIterator(this.database.schemaManager.databaseObjectIterator(7), this.database.schemaManager.databaseObjectIterator(15));
        objects = new WrapperIterator(objects, this.database.schemaManager.databaseObjectIterator(14));
        objects = new WrapperIterator(objects, this.database.schemaManager.databaseObjectIterator(13));
        OrderedHashSet grantees = session.getGrantee().getGranteeAndAllRolesWithPublic();
        while (objects.hasNext()) {
            SchemaObject object = (SchemaObject)objects.next();
            for (int i = 0; i < grantees.size(); ++i) {
                Grantee granteeObject = (Grantee)grantees.get(i);
                OrderedHashSet rights = granteeObject.getAllDirectPrivileges(object);
                OrderedHashSet grants = granteeObject.getAllGrantedPrivileges(object);
                if (!grants.isEmpty()) {
                    grants.addAll(rights);
                    rights = grants;
                }
                for (int j = 0; j < rights.size(); ++j) {
                    Right right = (Right)rights.get(j);
                    Right grantableRight = right.getGrantableRights();
                    Object[] row = t.getEmptyRowData();
                    row[0] = right.getGrantor().getName().name;
                    row[1] = right.getGrantee().getName().name;
                    row[2] = this.database.getCatalogName().name;
                    row[3] = object.getSchemaName().name;
                    row[4] = object.getName().name;
                    row[5] = SchemaObjectSet.getName(object.getName().type);
                    row[6] = "USAGE";
                    row[7] = right.getGrantee() == object.getOwner() || grantableRight.isFull() ? "YES" : "NO";
                    try {
                        t.insertSys(session, store, row);
                        continue;
                    }
                    catch (HsqlException e) {
                        // empty catch block
                    }
                }
            }
        }
        return t;
    }

    Table USER_DEFINED_TYPES(Session session, PersistentStore store) {
        Table t = this.sysTables[89];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[89]);
            this.addColumn(t, "USER_DEFINED_TYPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "USER_DEFINED_TYPE_CATEGORY", SQL_IDENTIFIER);
            this.addColumn(t, "IS_INSTANTIABLE", YES_OR_NO);
            this.addColumn(t, "IS_FINAL", YES_OR_NO);
            this.addColumn(t, "ORDERING_FORM", SQL_IDENTIFIER);
            this.addColumn(t, "ORDERING_CATEGORY", SQL_IDENTIFIER);
            this.addColumn(t, "ORDERING_ROUTINE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "ORDERING_ROUTINE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "ORDERING_ROUTINE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "REFERENCE_TYPE", SQL_IDENTIFIER);
            this.addColumn(t, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "CHARACTER_MAXIMUM_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_OCTET_LENGTH", CARDINAL_NUMBER);
            this.addColumn(t, "CHARACTER_SET_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "CHARACTER_SET_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "COLLATION_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(t, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "DATETIME_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "INTERVAL_TYPE", CHARACTER_DATA);
            this.addColumn(t, "INTERVAL_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "SOURCE_DTD_IDENTIFIER", CHARACTER_DATA);
            this.addColumn(t, "REF_DTD_IDENTIFIER", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(t, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(t, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(t, "MAXIMUM_CARDINALITY", CARDINAL_NUMBER);
            this.addColumn(t, "EXTERNAL_NAME", CHARACTER_DATA);
            this.addColumn(t, "EXTERNAL_LANGUAGE", CHARACTER_DATA);
            this.addColumn(t, "JAVA_INTERFACE", CHARACTER_DATA);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[89].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 4, 5, 6}, false);
            return t;
        }
        boolean user_defined_type_catalog = false;
        boolean user_defined_type_schema = true;
        int user_defined_type_name = 2;
        int user_defined_type_category = 3;
        int is_instantiable = 4;
        int is_final = 5;
        int ordering_form = 6;
        int ordering_category = 7;
        int ordering_routine_catalog = 8;
        int ordering_routine_schema = 9;
        int ordering_routine_name = 10;
        int reference_type = 11;
        int data_type = 12;
        int character_maximum_length = 13;
        int character_octet_length = 14;
        int character_set_catalog = 15;
        int character_set_schema = 16;
        int character_set_name = 17;
        int collation_catalog = 18;
        int collation_schema = 19;
        int collation_name = 20;
        int numeric_precision = 21;
        int numeric_precision_radix = 22;
        int numeric_scale = 23;
        int datetime_precision = 24;
        int interval_type = 25;
        int interval_precision = 26;
        int source_dtd_identifier = 27;
        int ref_dtd_identifier = 28;
        int declared_data_type = 29;
        int declared_numeric_precision = 30;
        int declared_numeric_scale = 31;
        int maximum_cardinality = 32;
        Iterator it = this.database.schemaManager.databaseObjectIterator(12);
        while (it.hasNext()) {
            Type type = (Type)it.next();
            if (!type.isDistinctType()) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = type.getSchemaName().name;
            row[2] = type.getName().name;
            row[12] = type.getFullNameString();
            row[3] = "DISTINCT";
            row[4] = "YES";
            row[5] = "YES";
            row[6] = "FULL";
            if (type.isCharacterType()) {
                row[13] = ValuePool.getLong(type.precision);
                row[14] = ValuePool.getLong(type.precision * 2L);
                row[15] = this.database.getCatalogName().name;
                row[16] = ((CharacterType)type).getCharacterSet().getSchemaName().name;
                row[17] = ((CharacterType)type).getCharacterSet().getName().name;
                row[18] = this.database.getCatalogName().name;
                row[19] = ((CharacterType)type).getCollation().getSchemaName().name;
                row[20] = ((CharacterType)type).getCollation().getName().name;
            } else if (type.isNumberType()) {
                row[21] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                row[30] = ValuePool.getLong(((NumberType)type).getNumericPrecisionInRadix());
                if (type.isExactNumberType()) {
                    row[23] = row[31] = ValuePool.getLong(type.scale);
                }
                row[22] = ValuePool.getLong(type.getPrecisionRadix());
            } else if (!type.isBooleanType()) {
                if (type.isDateTimeType()) {
                    row[24] = ValuePool.getLong(type.scale);
                } else if (type.isIntervalType()) {
                    row[12] = "INTERVAL";
                    IntervalType cfr_ignored_0 = (IntervalType)type;
                    row[25] = IntervalType.getQualifier(type.typeCode);
                    row[26] = ValuePool.getLong(type.precision);
                    row[24] = ValuePool.getLong(type.scale);
                } else if (type.isBinaryType()) {
                    row[13] = ValuePool.getLong(type.precision);
                    row[14] = ValuePool.getLong(type.precision);
                } else if (type.isBitType()) {
                    row[13] = ValuePool.getLong(type.precision);
                    row[14] = ValuePool.getLong(type.precision);
                } else if (type.isArrayType()) {
                    row[32] = ValuePool.getLong(type.arrayLimitCardinality());
                    row[12] = "ARRAY";
                }
            }
            row[27] = type.getDefinition();
            row[29] = row[12];
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table VIEW_COLUMN_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[90];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[90]);
            this.addColumn(t, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "COLUMN_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[90].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return t;
        }
        boolean view_catalog = false;
        boolean view_schema = true;
        int view_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        int column_name = 6;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isView() || !session.getGrantee().isFullyAccessibleByRole(table.getName())) continue;
            String viewCatalog = this.database.getCatalogName().name;
            String viewSchema = table.getSchemaName().name;
            String viewName = table.getName().name;
            View view = (View)table;
            OrderedHashSet references = view.getReferences();
            Iterator iterator = references.iterator();
            while (iterator.hasNext()) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)iterator.next();
                if (refName.type != 9) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = viewCatalog;
                row[1] = viewSchema;
                row[2] = viewName;
                row[3] = viewCatalog;
                row[4] = refName.parent.schema.name;
                row[5] = refName.parent.name;
                row[6] = refName.name;
                try {
                    t.insertSys(session, store, row);
                }
                catch (HsqlException e) {}
            }
        }
        return t;
    }

    Table VIEW_ROUTINE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[91];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[91]);
            this.addColumn(t, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[91].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean view_catalog = false;
        boolean view_schema = true;
        int view_name = 2;
        int specific_catalog = 3;
        int specific_schema = 4;
        int specific_name = 5;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isView()) continue;
            OrderedHashSet set = table.getReferences();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)set.get(i);
                if (refName.type != 24 || !session.getGrantee().isFullyAccessibleByRole(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = table.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table VIEW_TABLE_USAGE(Session session, PersistentStore store) {
        Table t = this.sysTables[92];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[92]);
            this.addColumn(t, "VIEW_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[92].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1, 2, 3, 4, 5}, false);
            return t;
        }
        boolean view_catalog = false;
        boolean view_schema = true;
        int view_name = 2;
        int table_catalog = 3;
        int table_schema = 4;
        int table_name = 5;
        Iterator tables = this.database.schemaManager.databaseObjectIterator(3);
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isView()) continue;
            OrderedHashSet references = table.getReferences();
            for (int i = 0; i < references.size(); ++i) {
                HsqlNameManager.HsqlName refName = (HsqlNameManager.HsqlName)references.get(i);
                if (refName.type != 3 || !session.getGrantee().isFullyAccessibleByRole(refName)) continue;
                Object[] row = t.getEmptyRowData();
                row[0] = this.database.getCatalogName().name;
                row[1] = table.getSchemaName().name;
                row[2] = table.getName().name;
                row[3] = this.database.getCatalogName().name;
                row[4] = refName.schema.name;
                row[5] = refName.name;
                try {
                    t.insertSys(session, store, row);
                    continue;
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    Table VIEWS(Session session, PersistentStore store) {
        Table t = this.sysTables[93];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[93]);
            this.addColumn(t, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(t, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "VIEW_DEFINITION", CHARACTER_DATA);
            this.addColumn(t, "CHECK_OPTION", CHARACTER_DATA);
            this.addColumn(t, "IS_UPDATABLE", YES_OR_NO);
            this.addColumn(t, "INSERTABLE_INTO", YES_OR_NO);
            this.addColumn(t, "IS_TRIGGER_UPDATABLE", YES_OR_NO);
            this.addColumn(t, "IS_TRIGGER_DELETABLE", YES_OR_NO);
            this.addColumn(t, "IS_TRIGGER_INSERTABLE_INTO", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[93].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{1, 2, 0}, false);
            return t;
        }
        boolean table_catalog = false;
        boolean table_schema = true;
        int table_name = 2;
        int view_definition = 3;
        int check_option = 4;
        int is_updatable = 5;
        int insertable_into = 6;
        int is_trigger_updatable = 7;
        int is_trigger_deletable = 8;
        int is_trigger_insertable_into = 9;
        Iterator tables = this.allTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.isView() && table.getSchemaName() != SqlInvariants.INFORMATION_SCHEMA_HSQLNAME || !this.isAccessibleTable(session, table)) continue;
            Object[] row = t.getEmptyRowData();
            row[0] = this.database.getCatalogName().name;
            row[1] = table.getSchemaName().name;
            row[2] = table.getName().name;
            String check = "NONE";
            if (table instanceof View) {
                if (session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                    row[3] = ((View)table).getStatement();
                }
                switch (((View)table).getCheckOption()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        check = "LOCAL";
                        break;
                    }
                    case 2: {
                        check = "CASCADED";
                    }
                }
            }
            row[4] = check;
            row[5] = table.isUpdatable() ? "YES" : "NO";
            row[6] = table.isInsertable() ? "YES" : "NO";
            row[7] = table.isTriggerUpdatable() ? "YES" : "NO";
            row[8] = table.isTriggerDeletable() ? "YES" : "NO";
            row[9] = table.isTriggerInsertable() ? "YES" : "NO";
            t.insertSys(session, store, row);
        }
        return t;
    }

    Table ROLE_AUTHORIZATION_DESCRIPTORS(Session session, PersistentStore store) {
        Table t = this.sysTables[54];
        if (t == null) {
            t = this.createBlankTable(sysTableHsqlNames[54]);
            this.addColumn(t, "ROLE_NAME", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(t, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(t, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName name = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationFull.sysTableHsqlNames[54].name, false, 20);
            t.createPrimaryKeyConstraint(name, new int[]{0, 1}, true);
            return t;
        }
        String grantorName = "_SYSTEM";
        boolean role_name = false;
        boolean grantee = true;
        int grantor = 2;
        int is_grantable = 3;
        Iterator grantees = session.getGrantee().visibleGrantees().iterator();
        while (grantees.hasNext()) {
            String isGrantable;
            Grantee granteeObject = (Grantee)grantees.next();
            String granteeName = granteeObject.getName().getNameString();
            Iterator roles = granteeObject.getDirectRoles().iterator();
            String string = isGrantable = granteeObject.isAdmin() ? "YES" : "NO";
            while (roles.hasNext()) {
                Grantee role = (Grantee)roles.next();
                Object[] row = t.getEmptyRowData();
                row[0] = role.getName().getNameString();
                row[1] = granteeName;
                row[2] = grantorName;
                row[3] = isGrantable;
                t.insertSys(session, store, row);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<DatabaseInformationFull> clazz = DatabaseInformationFull.class;
        synchronized (DatabaseInformationFull.class) {
            String resourceFileName = "/org/hsqldb/resources/information-schema.sql";
            String[] starters = new String[]{"/*"};
            InputStream fis = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public InputStream run() {
                    return this.getClass().getResourceAsStream("/org/hsqldb/resources/information-schema.sql");
                }
            });
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(fis, "ISO-8859-1");
            }
            catch (Exception e) {
                // empty catch block
            }
            LineNumberReader lineReader = new LineNumberReader(reader);
            LineGroupReader lg = new LineGroupReader(lineReader, starters);
            statementMap = lg.getAsMap();
            lg.close();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

