/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.OrderedHashSet;

public class View
extends TableDerived {
    SubQuery viewSubQuery;
    private String statement;
    private HsqlNameManager.HsqlName[] columnNames;
    SubQuery[] viewSubqueries;
    private OrderedHashSet schemaObjectNames;
    private int check;
    private Table baseTable;
    Expression checkExpression;
    boolean isTriggerInsertable;
    boolean isTriggerUpdatable;
    boolean isTriggerDeletable;

    View(Database db, HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames, int check) {
        super(db, name, 8);
        this.columnNames = columnNames;
        this.check = check;
    }

    public int getType() {
        return 4;
    }

    public OrderedHashSet getReferences() {
        return this.schemaObjectNames;
    }

    public OrderedHashSet getComponents() {
        return null;
    }

    public void compile(Session session, SchemaObject parentObject) {
        OrderedHashSet set;
        ParserDQL p = new ParserDQL(session, new Scanner(this.statement));
        p.read();
        this.viewSubQuery = p.XreadViewSubquery(this);
        this.queryExpression = this.viewSubQuery.queryExpression;
        if (this.getColumnCount() == 0) {
            if (this.columnNames == null) {
                this.columnNames = this.viewSubQuery.queryExpression.getResultColumnNames();
            }
            if (this.columnNames.length != this.viewSubQuery.queryExpression.getColumnCount()) {
                throw Error.error(5593, this.getName().statementName);
            }
            TableUtil.setColumnsInSchemaTable(this, this.columnNames, this.queryExpression.getColumnTypes());
        }
        if ((set = this.queryExpression.getSubqueries()) == null) {
            this.viewSubqueries = new SubQuery[]{this.viewSubQuery};
        } else {
            set.add(this.viewSubQuery);
            this.viewSubqueries = new SubQuery[set.size()];
            set.toArray(this.viewSubqueries);
            ArraySort.sort(this.viewSubqueries, 0, this.viewSubqueries.length, this.viewSubqueries[0]);
        }
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].parentView == null) {
                this.viewSubqueries[i].parentView = this;
            }
            this.viewSubqueries[i].prepareTable(session);
        }
        this.viewSubQuery.getTable().view = this;
        this.viewSubQuery.getTable().columnList = this.columnList;
        this.schemaObjectNames = p.compileContext.getSchemaObjectNames();
        this.baseTable = this.queryExpression.getBaseTable();
        if (this.baseTable == null) {
            return;
        }
        switch (this.check) {
            case 0: {
                break;
            }
            case 1: {
                this.checkExpression = this.queryExpression.getCheckCondition();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ').append("VIEW");
        sb.append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        sb.append('(');
        int count = this.getColumnCount();
        for (int j = 0; j < count; ++j) {
            sb.append(this.getColumn((int)j).getName().statementName);
            if (j >= count - 1) continue;
            sb.append(',');
        }
        sb.append(')').append(' ').append("AS").append(' ');
        sb.append(this.getStatement());
        return sb.toString();
    }

    public int[] getUpdatableColumns() {
        return this.queryExpression.getBaseTableColumnMap();
    }

    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public boolean isTriggerInsertable() {
        return this.isTriggerInsertable;
    }

    public boolean isTriggerUpdatable() {
        return this.isTriggerUpdatable;
    }

    public boolean isTriggerDeletable() {
        return this.isTriggerDeletable;
    }

    public boolean isInsertable() {
        return this.isTriggerInsertable ? false : super.isInsertable();
    }

    public boolean isUpdatable() {
        return this.isTriggerUpdatable ? false : super.isUpdatable();
    }

    void addTrigger(TriggerDef td, HsqlNameManager.HsqlName otherName) {
        switch (td.operationType) {
            case 50: {
                if (this.isTriggerInsertable) {
                    throw Error.error(5538);
                }
                this.isTriggerInsertable = true;
                break;
            }
            case 19: {
                if (this.isTriggerDeletable) {
                    throw Error.error(5538);
                }
                this.isTriggerDeletable = true;
                break;
            }
            case 82: {
                if (this.isTriggerUpdatable) {
                    throw Error.error(5538);
                }
                this.isTriggerUpdatable = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.addTrigger(td, otherName);
    }

    void removeTrigger(TriggerDef td) {
        switch (td.operationType) {
            case 50: {
                this.isTriggerInsertable = false;
                break;
            }
            case 19: {
                this.isTriggerDeletable = false;
                break;
            }
            case 82: {
                this.isTriggerInsertable = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.removeTrigger(td);
    }

    public int getCheckOption() {
        return this.check;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String sql) {
        this.statement = sql;
    }

    public void setDataReadOnly(boolean value) {
        throw Error.error(4000);
    }

    public void collectAllFunctionExpressions(OrderedHashSet collector) {
    }

    public Table getSubqueryTable() {
        return this.viewSubQuery.getTable();
    }

    public SubQuery[] getSubqueries() {
        return this.viewSubqueries;
    }
}

