/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class StatementSimple
extends Statement {
    String sqlState;
    HsqlNameManager.HsqlName label;
    ColumnSchema[] variables;
    int[] variableIndexes;

    StatementSimple(int type, HsqlNameManager.HsqlName label) {
        super(type, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.label = label;
    }

    StatementSimple(int type, String sqlState) {
        super(type, 2007);
        this.references = new OrderedHashSet();
        this.isTransactionStatement = false;
        this.sqlState = sqlState;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 92: {
                sb.append("SIGNAL").append(' ');
                sb.append("SQLSTATE");
                sb.append(' ').append('\'').append(this.sqlState).append('\'');
                break;
            }
            case 91: {
                sb.append("RESIGNAL").append(' ');
                sb.append("SQLSTATE");
                sb.append(' ').append('\'').append(this.sqlState).append('\'');
                break;
            }
            case 102: {
                sb.append("ITERATE").append(' ').append(this.label);
                break;
            }
            case 89: {
                sb.append("LEAVE").append(' ').append(this.label);
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 91: 
            case 92: {
                HsqlException ex = Error.error("sql routine SIGNAL or RESIGNAL", this.sqlState, -1);
                return Result.newErrorResult(ex);
            }
            case 89: 
            case 102: {
                return Result.newPSMResult(this.type, this.label.name, null);
            }
        }
        throw Error.runtimeError(201, "");
    }

    public void resolve(Session session) {
        boolean resolved = false;
        block0 : switch (this.type) {
            case 91: 
            case 92: {
                resolved = true;
                break;
            }
            case 102: {
                StatementCompound statement = this.parent;
                while (statement != null) {
                    if (statement.isLoop) {
                        if (this.label == null) {
                            resolved = true;
                            break block0;
                        }
                        if (statement.label != null && this.label.name.equals(statement.label.name)) {
                            resolved = true;
                            break block0;
                        }
                    }
                    statement = statement.parent;
                }
                break;
            }
            case 89: {
                resolved = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        if (!resolved) {
            throw Error.error(5602);
        }
    }

    public String describe(Session session) {
        return "";
    }

    public boolean isCatalogLock() {
        return false;
    }

    public boolean isCatalogChange() {
        return false;
    }
}

