/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    Expression[] targets;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    boolean isTruncate;
    boolean isSimpleInsert;
    int generatedType;
    ResultMetaData generatedInputMetaData;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;

    public StatementDML(int type, int group, HsqlNameManager.HsqlName schemaName) {
        super(type, group, schemaName);
    }

    StatementDML(Session session, Table targetTable, RangeVariable[] rangeVars, ParserDQL.CompileContext compileContext, boolean restartIdentity, int type) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable() == null ? targetTable : targetTable.getBaseTable();
        this.targetRangeVariables = rangeVars;
        this.restartIdentity = restartIdentity;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (type == 1205) {
            this.isTruncate = true;
        }
        this.targetRangeVariables[0].addAllColumns();
    }

    StatementDML(Session session, Expression[] targets, Table targetTable, RangeVariable[] rangeVars, int[] updateColumnMap, Expression[] colExpressions, boolean[] checkColumns, ParserDQL.CompileContext compileContext) {
        super(82, 2004, session.getCurrentSchemaHsqlName());
        this.targets = targets;
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable() == null ? targetTable : targetTable.getBaseTable();
        this.updateColumnMap = updateColumnMap;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = checkColumns;
        this.targetRangeVariables = rangeVars;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
        this.targetRangeVariables[0].addAllColumns();
    }

    StatementDML(Session session, Expression[] targets, RangeVariable[] targetRangeVars, int[] insertColMap, int[] updateColMap, boolean[] checkColumns, Expression mergeCondition, Expression insertExpr, Expression[] updateExpr, ParserDQL.CompileContext compileContext) {
        super(128, 2004, session.getCurrentSchemaHsqlName());
        this.targets = targets;
        this.sourceTable = targetRangeVars[0].rangeTable;
        this.targetTable = targetRangeVars[1].rangeTable;
        this.baseTable = this.targetTable.isTriggerUpdatable() ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = checkColumns;
        this.insertColumnMap = insertColMap;
        this.updateColumnMap = updateColMap;
        this.insertExpression = insertExpr;
        this.updateExpressions = updateExpr;
        this.targetRangeVariables = targetRangeVars;
        this.condition = mergeCondition;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
    }

    StatementDML() {
        super(81, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification select = ((TableDerived)this.targetTable).getQueryExpression().getMainSelect();
            this.updatableTableCheck = select.checkQueryCondition;
            this.checkRangeVariable = select.rangeVariables[0];
        }
    }

    Result getResult(Session session) {
        Result result = null;
        switch (this.type) {
            case 82: {
                result = this.executeUpdateStatement(session);
                break;
            }
            case 128: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isTruncate) {
                    result = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result = this.executeDeleteStatement(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        return result;
    }

    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(set, false);
        } else if (!this.baseTable.isTemp()) {
            block5: for (i = 0; i < this.baseTable.fkConstraints.length; ++i) {
                Constraint constraint = this.baseTable.fkConstraints[i];
                switch (this.type) {
                    case 82: {
                        if (!ArrayUtil.haveCommonElement(constraint.getRefColumns(), this.updateColumnMap)) continue block5;
                        set.add(this.baseTable.fkConstraints[i].getMain().getName());
                        continue block5;
                    }
                    case 50: {
                        set.add(this.baseTable.fkConstraints[i].getMain().getName());
                        continue block5;
                    }
                    case 128: {
                        if (this.updateColumnMap != null && ArrayUtil.haveCommonElement(constraint.getRefColumns(), this.updateColumnMap)) {
                            set.add(this.baseTable.fkConstraints[i].getMain().getName());
                        }
                        if (this.insertExpression == null) continue block5;
                        set.add(this.baseTable.fkConstraints[i].getMain().getName());
                    }
                }
            }
            if (this.type == 82 || this.type == 128) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, set);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, set);
            }
            this.getTriggerTableNames(set, false);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
        for (i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getTableNamesForRead());
        }
    }

    void collectTableNamesForWrite(OrderedHashSet set) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(set, true);
        } else if (!this.baseTable.isTemp()) {
            set.add(this.baseTable.getName());
            if (this.type == 82 || this.type == 128) {
                if (this.updateExpressions.length != 0) {
                    this.baseTable.collectFKWriteLocks(this.updateColumnMap, set);
                }
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, set);
            }
            this.getTriggerTableNames(set, true);
        }
    }

    public void setGeneratedColumnInfo(int generate, ResultMetaData meta) {
        if (this.type != 50) {
            return;
        }
        int idColIndex = this.baseTable.getIdentityColumnIndex();
        this.generatedType = generate;
        this.generatedInputMetaData = meta;
        switch (generate) {
            case 2: {
                return;
            }
            case 21: {
                this.generatedIndexes = meta.getGeneratedColumnIndexes();
                for (int i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0 && this.generatedIndexes[i] < this.baseTable.getColumnCount()) continue;
                    throw Error.error(5501);
                }
                break;
            }
            case 1: {
                int i;
                if (this.baseTable.hasGeneratedColumn()) {
                    if (idColIndex > 0) {
                        int generatedCount = ArrayUtil.countTrueElements(this.baseTable.colGenerated) + 1;
                        this.generatedIndexes = new int[generatedCount];
                        int j = 0;
                        for (i = 0; i < this.baseTable.colGenerated.length; ++i) {
                            if (!this.baseTable.colGenerated[i] && i != idColIndex) continue;
                            this.generatedIndexes[j++] = i;
                        }
                        break;
                    }
                    this.generatedIndexes = ArrayUtil.booleanArrayToIntIndexes(this.baseTable.colGenerated);
                    break;
                }
                if (idColIndex >= 0) {
                    this.generatedIndexes = new int[]{idColIndex};
                    break;
                }
                return;
            }
            case 11: {
                int i;
                String[] columnNames = meta.getGeneratedColumnNames();
                this.generatedIndexes = this.baseTable.getColumnIndexes(columnNames);
                for (i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0) continue;
                    throw Error.error(5501, columnNames[0]);
                }
                break;
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            ColumnSchema column = this.baseTable.getColumn(this.generatedIndexes[i]);
            this.generatedResultMetaData.columns[i] = column;
        }
        this.generatedResultMetaData.prepareData();
        this.isSimpleInsert = false;
    }

    Object[] getGeneratedColumns(Object[] data) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] values = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            values[i] = data[this.generatedIndexes[i]];
        }
        return values;
    }

    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    void getTriggerTableNames(OrderedHashSet set, boolean write) {
        block6: for (int i = 0; i < this.baseTable.triggerList.length; ++i) {
            TriggerDef td = this.baseTable.triggerList[i];
            switch (this.type) {
                case 50: {
                    if (td.getStatementType() != 50) continue block6;
                    break;
                }
                case 82: {
                    if (td.getStatementType() != 82) continue block6;
                    break;
                }
                case 19: {
                    if (td.getStatementType() != 19) continue block6;
                    break;
                }
                case 128: {
                    if (td.getStatementType() != 50 && td.getStatementType() != 82) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (td.routine == null) continue;
            if (write) {
                set.addAll(td.routine.getTableNamesForWrite());
                continue;
            }
            set.addAll(td.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session) {
        int count = 0;
        Expression[] colExpressions = this.updateExpressions;
        RowSetNavigatorDataChange rowset = new RowSetNavigatorDataChange(session.database.sqlEnforceTDCD, session.database.sqlEnforceTDCU);
        Type[] colTypes = this.baseTable.getColumnTypes();
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        while (it.next()) {
            session.sessionData.startRowProcessing();
            Row row = it.getCurrentRow();
            Object[] data = row.getData();
            Object[] newData = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, colExpressions, colTypes, data);
            if (this.updatableTableCheck != null) {
                it.setCurrent(newData);
                boolean check = this.updatableTableCheck.testCondition(session);
                if (!check) {
                    it.release();
                    throw Error.error(5700);
                }
            }
            rowset.addRow(session, row, newData, colTypes, this.updateColumnMap);
        }
        it.release();
        rowset.beforeFirst();
        count = this.update(session, this.baseTable, rowset, generatedNavigator);
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            if (count == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        return resultOut;
    }

    static Object[] getUpdatedData(Session session, Expression[] targets, Table targetTable, int[] columnMap, Expression[] colExpressions, Type[] colTypes, Object[] oldData) {
        Object[] data = targetTable.getEmptyRowData();
        System.arraycopy(oldData, 0, data, 0, data.length);
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            int colIndex;
            Expression expr;
            if ((expr = colExpressions[ix++]).getType() == 25) {
                Object[] values = expr.getRowValue(session);
                int j = 0;
                while (j < values.length) {
                    colIndex = columnMap[i];
                    Expression e = expr.nodes[j];
                    if (targetTable.identityColumn != colIndex || e.getType() != 1 || e.valueData != null) {
                        if (e.getType() == 4) {
                            if (targetTable.identityColumn != colIndex) {
                                data[colIndex] = targetTable.colDefaults[colIndex].getValue(session);
                            }
                        } else {
                            data[colIndex] = colTypes[colIndex].convertToType(session, values[j], e.dataType);
                        }
                    }
                    ++j;
                    ++i;
                }
                continue;
            }
            if (expr.getType() == 22) {
                Object[] values = expr.getRowValue(session);
                int j = 0;
                while (j < values.length) {
                    colIndex = columnMap[i];
                    Type colType = expr.subQuery.queryExpression.getMetaData().columnTypes[j];
                    data[colIndex] = colTypes[colIndex].convertToType(session, values[j], colType);
                    ++j;
                    ++i;
                }
                continue;
            }
            int colIndex2 = columnMap[i];
            if (expr.getType() == 4) {
                if (targetTable.identityColumn == colIndex2) {
                    ++i;
                    continue;
                }
                data[colIndex2] = targetTable.colDefaults[colIndex2].getValue(session);
                ++i;
                continue;
            }
            Object value = expr.getValue(session);
            data[colIndex2] = targets[i].getType() == 99 ? ((ExpressionAccessor)targets[i]).getUpdatedArray(session, (Object[])data[colIndex2], value, true) : colTypes[colIndex2].convertToType(session, value, expr.dataType);
            ++i;
        }
        return data;
    }

    Result executeMergeStatement(Session session) {
        int i;
        Type[] colTypes = this.baseTable.getColumnTypes();
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        int count = 0;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange updateRowSet = new RowSetNavigatorDataChange(session.database.sqlEnforceTDCD, session.database.sqlEnforceTDCU);
        RangeVariable[] joinRangeIterators = this.targetRangeVariables;
        RangeIterator[] rangeIterators = new RangeIterator[joinRangeIterators.length];
        for (i = 0; i < joinRangeIterators.length; ++i) {
            rangeIterators[i] = joinRangeIterators[i].getIterator(session);
        }
        int currentIndex = 0;
        while (currentIndex >= 0) {
            RangeIterator it = rangeIterators[currentIndex];
            boolean beforeFirst = it.isBeforeFirst();
            if (it.next()) {
                if (currentIndex < joinRangeIterators.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                Object[] data;
                if (currentIndex == 1 && beforeFirst && this.insertExpression != null && (data = this.getInsertData(session, colTypes, this.insertExpression.nodes[0].nodes)) != null) {
                    newData.add(data);
                }
                it.reset();
                --currentIndex;
                continue;
            }
            if (this.updateExpressions.length == 0) continue;
            Row row = it.getCurrentRow();
            session.sessionData.startRowProcessing();
            Object[] data = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, colTypes, row.getData());
            try {
                updateRowSet.addRow(session, row, data, colTypes, this.updateColumnMap);
            }
            catch (HsqlException e) {
                for (int i2 = 0; i2 < joinRangeIterators.length; ++i2) {
                    rangeIterators[i2].reset();
                }
                throw Error.error(3201);
            }
        }
        for (i = 0; i < joinRangeIterators.length; ++i) {
            rangeIterators[i].reset();
        }
        if (this.updateExpressions.length != 0) {
            count = this.update(session, this.baseTable, updateRowSet, generatedNavigator);
        }
        if (newData.getSize() > 0) {
            this.insertRowSet(session, generatedNavigator, newData);
            count += newData.getSize();
        }
        if (this.insertExpression != null && this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, newData);
        }
        if (resultOut == null) {
            if (count == 1) {
                return Result.updateOneResult;
            }
            return new Result(1, count);
        }
        resultOut.setUpdateCount(count);
        return resultOut;
    }

    void insertRowSet(Session session, RowSetNavigator generatedNavigator, RowSetNavigator newData) {
        Object[] data;
        PersistentStore store = this.baseTable.getRowStore(session);
        RangeVariable.RangeIteratorMain checkIterator = null;
        if (this.updatableTableCheck != null) {
            checkIterator = this.checkRangeVariable.getIterator(session);
        }
        newData.beforeFirst();
        if (this.baseTable.triggerLists[6].length > 0) {
            while (newData.hasNext()) {
                data = newData.getNext();
                this.baseTable.fireTriggers(session, 6, null, data, null);
            }
            newData.beforeFirst();
        }
        while (newData.hasNext()) {
            data = newData.getNext();
            this.baseTable.insertSingleRow(session, store, data, null);
            if (checkIterator != null) {
                checkIterator.setCurrent(data);
                boolean check = this.updatableTableCheck.testCondition(session);
                if (!check) {
                    throw Error.error(5700);
                }
            }
            if (generatedNavigator == null) continue;
            Object[] generatedValues = this.getGeneratedColumns(data);
            generatedNavigator.add(generatedValues);
        }
        newData.beforeFirst();
        while (newData.hasNext()) {
            data = newData.getNext();
            StatementDML.performIntegrityChecks(session, this.baseTable, null, data, null);
        }
        newData.beforeFirst();
        if (this.baseTable.triggerLists[3].length > 0) {
            while (newData.hasNext()) {
                data = newData.getNext();
                this.baseTable.fireTriggers(session, 3, null, data, null);
            }
            newData.beforeFirst();
        }
    }

    Result insertSingleRow(Session session, PersistentStore store, Object[] data) {
        if (this.baseTable.triggerLists[6].length > 0) {
            this.baseTable.fireTriggers(session, 6, null, data, null);
        }
        this.baseTable.insertSingleRow(session, store, data, null);
        StatementDML.performIntegrityChecks(session, this.baseTable, null, data, null);
        if (session.database.isReferentialIntegrity()) {
            int size = this.baseTable.fkConstraints.length;
            for (int i = 0; i < size; ++i) {
                this.baseTable.fkConstraints[i].checkInsert(session, this.baseTable, data, true);
            }
        }
        if (this.baseTable.triggerLists[3].length > 0) {
            this.baseTable.fireTriggers(session, 3, null, data, null);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, null);
        }
        return Result.updateOneResult;
    }

    Object[] getInsertData(Session session, Type[] colTypes, Expression[] rowArgs) {
        Object[] data = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < rowArgs.length; ++i) {
            Expression e = rowArgs[i];
            int colIndex = this.insertColumnMap[i];
            if (e.opType == 4) {
                if (this.baseTable.identityColumn == colIndex || this.baseTable.colDefaults[colIndex] == null) continue;
                data[colIndex] = this.baseTable.colDefaults[colIndex].getValue(session);
                continue;
            }
            Object value = e.getValue(session);
            Type type = colTypes[colIndex];
            if (session.database.sqlSyntaxMys || session.database.sqlSyntaxPgs) {
                try {
                    value = type.convertToType(session, value, e.dataType);
                }
                catch (HsqlException ex) {
                    if (type.typeCode == 91) {
                        value = Type.SQL_TIMESTAMP.convertToType(session, value, e.dataType);
                        value = type.convertToType(session, value, Type.SQL_TIMESTAMP);
                    }
                    if (type.typeCode == 93) {
                        value = Type.SQL_DATE.convertToType(session, value, e.dataType);
                        value = type.convertToType(session, value, Type.SQL_DATE);
                    }
                    throw ex;
                }
            } else {
                value = type.convertToType(session, value, e.dataType);
            }
            data[colIndex] = value;
        }
        return data;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange navigator, RowSetNavigator generatedNavigator) {
        Row row;
        int i;
        Table currentTable;
        Table currentTable2;
        int[] changedColumns;
        Object[] data;
        int i2;
        int rowCount = navigator.getSize();
        for (i2 = 0; i2 < rowCount; ++i2) {
            navigator.next();
            Object[] data2 = navigator.getCurrentChangedData();
            table.setIdentityColumn(session, data2);
            table.setGeneratedColumns(session, data2);
        }
        navigator.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet path = session.sessionContext.getConstraintPath();
            for (int i3 = 0; i3 < rowCount; ++i3) {
                Row row2 = navigator.getNextRow();
                Object[] data3 = navigator.getCurrentChangedData();
                StatementDML.performReferentialActions(session, table, navigator, row2, data3, this.updateColumnMap, path);
                path.clear();
            }
            navigator.beforeFirst();
        }
        for (i2 = 0; i2 < navigator.getSize(); ++i2) {
            Row row3 = navigator.getNextRow();
            data = navigator.getCurrentChangedData();
            changedColumns = navigator.getCurrentChangedColumns();
            currentTable2 = (Table)row3.getTable();
            if (currentTable2 instanceof TableDerived) {
                currentTable2 = ((TableDerived)currentTable2).view;
            }
            if (currentTable2.triggerLists[8].length <= 0) continue;
            currentTable2.fireTriggers(session, 8, row3.getData(), data, changedColumns);
            currentTable2.enforceRowConstraints(session, data);
        }
        if (table.isView) {
            return rowCount;
        }
        navigator.beforeFirst();
        for (i2 = 0; i2 < navigator.getSize(); ++i2) {
            Row row4 = navigator.getNextRow();
            Table currentTable3 = (Table)row4.getTable();
            changedColumns = navigator.getCurrentChangedColumns();
            session.addDeleteAction(currentTable3, row4, changedColumns);
        }
        navigator.beforeFirst();
        for (i2 = 0; i2 < navigator.getSize(); ++i2) {
            Row row5 = navigator.getNextRow();
            data = navigator.getCurrentChangedData();
            currentTable = (Table)row5.getTable();
            int[] changedColumns2 = navigator.getCurrentChangedColumns();
            PersistentStore store = currentTable.getRowStore(session);
            if (data == null) continue;
            Row newRow = currentTable.insertSingleRow(session, store, data, changedColumns2);
            if (generatedNavigator == null) continue;
            Object[] generatedValues = this.getGeneratedColumns(data);
            generatedNavigator.add(generatedValues);
        }
        navigator.beforeFirst();
        BaseHashMap extraUpdateTables = null;
        boolean hasAfterRowTriggers = table.triggerLists[5].length > 0;
        for (i = 0; i < navigator.getSize(); ++i) {
            row = navigator.getNextRow();
            currentTable2 = (Table)row.getTable();
            Object[] changedData = navigator.getCurrentChangedData();
            int[] changedColumns3 = navigator.getCurrentChangedColumns();
            StatementDML.performIntegrityChecks(session, currentTable2, row.getData(), changedData, changedColumns3);
            if (currentTable2 == table) continue;
            if (extraUpdateTables == null) {
                extraUpdateTables = new OrderedHashSet();
            }
            ((HashSet)extraUpdateTables).add(currentTable2);
            if (currentTable2.triggerLists[5].length <= 0) continue;
            hasAfterRowTriggers = true;
        }
        navigator.beforeFirst();
        if (hasAfterRowTriggers) {
            for (i = 0; i < navigator.getSize(); ++i) {
                row = navigator.getNextRow();
                Object[] changedData = navigator.getCurrentChangedData();
                int[] changedColumns4 = navigator.getCurrentChangedColumns();
                Table currentTable4 = (Table)row.getTable();
                currentTable4.fireTriggers(session, 5, row.getData(), changedData, changedColumns4);
            }
            navigator.beforeFirst();
        }
        this.baseTable.fireTriggers(session, 2, navigator);
        if (extraUpdateTables != null) {
            for (i = 0; i < extraUpdateTables.size(); ++i) {
                currentTable = (Table)((OrderedHashSet)extraUpdateTables).get(i);
                currentTable.fireTriggers(session, 2, navigator);
            }
        }
        return rowCount;
    }

    Result executeDeleteStatement(Session session) {
        int count = 0;
        RangeIterator it = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange navigator = new RowSetNavigatorDataChange(session.database.sqlEnforceTDCD, session.database.sqlEnforceTDCU);
        while (it.next()) {
            Row currentRow = it.getCurrentRow();
            navigator.addRow(currentRow);
        }
        it.release();
        if (navigator.getSize() <= 0) {
            return Result.updateZeroResult;
        }
        count = this.delete(session, this.baseTable, navigator);
        if (count == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore store = this.targetTable.getRowStore(session);
        RowIterator it = this.targetTable.getPrimaryIndex().firstRow(store);
        try {
            while (it.hasNext()) {
                Row row = it.getNextRow();
                session.addDeleteAction((Table)row.getTable(), row, null);
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
            Object var6_5 = null;
            it.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            it.release();
            throw throwable;
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange navigator) {
        Table currentTable;
        Object[] changedData;
        Row row;
        boolean hasAfterRowTriggers;
        Table currentTable2;
        Object[] data;
        Row row2;
        int i;
        int rowCount = navigator.getSize();
        navigator.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet path = session.sessionContext.getConstraintPath();
            for (i = 0; i < rowCount; ++i) {
                navigator.next();
                row2 = navigator.getCurrentRow();
                StatementDML.performReferentialActions(session, table, navigator, row2, null, null, path);
                path.clear();
            }
            navigator.beforeFirst();
        }
        while (navigator.hasNext()) {
            navigator.next();
            Row row3 = navigator.getCurrentRow();
            Object[] changedData2 = navigator.getCurrentChangedData();
            int[] changedColumns = navigator.getCurrentChangedColumns();
            Table currentTable3 = (Table)row3.getTable();
            if (currentTable3 instanceof TableDerived) {
                currentTable3 = ((TableDerived)currentTable3).view;
            }
            if (changedData2 == null) {
                currentTable3.fireTriggers(session, 7, row3.getData(), null, null);
                continue;
            }
            currentTable3.fireTriggers(session, 8, row3.getData(), changedData2, changedColumns);
        }
        if (table.isView) {
            return rowCount;
        }
        navigator.beforeFirst();
        boolean hasUpdate = false;
        for (i = 0; i < navigator.getSize(); ++i) {
            row2 = navigator.getNextRow();
            data = navigator.getCurrentChangedData();
            currentTable2 = (Table)row2.getTable();
            session.addDeleteAction(currentTable2, row2, null);
            if (data == null) continue;
            hasUpdate = true;
        }
        navigator.beforeFirst();
        if (hasUpdate) {
            for (i = 0; i < navigator.getSize(); ++i) {
                row2 = navigator.getNextRow();
                data = navigator.getCurrentChangedData();
                currentTable2 = (Table)row2.getTable();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                PersistentStore store = currentTable2.getRowStore(session);
                if (data == null) continue;
                Row newRow = currentTable2.insertSingleRow(session, store, data, changedColumns);
            }
            navigator.beforeFirst();
        }
        BaseHashMap extraUpdateTables = null;
        BaseHashMap extraDeleteTables = null;
        boolean bl = hasAfterRowTriggers = table.triggerLists[4].length > 0;
        if (rowCount != navigator.getSize()) {
            while (navigator.hasNext()) {
                navigator.next();
                row = navigator.getCurrentRow();
                changedData = navigator.getCurrentChangedData();
                int[] changedColumns = navigator.getCurrentChangedColumns();
                Table currentTable4 = (Table)row.getTable();
                if (changedData != null) {
                    StatementDML.performIntegrityChecks(session, currentTable4, row.getData(), changedData, changedColumns);
                }
                if (currentTable4 == table) continue;
                if (changedData == null) {
                    if (currentTable4.triggerLists[4].length > 0) {
                        hasAfterRowTriggers = true;
                    }
                    if (extraDeleteTables == null) {
                        extraDeleteTables = new OrderedHashSet();
                    }
                    ((HashSet)extraDeleteTables).add(currentTable4);
                    continue;
                }
                if (currentTable4.triggerLists[5].length > 0) {
                    hasAfterRowTriggers = true;
                }
                if (extraUpdateTables == null) {
                    extraUpdateTables = new OrderedHashSet();
                }
                ((HashSet)extraUpdateTables).add(currentTable4);
            }
            navigator.beforeFirst();
        }
        if (hasAfterRowTriggers) {
            while (navigator.hasNext()) {
                navigator.next();
                row = navigator.getCurrentRow();
                changedData = navigator.getCurrentChangedData();
                Table currentTable5 = (Table)row.getTable();
                if (changedData == null) {
                    currentTable5.fireTriggers(session, 4, row.getData(), null, null);
                    continue;
                }
                currentTable5.fireTriggers(session, 5, row.getData(), changedData, null);
            }
            navigator.beforeFirst();
        }
        table.fireTriggers(session, 1, navigator);
        if (extraUpdateTables != null) {
            for (int i2 = 0; i2 < extraUpdateTables.size(); ++i2) {
                currentTable = (Table)((OrderedHashSet)extraUpdateTables).get(i2);
                currentTable.fireTriggers(session, 2, navigator);
            }
        }
        if (extraDeleteTables != null) {
            for (int i3 = 0; i3 < extraDeleteTables.size(); ++i3) {
                currentTable = (Table)((OrderedHashSet)extraDeleteTables).get(i3);
                currentTable.fireTriggers(session, 1, navigator);
            }
        }
        return rowCount;
    }

    static void performIntegrityChecks(Session session, Table table, Object[] oldData, Object[] newData, int[] updatedColumns) {
        int i;
        if (newData == null) {
            return;
        }
        int size = table.checkConstraints.length;
        for (i = 0; i < size; ++i) {
            table.checkConstraints[i].checkInsert(session, table, newData, oldData == null);
        }
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        size = table.fkConstraints.length;
        for (i = 0; i < size; ++i) {
            boolean check = oldData == null;
            Constraint c = table.fkConstraints[i];
            if (!check) {
                check = ArrayUtil.haveCommonElement(c.getRefColumns(), updatedColumns);
            }
            if (!check) continue;
            c.checkInsert(session, table, newData, oldData == null);
        }
    }

    static void performReferentialActions(Session session, Table table, RowSetNavigatorDataChange navigator, Row row, Object[] data, int[] changedCols, HashSet path) {
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        boolean delete = data == null;
        for (Constraint c : table.fkMainConstraints) {
            int action;
            int n = action = delete ? c.core.deleteAction : c.core.updateAction;
            if (!delete && (!ArrayUtil.haveCommonElement(changedCols, c.core.mainCols) || c.core.mainIndex.compareRowNonUnique(session, row.getData(), data, c.core.mainCols) == 0)) continue;
            RowIterator refiterator = c.findFkRef(session, row.getData());
            if (!refiterator.hasNext()) {
                refiterator.release();
                continue;
            }
            block12: while (refiterator.hasNext()) {
                Object[] info;
                Row refRow = refiterator.getNextRow();
                Object[] refData = null;
                if (c.core.refIndex.compareRowNonUnique(session, refRow.getData(), row.getData(), c.core.mainCols) != 0) break;
                if (delete && refRow.getId() == row.getId()) continue;
                switch (action) {
                    case 0: {
                        int j;
                        if (delete) {
                            boolean result;
                            try {
                                result = navigator.addRow(refRow);
                            }
                            catch (HsqlException e) {
                                Object[] info2 = StatementDML.getConstraintInfo(c);
                                refiterator.release();
                                throw Error.error(null, 3900, 2, info2);
                            }
                            if (!result) continue block12;
                            StatementDML.performReferentialActions(session, c.core.refTable, navigator, refRow, null, null, path);
                            continue block12;
                        }
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            refData[c.core.refCols[j]] = data[c.core.mainCols[j]];
                        }
                        break;
                    }
                    case 2: {
                        int j;
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            refData[c.core.refCols[j]] = null;
                        }
                        break;
                    }
                    case 4: {
                        int j;
                        refData = c.core.refTable.getEmptyRowData();
                        System.arraycopy(refRow.getData(), 0, refData, 0, refData.length);
                        for (j = 0; j < c.core.refCols.length; ++j) {
                            ColumnSchema col = c.core.refTable.getColumn(c.core.refCols[j]);
                            refData[c.core.refCols[j]] = col.getDefaultValue(session);
                        }
                        break;
                    }
                    case 3: {
                        if (navigator.containsDeletedRow(refRow)) continue block12;
                    }
                    case 1: {
                        int errorCode = c.core.deleteAction == 3 ? 8 : 3501;
                        info = StatementDML.getConstraintInfo(c);
                        refiterator.release();
                        throw Error.error(null, errorCode, 2, info);
                    }
                    default: {
                        continue block12;
                    }
                }
                try {
                    refData = navigator.addRow(session, refRow, refData, c.core.refTable.getColumnTypes(), c.core.refCols);
                }
                catch (HsqlException e) {
                    info = StatementDML.getConstraintInfo(c);
                    refiterator.release();
                    throw Error.error(null, 3900, 2, info);
                }
                if (refData == null || !path.add(c)) continue;
                StatementDML.performReferentialActions(session, c.core.refTable, navigator, refRow, refData, c.core.refCols, path);
                path.remove(c);
            }
            refiterator.release();
        }
    }

    static String[] getConstraintInfo(Constraint c) {
        return new String[]{c.core.refName.name, c.core.refTable.getName().name};
    }
}

