/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public final class SortAndSlice {
    static final SortAndSlice noSort = new SortAndSlice();
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    public Collation[] collations;
    boolean sortUnion;
    HsqlArrayList exprList = new HsqlArrayList();
    ExpressionOp limitCondition;
    int columnCount;
    boolean hasNullsLast;
    boolean strictLimit;
    boolean zeroLimit;
    public boolean skipSort = false;
    public boolean skipFullResult = false;
    int[] columnIndexes;
    public Index index;
    public boolean isGenerated;

    SortAndSlice() {
    }

    public HsqlArrayList getExpressionList() {
        return this.exprList;
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression e) {
        this.exprList.add(e);
    }

    public void addLimitCondition(ExpressionOp expression) {
        this.limitCondition = expression;
    }

    public void setStrictLimit() {
        this.strictLimit = true;
    }

    public void setZeroLimit() {
        this.zeroLimit = true;
    }

    public void prepareSingleColumn(int colIndex) {
        this.sortOrder = new int[1];
        this.sortDescending = new boolean[1];
        this.sortNullsLast = new boolean[1];
        this.sortOrder[0] = colIndex;
    }

    public void prepare(int degree) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount + degree];
        this.sortDescending = new boolean[this.columnCount + degree];
        this.sortNullsLast = new boolean[this.columnCount + degree];
        ArrayUtil.fillSequence(this.sortOrder);
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            this.sortDescending[i] = sort.isDescending();
            this.sortNullsLast[i] = sort.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i];
        }
    }

    public void prepare(QuerySpecification select) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            this.sortOrder[i] = sort.getLeftNode().queryTableColumnIndex == -1 ? select.indexStartOrderBy + i : sort.getLeftNode().queryTableColumnIndex;
            this.sortDescending[i] = sort.isDescending();
            this.sortNullsLast[i] = sort.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i];
            if (sort.collation == null) continue;
            if (this.collations == null) {
                this.collations = new Collation[this.columnCount];
            }
            this.collations[i] = sort.collation;
        }
    }

    void setSortRange(QuerySpecification select) {
        boolean allDescending;
        if (this.isGenerated) {
            return;
        }
        if (this.columnCount == 0) {
            if (this.limitCondition == null) {
                return;
            }
            if (select.isDistinctSelect || select.isGrouped || select.isAggregated) {
                return;
            }
            this.skipFullResult = true;
            return;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            Type dataType = sort.getLeftNode().getDataType();
            if (!dataType.isArrayType() && !dataType.isLobType()) continue;
            throw Error.error(5534);
        }
        if (select == null || this.hasNullsLast) {
            return;
        }
        if (select.isDistinctSelect || select.isGrouped || select.isAggregated) {
            return;
        }
        int[] colIndexes = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            Expression e = ((Expression)this.exprList.get(i)).getLeftNode();
            if (e.getType() != 2) {
                return;
            }
            if (((ExpressionColumn)e).getRangeVariable() != select.rangeVariables[0]) {
                return;
            }
            colIndexes[i] = e.columnIndex;
        }
        this.columnIndexes = colIndexes;
        if (this.columnIndexes == null) {
            return;
        }
        if (this.collations != null) {
            return;
        }
        Index rangeIndex = select.rangeVariables[0].getSortIndex();
        if (rangeIndex == null) {
            return;
        }
        colIndexes = rangeIndex.getColumns();
        int count = ArrayUtil.countTrueElements(this.sortDescending);
        boolean bl = allDescending = count == this.columnCount;
        if (!allDescending && count > 0) {
            return;
        }
        if (!select.rangeVariables[0].hasIndexCondition()) {
            Table table = select.rangeVariables[0].getTable();
            Index index = table.getFullIndexForColumns(this.columnIndexes);
            if (index != null && select.rangeVariables[0].setSortIndex(index, allDescending)) {
                this.skipSort = true;
                this.skipFullResult = true;
            }
        } else if (ArrayUtil.haveEqualArrays(this.columnIndexes, colIndexes, this.columnIndexes.length)) {
            boolean reversed;
            if (allDescending && !(reversed = select.rangeVariables[0].reverseOrder())) {
                return;
            }
            this.skipSort = true;
            this.skipFullResult = true;
        }
    }

    public boolean prepareSpecial(Session session, QuerySpecification select) {
        Expression e = select.exprColumns[select.indexStartAggregates];
        int opType = e.getType();
        if ((e = e.getLeftNode()).getType() != 2) {
            return false;
        }
        if (((ExpressionColumn)e).getRangeVariable() != select.rangeVariables[0]) {
            return false;
        }
        Index rangeIndex = select.rangeVariables[0].getSortIndex();
        if (rangeIndex == null) {
            return false;
        }
        int[] colIndexes = rangeIndex.getColumns();
        if (select.rangeVariables[0].hasIndexCondition()) {
            if (colIndexes[0] != ((ExpressionColumn)e).getColumnIndex()) {
                return false;
            }
            if (opType == 74) {
                select.rangeVariables[0].reverseOrder();
            }
        } else {
            Table table = select.rangeVariables[0].getTable();
            Index index = table.getIndexForColumn(session, ((ExpressionColumn)e).getColumnIndex());
            if (index == null) {
                return false;
            }
            if (!select.rangeVariables[0].setSortIndex(index, opType == 74)) {
                return false;
            }
        }
        this.columnCount = 1;
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        this.columnIndexes = new int[this.columnCount];
        this.columnIndexes[0] = e.columnIndex;
        this.skipSort = true;
        this.skipFullResult = true;
        return true;
    }

    public int getLimitStart(Session session) {
        Integer limit;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getLeftNode().getValue(session)) != null) {
            return limit;
        }
        return 0;
    }

    public int getLimitCount(Session session, int rowCount) {
        Integer limit;
        int limitCount = 0;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getRightNode().getValue(session)) != null) {
            limitCount = limit;
        }
        if (rowCount != 0 && (limitCount == 0 || rowCount < limitCount)) {
            limitCount = rowCount;
        }
        return limitCount;
    }

    public void setIndex(Session session, TableBase table) {
        this.index = this.getNewIndex(session, table);
    }

    public Index getNewIndex(Session session, TableBase table) {
        if (this.hasOrder()) {
            Index orderIndex = table.createAndAddIndexStructure(session, null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false);
            if (this.collations != null) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.collations[i] == null) continue;
                    Type type = orderIndex.getColumnTypes()[i];
                    orderIndex.getColumnTypes()[i] = type = Type.getType(type.typeCode, type.getCharacterSet(), this.collations[i], type.precision, type.scale);
                }
            }
            return orderIndex;
        }
        return null;
    }
}

