/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Schema;
import org.hsqldb.Session;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.rights.User;

public class SessionManager {
    long sessionIdCount = 0L;
    private LongKeyHashMap sessionMap = new LongKeyHashMap();
    private Session sysSession;
    private Session sysLobSession;

    public SessionManager(Database db) {
        User sysUser = db.getUserManager().getSysUser();
        this.sysSession = new Session(db, sysUser, false, false, this.sessionIdCount++, null, 0);
        this.sysLobSession = new Session(db, sysUser, true, false, this.sessionIdCount++, null, 0);
    }

    public synchronized Session newSession(Database db, User user, boolean readonly, boolean autoCommit, String zoneString, int timeZoneSeconds) {
        Session s = new Session(db, user, autoCommit, readonly, this.sessionIdCount, zoneString, timeZoneSeconds);
        this.sessionMap.put(this.sessionIdCount, s);
        ++this.sessionIdCount;
        return s;
    }

    public synchronized Session newSessionForLog(Database db) {
        boolean autoCommit = db.databaseProperties.isVersion18();
        Session s = new Session(db, db.getUserManager().getSysUser(), autoCommit, false, this.sessionIdCount, null, 0);
        s.isProcessingLog = true;
        this.sessionMap.put(this.sessionIdCount, s);
        ++this.sessionIdCount;
        return s;
    }

    public Session getSysSessionForScript(Database db) {
        Session session = new Session(db, db.getUserManager().getSysUser(), false, false, 0L, null, 0);
        session.isProcessingScript = true;
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session newSysSession() {
        Session session = new Session(this.sysSession.database, this.sysSession.getUser(), false, false, this.sessionIdCount, null, 0);
        session.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public Session newSysSession(HsqlNameManager.HsqlName schema, User user) {
        Session session = new Session(this.sysSession.database, user, false, false, 0L, null, 0);
        session.currentSchema = schema;
        return session;
    }

    public synchronized void closeAllSessions() {
        Session[] sessions = this.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].close();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(long id) {
        return (Session)this.sessionMap.get(id);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessions = new Session[this.sessionMap.size()];
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            sessions[i] = (Session)it.next();
            ++i;
        }
        return sessions;
    }

    public synchronized boolean isUserActive(String userName) {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (userName.equals(session.getUser().getName().getNameString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void removeSchemaReference(Schema schema) {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            if (session.getCurrentSchemaHsqlName() == schema.getName()) {
                session.resetSchema();
            }
            ++i;
        }
    }

    public synchronized void resetLoggedSchemas() {
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Session session = (Session)it.next();
            session.loggedSchema = null;
            ++i;
        }
        this.sysLobSession.loggedSchema = null;
    }
}

