/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.hsqldb.Database;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserCommand;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SessionContext;
import org.hsqldb.SessionData;
import org.hsqldb.SessionInterface;
import org.hsqldb.Statement;
import org.hsqldb.StatementManager;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CountUpDownLatch;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Session
implements SessionInterface {
    private volatile boolean isClosed;
    public Database database;
    private final User sessionUser;
    private User user;
    private Grantee role;
    public boolean isReadOnlyDefault;
    int isolationLevelDefault = 2;
    int isolationLevel = 2;
    boolean isReadOnlyIsolation;
    int actionIndex;
    long actionTimestamp;
    long transactionTimestamp;
    long transactionEndTimestamp;
    boolean deadlockRollback;
    boolean isPreTransaction;
    boolean isTransaction;
    boolean isBatch;
    volatile boolean abortTransaction;
    volatile boolean redoAction;
    HsqlArrayList rowActionList;
    volatile boolean tempUnlocked;
    public OrderedHashSet waitedSessions;
    public OrderedHashSet waitingSessions;
    OrderedHashSet tempSet;
    public CountUpDownLatch latch = new CountUpDownLatch();
    Statement lockStatement;
    final String zoneString;
    final int sessionTimeZoneSeconds;
    int timeZoneSeconds;
    boolean isNetwork;
    private int sessionMaxRows;
    private final long sessionId;
    int sessionTxId = -1;
    private boolean script;
    boolean ignoreCase;
    private JDBCConnection intConnection;
    private JDBCConnection extConnection;
    public HsqlNameManager.HsqlName currentSchema;
    public HsqlNameManager.HsqlName loggedSchema;
    ParserCommand parser;
    boolean isProcessingScript;
    boolean isProcessingLog;
    public SessionContext sessionContext;
    int resultMaxMemoryRows;
    public SessionData sessionData;
    public StatementManager statementManager;
    private final long connectTime = System.currentTimeMillis();
    long currentDateSCN;
    long currentTimestampSCN;
    long currentMillis;
    private TimestampData currentDate;
    private TimestampData currentTimestamp;
    private TimestampData localTimestamp;
    private TimeData currentTime;
    private TimeData localTime;
    HsqlDeque sqlWarnings;
    Calendar calendar;
    Type.TypedComparator typedComparator;
    Scanner secondaryScanner;
    SimpleDateFormat simpleDateFormat;
    SimpleDateFormat simpleDateFormatGMT;
    Random randomGenerator = new Random();
    long seed = -1L;
    HsqlProperties clientProperties;

    Session(Database db, User user, boolean autocommit, boolean readonly, long id, String zoneString, int timeZoneSeconds) {
        this.sessionId = id;
        this.database = db;
        this.user = user;
        this.sessionUser = user;
        this.zoneString = zoneString;
        this.sessionTimeZoneSeconds = timeZoneSeconds;
        this.timeZoneSeconds = timeZoneSeconds;
        this.rowActionList = new HsqlArrayList(true);
        this.waitedSessions = new OrderedHashSet();
        this.waitingSessions = new OrderedHashSet();
        this.tempSet = new OrderedHashSet();
        this.isolationLevel = this.isolationLevelDefault = this.database.defaultIsolationLevel;
        this.deadlockRollback = this.database.defaultDeadlockRollback;
        this.isReadOnlyDefault = readonly;
        this.isReadOnlyIsolation = this.isolationLevel == 1;
        this.sessionContext = new SessionContext(this);
        this.sessionContext.isAutoCommit = autocommit ? Boolean.TRUE : Boolean.FALSE;
        this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        this.parser = new ParserCommand(this, new Scanner());
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.resetSchema();
        this.sessionData = new SessionData(this.database, this);
        this.statementManager = new StatementManager(this.database);
    }

    void resetSchema() {
        this.loggedSchema = null;
        this.currentSchema = this.user.getInitialOrDefaultSchema();
    }

    public long getId() {
        return this.sessionId;
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        try {
            this.database.logger.writeOtherStatement(this, "DISCONNECT");
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.statementManager.reset();
        this.database.sessionManager.removeSession(this);
        this.database.closeIfLast();
        this.rowActionList.clear();
        this.database = null;
        this.user = null;
        this.sessionContext.savepoints = null;
        this.sessionContext.lastIdentity = null;
        this.intConnection = null;
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setIsolationDefault(int level) {
        if (level == 1) {
            level = 2;
        }
        if (level == this.isolationLevelDefault) {
            return;
        }
        this.isolationLevelDefault = level;
        if (!this.isInMidTransaction()) {
            this.isolationLevel = this.isolationLevelDefault;
            this.isReadOnlyIsolation = level == 1;
        }
    }

    public void setIsolation(int level) {
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        if (level == 1) {
            level = 2;
        }
        if (this.isolationLevel != level) {
            this.isolationLevel = level;
            this.isReadOnlyIsolation = level == 1;
        }
    }

    public synchronized int getIsolation() {
        return this.isolationLevel;
    }

    void setLastIdentity(Number i) {
        this.sessionContext.lastIdentity = i;
    }

    public Number getLastIdentity() {
        return this.sessionContext.lastIdentity;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.user.getName().getNameString();
    }

    public User getUser() {
        return this.user;
    }

    public Grantee getGrantee() {
        return this.user;
    }

    public Grantee getRole() {
        return this.role;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRole(Grantee role) {
        this.role = role;
    }

    int getMaxRows() {
        return this.sessionContext.currentMaxRows;
    }

    void setSQLMaxRows(int rows) {
        this.sessionMaxRows = rows;
    }

    void checkAdmin() {
        this.user.checkAdmin();
    }

    void checkReadWrite() {
        if (this.sessionContext.isReadOnly.booleanValue() || this.isReadOnlyIsolation) {
            throw Error.error(3706);
        }
    }

    void checkDDLWrite() {
        this.checkReadWrite();
        if (this.isProcessingScript || this.isProcessingLog) {
            return;
        }
    }

    public long getActionTimestamp() {
        return this.actionTimestamp;
    }

    void addDeleteAction(Table table, Row row, int[] colMap) {
        if (this.abortTransaction) {
            // empty if block
        }
        this.database.txManager.addDeleteAction(this, table, row, colMap);
    }

    void addInsertAction(Table table, PersistentStore store, Row row, int[] changedColumns) {
        this.database.txManager.addInsertAction(this, table, store, row, changedColumns);
        if (this.abortTransaction) {
            // empty if block
        }
    }

    public synchronized void setAutoCommit(boolean autocommit) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.isAutoCommit != autocommit) {
            this.commit(false);
            this.sessionContext.isAutoCommit = ValuePool.getBoolean(autocommit);
        }
    }

    public void beginAction(Statement cs) {
        this.actionIndex = this.rowActionList.size();
        this.database.txManager.beginAction(this, cs);
        this.database.txManager.beginActionResume(this);
    }

    public void endAction(Result result) {
        this.sessionData.persistentStoreCollection.clearStatementTables();
        if (result.mode == 2) {
            this.sessionData.persistentStoreCollection.clearResultTables(this.actionTimestamp);
            this.database.txManager.rollbackAction(this);
        } else {
            this.sessionContext.diagnosticsVariables[2] = result.mode == 1 ? Integer.valueOf(result.getUpdateCount()) : ValuePool.INTEGER_0;
            this.database.txManager.completeActions(this);
        }
    }

    public boolean hasLocks(Statement statement) {
        if (this.lockStatement == statement) {
            if (this.isolationLevel == 4 || this.isolationLevel == 8) {
                return true;
            }
            if (statement.getTableNamesForRead().length == 0) {
                return true;
            }
        }
        return false;
    }

    public void startTransaction() {
        this.database.txManager.beginTransaction(this);
    }

    public synchronized void startPhasedTransaction() {
    }

    public synchronized void prepareCommit() {
        if (this.isClosed) {
            throw Error.error(1303);
        }
        if (!this.database.txManager.prepareCommitActions(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
    }

    public synchronized void commit(boolean chain) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        if (!this.isTransaction && this.rowActionList.size() == 0) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            this.setIsolation(this.isolationLevelDefault);
            return;
        }
        if (!this.database.txManager.commitTransaction(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
        this.endTransaction(true);
        if (this.database != null && !this.sessionUser.isSystem() && this.database.logger.needsCheckpointReset()) {
            this.database.checkpointRunner.start();
        }
    }

    public synchronized void rollback(boolean chain) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        if (!this.isTransaction && this.rowActionList.size() == 0) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            this.setIsolation(this.isolationLevelDefault);
            return;
        }
        try {
            this.database.logger.writeRollbackStatement(this);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.database.txManager.rollback(this);
        this.endTransaction(false);
    }

    private void endTransaction(boolean commit) {
        StatementSession endTX;
        this.sessionContext.savepoints.clear();
        this.sessionContext.savepointTimestamps.clear();
        this.rowActionList.clear();
        this.sessionData.persistentStoreCollection.clearTransactionTables();
        this.sessionData.closeAllTransactionNavigators();
        this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        this.setIsolation(this.isolationLevelDefault);
        this.lockStatement = null;
        this.logSequences();
        StatementSession statementSession = endTX = commit ? StatementSession.commitNoChainStatement : StatementSession.rollbackNoChainStatement;
        if (this.database.logger.getSqlEventLogLevel() > 0) {
            this.database.logger.logStatementEvent(this, endTX, null, 2);
        }
    }

    public synchronized void resetSession() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.statementManager.reset();
        this.sessionContext.lastIdentity = ValuePool.INTEGER_0;
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.user = this.sessionUser;
        this.resetSchema();
        this.setZoneSeconds(this.sessionTimeZoneSeconds);
        this.sessionMaxRows = 0;
        this.ignoreCase = false;
        this.setIsolation(this.isolationLevelDefault);
        this.deadlockRollback = this.database.defaultDeadlockRollback;
    }

    public synchronized void savepoint(String name) {
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index != -1) {
            this.sessionContext.savepoints.remove(name);
            this.sessionContext.savepointTimestamps.remove(index);
        }
        this.sessionContext.savepoints.add(name, ValuePool.getInt(this.rowActionList.size()));
        this.sessionContext.savepointTimestamps.addLast(this.actionTimestamp);
    }

    public synchronized void rollbackToSavepoint(String name) {
        if (this.isClosed) {
            return;
        }
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index < 0) {
            throw Error.error(4821, name);
        }
        this.database.txManager.rollbackSavepoint(this, index);
    }

    public synchronized void rollbackToSavepoint() {
        if (this.isClosed) {
            return;
        }
        String name = (String)this.sessionContext.savepoints.getKey(0);
        this.database.txManager.rollbackSavepoint(this, 0);
    }

    public synchronized void releaseSavepoint(String name) {
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index < 0) {
            throw Error.error(4821, name);
        }
        while (this.sessionContext.savepoints.size() > index) {
            this.sessionContext.savepoints.remove(this.sessionContext.savepoints.size() - 1);
            this.sessionContext.savepointTimestamps.removeLast();
        }
    }

    public boolean isInMidTransaction() {
        return this.isTransaction;
    }

    public void setNoSQL() {
        this.sessionContext.noSQL = Boolean.TRUE;
    }

    public void setIgnoreCase(boolean mode) {
        this.ignoreCase = mode;
    }

    public boolean isIgnorecase() {
        return this.ignoreCase;
    }

    public void setReadOnly(boolean readonly) {
        if (!readonly && this.database.databaseReadOnly) {
            throw Error.error(455);
        }
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        this.sessionContext.isReadOnly = readonly ? Boolean.TRUE : Boolean.FALSE;
    }

    public synchronized void setReadOnlyDefault(boolean readonly) {
        if (!readonly && this.database.databaseReadOnly) {
            throw Error.error(455);
        }
        this.isReadOnlyDefault = readonly;
        if (!this.isInMidTransaction()) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public boolean isReadOnly() {
        return this.sessionContext.isReadOnly != false || this.isReadOnlyIsolation;
    }

    public synchronized boolean isReadOnlyDefault() {
        return this.isReadOnlyDefault;
    }

    public synchronized boolean isAutoCommit() {
        return this.sessionContext.isAutoCommit;
    }

    public synchronized int getStreamBlockSize() {
        return 524288;
    }

    void setScripting(boolean script) {
        this.script = script;
    }

    boolean isScripting() {
        return this.script;
    }

    JDBCConnection getInternalConnection() {
        if (this.intConnection == null) {
            this.intConnection = new JDBCConnection(this);
        }
        JDBCDriver.driverInstance.threadConnection.set(this.intConnection);
        return this.intConnection;
    }

    void releaseInternalConnection() {
        if (this.sessionContext.depth == 0) {
            JDBCDriver.driverInstance.threadConnection.set(null);
        }
    }

    public JDBCConnection getJDBCConnection() {
        return this.extConnection;
    }

    public void setJDBCConnection(JDBCConnection connection) {
        this.extConnection = connection;
    }

    public String getDatabaseUniqueName() {
        return this.database.getUniqueName();
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getTransactionSize() {
        return this.rowActionList.size();
    }

    public long getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public Statement compileStatement(String sql, int props) {
        this.parser.reset(sql);
        Statement cs = this.parser.compileStatement(props);
        return cs;
    }

    public Statement compileStatement(String sql) {
        this.parser.reset(sql);
        Statement cs = this.parser.compileStatement(0);
        cs.setCompileTimestamp(Long.MAX_VALUE);
        return cs;
    }

    public synchronized Result execute(Result cmd) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        this.sessionContext.currentMaxRows = 0;
        this.isBatch = false;
        JavaSystem.gc();
        switch (cmd.mode) {
            case 18: {
                return this.performLOBOperation((ResultLob)cmd);
            }
            case 35: {
                int maxRows = cmd.getUpdateCount();
                this.sessionContext.currentMaxRows = maxRows == -1 ? 0 : maxRows;
                Statement cs = cmd.statement;
                if (cs == null || cs.compileTimestamp < this.database.schemaManager.schemaChangeTimestamp) {
                    long csid = cmd.getStatementID();
                    cs = this.statementManager.getStatement(this, csid);
                    cmd.setStatement(cs);
                    if (cs == null) {
                        return Result.newErrorResult(Error.error(1252));
                    }
                }
                Object[] pvals = (Object[])cmd.valueData;
                Result result = this.executeCompiledStatement(cs, pvals);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 9: {
                this.isBatch = true;
                Result result = this.executeCompiledBatchStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 34: {
                Result result = this.executeDirectStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 8: {
                this.isBatch = true;
                Result result = this.executeDirectBatchStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 37: {
                Statement cs;
                try {
                    cs = this.statementManager.compile(this, cmd);
                }
                catch (Throwable t) {
                    String errorString = cmd.getMainString();
                    if (this.database.getProperties().getErrorLevel() == 1) {
                        errorString = null;
                    }
                    return Result.newErrorResult(t, errorString);
                }
                Result result = Result.newPrepareResponse(cs);
                if (cs.getType() == 85 || cs.getType() == 7) {
                    this.sessionData.setResultSetProperties(cmd, result);
                }
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 40: {
                this.closeNavigator(cmd.getResultId());
                return Result.updateZeroResult;
            }
            case 41: {
                Result result = this.executeResultUpdate(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 36: {
                this.statementManager.freeStatement(cmd.getStatementID());
                return Result.updateZeroResult;
            }
            case 7: {
                int id = cmd.getStatementType();
                return this.getAttributesResult(id);
            }
            case 6: {
                return this.setAttributes(cmd);
            }
            case 33: {
                switch (cmd.getActionType()) {
                    case 0: {
                        try {
                            this.commit(false);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 6: {
                        try {
                            this.commit(true);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 1: {
                        this.rollback(false);
                        break;
                    }
                    case 7: {
                        this.rollback(true);
                        break;
                    }
                    case 4: {
                        try {
                            String name = cmd.getMainString();
                            this.releaseSavepoint(name);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 2: {
                        try {
                            this.rollbackToSavepoint(cmd.getMainString());
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 38: {
                switch (cmd.getConnectionAttrType()) {
                    case 10027: {
                        try {
                            this.savepoint(cmd.getMainString());
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 13: {
                return this.sessionData.getDataResultSlice(cmd.getResultId(), cmd.getUpdateCount(), cmd.getFetchSize());
            }
            case 32: {
                this.close();
                return Result.updateZeroResult;
            }
        }
        return Result.newErrorResult(Error.runtimeError(201, "Session"));
    }

    private Result performPostExecute(Result command, Result result) {
        if (result.mode == 3) {
            result = this.sessionData.getDataResultHead(command, result, this.isNetwork);
        }
        if (this.sqlWarnings != null && this.sqlWarnings.size() > 0) {
            if (result.mode == 1) {
                result = new Result(1, result.getUpdateCount());
            }
            HsqlException[] warnings = this.getAndClearWarnings();
            result.addWarnings(warnings);
        }
        return result;
    }

    public RowSetNavigatorClient getRows(long navigatorId, int offset, int blockSize) {
        return this.sessionData.getRowSetSlice(navigatorId, offset, blockSize);
    }

    public synchronized void closeNavigator(long id) {
        this.sessionData.closeNavigator(id);
    }

    public Result executeDirectStatement(Result cmd) {
        HsqlArrayList list;
        String sql = cmd.getMainString();
        int maxRows = cmd.getUpdateCount();
        if (maxRows == -1) {
            this.sessionContext.currentMaxRows = 0;
        } else if (this.sessionMaxRows == 0) {
            this.sessionContext.currentMaxRows = maxRows;
        } else {
            this.sessionContext.currentMaxRows = this.sessionMaxRows;
            this.sessionMaxRows = 0;
        }
        try {
            list = this.parser.compileStatements(sql, cmd);
        }
        catch (Exception e) {
            return Result.newErrorResult(e);
        }
        Result result = null;
        for (int i = 0; i < list.size(); ++i) {
            Statement cs = (Statement)list.get(i);
            cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
            result = this.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            if (result.mode == 2) break;
        }
        return result;
    }

    public Result executeDirectStatement(String sql) {
        try {
            Statement cs = this.compileStatement(sql);
            Result result = this.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            return result;
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
    }

    public Result executeCompiledStatement(Statement cs, Object[] pvals) {
        Result r;
        if (this.abortTransaction) {
            this.rollback(false);
            return Result.newErrorResult(Error.error(4861));
        }
        if (this.sessionContext.depth > 0 && (this.sessionContext.noSQL.booleanValue() || cs.isAutoCommitStatement())) {
            return Result.newErrorResult(Error.error(6000));
        }
        if (cs.isAutoCommitStatement()) {
            if (this.isReadOnly()) {
                return Result.newErrorResult(Error.error(3706));
            }
            try {
                this.commit(false);
            }
            catch (HsqlException e) {
                this.database.logger.logInfoEvent("Exception at commit");
            }
        }
        this.sessionContext.currentStatement = cs;
        boolean isTX = cs.isTransactionStatement();
        if (!isTX) {
            if (this.database.logger.getSqlEventLogLevel() > 0) {
                this.sessionContext.setDynamicArguments(pvals);
            }
            if (this.database.logger.getSqlEventLogLevel() > 0) {
                this.database.logger.logStatementEvent(this, cs, pvals, 3);
            }
            Result r2 = cs.execute(this);
            this.sessionContext.currentStatement = null;
            return r2;
        }
        while (true) {
            this.actionIndex = this.rowActionList.size();
            this.database.txManager.beginAction(this, cs);
            cs = this.sessionContext.currentStatement;
            if (cs == null) {
                return Result.newErrorResult(Error.error(1252));
            }
            if (this.abortTransaction) {
                this.rollback(false);
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.abortTransaction = true;
            }
            if (this.abortTransaction) {
                this.rollback(false);
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            this.database.txManager.beginActionResume(this);
            this.sessionContext.setDynamicArguments(pvals);
            if (this.database.logger.getSqlEventLogLevel() > 0) {
                this.database.logger.logStatementEvent(this, cs, pvals, 3);
            }
            r = cs.execute(this);
            this.lockStatement = this.sessionContext.currentStatement;
            this.endAction(r);
            if (this.abortTransaction) {
                this.rollback(false);
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            if (!this.redoAction) break;
            this.redoAction = false;
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.abortTransaction = true;
            }
        }
        if (this.sessionContext.depth == 0 && (this.sessionContext.isAutoCommit.booleanValue() || cs.isAutoCommitStatement())) {
            try {
                if (r.mode == 2) {
                    this.rollback(false);
                } else {
                    this.commit(false);
                }
            }
            catch (Exception e) {
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861, e));
            }
        }
        this.sessionContext.currentStatement = null;
        return r;
    }

    private Result executeCompiledBatchStatement(Result cmd) {
        long csid;
        Statement cs = cmd.statement;
        if ((cs == null || cs.compileTimestamp < this.database.schemaManager.schemaChangeTimestamp) && (cs = this.statementManager.getStatement(this, csid = cmd.getStatementID())) == null) {
            return Result.newErrorResult(Error.error(1252));
        }
        int count = 0;
        RowSetNavigator nav = cmd.initialiseNavigator();
        int[] updateCounts = new int[nav.getSize()];
        Result generatedResult = null;
        if (cs.hasGeneratedColumns()) {
            generatedResult = Result.newDataResult(cs.generatedResultMetaData());
        }
        Result error = null;
        while (nav.hasNext()) {
            Object[] pvals = nav.getNext();
            Result in = this.executeCompiledStatement(cs, pvals);
            if (in.isUpdateCount()) {
                if (cs.hasGeneratedColumns()) {
                    RowSetNavigator navgen = in.getChainedResult().getNavigator();
                    while (navgen.hasNext()) {
                        Object[] generatedRow = navgen.getNext();
                        generatedResult.getNavigator().add(generatedRow);
                    }
                }
                updateCounts[count++] = in.getUpdateCount();
                continue;
            }
            if (in.isData()) {
                updateCounts[count++] = -2;
                continue;
            }
            if (in.mode == 2) {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                error = in;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(updateCounts, generatedResult, error);
    }

    private Result executeDirectBatchStatement(Result cmd) {
        int count = 0;
        RowSetNavigator nav = cmd.initialiseNavigator();
        int[] updateCounts = new int[nav.getSize()];
        Result error = null;
        while (nav.hasNext()) {
            Result in;
            Object[] data = nav.getNext();
            String sql = (String)data[0];
            try {
                in = this.executeDirectStatement(sql);
            }
            catch (Throwable t) {
                in = Result.newErrorResult(t);
            }
            if (in.isUpdateCount()) {
                updateCounts[count++] = in.getUpdateCount();
                continue;
            }
            if (in.isData()) {
                updateCounts[count++] = -2;
                continue;
            }
            if (in.mode == 2) {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                error = in;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(updateCounts, null, error);
    }

    private Result executeResultUpdate(Result cmd) {
        long id = cmd.getResultId();
        int actionType = cmd.getActionType();
        Result result = this.sessionData.getDataResult(id);
        if (result == null) {
            return Result.newErrorResult(Error.error(3601));
        }
        Object[] pvals = (Object[])cmd.valueData;
        Type[] types = cmd.metaData.columnTypes;
        StatementQuery statement = (StatementQuery)result.getStatement();
        QueryExpression qe = statement.queryExpression;
        Table baseTable = qe.getBaseTable();
        int[] columnMap = qe.getBaseTableColumnMap();
        this.sessionContext.rowUpdateStatement.setRowActionProperties(result, actionType, baseTable, types, columnMap);
        Result resultOut = this.executeCompiledStatement(this.sessionContext.rowUpdateStatement, pvals);
        return resultOut;
    }

    public synchronized TimestampData getCurrentDate() {
        this.resetCurrentTimestamp();
        if (this.currentDate == null) {
            this.currentDate = (TimestampData)Type.SQL_DATE.getValue(this.currentMillis / 1000L, 0, this.getZoneSeconds());
        }
        return this.currentDate;
    }

    synchronized TimeData getCurrentTime(boolean withZone) {
        this.resetCurrentTimestamp();
        if (withZone) {
            if (this.currentTime == null) {
                int seconds = (int)HsqlDateTime.getNormalisedTime(this.currentMillis) / 1000;
                int nanos = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTime = new TimeData(seconds, nanos, this.getZoneSeconds());
            }
            return this.currentTime;
        }
        if (this.localTime == null) {
            int seconds = (int)HsqlDateTime.getNormalisedTime(this.currentMillis + (long)(this.getZoneSeconds() * 1000)) / 1000;
            int nanos = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTime = new TimeData(seconds, nanos, 0);
        }
        return this.localTime;
    }

    synchronized TimestampData getCurrentTimestamp(boolean withZone) {
        this.resetCurrentTimestamp();
        if (withZone) {
            if (this.currentTimestamp == null) {
                int nanos = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTimestamp = new TimestampData(this.currentMillis / 1000L, nanos, this.getZoneSeconds());
            }
            return this.currentTimestamp;
        }
        if (this.localTimestamp == null) {
            int nanos = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTimestamp = new TimestampData(this.currentMillis / 1000L + (long)this.getZoneSeconds(), nanos, 0);
        }
        return this.localTimestamp;
    }

    private void resetCurrentTimestamp() {
        if (this.currentTimestampSCN != this.actionTimestamp) {
            this.currentTimestampSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTimestamp = null;
            this.localTimestamp = null;
            this.currentTime = null;
            this.localTime = null;
        }
    }

    public int getZoneSeconds() {
        return this.timeZoneSeconds;
    }

    public void setZoneSeconds(int seconds) {
        if (seconds == this.sessionTimeZoneSeconds) {
            this.calendar = null;
            this.timeZoneSeconds = this.sessionTimeZoneSeconds;
        } else {
            TimeZone zone = TimeZone.getDefault();
            zone.setRawOffset(seconds * 1000);
            this.calendar = new GregorianCalendar(zone);
            this.timeZoneSeconds = seconds;
        }
    }

    private Result getAttributesResult(int id) {
        Result r = Result.newSessionAttributesResult();
        Object[] data = r.getSingleRowData();
        data[0] = ValuePool.getInt(id);
        switch (id) {
            case 0: {
                data[1] = ValuePool.getInt(this.isolationLevel);
                break;
            }
            case 1: {
                data[2] = this.sessionContext.isAutoCommit;
                break;
            }
            case 2: {
                data[2] = this.sessionContext.isReadOnly;
                break;
            }
            case 3: {
                data[3] = this.database.getCatalogName().name;
            }
        }
        return r;
    }

    private Result setAttributes(Result r) {
        Object[] row = r.getSessionAttributes();
        int id = (Integer)row[0];
        try {
            switch (id) {
                case 1: {
                    boolean value = (Boolean)row[2];
                    this.setAutoCommit(value);
                    break;
                }
                case 2: {
                    boolean value = (Boolean)row[2];
                    this.setReadOnlyDefault(value);
                    break;
                }
                case 0: {
                    int value = (Integer)row[1];
                    this.setIsolationDefault(value);
                    break;
                }
                case 3: {
                    String value = (String)row[3];
                    this.setCatalog(value);
                }
            }
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        return Result.updateZeroResult;
    }

    public synchronized Object getAttribute(int id) {
        switch (id) {
            case 0: {
                return ValuePool.getInt(this.isolationLevel);
            }
            case 1: {
                return this.sessionContext.isAutoCommit;
            }
            case 2: {
                return this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.database.getCatalogName().name;
            }
        }
        return null;
    }

    public synchronized void setAttribute(int id, Object object) {
        switch (id) {
            case 1: {
                boolean value = (Boolean)object;
                this.setAutoCommit(value);
                break;
            }
            case 2: {
                boolean value = (Boolean)object;
                this.setReadOnlyDefault(value);
                break;
            }
            case 0: {
                int value = (Integer)object;
                this.setIsolationDefault(value);
                break;
            }
            case 3: {
                String value = (String)object;
                this.setCatalog(value);
            }
        }
    }

    public BlobDataID createBlob(long length) {
        long lobID = this.database.lobManager.createBlob(length);
        if (lobID == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.addToCreatedLobs(lobID);
        return new BlobDataID(lobID);
    }

    public ClobDataID createClob(long length) {
        long lobID = this.database.lobManager.createClob(length);
        if (lobID == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.addToCreatedLobs(lobID);
        return new ClobDataID(lobID);
    }

    public void registerResultLobs(Result result) {
        this.sessionData.registerLobForResult(result);
    }

    public void allocateResultLob(ResultLob result, InputStream inputStream) {
        this.sessionData.allocateLobForResult(result, inputStream);
    }

    Result performLOBOperation(ResultLob cmd) {
        long id = cmd.getLobID();
        int operation = cmd.getSubType();
        switch (operation) {
            case 11: {
                return this.database.lobManager.getLob(id, cmd.getOffset(), cmd.getBlockLength());
            }
            case 10: {
                return this.database.lobManager.getLength(id);
            }
            case 1: {
                return this.database.lobManager.getBytes(id, cmd.getOffset(), (int)cmd.getBlockLength());
            }
            case 2: {
                return this.database.lobManager.setBytes(id, cmd.getOffset(), cmd.getByteArray());
            }
            case 3: {
                return this.database.lobManager.getChars(id, cmd.getOffset(), (int)cmd.getBlockLength());
            }
            case 4: {
                return this.database.lobManager.setChars(id, cmd.getOffset(), cmd.getCharArray());
            }
            case 9: {
                throw Error.error(1551);
            }
            case 12: {
                return this.database.lobManager.getTruncateLength(id);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw Error.error(1551);
            }
        }
        throw Error.runtimeError(201, "Session");
    }

    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }

    boolean isProcessingScript() {
        return this.isProcessingScript;
    }

    boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    public void setSchema(String schema) {
        this.currentSchema = this.database.schemaManager.getSchemaHsqlName(schema);
    }

    public void setCatalog(String catalog) {
        if (this.database.getCatalogName().name.equals(catalog)) {
            return;
        }
        throw Error.error(4840);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String name) {
        return name == null ? this.currentSchema : this.database.schemaManager.getSchemaHsqlName(name);
    }

    public String getSchemaName(String name) {
        return name == null ? this.currentSchema.name : this.database.schemaManager.getSchemaName(name);
    }

    public void setCurrentSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.currentSchema = name;
    }

    public HsqlNameManager.HsqlName getCurrentSchemaHsqlName() {
        return this.currentSchema;
    }

    public int getResultMemoryRowCount() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMemoryRowCount(int count) {
        if (this.database.logger.getTempDirectoryPath() != null) {
            if (count < 0) {
                count = 0;
            }
            this.resultMaxMemoryRows = count;
        }
    }

    public void addWarning(HsqlException warning) {
        int index;
        if (this.sqlWarnings == null) {
            this.sqlWarnings = new HsqlDeque();
        }
        if (this.sqlWarnings.size() > 9) {
            this.sqlWarnings.removeFirst();
        }
        if ((index = this.sqlWarnings.indexOf(warning)) >= 0) {
            this.sqlWarnings.remove(index);
        }
        this.sqlWarnings.add(warning);
    }

    public HsqlException[] getAndClearWarnings() {
        if (this.sqlWarnings == null) {
            return HsqlException.emptyArray;
        }
        Object[] array = new HsqlException[this.sqlWarnings.size()];
        this.sqlWarnings.toArray(array);
        this.sqlWarnings.clear();
        return array;
    }

    public HsqlException getLastWarning() {
        if (this.sqlWarnings == null || this.sqlWarnings.size() == 0) {
            return null;
        }
        return (HsqlException)this.sqlWarnings.getLast();
    }

    public void clearWarnings() {
        if (this.sqlWarnings != null) {
            this.sqlWarnings.clear();
        }
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            if (this.zoneString == null) {
                this.calendar = new GregorianCalendar();
            } else {
                TimeZone zone = TimeZone.getTimeZone(this.zoneString);
                this.calendar = new GregorianCalendar(zone);
            }
        }
        return this.calendar;
    }

    public Type.TypedComparator getComparator() {
        if (this.typedComparator == null) {
            this.typedComparator = Type.newComparator(this);
        }
        return this.typedComparator;
    }

    public double random(long seed) {
        if (this.seed != seed) {
            this.randomGenerator.setSeed(seed);
            this.seed = seed;
        }
        return this.randomGenerator.nextDouble();
    }

    public double random() {
        return this.randomGenerator.nextDouble();
    }

    public Scanner getScanner() {
        if (this.secondaryScanner == null) {
            this.secondaryScanner = new Scanner();
        }
        return this.secondaryScanner;
    }

    public HsqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new HsqlProperties();
            this.clientProperties.setProperty("jdbc.translate_tti_types", this.database.sqlTranslateTTI);
        }
        return this.clientProperties;
    }

    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            this.simpleDateFormatGMT.setCalendar(cal);
        }
        return this.simpleDateFormatGMT;
    }

    void logSequences() {
        HashMap map = this.sessionData.sequenceUpdateMap;
        if (map == null || map.isEmpty()) {
            return;
        }
        Iterator it = map.keySet().iterator();
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            NumberSequence sequence = (NumberSequence)it.next();
            this.database.logger.writeSequenceStatement(this, sequence);
        }
        this.sessionData.sequenceUpdateMap.clear();
    }

    String getStartTransactionSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("START").append(' ').append("TRANSACTION");
        if (this.isolationLevel != this.isolationLevelDefault) {
            sb.append(' ');
            Session.appendIsolationSQL(sb, this.isolationLevel);
        }
        return sb.toString();
    }

    String getTransactionIsolationSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ').append("TRANSACTION");
        sb.append(' ');
        Session.appendIsolationSQL(sb, this.isolationLevel);
        return sb.toString();
    }

    String getSessionIsolationSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ').append("SESSION");
        sb.append(' ').append("CHARACTERISTICS").append(' ');
        sb.append("AS").append(' ').append("TRANSACTION").append(' ');
        Session.appendIsolationSQL(sb, this.isolationLevelDefault);
        return sb.toString();
    }

    static void appendIsolationSQL(StringBuffer sb, int isolationLevel) {
        sb.append("ISOLATION").append(' ');
        sb.append("LEVEL").append(' ');
        sb.append(Session.getIsolationString(isolationLevel));
    }

    static String getIsolationString(int isolationLevel) {
        switch (isolationLevel) {
            case 1: 
            case 2: {
                StringBuffer sb = new StringBuffer();
                sb.append("READ").append(' ');
                sb.append("COMMITTED");
                return sb.toString();
            }
        }
        return "SERIALIZABLE";
    }

    String getSetSchemaStatement() {
        return "SET SCHEMA " + this.currentSchema.statementName;
    }
}

