/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.store.ValuePool;

public class RangeVariableJoined
extends RangeVariable {
    RangeVariable[] rangeArray;

    RangeVariableJoined(Table table, HsqlNameManager.SimpleName alias, OrderedHashSet columnList, HsqlNameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        super(table, alias, columnList, columnNameList, compileContext);
        QuerySpecification qs = (QuerySpecification)this.rangeTable.getQueryExpression();
        this.rangeArray = qs.rangeVariables;
    }

    public void setRangeTableVariables() {
        super.setRangeTableVariables();
    }

    public RangeVariable duplicate() {
        RangeVariable r = null;
        try {
            r = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        r.resetConditions();
        return r;
    }

    void setJoinType(boolean isLeft, boolean isRight) {
        super.setJoinType(isLeft, isRight);
    }

    public void addNamedJoinColumns(OrderedHashSet columns) {
        super.addNamedJoinColumns(columns);
    }

    public void addColumn(int columnIndex) {
        super.addColumn(columnIndex);
    }

    public void addAllColumns() {
        super.addAllColumns();
    }

    void addNamedJoinColumnExpression(String name, Expression e) {
        super.addNamedJoinColumnExpression(name, e);
    }

    ExpressionColumn getColumnExpression(String name) {
        return super.getColumnExpression(name);
    }

    Table getTable() {
        return super.getTable();
    }

    boolean hasIndexCondition() {
        return super.hasIndexCondition();
    }

    boolean setDistinctColumnsOnIndex(int[] colMap) {
        return super.setDistinctColumnsOnIndex(colMap);
    }

    Index getSortIndex() {
        return super.getSortIndex();
    }

    boolean setSortIndex(Index index, boolean reversed) {
        return super.setSortIndex(index, reversed);
    }

    boolean reverseOrder() {
        return super.reverseOrder();
    }

    public OrderedHashSet getColumnNames() {
        return super.getColumnNames();
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        return super.getUniqueColumnNameSet();
    }

    public int findColumn(ExpressionColumn e) {
        if (this.tableAlias != null) {
            return super.findColumn(e);
        }
        int count = 0;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            int colIndex = this.rangeArray[i].findColumn(e);
            if (colIndex > -1) {
                return count + colIndex;
            }
            count += this.rangeArray[i].rangeTable.getColumnCount();
        }
        return -1;
    }

    public int findColumn(String columnName) {
        return super.findColumn(columnName);
    }

    ColumnSchema getColumn(String columnName) {
        return super.getColumn(columnName);
    }

    ColumnSchema getColumn(int i) {
        return super.getColumn(i);
    }

    String getColumnAlias(int i) {
        return super.getColumnAlias(i);
    }

    public HsqlNameManager.SimpleName getColumnAliasName(int i) {
        return super.getColumnAliasName(i);
    }

    boolean hasColumnAlias() {
        return super.hasColumnAlias();
    }

    String getTableAlias() {
        return super.getTableAlias();
    }

    HsqlNameManager.SimpleName getTableAliasName() {
        return super.getTableAliasName();
    }

    boolean resolvesTableName(ExpressionColumn e) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(e);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(e)) continue;
            return true;
        }
        return false;
    }

    public boolean resolvesTableName(String name) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(name);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(name)) continue;
            return true;
        }
        return false;
    }

    boolean resolvesSchemaName(String name) {
        return super.resolvesSchemaName(name);
    }

    void addTableColumns(HsqlArrayList exprList) {
        super.addTableColumns(exprList);
    }

    int addTableColumns(HsqlArrayList exprList, int position, HashSet exclude) {
        return super.addTableColumns(exprList, position, exclude);
    }

    void addTableColumns(Expression expression, HashSet exclude) {
        super.addTableColumns(expression, exclude);
    }

    void setForCheckConstraint() {
        super.setForCheckConstraint();
    }

    Expression getJoinCondition() {
        return super.getJoinCondition();
    }

    void addJoinCondition(Expression e) {
        super.addJoinCondition(e);
    }

    void resetConditions() {
        super.resetConditions();
    }

    OrderedHashSet getSubqueries() {
        return super.getSubqueries();
    }

    public void replaceColumnReference(RangeVariable range, Expression[] list) {
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        super.replaceRangeVariables(ranges, newRanges);
    }

    public void resolveRangeTable(Session session, RangeVariable[] rangeVariables, int rangeCount, RangeVariable[] outerRanges) {
        super.resolveRangeTable(session, rangeVariables, rangeCount, RangeVariable.emptyArray);
    }

    public String describe(Session session, int blanks) {
        RangeVariable.RangeVariableConditions[] conditionsArray = this.joinConditions;
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append(b).append("join type=").append(temp).append("\n");
        sb.append(b).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            sb.append(b).append("alias=").append(this.tableAlias.name).append("\n");
        }
        boolean fullScan = !conditionsArray[0].hasIndexCondition();
        sb.append(b).append("access=").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < conditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions conditions = this.joinConditions[i];
            if (i > 0) {
                sb.append(b).append("OR condition = [");
            } else {
                sb.append(b).append("condition = [");
            }
            sb.append(conditions.describe(session, blanks + 2));
            sb.append(b).append("]\n");
        }
        return sb.toString();
    }

    public RangeVariable.RangeIteratorMain getIterator(Session session) {
        return super.getIterator(session);
    }
}

