/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class RangeVariable
implements Cloneable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    public static final int TABLE_RANGE = 1;
    public static final int TRANSITION_RANGE = 2;
    public static final int PARAMETER_RANGE = 3;
    public static final int VARIALBE_RANGE = 4;
    Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    private Object[] emptyData;
    boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    boolean[] usedColumns;
    boolean[] updatedColumns;
    RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    boolean isLeftJoin;
    boolean isRightJoin;
    boolean isBoundary;
    int level;
    int indexDistinctCount;
    int rangePositionInJoin;
    int rangePosition;
    int parsePosition;
    HashMappedList variables;
    int rangeType;
    boolean isGenerated;

    RangeVariable(HashMappedList variables, HsqlNameManager.SimpleName rangeName, boolean isVariable, int rangeType) {
        this.variables = variables;
        this.rangeType = rangeType;
        this.rangeTable = null;
        this.tableAlias = rangeName;
        this.emptyData = null;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    RangeVariable(Table table, HsqlNameManager.SimpleName alias, OrderedHashSet columnList, HsqlNameManager.SimpleName[] columnNameList, ParserDQL.CompileContext compileContext) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = alias;
        this.columnAliases = columnList;
        this.columnAliasNames = columnNameList;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        compileContext.registerRangeVariable(this);
        SubQuery subQuery = this.rangeTable.getSubQuery();
        if (subQuery == null || subQuery.isResolved()) {
            this.setRangeTableVariables();
        }
    }

    RangeVariable(Table table, int position) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = null;
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = position;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public void resetViewRageTableAsSubquery() {
        this.rangeTable = ((View)this.rangeTable).getSubqueryTable();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public void setRangeTableVariables() {
        if (this.columnAliasNames != null && this.rangeTable.getColumnCount() != this.columnAliasNames.length) {
            throw Error.error(5593);
        }
        this.emptyData = this.rangeTable.getEmptyRowData();
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public RangeVariable duplicate() {
        RangeVariable r = null;
        try {
            r = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        r.resetConditions();
        return r;
    }

    void setJoinType(boolean isLeft, boolean isRight) {
        this.isLeftJoin = isLeft;
        this.isRightJoin = isRight;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void addNamedJoinColumns(OrderedHashSet columns) {
        this.namedJoinColumns = columns;
    }

    public void addColumn(int columnIndex) {
        this.usedColumns[columnIndex] = true;
    }

    public void addAllColumns() {
    }

    void addNamedJoinColumnExpression(String name, Expression e) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(name, e);
    }

    ExpressionColumn getColumnExpression(String name) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(name);
    }

    Table getTable() {
        return this.rangeTable;
    }

    boolean hasIndexCondition() {
        return this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount > 0;
    }

    boolean setDistinctColumnsOnIndex(int[] colMap) {
        int[] indexColMap = this.joinConditions[0].rangeIndex.getColumns();
        if (colMap.length != ArrayUtil.countTrueElements(this.usedColumns)) {
            return false;
        }
        if (colMap.length == 1 && colMap[0] == indexColMap[0]) {
            this.indexDistinctCount = 1;
            return true;
        }
        return false;
    }

    Index getSortIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        return null;
    }

    boolean setSortIndex(Index index, boolean reversed) {
        if (this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount == 0) {
            this.joinConditions[0].rangeIndex = index;
            this.joinConditions[0].reversed = reversed;
            return true;
        }
        return false;
    }

    boolean reverseOrder() {
        this.joinConditions[0].reverseIndexCondition();
        return true;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.columnAliases != null) {
            set.addAll(this.columnAliases);
            return set;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String name = this.rangeTable.getColumn((int)i).getName().name;
            boolean added = set.add(name);
            if (added) continue;
            throw Error.error(5578, name);
        }
        return set;
    }

    public int findColumn(ExpressionColumn e) {
        if (!this.resolvesTableName(e)) {
            return -1;
        }
        return this.findColumn(e.columnName);
    }

    public int findColumn(String columnName) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(columnName)) {
            return -1;
        }
        if (this.variables != null) {
            return this.variables.getIndex(columnName);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(columnName);
        }
        return this.rangeTable.findColumn(columnName);
    }

    ColumnSchema getColumn(String columnName) {
        int index = this.findColumn(columnName);
        return index < 0 ? null : this.rangeTable.getColumn(index);
    }

    ColumnSchema getColumn(int i) {
        if (this.variables == null) {
            return this.rangeTable.getColumn(i);
        }
        return (ColumnSchema)this.variables.get(i);
    }

    String getColumnAlias(int i) {
        HsqlNameManager.SimpleName name = this.getColumnAliasName(i);
        return name.name;
    }

    public HsqlNameManager.SimpleName getColumnAliasName(int i) {
        if (this.columnAliases == null) {
            return this.rangeTable.getColumn(i).getName();
        }
        return this.columnAliasNames[i];
    }

    boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    String getTableAlias() {
        HsqlNameManager.SimpleName name = this.getTableAliasName();
        return name.name;
    }

    HsqlNameManager.SimpleName getTableAliasName() {
        return this.tableAlias == null ? this.rangeTable.getName() : this.tableAlias;
    }

    boolean resolvesTableName(ExpressionColumn e) {
        if (e.tableName == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return e.tableName.equals(this.tableAlias.name);
            }
            return false;
        }
        return e.schema == null ? (this.tableAlias == null ? e.tableName.equals(this.rangeTable.getName().name) : e.tableName.equals(this.tableAlias.name)) : this.tableAlias == null && e.tableName.equals(this.rangeTable.getName().name) && e.schema.equals(this.rangeTable.getSchemaName().name);
    }

    public boolean resolvesTableName(String name) {
        if (name == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return name.equals(this.tableAlias.name);
            }
            return false;
        }
        return this.tableAlias == null ? name.equals(this.rangeTable.getName().name) : name.equals(this.tableAlias.name);
    }

    boolean resolvesSchemaName(String name) {
        if (name == null) {
            return true;
        }
        if (this.variables != null) {
            return false;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return name.equals(this.rangeTable.getSchemaName().name);
    }

    void addTableColumns(HsqlArrayList exprList) {
        if (this.namedJoinColumns != null) {
            int count = exprList.size();
            int position = 0;
            for (int i = 0; i < count; ++i) {
                Expression e = (Expression)exprList.get(i);
                String columnName = e.getColumnName();
                if (!this.namedJoinColumns.contains(columnName)) continue;
                if (position != i) {
                    exprList.remove(i);
                    exprList.add(position, e);
                }
                e = this.getColumnExpression(columnName);
                exprList.set(position, e);
                ++position;
            }
        }
        this.addTableColumns(exprList, exprList.size(), this.namedJoinColumns);
    }

    int addTableColumns(HsqlArrayList exprList, int position, HashSet exclude) {
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, i);
            exprList.add(position++, e);
        }
        return position;
    }

    void addTableColumns(Expression expression, HashSet exclude) {
        HsqlArrayList list = new HsqlArrayList();
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String columnName;
            ColumnSchema column = table.getColumn(i);
            String string = columnName = this.columnAliases == null ? column.getName().name : (String)this.columnAliases.get(i);
            if (exclude != null && exclude.contains(columnName)) continue;
            ExpressionColumn e = new ExpressionColumn(this, i);
            list.add(e);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        expression.nodes = nodes;
    }

    void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
        this.rangePosition = 0;
    }

    Expression getJoinCondition() {
        return this.joinCondition;
    }

    void addJoinCondition(Expression e) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, e);
    }

    void resetConditions() {
        Index index = this.joinConditions[0].rangeIndex;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = index;
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    OrderedHashSet getSubqueries() {
        OrderedHashSet set = null;
        if (this.joinCondition != null) {
            set = this.joinCondition.collectAllSubqueries(set);
        }
        if (this.rangeTable instanceof TableDerived) {
            QueryExpression baseQueryExpression = ((TableDerived)this.rangeTable).getQueryExpression();
            if (((TableDerived)this.rangeTable).view != null) {
                if (set == null) {
                    set = new OrderedHashSet();
                }
                set.addAll(((TableDerived)this.rangeTable).view.getSubqueries());
            } else if (baseQueryExpression == null) {
                set = OrderedHashSet.add(set, this.rangeTable.getSubQuery());
            } else {
                OrderedHashSet temp = baseQueryExpression.getSubqueries();
                set = OrderedHashSet.addAll(set, temp);
                set = OrderedHashSet.add(set, this.rangeTable.getSubQuery());
            }
        }
        return set;
    }

    public void replaceColumnReference(RangeVariable range, Expression[] list) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceColumnReferences(range, list);
        }
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceRangeVariables(ranges, newRanges);
        }
    }

    public void resolveRangeTable(Session session, RangeVariable[] rangeVariables, int rangeCount, RangeVariable[] outerRanges) {
        Table table = this.rangeTable;
        SubQuery subQuery = table.getSubQuery();
        if (subQuery != null && !subQuery.isResolved()) {
            if (subQuery.dataExpression != null) {
                HsqlList unresolved = subQuery.dataExpression.resolveColumnReferences(session, emptyArray, null);
                if (unresolved != null) {
                    unresolved = subQuery.dataExpression.resolveColumnReferences(session, rangeVariables, rangeCount, null, true);
                }
                if (unresolved != null) {
                    unresolved = subQuery.dataExpression.resolveColumnReferences(session, outerRanges, null);
                }
                if (unresolved != null) {
                    throw Error.error(5501, ((Expression)unresolved.get(0)).getSQL());
                }
                subQuery.dataExpression.resolveTypes(session, null);
                this.setRangeTableVariables();
            }
            if (subQuery.queryExpression != null) {
                subQuery.queryExpression.resolveReferences(session, outerRanges);
                HsqlList list = subQuery.queryExpression.getUnresolvedExpressions();
                HsqlList unresolved = Expression.resolveColumnSet(session, rangeVariables, rangeCount, list, null);
                if (unresolved != null) {
                    throw Error.error(5501, ((Expression)unresolved.get(0)).getSQL());
                }
                subQuery.queryExpression.resolveTypes(session);
                subQuery.prepareTable(session);
                subQuery.setCorrelated();
                this.setRangeTableVariables();
            }
        }
    }

    public String describe(Session session, int blanks) {
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        String temp = "INNER";
        if (this.isLeftJoin) {
            temp = "LEFT OUTER";
            if (this.isRightJoin) {
                temp = "FULL";
            }
        } else if (this.isRightJoin) {
            temp = "RIGHT OUTER";
        }
        sb.append(b).append("join type=").append(temp).append("\n");
        sb.append(b).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            sb.append(b).append("alias=").append(this.tableAlias.name).append("\n");
        }
        RangeVariableConditions[] conditions = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            conditions = this.whereConditions;
        }
        boolean fullScan = !conditions[0].hasIndexCondition();
        sb.append(b);
        if (conditions == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            sb.append("join condition = [");
            sb.append(this.joinConditions[0].nonIndexCondition.describe(session, blanks));
            sb.append(b).append("]\n");
            sb.append(b);
        }
        sb.append("access=").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                sb.append(b).append("OR condition = [");
            } else {
                sb.append(b);
                if (conditions == this.whereConditions) {
                    sb.append("where condition = [");
                } else {
                    sb.append("join condition = [");
                }
            }
            sb.append(conditions[i].describe(session, blanks + 2));
            sb.append(b).append("]\n");
        }
        if (conditions == this.joinConditions) {
            sb.append(b);
            if (this.whereConditions[0].nonIndexCondition != null) {
                sb.append("where condition = [");
                sb.append(this.whereConditions[0].nonIndexCondition.describe(session, blanks));
                sb.append(b).append("]\n");
                sb.append(b);
            }
        }
        return sb.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain it = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(it);
        return it;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVars) {
        if (rangeVars.length == 1) {
            return rangeVars[0].getIterator(session);
        }
        RangeIteratorMain[] iterators = new RangeIteratorMain[rangeVars.length];
        for (int i = 0; i < rangeVars.length; ++i) {
            iterators[i] = rangeVars[i].getIterator(session);
        }
        return new RangeIteratorJoined(iterators);
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression[] indexEndCond;
        Expression indexEndCondition;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        Expression nonIndexCondition;
        int opType;
        int opTypeEnd;
        boolean isFalse;
        boolean reversed;

        RangeVariableConditions(RangeVariable rangeVar, boolean isJoin) {
            this.rangeVar = rangeVar;
            this.isJoin = isJoin;
        }

        RangeVariableConditions(RangeVariableConditions base) {
            this.rangeVar = base.rangeVar;
            this.isJoin = base.isJoin;
            this.nonIndexCondition = base.nonIndexCondition;
        }

        boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        void addCondition(Expression e) {
            if (e == null) {
                return;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, e);
            if (Expression.EXPR_FALSE.equals(this.nonIndexCondition)) {
                this.isFalse = true;
            }
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            if (this.indexedColumnCount == 0) {
                return;
            }
            if (e.getIndexableExpression(this.rangeVar) == null) {
                return;
            }
            int colIndex = e.getLeftNode().getColumnIndex();
            switch (e.getType()) {
                case 42: 
                case 43: {
                    if (this.opType == 48) {
                        if (this.rangeIndex.getColumns()[this.indexedColumnCount - 1] != colIndex) break;
                        this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, this.indexCond[this.indexedColumnCount - 1]);
                        this.indexCond[this.indexedColumnCount - 1] = e;
                        this.opType = e.opType;
                        if (e.exprSubType != 53 || this.indexedColumnCount != 1) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = ExpressionLogical.andExpressions(this.indexEndCond[this.indexedColumnCount - 1], e.nodes[2]);
                        break;
                    }
                    this.addToIndexConditions(e);
                    break;
                }
                case 44: 
                case 45: {
                    if (this.opType != 43 && this.opType != 42 && this.opType != 48 || this.opTypeEnd != 74 || this.rangeIndex.getColumns()[this.indexedColumnCount - 1] != colIndex) break;
                    this.indexEndCond[this.indexedColumnCount - 1] = e;
                    this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                    this.opTypeEnd = e.getType();
                    break;
                }
            }
        }

        boolean addToIndexConditions(Expression e) {
            if ((this.opType == 41 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == e.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = e;
                ++this.indexedColumnCount;
                this.opType = e.opType;
                this.opTypeEnd = 74;
                return true;
            }
            return false;
        }

        void addIndexCondition(Expression[] exprList, Index index, int colCount) {
            this.rangeIndex = index;
            this.opType = exprList[0].getType();
            switch (this.opType) {
                case 48: {
                    this.indexCond = exprList;
                    this.indexEndCond = new Expression[exprList.length];
                    this.opTypeEnd = 74;
                    break;
                }
                case 42: 
                case 43: {
                    this.indexCond = exprList;
                    this.indexEndCond = new Expression[exprList.length];
                    if (exprList[0].exprSubType == 53) {
                        this.indexEndCond[0] = this.indexEndCondition = exprList[0].nodes[2];
                    }
                    this.opTypeEnd = 74;
                    break;
                }
                case 44: 
                case 45: {
                    Expression e = exprList[0].getLeftNode();
                    e = new ExpressionLogical(47, e);
                    e = new ExpressionLogical(48, e);
                    this.indexCond = new Expression[]{e};
                    this.indexEndCond = new Expression[exprList.length];
                    this.indexEndCond[0] = this.indexEndCondition = exprList[0];
                    this.opTypeEnd = this.opType;
                    this.opType = 48;
                    break;
                }
                case 41: 
                case 47: {
                    this.indexCond = exprList;
                    this.indexEndCond = new Expression[exprList.length];
                    for (int i = 0; i < colCount; ++i) {
                        Expression e;
                        this.indexEndCond[i] = e = exprList[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
                        this.opType = e.getType();
                    }
                    this.opTypeEnd = this.opType;
                    break;
                }
                default: {
                    Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = colCount;
        }

        void reverseIndexCondition() {
            if (this.opType == 41 || this.opType == 47) {
                return;
            }
            this.indexEndCondition = null;
            for (int i = 0; i < this.indexedColumnCount; ++i) {
                Expression e = this.indexCond[i];
                this.indexCond[i] = this.indexEndCond[i];
                this.indexEndCond[i] = e;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, e);
            }
            this.opType = this.opTypeEnd;
            this.reversed = true;
        }

        String describe(Session session, int blanks) {
            StringBuffer sb = new StringBuffer();
            String b = ValuePool.spaceString.substring(0, blanks);
            sb.append("index=").append(this.rangeIndex.getName().name).append("\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    sb.append(b).append("start conditions=[");
                    for (int j = 0; j < this.indexedColumnCount; ++j) {
                        if (this.indexCond == null || this.indexCond[j] == null) continue;
                        sb.append(this.indexCond[j].describe(session, blanks));
                    }
                    sb.append("]\n");
                }
                if (this.indexEndCondition != null) {
                    String temp = this.indexEndCondition.describe(session, blanks);
                    sb.append(b).append("end condition=[").append(temp).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String temp = this.nonIndexCondition.describe(session, blanks);
                sb.append(b).append("other condition=[").append(temp).append("]\n");
            }
            return sb.toString();
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIterators) {
            this.rangeIterators = rangeIterators;
            this.isBeforeFirst = true;
        }

        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        public boolean next() {
            while (this.currentIndex >= 0) {
                RangeIteratorMain it = this.rangeIterators[this.currentIndex];
                if (it.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    this.currentRow = this.rangeIterators[this.currentIndex].currentRow;
                    this.currentData = this.currentRow.getData();
                    return true;
                }
                it.reset();
                --this.currentIndex;
            }
            this.currentData = this.rangeIterators[this.rangeIterators.length - 1].rangeVar.emptyData;
            this.currentRow = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        public void remove() {
        }

        public void release() {
            if (this.it != null) {
                this.it.release();
            }
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        public int getRangePosition() {
            return 0;
        }

        public RangeVariable getRange() {
            return null;
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVar, RangeIteratorMain main) {
            super(session, rangeVar);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == null) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        protected boolean findNextRight() {
            boolean result;
            block2: {
                result = false;
                do {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block2;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block2;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                result = true;
            }
            if (result) {
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            return result;
        }

        private boolean lookupAndTest() {
            boolean result;
            boolean bl = result = !this.lookup.contains(this.currentRow.getPos());
            if (result) {
                this.currentData = this.currentRow.getData();
                if (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                    result = false;
                }
            }
            return result;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        RangeVariableConditions[] joinConditions;
        int condIndex = 0;
        OrderedIntHashSet lookup;
        Object[] currentJoinData = null;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVar) {
            this.rangePosition = rangeVar.rangePosition;
            this.store = rangeVar.rangeTable.getRowStore(session);
            this.session = session;
            this.rangeVar = rangeVar;
            this.currentData = rangeVar.emptyData;
            this.isBeforeFirst = true;
            this.whereConditions = rangeVar.whereConditions;
            this.joinConditions = rangeVar.joinConditions;
            if (rangeVar.isRightJoin) {
                this.lookup = new OrderedIntHashSet();
            }
            this.conditions = rangeVar.joinConditions;
            if (rangeVar.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVar.whereConditions;
            }
        }

        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        public boolean next() {
            while (this.condIndex < this.conditions.length) {
                boolean result;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (result = this.findNext()) {
                    return true;
                }
                this.reset();
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        public void remove() {
        }

        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentData = this.rangeVar.emptyData;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            if (this.condIndex == 0) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].isFalse) {
                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                return;
            }
            SubQuery subQuery = this.rangeVar.rangeTable.getSubQuery();
            if (subQuery != null) {
                subQuery.materialiseCorrelated(this.session);
            }
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].reversed ? this.conditions[this.condIndex].rangeIndex.lastRow(this.session, this.store) : this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store);
            } else {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            if (this.currentJoinData == null || this.currentJoinData.length < this.conditions[this.condIndex].indexedColumnCount) {
                this.currentJoinData = new Object[this.conditions[this.condIndex].indexedColumnCount];
            }
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                Object value;
                block11: {
                    int exprType;
                    int range;
                    block12: {
                        int opType;
                        range = 0;
                        int n = opType = i == this.conditions[this.condIndex].indexedColumnCount - 1 ? this.conditions[this.condIndex].opType : this.conditions[this.condIndex].indexCond[i].getType();
                        if (opType == 47 || opType == 48 || opType == 74) {
                            this.currentJoinData[i] = null;
                            continue;
                        }
                        Type valueType = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                        value = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                        Type targetType = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                        if (targetType != valueType && (range = targetType.compareToTypeRange(value)) == 0 && targetType.typeComparisonGroup != valueType.typeComparisonGroup) {
                            value = targetType.convertToType(this.session, value, valueType);
                        }
                        if (i != 0) break block11;
                        exprType = this.conditions[this.condIndex].indexCond[0].getType();
                        if (range >= 0) break block12;
                        switch (exprType) {
                            case 42: 
                            case 43: {
                                value = null;
                                break block11;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                    if (range > 0) {
                        switch (exprType) {
                            case 48: {
                                value = null;
                                break;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                }
                this.currentJoinData[i] = value;
            }
            this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, this.currentJoinData, this.conditions[this.condIndex].indexedColumnCount, this.rangeVar.indexDistinctCount, this.conditions[this.condIndex].opType, this.conditions[this.condIndex].reversed, null);
        }

        protected boolean findNext() {
            boolean result;
            block5: {
                result = false;
                while (true) {
                    this.currentRow = this.it.getNextRow();
                    if (this.currentRow == null) break block5;
                    this.currentData = this.currentRow.getData();
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block5;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        this.addFoundRow();
                        continue;
                    }
                    Expression e = this.conditions[this.condIndex].excludeConditions;
                    if (e == null || !e.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.currentRow = null;
            this.currentData = this.rangeVar.emptyData;
            if (this.hasLeftOuterRow && this.condIndex == this.conditions.length - 1) {
                result = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
                this.hasLeftOuterRow = false;
            }
            return result;
        }

        protected void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                this.lookup.add(this.currentRow.getPos());
            }
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it;
        PersistentStore store;
        Object[] currentData;
        Row currentRow;
        boolean isBeforeFirst;
        RangeVariable rangeVar;

        RangeIteratorBase() {
        }

        public RangeIteratorBase(Session session, PersistentStore store, TableBase t, int position) {
            this.session = session;
            this.rangePosition = position;
            this.store = store;
            this.it = t.rowIterator(store);
            this.isBeforeFirst = true;
        }

        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == null) {
                return false;
            }
            this.currentRow = this.it.getNextRow();
            if (this.currentRow == null) {
                return false;
            }
            this.currentData = this.currentRow.getData();
            return true;
        }

        public Row getCurrentRow() {
            return this.currentRow;
        }

        public Object[] getCurrent() {
            return this.currentData;
        }

        public Object getCurrent(int i) {
            return this.currentData == null ? null : this.currentData[i];
        }

        public void setCurrent(Object[] data) {
            this.currentData = data;
        }

        public long getRowId() {
            return this.currentRow == null ? 0L : ((long)this.rangeVar.rangeTable.getId() << 32) + (long)this.currentRow.getPos();
        }

        public Object getRowidObject() {
            return this.currentRow == null ? null : ValuePool.getLong(this.getRowId());
        }

        public void remove() {
        }

        public void reset() {
            if (this.it != null) {
                this.it.release();
            }
            this.it = null;
            this.currentRow = null;
            this.isBeforeFirst = true;
        }

        public int getRangePosition() {
            return this.rangePosition;
        }

        public RangeVariable getRange() {
            return this.rangeVar;
        }

        public Row getNextRow() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        public Object[] getNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        public boolean setRowColumns(boolean[] columns) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        public void release() {
            if (this.it != null) {
                this.it.release();
            }
        }
    }
}

