/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDML;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementProcedure;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSet;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public class ParserRoutine
extends ParserDML {
    ParserRoutine(Session session, Scanner t) {
        super(session, t);
    }

    Expression readDefaultClause(Type dataType) {
        Expression e = null;
        boolean minus = false;
        if (this.token.tokenType == 186) {
            this.read();
            return new ExpressionValue(null, dataType);
        }
        if (dataType.isDateTimeType() || dataType.isIntervalType()) {
            switch (this.token.tokenType) {
                case 72: 
                case 140: 
                case 281: 
                case 282: {
                    e = this.readDateTimeIntervalLiteral();
                    if (e.dataType.typeCode != dataType.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object defaultValue = e.getValue(this.session, dataType);
                    return new ExpressionValue(defaultValue, dataType);
                }
                case 845: {
                    break;
                }
                default: {
                    e = this.XreadDateTimeValueFunctionOrNull();
                    if (e == null) break;
                    e = this.XreadModifier(e);
                    break;
                }
            }
        } else if (dataType.isNumberType()) {
            if (this.token.tokenType == 784) {
                this.read();
                minus = true;
            } else if (this.database.sqlSyntaxPgs && this.token.tokenType == 609) {
                return this.readNextvalFunction();
            }
        } else if (dataType.isCharacterType()) {
            switch (this.token.tokenType) {
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 253: 
                case 277: 
                case 305: {
                    FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    e = this.readSQLFunction(function);
                    break;
                }
            }
        } else if (dataType.isBooleanType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 106: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        } else if (dataType.isBitType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, dataType);
                }
                case 106: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, dataType);
                }
            }
        } else if (dataType.isArrayType()) {
            e = this.readCollection(19);
            if (e.nodes.length > 0) {
                throw Error.error(5562);
            }
            this.resolveOuterReferencesAndTypes(RangeVariable.emptyArray, e);
            return e;
        }
        if (e != null) {
            e.resolveTypes(this.session, null);
            if (dataType.typeComparisonGroup != e.getDataType().typeComparisonGroup) {
                throw Error.error(5562);
            }
            return e;
        }
        boolean inParens = false;
        if (this.database.sqlSyntaxMss && this.token.tokenType == 786) {
            this.read();
            inParens = true;
        }
        if (this.token.tokenType == 845) {
            Object value = this.token.tokenValue;
            Type valueType = this.token.dataType;
            Type convertType = dataType;
            if (dataType.typeCode == 40) {
                convertType = Type.getType(12, null, this.database.collation, dataType.precision, 0);
            } else if (dataType.typeCode == 30) {
                convertType = Type.getType(61, null, null, dataType.precision, 0);
            }
            value = convertType.convertToType(this.session, value, valueType);
            this.read();
            if (minus) {
                value = dataType.negate(value);
            }
            if (inParens) {
                this.readThis(772);
            }
            return new ExpressionValue(value, convertType);
        }
        throw this.unexpectedToken();
    }

    Statement compileOpenCursorStatement(StatementCompound context) {
        this.readThis(196);
        this.checkIsSimpleName();
        String tokenString = this.token.tokenString;
        this.read();
        for (int i = 0; i < context.cursors.length; ++i) {
            if (!context.cursors[i].getCursorName().name.equals(tokenString)) continue;
            return context.cursors[i];
        }
        throw Error.error(4680);
    }

    Statement compileSelectSingleRowStatement(RangeVariable[] rangeVars) {
        OrderedHashSet variableNames = new OrderedHashSet();
        QuerySpecification select = this.XreadSelect();
        LongDeque colIndexList = new LongDeque();
        this.readThis(141);
        this.readTargetSpecificationList(variableNames, rangeVars, colIndexList);
        this.XreadTableExpression(select);
        select.setReturningResult();
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] variables = new Expression[variableNames.size()];
        variableNames.toArray(variables);
        Type[] targetTypes = new Type[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            if (((Expression)variables[i]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            targetTypes[i] = ((Expression)variables[i]).getDataType();
        }
        select.resolve(this.session, rangeVars, targetTypes);
        if (select.getColumnCount() != variables.length) {
            throw Error.error(5564, "INTO");
        }
        StatementSet statement = new StatementSet(this.session, (Expression[])variables, select, columnMap, this.compileContext);
        return statement;
    }

    Statement compileGetStatement(RangeVariable[] rangeVars) {
        int i;
        this.read();
        this.readThis(391);
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        LongDeque colIndexList = new LongDeque();
        this.readGetClauseList(rangeVars, targetSet, colIndexList, exprList);
        if (exprList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != targetSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeVars, (Expression)targets[i]);
        }
        this.resolveOuterReferencesAndTypes(rangeVars, expression);
        for (i = 0; i < targets.length; ++i) {
            if (((Expression)targets[i]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            if (((Expression)targets[i]).getDataType().canBeAssignedFrom(expression.getNodeDataType(i))) continue;
            throw Error.error(5561);
        }
        StatementSet cs = new StatementSet(this.session, (Expression[])targets, expression, columnMap, this.compileContext);
        return cs;
    }

    Statement compileSetStatement(RangeVariable[] rangeVars) {
        int i;
        this.read();
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        LongDeque colIndexList = new LongDeque();
        this.readSetClauseList(rangeVars, targetSet, colIndexList, exprList);
        if (exprList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != targetSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeVars, (Expression)targets[i]);
        }
        this.resolveOuterReferencesAndTypes(rangeVars, expression);
        for (i = 0; i < targets.length; ++i) {
            if (((Expression)targets[i]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            if (((Expression)targets[i]).getDataType().canBeAssignedFrom(expression.getNodeDataType(i))) continue;
            throw Error.error(5561);
        }
        StatementSet cs = new StatementSet(this.session, (Expression[])targets, expression, columnMap, this.compileContext);
        return cs;
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeVariable[] rangeVars) {
        this.read();
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] targetRangeVars = new RangeVariable[]{rangeVars[1]};
        LongDeque colIndexList = new LongDeque();
        this.readSetClauseList(targetRangeVars, targetSet, colIndexList, exprList);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(RangeVariable.emptyArray, (Expression)targets[i]);
        }
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        this.resolveUpdateExpressions(table, rangeVars, columnMap, updateExpressions, RangeVariable.emptyArray);
        StatementSet cs = new StatementSet(this.session, (Expression[])targets, table, rangeVars, columnMap, updateExpressions, this.compileContext);
        return cs;
    }

    StatementSchema compileAlterSpecificRoutine() {
        OrderedHashSet set;
        boolean restrict = false;
        this.readThis(259);
        this.readThis(491);
        Routine routine = (Routine)this.readSchemaObjectName(24);
        routine = routine.duplicate();
        this.readRoutineCharacteristics(routine);
        restrict = this.readIfThis(485);
        if (restrict && !(set = this.database.schemaManager.getReferencingObjectNames(routine.getSpecificName())).isEmpty()) {
            throw Error.error(5502);
        }
        if (this.token.tokenType == 567) {
            this.read();
        } else if (this.token.tokenType == 445) {
            this.read();
        }
        this.readRoutineBody(routine);
        routine.resetAlteredRoutineSettings();
        routine.resolve(this.session);
        Object[] args = new Object[]{routine};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 17, args, null, this.database.schemaManager.getCatalogNameArray());
        return cs;
    }

    StatementSchema compileCreateProcedureOrFunction() {
        boolean isAggregate = false;
        if (this.token.tokenType == 559) {
            isAggregate = true;
            this.read();
            if (this.token.tokenType == 215) {
                throw super.unexpectedToken();
            }
        }
        int routineType = this.token.tokenType == 215 ? 17 : 16;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(routineType, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Routine routine = new Routine(routineType);
        routine.setName(name);
        routine.setAggregate(isAggregate);
        this.readThis(786);
        if (this.token.tokenType == 772) {
            this.read();
        } else {
            while (true) {
                ColumnSchema newcolumn = this.readRoutineParameter(routine, true);
                routine.addParameter(newcolumn);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            this.readThis(772);
        }
        if (routineType != 17) {
            this.readThis(238);
            if (this.token.tokenType == 278) {
                this.read();
                TableDerived table = new TableDerived(this.database, SqlInvariants.MODULE_HSQLNAME, 11);
                this.readTableDefinition(routine, table);
                routine.setReturnTable(table);
            } else {
                Type type = this.readTypeDefinition(false, true);
                routine.setReturnType(type);
            }
        }
        this.readRoutineCharacteristics(routine);
        this.readRoutineBody(routine);
        Object[] args = new Object[]{routine};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 14, args, null, this.database.schemaManager.getCatalogNameArray());
        return cs;
    }

    Routine readCreatePasswordCheckFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 181) {
            this.read();
            return null;
        }
        if (this.token.tokenType == 104) {
            routine.setLanguage(1);
            routine.setDataImpact(1);
        } else {
            routine.setLanguage(2);
            routine.setDataImpact(2);
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 16);
        hsqlName.setSchemaIfNull(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        routine.setName(hsqlName);
        hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 23);
        ColumnSchema column = new ColumnSchema(hsqlName, Type.SQL_VARCHAR, false, false, null);
        routine.addParameter(column);
        routine.setReturnType(Type.SQL_BOOLEAN);
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    Routine readCreateDatabaseAuthenticationFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 181) {
            this.read();
            return null;
        }
        this.checkIsThis(104);
        routine.setLanguage(1);
        routine.setDataImpact(1);
        routine.setName(this.database.nameManager.newHsqlName("AUTHENTICATION", false, 16));
        for (int i = 0; i < 3; ++i) {
            ColumnSchema column = new ColumnSchema(null, Type.SQL_VARCHAR, false, false, null);
            routine.addParameter(column);
        }
        routine.setReturnType(new ArrayType(Type.SQL_VARCHAR_DEFAULT, 1024));
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    private void readTableDefinition(Routine routine, Table table) throws HsqlException {
        this.readThis(786);
        int i = 0;
        while (true) {
            ColumnSchema newcolumn;
            if ((newcolumn = this.readRoutineParameter(routine, false)).getName() == null) {
                throw super.unexpectedToken();
            }
            table.addColumn(newcolumn);
            if (this.token.tokenType != 774) break;
            this.read();
            ++i;
        }
        this.readThis(772);
        table.createPrimaryKey();
    }

    private void readRoutineCharacteristics(Routine routine) {
        OrderedIntHashSet set = new OrderedIntHashSet();
        boolean end = false;
        block16: while (!end) {
            switch (this.token.tokenType) {
                case 146: {
                    if (!set.add(146)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setLanguage(1);
                        continue block16;
                    }
                    if (this.token.tokenType == 261) {
                        this.read();
                        routine.setLanguage(2);
                        continue block16;
                    }
                    throw this.unexpectedToken();
                }
                case 204: {
                    if (!set.add(204)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(519);
                    if (this.token.tokenType == 425) {
                        this.read();
                        routine.setParameterStyle(1);
                        continue block16;
                    }
                    this.readThis(261);
                    routine.setParameterStyle(2);
                    continue block16;
                }
                case 259: {
                    if (!set.add(259)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(24, false);
                    routine.setSpecificName(name);
                    continue block16;
                }
                case 83: {
                    if (!set.add(83)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block16;
                }
                case 183: {
                    if (!set.add(83)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(83);
                    routine.setDeterministic(false);
                    continue block16;
                }
                case 171: {
                    if (!set.add(261)) {
                        throw this.unexpectedToken();
                    }
                    if (routine.getType() == 16) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    this.readThis(378);
                    routine.setDataImpact(4);
                    continue block16;
                }
                case 180: {
                    if (!set.add(261)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    routine.setDataImpact(1);
                    continue block16;
                }
                case 218: {
                    if (!set.add(261)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    this.readThis(378);
                    routine.setDataImpact(3);
                    continue block16;
                }
                case 375: {
                    if (!set.add(261)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(261);
                    routine.setDataImpact(2);
                    continue block16;
                }
                case 238: {
                    if (!set.add(186) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isAggregate()) {
                        throw Error.error(5604, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(186);
                    this.readThis(194);
                    this.readThis(186);
                    this.readThis(419);
                    routine.setNullInputOutput(true);
                    continue block16;
                }
                case 26: {
                    if (!set.add(186) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(194);
                    this.readThis(186);
                    this.readThis(419);
                    routine.setNullInputOutput(false);
                    continue block16;
                }
                case 89: {
                    if (!set.add(236) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(236);
                    this.readThis(510);
                    int results = this.readInteger();
                    if (results < 0 || results > 16) {
                        throw Error.error(5604, String.valueOf(results));
                    }
                    routine.setMaxDynamicResults(results);
                    continue block16;
                }
                case 179: {
                    if (routine.getType() == 16 || !set.add(246)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(246);
                    this.readThis(432);
                    routine.setNewSavepointLevel(true);
                    continue block16;
                }
                case 193: {
                    if (routine.getType() == 16 || !set.add(246)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(246);
                    this.readThis(432);
                    routine.setNewSavepointLevel(false);
                    throw super.unsupportedFeature("OLD");
                }
            }
            end = true;
        }
    }

    void readRoutineBody(Routine routine) {
        if (this.token.tokenType == 104) {
            if (routine.getLanguage() != 1) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(445);
            this.checkIsValue(1);
            routine.setMethodURL((String)this.token.tokenValue);
            this.read();
            if (this.token.tokenType == 204) {
                this.read();
                this.readThis(519);
                this.readThis(425);
            }
        } else {
            this.startRecording();
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            Token[] tokenisedStatement = this.getRecordedStatement();
            String sql = Token.getSQL(tokenisedStatement);
            statement.setSQL(sql);
            routine.setProcedure(statement);
        }
    }

    private Object[] readLocalDeclarationList(Routine routine, StatementCompound context) {
        RangeVariable[] rangeVariables;
        HsqlArrayList list = new HsqlArrayList();
        boolean table = false;
        boolean variableOrCondition = true;
        int cursor = 2;
        int handler = 3;
        int objectType = 0;
        RangeVariable[] rangeVariableArray = rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        while (this.token.tokenType == 77) {
            Object var = null;
            if (objectType == 0) {
                var = this.readLocalTableVariableDeclarationOrNull(routine);
                if (var == null) {
                    objectType = 1;
                    continue;
                }
                list.add(var);
                this.readThis(791);
                continue;
            }
            if (objectType == 1) {
                var = this.readLocalVariableDeclarationOrNull();
                if (var == null) {
                    objectType = 2;
                    continue;
                }
                list.addAll((Object[])var);
                continue;
            }
            if (objectType == 2) {
                var = this.compileDeclareCursor(true, rangeVariables);
                if (var == null) {
                    objectType = 3;
                    continue;
                }
                list.add(var);
                this.readThis(791);
                continue;
            }
            if (objectType != 3) continue;
            var = this.compileLocalHandlerDeclaration(routine, context);
            list.add(var);
        }
        Object[] declarations = new Object[list.size()];
        list.toArray(declarations);
        return declarations;
    }

    Table readLocalTableVariableDeclarationOrNull(Routine routine) {
        int position = super.getPosition();
        this.readThis(77);
        if (this.token.tokenType == 278) {
            this.read();
            HsqlNameManager.HsqlName name = super.readNewSchemaObjectName(3, false);
            name.schema = SqlInvariants.MODULE_HSQLNAME;
            Table table = new Table(this.database, name, 11);
            this.readTableDefinition(routine, table);
            return table;
        }
        this.rewind(position);
        return null;
    }

    ColumnSchema[] readLocalVariableDeclarationOrNull() {
        Type type;
        int position = super.getPosition();
        HsqlNameManager.HsqlName[] names = HsqlNameManager.HsqlName.emptyArray;
        try {
            this.readThis(77);
            if (this.isReservedKey()) {
                this.rewind(position);
                return null;
            }
            while (true) {
                names = (HsqlNameManager.HsqlName[])ArrayUtil.resizeArray(names, names.length + 1);
                names[names.length - 1] = super.readNewSchemaObjectName(22, false);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            type = this.readTypeDefinition(false, true);
        }
        catch (HsqlException e) {
            this.rewind(position);
            return null;
        }
        Expression def = null;
        if (this.token.tokenType == 78) {
            this.read();
            def = this.readDefaultClause(type);
        }
        ColumnSchema[] variable = new ColumnSchema[names.length];
        for (int i = 0; i < names.length; ++i) {
            variable[i] = new ColumnSchema(names[i], type, true, false, def);
            variable[i].setParameterMode((byte)2);
        }
        this.readThis(791);
        return variable;
    }

    private StatementHandler compileLocalHandlerDeclaration(Routine routine, StatementCompound context) {
        int handlerType;
        this.readThis(77);
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                handlerType = 5;
                break;
            }
            case 102: {
                this.read();
                handlerType = 6;
                break;
            }
            case 297: {
                this.read();
                handlerType = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(124);
        this.readThis(112);
        StatementHandler handler = new StatementHandler(handlerType);
        boolean end = false;
        boolean start = true;
        block12: while (!end) {
            int conditionType = 0;
            switch (this.token.tokenType) {
                case 774: {
                    if (start) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    start = true;
                    continue block12;
                }
                case 263: {
                    conditionType = 4;
                }
                case 262: {
                    if (conditionType == 0) {
                        conditionType = 1;
                    }
                }
                case 264: {
                    if (conditionType == 0) {
                        conditionType = 2;
                    }
                }
                case 183: {
                    if (conditionType == 0) {
                        conditionType = 3;
                    }
                    if (!start) {
                        throw this.unexpectedToken();
                    }
                    start = false;
                    this.read();
                    if (conditionType == 3) {
                        this.readThis(404);
                    } else if (conditionType == 4) {
                        String sqlState = this.parseSQLStateValue();
                        handler.addConditionState(sqlState);
                        continue block12;
                    }
                    handler.addConditionType(conditionType);
                    continue block12;
                }
            }
            if (start) {
                throw this.unexpectedToken();
            }
            end = true;
        }
        if (this.token.tokenType == 791) {
            this.read();
        } else {
            Statement e = this.compileSQLProcedureStatementOrNull(routine, context);
            if (e == null) {
                throw this.unexpectedToken();
            }
            this.readThis(791);
            handler.addStatement(e);
        }
        return handler;
    }

    String parseSQLStateValue() {
        this.readIfThis(307);
        this.checkIsValue(1);
        String sqlState = this.token.tokenString;
        if (this.token.tokenString.length() != 5) {
            throw Error.error(5607);
        }
        this.read();
        return sqlState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement compileCompoundStatement(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        boolean atomic = true;
        this.readThis(17);
        this.readThis(14);
        StatementCompound statement = new StatementCompound(12, label);
        statement.setAtomic(true);
        statement.setRoot(routine);
        statement.setParent(context);
        Object[] declarations = this.readLocalDeclarationList(routine, context);
        statement.setLocalDeclarations(declarations);
        this.session.sessionContext.pushRoutineTables(statement.scopeTables);
        try {
            Statement[] statements = this.compileSQLProcedureStatementList(routine, statement);
            statement.setStatements(statements);
            Object var9_8 = null;
            this.session.sessionContext.popRoutineTables();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.session.sessionContext.popRoutineTables();
            throw throwable;
        }
        this.readThis(94);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        return statement;
    }

    private Statement[] compileSQLProcedureStatementList(Routine routine, StatementCompound context) {
        Statement e;
        HsqlArrayList list = new HsqlArrayList();
        while ((e = this.compileSQLProcedureStatementOrNull(routine, context)) != null) {
            this.readThis(791);
            list.add(e);
        }
        if (list.size() == 0) {
            throw this.unexpectedToken();
        }
        Statement[] statements = new Statement[list.size()];
        list.toArray(statements);
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Statement compileSQLProcedureStatementOrNull(Routine routine, StatementCompound context) {
        Statement statement;
        RangeVariable[] rangeVariables;
        Statement cs = null;
        HsqlNameManager.HsqlName label = null;
        RangeVariable[] rangeVariableArray = rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        if (!routine.isTrigger() && this.isSimpleName() && !this.isReservedKey()) {
            label = this.readNewSchemaObjectName(21, false);
            if (this.token.tokenType != 773) {
                throw this.unexpectedToken(label.getNameString());
            }
            this.readThis(773);
        }
        this.compileContext.reset();
        HsqlNameManager.HsqlName oldSchema = this.session.getCurrentSchemaHsqlName();
        this.session.setCurrentSchemaHsqlName(routine.getSchemaName());
        try {
            block2 : switch (this.token.tokenType) {
                case 196: {
                    if (routine.dataImpact == 2) {
                        throw Error.error(5602, routine.getDataImpactString());
                    }
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileOpenCursorStatement(context);
                    break;
                }
                case 251: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileSelectSingleRowStatement(rangeVariables);
                    break;
                }
                case 135: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileInsertStatement(rangeVariables);
                    break;
                }
                case 303: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileUpdateStatement(rangeVariables);
                    break;
                }
                case 79: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileDeleteStatement(rangeVariables);
                    break;
                }
                case 295: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileTruncateStatement();
                    break;
                }
                case 166: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileMergeStatement(rangeVariables);
                    break;
                }
                case 254: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isTrigger()) {
                        if (routine.triggerOperation == 19) {
                            cs = this.compileSetStatement(rangeVariables);
                            break;
                        }
                        if (routine.triggerType != 4) {
                            cs = this.compileSetStatement(rangeVariables);
                            break;
                        }
                        int position = super.getPosition();
                        try {
                            cs = this.compileTriggerSetStatement(routine.triggerTable, rangeVariables);
                        }
                        catch (HsqlException e) {
                            this.rewind(position);
                            cs = this.compileSetStatement(rangeVariables);
                        }
                        break;
                    }
                    cs = this.compileSetStatement(rangeVariables);
                    break;
                }
                case 25: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileCallStatement(rangeVariables, true);
                    Routine proc = ((StatementProcedure)cs).procedure;
                    if (proc == null) break;
                    switch (routine.dataImpact) {
                        case 2: {
                            if (proc.dataImpact == 3) throw Error.error(5602, routine.getDataImpactString());
                            if (proc.dataImpact == 4) {
                                throw Error.error(5602, routine.getDataImpactString());
                            }
                            break block2;
                        }
                        case 3: {
                            if (proc.dataImpact == 4) {
                                throw Error.error(5602, routine.getDataImpactString());
                            }
                            break block2;
                        }
                    }
                    break;
                }
                case 237: {
                    if (routine.isTrigger()) throw this.unexpectedToken();
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    cs = this.compileReturnValue(routine, context);
                    break;
                }
                case 17: {
                    cs = this.compileCompoundStatement(routine, context, label);
                    break;
                }
                case 322: {
                    if (routine.isTrigger()) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileWhile(routine, context, label);
                    break;
                }
                case 234: {
                    cs = this.compileRepeat(routine, context, label);
                    break;
                }
                case 160: {
                    cs = this.compileLoop(routine, context, label);
                    break;
                }
                case 112: {
                    cs = this.compileFor(routine, context, label);
                    break;
                }
                case 143: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileIterate();
                    break;
                }
                case 152: {
                    if (label != null) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileLeave(routine, context);
                    break;
                }
                case 412: {
                    cs = this.compileIf(routine, context);
                    break;
                }
                case 29: {
                    cs = this.compileCase(routine, context);
                    break;
                }
                case 255: {
                    cs = this.compileSignal(routine, context, label);
                    break;
                }
                case 235: {
                    cs = this.compileResignal(routine, context, label);
                    break;
                }
                default: {
                    Statement statement2 = null;
                    Object var10_12 = null;
                    this.session.setCurrentSchemaHsqlName(oldSchema);
                    return statement2;
                }
            }
            cs.setRoot(routine);
            cs.setParent(context);
            statement = cs;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.session.setCurrentSchemaHsqlName(oldSchema);
            throw throwable;
        }
        Object var10_13 = null;
        this.session.setCurrentSchemaHsqlName(oldSchema);
        return statement;
    }

    private Statement compileReturnValue(Routine routine, StatementCompound context) {
        Expression e = this.XreadValueExpressionOrNull();
        if (e == null) {
            this.checkIsValue();
            if (this.token.tokenValue == null) {
                e = new ExpressionValue(null, null);
            }
        }
        this.resolveOuterReferencesAndTypes(routine, context, e);
        if (routine.isProcedure()) {
            throw Error.error(5602);
        }
        return new StatementExpression(this.session, this.compileContext, 58, e);
    }

    private Statement compileIterate() {
        this.readThis(143);
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(102, label);
    }

    private Statement compileLeave(Routine routine, StatementCompound context) {
        this.readThis(152);
        HsqlNameManager.HsqlName label = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(89, label);
    }

    private Statement compileWhile(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(322);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1201, e);
        this.readThis(86);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(94);
        this.readThis(322);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(97, label);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    private Statement compileRepeat(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(234);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(302);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1201, e);
        this.readThis(94);
        this.readThis(234);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(95, label);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    private Statement compileLoop(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(160);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(94);
        this.readThis(160);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound result = new StatementCompound(90, label);
        result.setStatements(statements);
        return result;
    }

    private Statement compileFor(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        RangeVariable[] rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        this.readThis(112);
        StatementQuery cursorStatement = this.compileCursorSpecification(0, false, rangeVariables);
        this.readThis(86);
        StatementCompound forStatement = new StatementCompound(46, label);
        forStatement.setAtomic(true);
        forStatement.setRoot(routine);
        forStatement.setParent(context);
        forStatement.setLoopStatement(cursorStatement);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, forStatement);
        this.readThis(94);
        this.readThis(112);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        forStatement.setStatements(statements);
        return forStatement;
    }

    private Statement compileIf(Routine routine, StatementCompound context) {
        int i;
        HsqlArrayList list = new HsqlArrayList();
        this.readThis(412);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, e);
        list.add(statement);
        this.readThis(280);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        for (i = 0; i < statements.length; ++i) {
            list.add(statements[i]);
        }
        while (this.token.tokenType == 93) {
            this.read();
            e = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, context, e);
            statement = new StatementExpression(this.session, this.compileContext, 1201, e);
            list.add(statement);
            this.readThis(280);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        if (this.token.tokenType == 92) {
            this.read();
            e = Expression.EXPR_TRUE;
            statement = new StatementExpression(this.session, this.compileContext, 1201, e);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(94);
        this.readThis(412);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(88, null);
        result.setStatements(statements);
        return result;
    }

    private Statement compileCase(Routine routine, StatementCompound context) {
        Statement[] statements;
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        this.readThis(29);
        list = this.token.tokenType == 314 ? this.readCaseWhen(routine, context) : this.readSimpleCaseWhen(routine, context);
        if (this.token.tokenType == 92) {
            this.read();
            condition = Expression.EXPR_TRUE;
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, condition);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(94);
        this.readThis(29);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(88, null);
        result.setStatements(statements);
        return result;
    }

    private HsqlArrayList readSimpleCaseWhen(Routine routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        Expression predicand = this.XreadRowValuePredicand();
        do {
            this.readThis(314);
            while (true) {
                Expression newCondition;
                if (predicand == (newCondition = this.XreadPredicateRightPart(predicand))) {
                    newCondition = new ExpressionLogical(predicand, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferencesAndTypes(routine, context, newCondition);
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, condition);
            list.add(statement);
            this.readThis(280);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 314);
        return list;
    }

    private HsqlArrayList readCaseWhen(Routine routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        do {
            this.readThis(314);
            condition = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, context, condition);
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, condition);
            list.add(statement);
            this.readThis(280);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 314);
        return list;
    }

    private Statement compileSignal(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        this.readThis(255);
        this.readThis(263);
        String sqlState = this.parseSQLStateValue();
        StatementSimple cs = new StatementSimple(92, sqlState);
        return cs;
    }

    private Statement compileResignal(Routine routine, StatementCompound context, HsqlNameManager.HsqlName label) {
        String sqlState = null;
        this.readThis(235);
        if (this.readIfThis(263)) {
            sqlState = this.parseSQLStateValue();
        }
        StatementSimple cs = new StatementSimple(91, sqlState);
        return cs;
    }

    private ColumnSchema readRoutineParameter(Routine routine, boolean isParam) {
        HsqlNameManager.HsqlName hsqlName = null;
        byte parameterMode = 1;
        if (isParam) {
            switch (this.token.tokenType) {
                case 130: {
                    this.read();
                    break;
                }
                case 199: {
                    if (routine.getType() != 17) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    parameterMode = 4;
                    break;
                }
                case 133: {
                    if (routine.getType() != 17 && !routine.isAggregate()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    parameterMode = 2;
                    break;
                }
            }
        }
        if (!this.isReservedKey()) {
            hsqlName = this.readNewDependentSchemaObjectName(routine.getName(), 23);
        }
        Type typeObject = this.readTypeDefinition(false, true);
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, true, false, null);
        if (isParam) {
            column.setParameterMode(parameterMode);
        }
        return column;
    }

    void resolveOuterReferencesAndTypes(Routine routine, StatementCompound context, Expression e) {
        RangeVariable[] rangeVars = routine.getParameterRangeVariables();
        if (context != null) {
            rangeVars = context.getRangeVariables();
        }
        this.resolveOuterReferencesAndTypes(rangeVars, e);
    }
}

