/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementInsert;
import org.hsqldb.StatementProcedure;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.types.Type;

public class ParserDML
extends ParserDQL {
    ParserDML(Session session, Scanner t) {
        super(session, t);
    }

    StatementDMQL compileInsertStatement(RangeVariable[] outerRanges) {
        this.read();
        this.readThis(141);
        boolean overridingUser = false;
        boolean overridingSystem = false;
        boolean assignsToIdentity = false;
        RangeVariable range = this.readSimpleRangeVariable(50);
        Table table = range.getTable();
        boolean[] columnCheckList = null;
        int[] columnMap = table.getColumnMap();
        int colCount = table.getColumnCount();
        int position = this.getPosition();
        Table baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        switch (this.token.tokenType) {
            case 78: {
                this.read();
                this.readThis(308);
                Expression insertExpression = new Expression(25, new Expression[0]);
                insertExpression = new Expression(26, new Expression[]{insertExpression});
                columnCheckList = table.getNewColumnCheckList();
                for (int i = 0; i < table.colDefaults.length; ++i) {
                    if (table.colDefaults[i] != null || table.identityColumn == i || table.getColumn(i).isGenerated()) continue;
                    throw Error.error(5544);
                }
                StatementInsert cs = new StatementInsert(this.session, table, columnMap, insertExpression, columnCheckList, this.compileContext);
                return cs;
            }
            case 786: {
                int brackets = this.readOpenBrackets();
                if (brackets == 1) {
                    boolean isQuery = false;
                    switch (this.token.tokenType) {
                        case 251: 
                        case 278: 
                        case 319: {
                            this.rewind(position);
                            isQuery = true;
                            break;
                        }
                    }
                    if (isQuery) break;
                    OrderedHashSet columnNames = new OrderedHashSet();
                    boolean withPrefix = this.database.sqlSyntaxOra;
                    this.readSimpleColumnNames(columnNames, range, withPrefix);
                    this.readThis(772);
                    colCount = columnNames.size();
                    columnMap = table.getColumnIndexes(columnNames);
                    if (this.token.tokenType != 308 && this.token.tokenType != 461) {
                        break;
                    }
                } else {
                    this.rewind(position);
                    break;
                }
            }
            case 461: {
                if (this.token.tokenType == 461) {
                    this.read();
                    if (this.token.tokenType == 305) {
                        this.read();
                        overridingUser = true;
                    } else if (this.token.tokenType == 276) {
                        this.read();
                        overridingSystem = true;
                    } else {
                        this.unexpectedToken();
                    }
                    this.readThis(307);
                    if (this.token.tokenType != 308) break;
                }
            }
            case 308: {
                this.read();
                columnCheckList = table.getColumnCheckList(columnMap);
                Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                HsqlList unresolved = insertExpressions.resolveColumnReferences(this.session, outerRanges, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                insertExpressions.resolveTypes(this.session, null);
                ParserDML.setParameterTypes(insertExpressions, table, columnMap);
                if (table != baseTable) {
                    int[] baseColumnMap = table.getBaseTableColumnMap();
                    int[] newColumnMap = new int[columnMap.length];
                    ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
                    columnMap = newColumnMap;
                }
                Expression[] rowList = insertExpressions.nodes;
                for (int j = 0; j < rowList.length; ++j) {
                    Expression[] rowArgs = rowList[j].nodes;
                    for (int i = 0; i < rowArgs.length; ++i) {
                        Expression e = rowArgs[i];
                        ColumnSchema column = baseTable.getColumn(columnMap[i]);
                        if (column.isIdentity()) {
                            assignsToIdentity = true;
                            if (e.getType() != 4) {
                                if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                                    throw Error.error(5543);
                                }
                                if (overridingUser) {
                                    rowArgs[i] = new ExpressionColumn(4);
                                }
                            }
                        } else if (!column.hasDefault()) {
                            if (column.isGenerated()) {
                                if (e.getType() != 4) {
                                    throw Error.error(5541);
                                }
                            } else if (e.getType() == 4) {
                                throw Error.error(5544);
                            }
                        }
                        if (!e.isUnresolvedParam()) continue;
                        e.setAttributesAsColumn(column, true);
                    }
                }
                if (!assignsToIdentity && (overridingUser || overridingSystem)) {
                    this.unexpectedTokenRequire("OVERRIDING");
                }
                StatementInsert cs = new StatementInsert(this.session, table, columnMap, insertExpressions, columnCheckList, this.compileContext);
                return cs;
            }
            case 251: 
            case 278: 
            case 319: {
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        columnCheckList = table.getColumnCheckList(columnMap);
        if (baseTable != null && table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
        }
        int enforcedDefaultIndex = table.getIdentityColumnIndex();
        int overrideIndex = -1;
        if (enforcedDefaultIndex != -1 && ArrayUtil.find(columnMap, enforcedDefaultIndex) > -1) {
            if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                throw Error.error(5543);
            }
            if (overridingUser) {
                overrideIndex = enforcedDefaultIndex;
            }
        } else if (overridingUser || overridingSystem) {
            this.unexpectedTokenRequire("OVERRIDING");
        }
        Object[] types = new Type[columnMap.length];
        ArrayUtil.projectRow(baseTable.getColumnTypes(), columnMap, types);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, outerRanges, (Type[])types);
        if (colCount != queryExpression.getColumnCount()) {
            throw Error.error(5546);
        }
        StatementInsert cs = new StatementInsert(this.session, table, columnMap, columnCheckList, queryExpression, this.compileContext, overrideIndex);
        return cs;
    }

    private static void setParameterTypes(Expression tableExpression, Table table, int[] columnMap) {
        for (int i = 0; i < tableExpression.nodes.length; ++i) {
            Expression[] list = tableExpression.nodes[i].nodes;
            for (int j = 0; j < list.length; ++j) {
                if (!list[j].isUnresolvedParam()) continue;
                list[j].setAttributesAsColumn(table.getColumn(columnMap[j]), true);
            }
        }
    }

    Statement compileTruncateStatement() {
        boolean isTable = false;
        boolean withCommit = false;
        boolean noCheck = false;
        boolean restartIdentity = false;
        HsqlNameManager.HsqlName objectName = null;
        RangeVariable[] rangeVariables = null;
        Table table = null;
        HsqlNameManager.HsqlName[] writeTableNames = null;
        this.readThis(295);
        if (this.token.tokenType == 278) {
            this.readThis(278);
            rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(1205)};
            table = rangeVariables[0].getTable();
            objectName = table.getName();
            isTable = true;
            switch (this.token.tokenType) {
                case 376: {
                    this.read();
                    this.readThis(128);
                    break;
                }
                case 484: {
                    this.read();
                    this.readThis(128);
                    restartIdentity = true;
                }
            }
        } else {
            this.readThis(497);
            objectName = this.readSchemaName();
            this.checkIsThis(5);
        }
        if (this.readIfThis(5)) {
            this.readThis(44);
            withCommit = true;
            if (this.readIfThis(180)) {
                this.readThis(37);
                noCheck = true;
            }
        }
        writeTableNames = isTable ? new HsqlNameManager.HsqlName[]{table.getName()} : this.session.database.schemaManager.getCatalogAndBaseTableNames();
        if (isTable && !noCheck) {
            for (int i = 0; i < table.fkMainConstraints.length; ++i) {
                if (table.fkMainConstraints[i].getRef() == table) continue;
                String tableName = table.fkMainConstraints[i].getRef().getName().name;
                throw Error.error(8, tableName);
            }
        }
        if (!isTable && !noCheck) {
            OrderedHashSet set = new OrderedHashSet();
            this.session.database.schemaManager.getCascadingSchemaReferences(objectName, set);
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                if (name.type != 5 || name.parent.type != 3) continue;
                Table refTable = this.session.database.schemaManager.getUserTable(this.session, name.parent);
                throw Error.error(8, refTable.getName().name);
            }
        }
        if (withCommit) {
            Object[] args = new Object[]{objectName, restartIdentity};
            return new StatementCommand(1205, args, null, writeTableNames);
        }
        StatementDML cs = new StatementDML(this.session, table, rangeVariables, this.compileContext, restartIdentity, 1205);
        return cs;
    }

    Statement compileDeleteStatement(RangeVariable[] outerRanges) {
        Table baseTable;
        Expression condition = null;
        boolean restartIdentity = false;
        this.readThis(79);
        this.readThis(115);
        RangeVariable[] rangeVariables = null;
        Table table = null;
        rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(19)};
        table = rangeVariables[0].getTable();
        if (table.isTriggerDeletable()) {
            rangeVariables[0].resetViewRageTableAsSubquery();
        }
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            HsqlList unresolved = condition.resolveColumnReferences(this.session, outerRanges, null);
            unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isUnresolvedParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            }
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        Table table2 = baseTable = table.isTriggerDeletable() ? table : table.getBaseTable();
        if (table != baseTable) {
            QuerySpecification baseSelect = ((TableDerived)table).getQueryExpression().getMainSelect();
            RangeVariable[] newRangeVariables = (RangeVariable[])ArrayUtil.duplicateArray(baseSelect.rangeVariables);
            newRangeVariables[0] = baseSelect.rangeVariables[0].duplicate();
            Expression[] newBaseExprColumns = new Expression[baseSelect.indexLimitData];
            for (int i = 0; i < baseSelect.indexLimitData; ++i) {
                Expression e;
                newBaseExprColumns[i] = e = baseSelect.exprColumns[i].duplicate();
                e.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
            }
            Expression baseQueryCondition = baseSelect.queryCondition;
            if (baseQueryCondition != null) {
                baseQueryCondition = baseQueryCondition.duplicate();
                baseQueryCondition.replaceRangeVariables(rangeVariables, newRangeVariables);
            }
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], newBaseExprColumns);
            }
            rangeVariables = newRangeVariables;
            condition = ExpressionLogical.andExpressions(baseQueryCondition, condition);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, null, this.compileContext);
            resolver.processConditions(this.session);
            rangeVariables = resolver.rangeVariables;
        }
        StatementDML cs = new StatementDML(this.session, table, rangeVariables, this.compileContext, restartIdentity, 19);
        return cs;
    }

    StatementDMQL compileUpdateStatement(RangeVariable[] outerRanges) {
        Table baseTable;
        this.read();
        OrderedHashSet targetSet = new OrderedHashSet();
        LongDeque colIndexList = new LongDeque();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(82)};
        Table table = rangeVariables[0].rangeTable;
        Table table2 = baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
        if (table.isTriggerDeletable()) {
            rangeVariables[0].resetViewRageTableAsSubquery();
        }
        this.readThis(254);
        this.readSetClauseList(rangeVariables, targetSet, colIndexList, exprList);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(outerRanges, (Expression)targets[i]);
        }
        boolean[] columnCheckList = table.getColumnCheckList(columnMap);
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        Expression condition = null;
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            HsqlList unresolved = condition.resolveColumnReferences(this.session, outerRanges, null);
            unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isUnresolvedParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            }
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        this.resolveUpdateExpressions(table, rangeVariables, columnMap, updateExpressions, outerRanges);
        if (table != baseTable) {
            QuerySpecification baseSelect = ((TableDerived)table).getQueryExpression().getMainSelect();
            RangeVariable[] newRangeVariables = (RangeVariable[])ArrayUtil.duplicateArray(baseSelect.rangeVariables);
            newRangeVariables[0] = baseSelect.rangeVariables[0].duplicate();
            Expression[] newBaseExprColumns = new Expression[baseSelect.indexLimitData];
            for (int i = 0; i < baseSelect.indexLimitData; ++i) {
                Expression e;
                newBaseExprColumns[i] = e = baseSelect.exprColumns[i].duplicate();
                e.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
            }
            Expression baseQueryCondition = baseSelect.queryCondition;
            if (baseQueryCondition != null) {
                baseQueryCondition = baseQueryCondition.duplicate();
                baseQueryCondition.replaceRangeVariables(rangeVariables, newRangeVariables);
            }
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], newBaseExprColumns);
            }
            for (int i = 0; i < updateExpressions.length; ++i) {
                updateExpressions[i] = updateExpressions[i].replaceColumnReferences(rangeVariables[0], newBaseExprColumns);
            }
            rangeVariables = newRangeVariables;
            condition = ExpressionLogical.andExpressions(baseQueryCondition, condition);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, null, this.compileContext);
            resolver.processConditions(this.session);
            rangeVariables = resolver.rangeVariables;
        }
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
            for (int i = 0; i < columnMap.length; ++i) {
                if (!baseTable.colGenerated[columnMap[i]]) continue;
                throw Error.error(5513);
            }
        }
        StatementDML cs = new StatementDML(this.session, (Expression[])targets, table, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext);
        return cs;
    }

    void resolveUpdateExpressions(Table targetTable, RangeVariable[] rangeVariables, int[] columnMap, Expression[] colExpressions, RangeVariable[] outerRanges) {
        HsqlList unresolved = null;
        int enforcedDefaultIndex = -1;
        if (targetTable.hasIdentityColumn() && targetTable.identitySequence.isAlways()) {
            enforcedDefaultIndex = targetTable.getIdentityColumnIndex();
        }
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            Expression e;
            int j;
            Expression expr = colExpressions[ix];
            if (targetTable.colGenerated[columnMap[i]]) {
                throw Error.error(5513);
            }
            if (expr.getType() == 25) {
                Expression[] elements = expr.nodes;
                j = 0;
                while (j < elements.length) {
                    e = elements[j];
                    if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                        throw Error.error(5541);
                    }
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                    } else if (e.getType() == 4) {
                        if (targetTable.colDefaults[columnMap[i]] == null && targetTable.identityColumn != columnMap[i]) {
                            throw Error.error(5544);
                        }
                    } else {
                        unresolved = expr.resolveColumnReferences(this.session, outerRanges, null);
                        unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
                        ExpressionColumn.checkColumnsResolved(unresolved);
                        unresolved = null;
                        e.resolveTypes(this.session, null);
                    }
                    ++j;
                    ++i;
                }
            } else if (expr.getType() == 22) {
                unresolved = expr.resolveColumnReferences(this.session, outerRanges, null);
                unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                expr.resolveTypes(this.session, null);
                int count = expr.subQuery.queryExpression.getColumnCount();
                j = 0;
                while (j < count) {
                    if (enforcedDefaultIndex == columnMap[i]) {
                        throw Error.error(5541);
                    }
                    ++j;
                    ++i;
                }
            } else {
                e = expr;
                if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                    throw Error.error(5541);
                }
                if (e.isUnresolvedParam()) {
                    e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                } else if (e.getType() == 4) {
                    if (targetTable.colDefaults[columnMap[i]] == null && targetTable.identityColumn != columnMap[i]) {
                        throw Error.error(5544);
                    }
                } else {
                    unresolved = expr.resolveColumnReferences(this.session, outerRanges, null);
                    unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
                    ExpressionColumn.checkColumnsResolved(unresolved);
                    e.resolveTypes(this.session, null);
                }
                ++i;
            }
            ++ix;
        }
    }

    void readSetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression e;
            int degree;
            if (this.token.tokenType == 786) {
                this.read();
                int oldCount = targets.size();
                this.readTargetSpecificationList(targets, rangeVars, colIndexList);
                degree = targets.size() - oldCount;
                this.readThis(772);
            } else {
                Expression target = this.XreadTargetSpecification(rangeVars, colIndexList);
                if (!targets.add(target)) {
                    ColumnSchema col = target.getColumn();
                    throw Error.error(5579, col.getName().name);
                }
                degree = 1;
            }
            this.readThis(396);
            int position = this.getPosition();
            int brackets = this.readOpenBrackets();
            if (this.token.tokenType == 251) {
                this.rewind(position);
                SubQuery sq = this.XreadSubqueryBody(22);
                if (degree != sq.queryExpression.getColumnCount()) {
                    throw Error.error(5546);
                }
                Expression e2 = new Expression(22, sq);
                expressions.add(e2);
                if (this.token.tokenType != 774) break;
                this.read();
                continue;
            }
            if (brackets > 0) {
                this.rewind(position);
            }
            if (degree > 1) {
                int rowDegree;
                this.readThis(786);
                e = this.readRow();
                this.readThis(772);
                int n = rowDegree = e.getType() == 25 ? e.nodes.length : 1;
                if (degree != rowDegree) {
                    throw Error.error(5546);
                }
                expressions.add(e);
            } else {
                e = this.XreadValueExpressionWithContext();
                expressions.add(e);
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
    }

    void readGetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression target;
            if (!targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList))) {
                ColumnSchema col = target.getColumn();
                throw Error.error(5579, col.getName().name);
            }
            this.readThis(396);
            switch (this.token.tokenType) {
                case 443: 
                case 495: {
                    int columnIndex = ExpressionColumn.diagnosticsList.getIndex(this.token.tokenString);
                    ExpressionColumn e = new ExpressionColumn(10, columnIndex);
                    expressions.add(e);
                    this.read();
                }
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
    }

    StatementDMQL compileMergeStatement(RangeVariable[] outerRanges) {
        int[] insertColumnMap = null;
        int[] updateColumnMap = null;
        Object[] targets = null;
        HsqlArrayList updateList = new HsqlArrayList();
        Expression[] updateExpressions = Expression.emptyArray;
        HsqlArrayList insertList = new HsqlArrayList();
        Expression insertExpression = null;
        this.read();
        this.readThis(141);
        RangeVariable targetRange = this.readSimpleRangeVariable(128);
        Table table = targetRange.rangeTable;
        this.readThis(306);
        RangeVariable sourceRange = this.readTableOrSubquery(outerRanges);
        this.readThis(194);
        Expression mergeCondition = this.XreadBooleanValueExpression();
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        RangeVariable[] fullRangeVars = new RangeVariable[]{sourceRange, targetRange};
        RangeVariable[] sourceRangeVars = new RangeVariable[]{sourceRange};
        RangeVariable[] targetRangeVars = new RangeVariable[]{targetRange};
        insertColumnMap = table.getColumnMap();
        boolean[] insertColumnCheckList = table.getNewColumnCheckList();
        OrderedHashSet updateTargetSet = new OrderedHashSet();
        OrderedHashSet insertColNames = new OrderedHashSet();
        LongDeque updateColIndexList = new LongDeque();
        this.readMergeWhen(updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange);
        if (insertList.size() > 0) {
            int colCount = insertColNames.size();
            if (colCount != 0) {
                insertColumnMap = table.getColumnIndexes(insertColNames);
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
            }
            insertExpression = (Expression)insertList.get(0);
            ParserDML.setParameterTypes(insertExpression, table, insertColumnMap);
        }
        if (updateList.size() > 0) {
            targets = new Expression[updateTargetSet.size()];
            updateTargetSet.toArray(targets);
            for (int i = 0; i < targets.length; ++i) {
                this.resolveOuterReferencesAndTypes(outerRanges, (Expression)targets[i]);
            }
            updateExpressions = new Expression[updateList.size()];
            updateList.toArray(updateExpressions);
            updateColumnMap = new int[updateColIndexList.size()];
            updateColIndexList.toArray(updateColumnMap);
        }
        if (updateExpressions.length != 0) {
            Table baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
            int[] baseUpdateColumnMap = updateColumnMap;
            if (table != baseTable) {
                baseUpdateColumnMap = new int[updateColumnMap.length];
                ArrayUtil.projectRow(table.getBaseTableColumnMap(), updateColumnMap, baseUpdateColumnMap);
            }
            this.resolveUpdateExpressions(table, fullRangeVars, updateColumnMap, updateExpressions, outerRanges);
        }
        HsqlList unresolved = null;
        unresolved = mergeCondition.resolveColumnReferences(this.session, fullRangeVars, null);
        unresolved = Expression.resolveColumnSet(this.session, outerRanges, outerRanges.length, unresolved, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        mergeCondition.resolveTypes(this.session, null);
        if (mergeCondition.isUnresolvedParam()) {
            mergeCondition.dataType = Type.SQL_BOOLEAN;
        }
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        fullRangeVars[1].addJoinCondition(mergeCondition);
        fullRangeVars[0].setJoinType(true, false);
        RangeVariableResolver resolver = new RangeVariableResolver(fullRangeVars, null, this.compileContext);
        resolver.processConditions(this.session);
        fullRangeVars = resolver.rangeVariables;
        if (insertExpression != null) {
            unresolved = insertExpression.resolveColumnReferences(this.session, sourceRangeVars, null);
            unresolved = Expression.resolveColumnSet(this.session, outerRanges, outerRanges.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            insertExpression.resolveTypes(this.session, null);
        }
        StatementDML cs = new StatementDML(this.session, (Expression[])targets, fullRangeVars, insertColumnMap, updateColumnMap, insertColumnCheckList, mergeCondition, insertExpression, updateExpressions, this.compileContext);
        return cs;
    }

    private void readMergeWhen(LongDeque updateColIndexList, OrderedHashSet insertColumnNames, OrderedHashSet updateTargetSet, HsqlArrayList insertExpressions, HsqlArrayList updateExpressions, RangeVariable[] targetRangeVars, RangeVariable sourceRangeVar) {
        Table table = targetRangeVars[0].rangeTable;
        int columnCount = table.getColumnCount();
        this.readThis(314);
        if (this.token.tokenType == 437) {
            if (updateExpressions.size() != 0) {
                throw Error.error(5547);
            }
            this.read();
            this.readThis(280);
            this.readThis(303);
            this.readThis(254);
            this.readSetClauseList(targetRangeVars, updateTargetSet, updateColIndexList, updateExpressions);
        } else if (this.token.tokenType == 183) {
            if (insertExpressions.size() != 0) {
                throw Error.error(5548);
            }
            this.read();
            this.readThis(437);
            this.readThis(280);
            this.readThis(135);
            int brackets = this.readOpenBrackets();
            if (brackets == 1) {
                boolean withPrefix = this.database.sqlSyntaxOra;
                this.readSimpleColumnNames(insertColumnNames, targetRangeVars[0], withPrefix);
                columnCount = insertColumnNames.size();
                this.readThis(772);
                brackets = 0;
            }
            this.readThis(308);
            Expression e = this.XreadContextuallyTypedTable(columnCount);
            if (e.nodes.length != 1) {
                throw Error.error(3201);
            }
            insertExpressions.add(e);
        } else {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 314) {
            this.readMergeWhen(updateColIndexList, insertColumnNames, updateTargetSet, insertExpressions, updateExpressions, targetRangeVars, sourceRangeVar);
        }
    }

    StatementDMQL compileCallStatement(RangeVariable[] outerRanges, boolean isStrictlyProcedure) {
        this.read();
        if (this.isIdentifier()) {
            this.checkValidCatalogName(this.token.namePrePrefix);
            RoutineSchema routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.token.tokenString, this.session.getSchemaName(this.token.namePrefix), 17);
            if (routineSchema != null) {
                int i;
                this.read();
                HsqlArrayList list = new HsqlArrayList();
                this.readThis(786);
                if (this.token.tokenType == 772) {
                    this.read();
                } else {
                    while (true) {
                        Expression e = this.XreadValueExpression();
                        list.add(e);
                        if (this.token.tokenType != 774) break;
                        this.read();
                    }
                    this.readThis(772);
                }
                Expression[] arguments = new Expression[list.size()];
                list.toArray(arguments);
                Routine routine = routineSchema.getSpecificRoutine(arguments.length);
                this.compileContext.addProcedureCall(routine);
                HsqlList unresolved = null;
                for (i = 0; i < arguments.length; ++i) {
                    Expression e = arguments[i];
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(routine.getParameter(i), routine.getParameter(i).isWriteable());
                        continue;
                    }
                    byte paramMode = routine.getParameter(i).getParameterMode();
                    unresolved = arguments[i].resolveColumnReferences(this.session, outerRanges, unresolved);
                    if (paramMode == 1 || e.getType() == 6) continue;
                    throw Error.error(5603);
                }
                ExpressionColumn.checkColumnsResolved(unresolved);
                for (i = 0; i < arguments.length; ++i) {
                    arguments[i].resolveTypes(this.session, null);
                    if (routine.getParameter(i).getDataType().canBeAssignedFrom(arguments[i].getDataType())) continue;
                    throw Error.error(5561);
                }
                StatementProcedure cs = new StatementProcedure(this.session, routine, arguments, this.compileContext);
                return cs;
            }
        }
        if (isStrictlyProcedure) {
            throw Error.error(5501, this.token.tokenString);
        }
        Expression expression = this.XreadValueExpression();
        HsqlList unresolved = expression.resolveColumnReferences(this.session, outerRanges, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        expression.resolveTypes(this.session, null);
        StatementProcedure cs = new StatementProcedure(this.session, expression, this.compileContext);
        return cs;
    }

    void resolveOuterReferencesAndTypes(RangeVariable[] rangeVars, Expression e) {
        HsqlList unresolved = e.resolveColumnReferences(this.session, rangeVars, rangeVars.length, null, false);
        unresolved = Expression.resolveColumnSet(this.session, rangeVars, rangeVars.length, unresolved, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
    }
}

