/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{55, 121};
    static final short[] startStatementTokens = new short[]{55, 121, 4, 88};
    static final short[] startStatementTokensSchema = new short[]{55, 121};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    void reset(String sql) {
        super.reset(sql);
    }

    StatementSchema compileCreate() {
        int tableType = 4;
        boolean isTable = false;
        this.read();
        switch (this.token.tokenType) {
            case 120: {
                this.read();
                this.readThis(523);
                this.readIfThis(605);
                this.readThis(278);
                isTable = true;
                tableType = 3;
                break;
            }
            case 627: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 3;
                break;
            }
            case 523: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 3;
                break;
            }
            case 605: {
                this.read();
                this.readThis(278);
                isTable = true;
                break;
            }
            case 570: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 5;
                break;
            }
            case 628: {
                this.read();
                this.readThis(278);
                isTable = true;
                tableType = 7;
                break;
            }
            case 278: {
                this.read();
                isTable = true;
                tableType = this.database.schemaManager.getDefaultTableType();
                break;
            }
        }
        if (isTable) {
            return this.compileCreateTable(tableType);
        }
        switch (this.token.tokenType) {
            case 558: {
                return this.compileCreateAlias();
            }
            case 505: {
                return this.compileCreateSequence();
            }
            case 497: {
                return this.compileCreateSchema();
            }
            case 291: {
                return this.compileCreateTrigger();
            }
            case 305: {
                return this.compileCreateUser();
            }
            case 490: {
                return this.compileCreateRole();
            }
            case 545: {
                return this.compileCreateView(false);
            }
            case 393: {
                return this.compileCreateDomain();
            }
            case 535: {
                return this.compileCreateType();
            }
            case 35: {
                return this.compileCreateCharacterSet();
            }
            case 358: {
                return this.compileCreateCollation();
            }
            case 299: {
                this.read();
                this.checkIsThis(595);
                return this.compileCreateIndex(true);
            }
            case 595: {
                return this.compileCreateIndex(false);
            }
            case 117: 
            case 215: 
            case 559: {
                return this.compileCreateProcedureOrFunction();
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 595: {
                this.read();
                HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(20, true);
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                if (this.token.tokenType == 619) {
                    this.read();
                    this.readThis(285);
                    return this.compileRenameObject(name, 20);
                }
                this.readThis(10);
                Index index = (Index)this.database.schemaManager.getSchemaObject(name);
                if (index == null) {
                    throw Error.error(5501);
                }
                Table table = (Table)this.database.schemaManager.getSchemaObject(index.getName().parent);
                int[] indexColumns = this.readColumnList(table, true);
                String sql = this.getLastPart();
                Object[] args = new Object[]{table, indexColumns, index.getName()};
                return new StatementSchema(sql, 1069, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 497: {
                this.read();
                HsqlNameManager.HsqlName name = this.readSchemaName();
                this.readThis(619);
                this.readThis(285);
                return this.compileRenameObject(name, 2);
            }
            case 348: {
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.checkValidCatalogName(name);
                this.read();
                this.readThis(619);
                this.readThis(285);
                return this.compileRenameObject(this.database.getCatalogName(), 1);
            }
            case 505: {
                return this.compileAlterSequence();
            }
            case 278: {
                return this.compileAlterTable();
            }
            case 305: {
                return this.compileAlterUser();
            }
            case 393: {
                return this.compileAlterDomain();
            }
            case 545: {
                return this.compileCreateView(true);
            }
            case 508: {
                return this.compileAlterSession();
            }
            case 259: {
                return this.compileAlterSpecificRoutine();
            }
            case 491: {
                return this.compileAlterRoutine();
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterRoutine() {
        this.readThis(491);
        RoutineSchema routine = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(619);
        this.readThis(285);
        return this.compileRenameObject(routine.getName(), routine.getName().type);
    }

    Statement compileDrop() {
        int objectType;
        int statementType;
        boolean canCascade = false;
        boolean cascade = false;
        boolean useIfExists = false;
        boolean ifExists = false;
        this.read();
        int objectTokenType = this.token.tokenType;
        switch (objectTokenType) {
            case 595: {
                this.read();
                statementType = 1077;
                objectType = 20;
                useIfExists = true;
                break;
            }
            case 339: {
                this.read();
                statementType = 24;
                objectType = 6;
                canCascade = true;
                break;
            }
            case 259: {
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                statementType = 30;
                objectType = 24;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 215: {
                this.read();
                statementType = 30;
                objectType = 17;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 117: {
                this.read();
                statementType = 30;
                objectType = 16;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 497: {
                this.read();
                statementType = 31;
                objectType = 2;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 505: {
                this.read();
                statementType = 135;
                objectType = 7;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 291: {
                this.read();
                statementType = 34;
                objectType = 8;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 305: {
                this.read();
                statementType = 1079;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 490: {
                this.read();
                statementType = 29;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 393: {
                this.read();
                statementType = 27;
                objectType = 13;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 535: {
                this.read();
                statementType = 35;
                objectType = 12;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 35: {
                this.read();
                this.readThis(254);
                statementType = 25;
                objectType = 14;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 358: {
                this.read();
                statementType = 26;
                objectType = 15;
                canCascade = false;
                useIfExists = true;
                break;
            }
            case 545: {
                this.read();
                statementType = 36;
                objectType = 4;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 278: {
                this.read();
                statementType = 32;
                objectType = 3;
                canCascade = true;
                useIfExists = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (useIfExists && this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 101) {
                this.read();
                ifExists = true;
            } else {
                this.rewind(position);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName name = null;
        switch (objectTokenType) {
            case 305: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                User grantee = this.database.getUserManager().get(this.token.tokenString);
                name = grantee.getName();
                this.read();
                break;
            }
            case 490: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                Grantee role = this.database.getGranteeManager().getRole(this.token.tokenString);
                name = role.getName();
                this.read();
                break;
            }
            case 497: {
                name = this.readNewSchemaName();
                break;
            }
            case 278: {
                boolean isModule = this.token.namePrePrefix == null && ("MODULE".equals(this.token.namePrefix) || "SESSION".equals(this.token.namePrefix));
                name = this.readNewSchemaObjectName(objectType, false);
                if (!isModule) break;
                Object[] args = new Object[]{name, ifExists};
                return new StatementSession(32, args);
            }
            default: {
                name = this.readNewSchemaObjectName(objectType, false);
            }
        }
        if (!ifExists && useIfExists && this.token.tokenType == 412) {
            this.read();
            this.readThis(101);
            ifExists = true;
        }
        if (canCascade) {
            if (this.token.tokenType == 347) {
                cascade = true;
                this.read();
            } else if (this.token.tokenType == 485) {
                this.read();
            }
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, new Integer(objectType), cascade, ifExists};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames();
        StatementSchema cs = new StatementSchema(sql, statementType, args, null, writeLockNames);
        return cs;
    }

    Statement compileAlterTable() {
        this.read();
        String tableName = this.token.tokenString;
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Table t = this.database.schemaManager.getUserTable(this.session, tableName, schema.name);
        this.read();
        switch (this.token.tokenType) {
            case 619: {
                this.read();
                this.readThis(285);
                return this.compileRenameObject(t.getName(), 3);
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName cname = null;
                if (this.token.tokenType == 48) {
                    this.read();
                    cname = this.readNewDependentSchemaObjectName(t.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 113: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddForeignKeyConstraint(t, cname);
                    }
                    case 299: {
                        this.read();
                        return this.compileAlterTableAddUniqueConstraint(t, cname);
                    }
                    case 37: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(t, cname);
                    }
                    case 214: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddPrimaryKey(t, cname);
                    }
                    case 43: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(t);
                    }
                }
                if (cname != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(t);
            }
            case 88: {
                this.read();
                switch (this.token.tokenType) {
                    case 214: {
                        boolean cascade = false;
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableDropPrimaryKey(t);
                    }
                    case 48: {
                        this.read();
                        return this.compileAlterTableDropConstraint(t);
                    }
                    case 43: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                boolean cascade = false;
                this.read();
                if (this.token.tokenType == 485) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    cascade = true;
                }
                return this.compileAlterTableDropColumn(t, name, cascade);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 43) {
                    this.read();
                }
                int columnIndex = t.getColumnIndex(this.token.tokenString);
                ColumnSchema column = t.getColumn(columnIndex);
                this.read();
                return this.compileAlterColumn(t, column, columnIndex);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table t) {
        boolean cascade = false;
        SchemaObject object = this.readSchemaObjectName(t.getSchemaName(), 5);
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            cascade = true;
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{object.getName(), ValuePool.getInt(5), cascade, false};
        HsqlNameManager.HsqlName mainName = ((Constraint)object).getMainTableName();
        HsqlNameManager.HsqlName[] writeLockNames = mainName == null ? new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), t.getName()} : new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), t.getName(), mainName};
        StatementSchema cs = new StatementSchema(sql, 1078, args, null, writeLockNames);
        return cs;
    }

    private Statement compileAlterTableDropPrimaryKey(Table t) {
        boolean cascade = false;
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            cascade = true;
        }
        if (!t.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String sql = this.getLastPart();
        Constraint object = t.getPrimaryConstraint();
        Object[] args = new Object[]{object.getName(), ValuePool.getInt(5), cascade, false};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames();
        StatementSchema cs = new StatementSchema(sql, 1078, args, null, writeLockNames);
        return cs;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        int position = super.getPosition();
        try {
            this.readThis(77);
            this.readThis(157);
            this.readThis(523);
            this.readThis(278);
        }
        catch (HsqlException e) {
            this.lastError = e;
            this.rewind(position);
            return null;
        }
        if (this.token.namePrePrefix != null || this.token.namePrefix != null && !"MODULE".equals(this.token.namePrefix) && !"SESSION".equals(this.token.namePrefix)) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        name.schema = SqlInvariants.MODULE_HSQLNAME;
        Table table = TableUtil.newTable(this.database, 3, name);
        StatementSchema cs = this.compileCreateTableBody(table, false);
        HsqlArrayList constraints = (HsqlArrayList)cs.arguments[1];
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.get(i);
            if (c.getConstraintType() != 0) continue;
            throw this.unexpectedToken("FOREIGN");
        }
        StatementSession ss = new StatementSession(1068, cs.arguments);
        return ss;
    }

    StatementSchema compileCreateTable(int type) {
        boolean ifNot = false;
        if (this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThis(101);
                ifNot = true;
            } else {
                this.rewind(position);
            }
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Table table = TableUtil.newTable(this.database, type, name);
        return this.compileCreateTableBody(table, ifNot);
    }

    StatementSchema compileCreateTableBody(Table table, boolean ifNot) {
        HsqlArrayList tempConstraints = new HsqlArrayList();
        if (this.token.tokenType == 10) {
            return this.readTableAsSubqueryDefinition(table);
        }
        int position = this.getPosition();
        this.readThis(786);
        Constraint c = new Constraint(null, null, 5);
        tempConstraints.add(c);
        boolean start = true;
        boolean startPart = true;
        boolean end = false;
        block6: while (!end) {
            switch (this.token.tokenType) {
                case 154: {
                    ColumnSchema[] likeColumns = this.readLikeTable(table);
                    for (int i = 0; i < likeColumns.length; ++i) {
                        table.addColumn(likeColumns[i]);
                    }
                    start = false;
                    startPart = false;
                    continue block6;
                }
                case 37: 
                case 48: 
                case 113: 
                case 214: 
                case 299: {
                    if (!startPart) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, tempConstraints);
                    start = false;
                    startPart = false;
                    continue block6;
                }
                case 774: {
                    if (startPart) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    startPart = true;
                    continue block6;
                }
                case 772: {
                    this.read();
                    end = true;
                    continue block6;
                }
            }
            if (!startPart) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema newcolumn = this.readColumnDefinitionOrNull(table, hsqlName, tempConstraints);
            if (newcolumn == null) {
                if (start) {
                    this.rewind(position);
                    return this.readTableAsSubqueryDefinition(table);
                }
                throw Error.error(5000);
            }
            table.addColumn(newcolumn);
            start = false;
            startPart = false;
        }
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, tempConstraints, null, ifNot};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames();
        return new StatementSchema(sql, 77, args, null, writeLockNames);
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean generated = false;
        boolean identity = false;
        boolean defaults = false;
        Table likeTable = this.readTableName();
        OrderedIntHashSet set = new OrderedIntHashSet();
        while (true) {
            boolean including;
            boolean bl = including = this.token.tokenType == 416;
            if (!including && this.token.tokenType != 399) break;
            this.read();
            switch (this.token.tokenType) {
                case 407: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    generated = including;
                    break;
                }
                case 128: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    identity = including;
                    break;
                }
                case 381: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    defaults = including;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnList = new ColumnSchema[likeTable.getColumnCount()];
        for (int i = 0; i < columnList.length; ++i) {
            ColumnSchema column = likeTable.getColumn(i).duplicate();
            HsqlNameManager.HsqlName name = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), column.getName());
            column.setName(name);
            column.setNullable(true);
            column.setPrimaryKey(false);
            if (identity) {
                if (column.isIdentity()) {
                    column.setIdentity(column.getIdentitySequence().duplicate());
                }
            } else {
                column.setIdentity(null);
            }
            if (!defaults) {
                column.setDefaultExpression(null);
            }
            if (!generated) {
                column.setGeneratingExpression(null);
            }
            columnList[i] = column;
        }
        return columnList;
    }

    StatementSchema readTableAsSubqueryDefinition(Table table) {
        HsqlNameManager.HsqlName[] readName = null;
        boolean withData = true;
        HsqlNameManager.HsqlName[] columnNames = null;
        StatementQuery statement = null;
        if (this.token.tokenType == 786) {
            columnNames = this.readColumnNames(table.getName());
        }
        this.readThis(10);
        this.readThis(786);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(772);
        this.readThis(319);
        if (this.token.tokenType == 180) {
            this.read();
            withData = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(378);
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
        if (columnNames == null) {
            columnNames = queryExpression.getResultColumnNames();
        } else if (columnNames.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, columnNames, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (withData) {
            statement = new StatementQuery(this.session, queryExpression, this.compileContext);
            readName = statement.getTableNamesForRead();
        }
        Object[] args = new Object[]{table, new HsqlArrayList(), statement, Boolean.FALSE};
        String sql = this.getLastPart();
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        StatementSchema st = new StatementSchema(sql, 77, args, readName, writeTableNames);
        return st;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList tempConstraints, HsqlArrayList constraintList, boolean addToSchema) {
        Constraint c = (Constraint)tempConstraints.get(0);
        String namePart = c.getName() == null ? null : c.getName().name;
        HsqlNameManager.HsqlName indexName = session.database.nameManager.newAutoName("IDX", namePart, table.getSchemaName(), table.getName(), 20);
        c.setColumnsIndexes(table);
        table.createPrimaryKey(indexName, c.core.mainCols, true);
        if (c.core.mainCols != null) {
            Constraint newconstraint = new Constraint(c.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(newconstraint);
            if (addToSchema) {
                session.database.schemaManager.addSchemaObject(newconstraint);
            }
        }
        block7: for (int i = 1; i < tempConstraints.size(); ++i) {
            c = (Constraint)tempConstraints.get(i);
            switch (c.constType) {
                case 2: {
                    c.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(c.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    indexName = session.database.nameManager.newAutoName("IDX", c.getName().name, table.getSchemaName(), table.getName(), 20);
                    Index index = table.createAndAddIndexStructure(session, indexName, c.core.mainCols, null, null, true, true, false);
                    Constraint newconstraint = new Constraint(c.getName(), table, index, 2);
                    table.addConstraint(newconstraint);
                    if (!addToSchema) continue block7;
                    session.database.schemaManager.addSchemaObject(newconstraint);
                    continue block7;
                }
                case 0: {
                    ParserDDL.addForeignKey(session, table, c, constraintList);
                    continue block7;
                }
                case 3: {
                    try {
                        c.prepareCheckConstraint(session, table, false);
                    }
                    catch (HsqlException e) {
                        if (session.isProcessingScript()) continue block7;
                        throw e;
                    }
                    table.addConstraint(c);
                    if (c.isNotNull()) {
                        ColumnSchema column = table.getColumn(c.notNullColumnIndex);
                        column.setNullable(false);
                        table.setColumnTypeVars(c.notNullColumnIndex);
                    }
                    if (!addToSchema) continue block7;
                    session.database.schemaManager.addSchemaObject(c);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint c, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        if (mainTableName == table.getName()) {
            c.core.mainTable = table;
        } else {
            Table mainTable = session.database.schemaManager.findUserTable(session, mainTableName.name, mainTableName.schema.name);
            if (mainTable == null) {
                if (constraintList == null) {
                    throw Error.error(5501, mainTableName.name);
                }
                constraintList.add(c);
                return;
            }
            c.core.mainTable = mainTable;
        }
        c.setColumnsIndexes(table);
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.checkCreateForeignKey(c);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        if (uniqueConstraint == null) {
            throw Error.error(5523);
        }
        Index mainIndex = uniqueConstraint.getMainIndex();
        boolean isForward = c.core.mainTable.getSchemaName() != table.getSchemaName();
        int offset = session.database.schemaManager.getTableIndex(table);
        if (offset != -1 && offset < session.database.schemaManager.getTableIndex(c.core.mainTable)) {
            isForward = true;
        }
        HsqlNameManager.HsqlName refIndexName = session.database.nameManager.newAutoName("IDX", table.getSchemaName(), table.getName(), 20);
        Index index = table.createAndAddIndexStructure(session, refIndexName, c.core.refCols, null, null, false, true, isForward);
        HsqlNameManager.HsqlName mainName = session.database.nameManager.newAutoName("REF", c.getName().name, table.getSchemaName(), table.getName(), 20);
        c.core.uniqueName = uniqueConstraint.getName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = table;
        c.core.refName = c.getName();
        c.core.refIndex = index;
        c.isForward = isForward;
        table.addConstraint(c);
        c.core.mainTable.addConstraint(new Constraint(mainName, c));
        session.database.schemaManager.addSchemaObject(c);
    }

    private Constraint readFKReferences(Table refTable, HsqlNameManager.HsqlName constraintName, OrderedHashSet refColSet) {
        HsqlNameManager.HsqlName mainTableName;
        OrderedHashSet mainColSet = null;
        this.readThis(222);
        HsqlNameManager.HsqlName schema = this.token.namePrefix == null ? refTable.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (refTable.getSchemaName() == schema && refTable.getName().name.equals(this.token.tokenString)) {
            mainTableName = refTable.getName();
            this.read();
        } else {
            mainTableName = this.readFKTableName(schema);
        }
        if (this.token.tokenType == 786) {
            mainColSet = this.readColumnNames(false);
        }
        int matchType = 59;
        if (this.token.tokenType == 162) {
            this.read();
            switch (this.token.tokenType) {
                case 511: {
                    this.read();
                    break;
                }
                case 470: {
                    throw super.unsupportedFeature();
                }
                case 116: {
                    this.read();
                    matchType = 61;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int deleteAction = 3;
        int updateAction = 3;
        OrderedIntHashSet set = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 194) {
            this.read();
            if (!set.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 79) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            deleteAction = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            deleteAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    deleteAction = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            if (this.token.tokenType == 303) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            updateAction = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            updateAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    updateAction = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (constraintName == null) {
            constraintName = this.database.nameManager.newAutoName("FK", refTable.getSchemaName(), refTable.getName(), 5);
        }
        return new Constraint(constraintName, refTable.getName(), refColSet, mainTableName, mainColSet, 0, deleteAction, updateAction, matchType);
    }

    private HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName schema) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.session, this.token.tokenString, schema.name);
        HsqlNameManager.HsqlName name = table == null ? this.database.nameManager.newHsqlName(schema, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return name;
    }

    StatementSchema compileCreateView(boolean alter) {
        QueryExpression queryExpression;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(4, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(name.schema);
        HsqlNameManager.HsqlName[] colList = null;
        if (this.token.tokenType == 786) {
            try {
                colList = this.readColumnNames(name);
            }
            catch (HsqlException e) {
                if (this.session.isProcessingScript() && this.database.getProperties().isVersion18()) {
                    while (this.token.tokenType != 10) {
                        this.read();
                    }
                }
                throw e;
            }
        }
        this.readThis(10);
        this.startRecording();
        int position = this.getPosition();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        Token[] tokenisedStatement = this.getRecordedStatement();
        int check = 0;
        if (this.token.tokenType == 319) {
            this.read();
            check = 2;
            if (this.readIfThis(157)) {
                check = 1;
            } else {
                this.readIfThis(28);
            }
            this.readThis(37);
            this.readThis(455);
        }
        View view = new View(this.database, name, colList, check);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        view.setStatement(Token.getSQL(tokenisedStatement));
        StatementQuery s = new StatementQuery(this.session, queryExpression, this.compileContext);
        String fullSQL = this.getLastPart();
        Object[] args = new Object[]{view};
        int type = alter ? 1070 : 84;
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(fullSQL, type, args, s.readTableNames, writeTableNames);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(7, false);
        NumberSequence sequence = new NumberSequence(name, Type.SQL_INTEGER);
        this.readSequenceOptions(sequence, true, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 133, args, null, writeTableNames);
    }

    StatementSchema compileCreateDomain() {
        boolean end;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(13, false);
        this.readIfThis(10);
        Type type = this.readTypeDefinition(false, false).duplicate();
        Expression defaultClause = null;
        if (this.readIfThis(78)) {
            defaultClause = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(name, 13, type);
        userTypeModifier.setDefaultClause(defaultClause);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList tempConstraints = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            end = false;
            switch (this.token.tokenType) {
                case 37: 
                case 48: {
                    this.readConstraint(type, tempConstraints);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        this.compileContext.currentDomain = null;
        for (int i = 0; i < tempConstraints.size(); ++i) {
            Constraint c = (Constraint)tempConstraints.get(i);
            c.prepareCheckConstraint(this.session, null, false);
            userTypeModifier.addConstraint(c);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 23, args, null, writeTableNames);
    }

    StatementSchema compileCreateType() {
        UserTypeModifier userTypeModifier;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(12, false);
        this.readThis(10);
        Type type = this.readTypeDefinition(false, false).duplicate();
        this.readIfThis(400);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(name, 12, type);
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 83, args, null, writeTableNames);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(254);
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(14, false);
        this.readIfThis(10);
        this.readThis(119);
        String schema = this.session.getSchemaName(this.token.namePrefix);
        Charset source = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, schema, 14);
        this.read();
        if (this.token.tokenType == 358) {
            this.read();
            this.readThis(115);
            this.readThis(78);
        }
        Charset charset = new Charset(name);
        charset.base = source.getName();
        String sql = this.getLastPart();
        Object[] args = new Object[]{charset};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 8, args, null, writeTableNames);
    }

    StatementSchema compileCreateCollation() {
        Collation source;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(15, false);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(112);
        HsqlNameManager.HsqlName charsetName = this.readNewSchemaObjectName(14, false);
        charsetName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(115);
        HsqlNameManager.HsqlName sourceName = this.readNewSchemaObjectName(15, false);
        sourceName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        if (this.readIfThis(180)) {
            this.readThis(463);
        } else if (this.readIfThis(463)) {
            this.readThis(514);
        }
        Charset charset = (Charset)this.database.schemaManager.getSchemaObject(charsetName);
        if (charset == null) {
            throw Error.error(5501, charsetName.getSchemaQualifiedStatementName());
        }
        try {
            source = Collation.getCollation(sourceName.name);
        }
        catch (HsqlException e) {
            source = (Collation)this.database.schemaManager.getSchemaObject(sourceName);
        }
        if (source == null) {
            throw Error.error(5501, sourceName.getSchemaQualifiedStatementName());
        }
        Collation collation = new Collation(name, source, charset);
        String sql = this.getLastPart();
        Object[] args = new Object[]{collation};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 10, args, null, writeTableNames);
    }

    StatementSchema compileCreateAlias() {
        String alias;
        HsqlNameManager.HsqlName name = null;
        Routine[] routines = null;
        String methodFQN = null;
        if (!this.session.isProcessingScript()) {
            throw super.unsupportedFeature();
        }
        this.read();
        try {
            alias = this.token.tokenString;
            this.read();
            this.readThis(112);
            methodFQN = this.token.tokenString;
            this.read();
        }
        catch (HsqlException e) {
            alias = null;
        }
        if (alias != null) {
            HsqlNameManager.HsqlName schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            name = this.database.nameManager.newHsqlName(schema, alias, 16);
            Method[] methods = Routine.getMethods(methodFQN);
            routines = Routine.newRoutines(this.session, methods);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, routines};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1072, args, null, writeTableNames);
    }

    StatementSchema compileCreateTrigger() {
        Object[] args;
        String sql;
        int operationType;
        int beforeOrAfterType;
        Boolean isForEachRow = null;
        boolean isNowait = false;
        boolean hasQueueSize = false;
        int queueSize = 0;
        HsqlNameManager.HsqlName otherName = null;
        OrderedHashSet columns = null;
        int[] updateColumnIndexes = null;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(8, true);
        switch (this.token.tokenType) {
            case 422: {
                beforeOrAfterType = TriggerDef.getTiming(422);
                this.read();
                this.readThis(191);
                break;
            }
            case 336: 
            case 343: {
                beforeOrAfterType = TriggerDef.getTiming(this.token.tokenType);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (this.token.tokenType) {
            case 79: 
            case 135: {
                operationType = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                break;
            }
            case 303: {
                operationType = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                if (this.token.tokenType != 191 || beforeOrAfterType == 6) break;
                this.read();
                columns = new OrderedHashSet();
                this.readColumnNameList(columns, null, false);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(194);
        Table table = this.readTableName();
        if (this.token.tokenType == 343) {
            this.read();
            this.checkIsSimpleName();
            otherName = this.readNewSchemaObjectName(8, true);
        }
        name.setSchemaIfNull(table.getSchemaName());
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (beforeOrAfterType == 6 ? !table.isView() || ((View)table).getCheckOption() == 2 : table.isView()) {
            throw Error.error(5538, name.schema.name);
        }
        if (name.schema != table.getSchemaName()) {
            throw Error.error(5505, name.schema.name);
        }
        name.parent = table.getName();
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        if (columns != null) {
            updateColumnIndexes = table.getColumnIndexes(columns);
            for (int i = 0; i < updateColumnIndexes.length; ++i) {
                if (updateColumnIndexes[i] != -1) continue;
                throw Error.error(5544, (String)columns.get(i));
            }
        }
        Expression condition = null;
        String oldTableName = null;
        String newTableName = null;
        HsqlNameManager.SimpleName oldRowName = null;
        HsqlNameManager.SimpleName newRowName = null;
        Table[] transitions = new Table[4];
        RangeVariable[] rangeVars = new RangeVariable[4];
        String conditionSQL = null;
        if (this.token.tokenType == 223) {
            this.read();
            if (this.token.tokenType != 193 && this.token.tokenType != 179) {
                throw this.unexpectedToken();
            }
            while (true) {
                RangeVariable range;
                RangeVariable range2;
                Table transition;
                HsqlNameManager.HsqlName hsqlName;
                String n;
                if (this.token.tokenType == 193) {
                    if (operationType == 50) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 278) {
                        if (Boolean.TRUE.equals(isForEachRow) || oldTableName != null || beforeOrAfterType == 4) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(10);
                        this.checkIsSimpleName();
                        this.read();
                        n = oldTableName = this.token.tokenString;
                        if (n.equals(newTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                            throw this.unexpectedToken();
                        }
                        isForEachRow = Boolean.FALSE;
                        hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n, this.isDelimitedIdentifier(), 10);
                        transition = new Table(table, hsqlName);
                        range2 = new RangeVariable(transition, null, null, null, this.compileContext);
                        transitions[2] = transition;
                        rangeVars[2] = range2;
                        continue;
                    }
                    if (Boolean.FALSE.equals(isForEachRow) || oldRowName != null) {
                        throw this.unexpectedToken();
                    }
                    this.readIfThis(243);
                    this.readIfThis(10);
                    this.checkIsSimpleName();
                    oldRowName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    n = oldRowName.name;
                    if (n.equals(newTableName) || n.equals(oldTableName) || n.equals(newRowName)) {
                        throw this.unexpectedToken();
                    }
                    isForEachRow = Boolean.TRUE;
                    range = new RangeVariable(table.columnList, oldRowName, false, 2);
                    range.rangePosition = 0;
                    transitions[0] = null;
                    rangeVars[0] = range;
                    continue;
                }
                if (this.token.tokenType != 179) break;
                if (operationType == 19) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 278) {
                    if (Boolean.TRUE.equals(isForEachRow) || newTableName != null || beforeOrAfterType == 4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readIfThis(10);
                    this.checkIsSimpleName();
                    newTableName = this.token.tokenString;
                    this.read();
                    isForEachRow = Boolean.FALSE;
                    n = newTableName;
                    if (n.equals(oldTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                        throw this.unexpectedToken();
                    }
                    hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n, this.isDelimitedIdentifier(), 10);
                    transition = new Table(table, hsqlName);
                    range2 = new RangeVariable(transition, null, null, null, this.compileContext);
                    transitions[3] = transition;
                    rangeVars[3] = range2;
                    continue;
                }
                if (Boolean.FALSE.equals(isForEachRow) || newRowName != null) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(243);
                this.readIfThis(10);
                this.checkIsSimpleName();
                newRowName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                this.read();
                n = newRowName.name;
                if (n.equals(oldTableName) || n.equals(newTableName) || n.equals(oldRowName)) {
                    throw this.unexpectedToken();
                }
                isForEachRow = Boolean.TRUE;
                range = new RangeVariable(table.columnList, newRowName, false, 2);
                range.rangePosition = 1;
                transitions[1] = null;
                rangeVars[1] = range;
            }
        }
        if (Boolean.TRUE.equals(isForEachRow) && this.token.tokenType != 112) {
            throw this.unexpectedTokenRequire("FOR");
        }
        if (this.token.tokenType == 112) {
            this.read();
            this.readThis(90);
            if (this.token.tokenType == 243) {
                if (Boolean.FALSE.equals(isForEachRow)) {
                    throw this.unexpectedToken();
                }
                isForEachRow = Boolean.TRUE;
            } else if (this.token.tokenType == 517) {
                if (Boolean.TRUE.equals(isForEachRow) || beforeOrAfterType == 4) {
                    throw this.unexpectedToken();
                }
                isForEachRow = Boolean.FALSE;
            } else {
                throw this.unexpectedToken();
            }
            this.read();
        }
        if (rangeVars[2] != null) {
            // empty if block
        }
        if (rangeVars[3] != null) {
            // empty if block
        }
        if ("QUEUE".equals(this.token.tokenString)) {
            this.read();
            queueSize = this.readInteger();
            hasQueueSize = true;
        }
        if ("NOWAIT".equals(this.token.tokenString)) {
            this.read();
            isNowait = true;
        }
        if (this.token.tokenType == 314 && beforeOrAfterType != 6) {
            this.read();
            this.readThis(786);
            int position = this.getPosition();
            this.isCheckOrTriggerCondition = true;
            condition = this.XreadBooleanValueExpression();
            conditionSQL = this.getLastPart(position);
            this.isCheckOrTriggerCondition = false;
            this.readThis(772);
            HsqlList unresolved = condition.resolveColumnReferences(this.session, rangeVars, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (isForEachRow == null) {
            isForEachRow = Boolean.FALSE;
        }
        if (this.token.tokenType == 25) {
            int position = this.getPosition();
            try {
                this.read();
                this.checkIsSimpleName();
                this.checkIsDelimitedIdentifier();
                String className = this.token.tokenString;
                this.read();
                if (this.token.tokenType == 786) {
                    throw this.unexpectedToken();
                }
                TriggerDef td = new TriggerDef(name, beforeOrAfterType, operationType, isForEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumnIndexes, className, isNowait, queueSize);
                sql = this.getLastPart();
                args = new Object[]{td, otherName};
                return new StatementSchema(sql, 80, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
            }
            catch (HsqlException e) {
                this.rewind(position);
            }
        }
        if (hasQueueSize) {
            throw this.unexpectedToken("QUEUE");
        }
        if (isNowait) {
            throw this.unexpectedToken("NOWAIT");
        }
        Routine routine = this.compileTriggerRoutine(table, rangeVars, beforeOrAfterType, operationType);
        TriggerDefSQL td = new TriggerDefSQL(name, beforeOrAfterType, operationType, isForEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumnIndexes, routine);
        sql = this.getLastPart();
        args = new Object[]{td, otherName};
        return new StatementSchema(sql, 80, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    Routine compileTriggerRoutine(Table table, RangeVariable[] ranges, int beforeOrAfter, int operation) {
        int impact = beforeOrAfter == 4 ? 3 : 4;
        Routine routine = new Routine(table, ranges, impact, beforeOrAfter, operation);
        this.startRecording();
        StatementCompound parent = new StatementCompound(12, null);
        parent.rangeVariables = ranges;
        Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
        if (statement == null) {
            throw this.unexpectedToken();
        }
        Token[] tokenisedStatement = this.getRecordedStatement();
        String sql = Token.getSQL(tokenisedStatement);
        statement.setSQL(sql);
        routine.setProcedure(statement);
        routine.resolve(this.session);
        return routine;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList constraintList) {
        boolean isGenerated = false;
        boolean isIdentity = false;
        boolean isPKIdentity = false;
        boolean generatedAlways = false;
        Expression generateExpr = null;
        boolean isNullable = true;
        Expression defaultExpr = null;
        Type typeObject = null;
        NumberSequence sequence = null;
        switch (this.token.tokenType) {
            case 407: {
                this.read();
                this.readThis(337);
                isGenerated = true;
                generatedAlways = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 128: {
                this.read();
                isIdentity = true;
                isPKIdentity = true;
                typeObject = Type.SQL_INTEGER;
                sequence = new NumberSequence(null, 0L, 1L, typeObject);
                break;
            }
            case 774: {
                return null;
            }
            case 772: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            isIdentity = true;
                            isPKIdentity = true;
                            typeObject = Type.SQL_BIGINT;
                            sequence = new NumberSequence(null, 1L, 1L, typeObject);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            isIdentity = true;
                            typeObject = Type.SQL_INTEGER;
                            sequence = new NumberSequence(null, 1L, 1L, typeObject);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        isIdentity = true;
                        isPKIdentity = true;
                        typeObject = Type.SQL_BIGINT;
                        sequence = new NumberSequence(null, 1L, 1L, typeObject);
                        break;
                    }
                }
                typeObject = this.readTypeDefinition(true, true);
            }
        }
        if (!isGenerated && !isIdentity) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 186: {
                        this.read();
                        break;
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        isNullable = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 78: {
                    this.read();
                    defaultExpr = this.readDefaultClause(typeObject);
                    if (defaultExpr.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    sequence = ((ExpressionColumn)defaultExpr).sequence;
                    defaultExpr = null;
                    isIdentity = true;
                    break;
                }
                case 407: {
                    this.read();
                    if (this.token.tokenType == 24) {
                        this.read();
                        this.readThis(78);
                    } else {
                        this.readThis(337);
                        generatedAlways = true;
                    }
                    this.readThis(10);
                    if (this.token.tokenType == 128) {
                        this.read();
                        sequence = new NumberSequence(null, typeObject);
                        sequence.setAlways(generatedAlways);
                        if (this.token.tokenType == 786) {
                            this.read();
                            this.readSequenceOptions(sequence, false, false);
                            this.readThis(772);
                        }
                        isIdentity = true;
                        break;
                    }
                    if (this.token.tokenType == 786) {
                        if (!generatedAlways) {
                            throw super.unexpectedTokenRequire("IDENTITY");
                        }
                        isGenerated = true;
                        break;
                    }
                    if (this.token.tokenType != 505) break;
                    if (generatedAlways) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                        throw super.unexpectedToken(this.token.namePrefix);
                    }
                    sequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                    isIdentity = true;
                    this.read();
                    break;
                }
                case 128: {
                    this.read();
                    isIdentity = true;
                    isPKIdentity = true;
                    sequence = new NumberSequence(null, 0L, 1L, typeObject);
                }
            }
        }
        if (isGenerated) {
            this.readThis(786);
            generateExpr = this.XreadValueExpression();
            this.readThis(772);
        }
        if (!isGenerated && !isIdentity && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            isIdentity = true;
            sequence = new NumberSequence(null, 0L, 1L, typeObject);
        }
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, isNullable, false, defaultExpr);
        column.setGeneratingExpression(generateExpr);
        this.readColumnConstraints(table, column, constraintList);
        if (this.token.tokenType == 128 && !isIdentity) {
            this.read();
            isIdentity = true;
            isPKIdentity = true;
            sequence = new NumberSequence(null, 0L, 1L, typeObject);
        }
        if (isIdentity) {
            column.setIdentity(sequence);
        }
        if (isPKIdentity && !column.isPrimaryKey()) {
            OrderedHashSet set = new OrderedHashSet();
            set.add(column.getName().name);
            HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint c = new Constraint(constName, set, 4);
            constraintList.set(0, c);
            column.setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 78 && column.getDefaultExpression() == null && column.getIdentitySequence() == null) {
            this.read();
            defaultExpr = this.readDefaultClause(typeObject);
            if (defaultExpr.opType == 12) {
                sequence = ((ExpressionColumn)defaultExpr).sequence;
                defaultExpr = null;
            }
            column.setDefaultExpression(defaultExpr);
            column.setIdentity(sequence);
        }
        return column;
    }

    private void readSequenceOptions(NumberSequence sequence, boolean withType, boolean isAlter) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        do {
            end = false;
            if (set.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 10: {
                    if (withType) {
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        sequence.setDefaults(sequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 267: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(319);
                    long value = this.readBigint();
                    sequence.setStartValueNoCheck(value);
                    break;
                }
                case 484: {
                    if (!isAlter) {
                        end = true;
                        break;
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(319)) {
                        long value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.setStartValueDefault();
                    break;
                }
                case 417: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(24);
                    long value = this.readBigint();
                    sequence.setIncrement(value);
                    break;
                }
                case 180: {
                    this.read();
                    if (this.token.tokenType == 438) {
                        sequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 442) {
                        sequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 71) {
                        sequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 438: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMaxValueNoCheck(value);
                    break;
                }
                case 442: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMinValueNoCheck(value);
                    break;
                }
                case 71: {
                    set.add(this.token.tokenType);
                    this.read();
                    sequence.setCycle(true);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
    }

    private void readConstraint(SchemaObject schemaObject, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName constName = null;
        if (this.token.tokenType == 48) {
            this.read();
            constName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 214: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                Constraint mainConst = (Constraint)constraintList.get(0);
                if (mainConst.constType == 4) {
                    throw Error.error(5532);
                }
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = new Constraint(constName, set, 4);
                constraintList.set(0, c);
                break;
            }
            case 299: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                OrderedHashSet set = this.readColumnNames(false);
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, set, 2);
                constraintList.add(c);
                break;
            }
            case 113: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = this.readFKReferences((Table)schemaObject, constName, set);
                constraintList.add(c);
                break;
            }
            case 37: {
                this.read();
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, null, 3);
                this.readCheckConstraintCondition(c);
                constraintList.add(c);
                break;
            }
            default: {
                if (constName == null) break;
                throw super.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema column, HsqlArrayList constraintList) {
        boolean end = false;
        boolean hasNotNullConstraint = false;
        boolean hasNullNoiseWord = false;
        boolean hasPrimaryKey = false;
        do {
            HsqlNameManager.HsqlName constName = null;
            if (this.token.tokenType == 48) {
                this.read();
                constName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 214: {
                    if (hasNullNoiseWord || hasPrimaryKey) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(427);
                    Constraint existingConst = (Constraint)constraintList.get(0);
                    if (existingConst.constType == 4) {
                        throw Error.error(5532);
                    }
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 4);
                    constraintList.set(0, c);
                    column.setPrimaryKey(true);
                    hasPrimaryKey = true;
                    break;
                }
                case 299: {
                    this.read();
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 2);
                    constraintList.add(c);
                    break;
                }
                case 113: {
                    this.read();
                    this.readThis(427);
                }
                case 222: {
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    Constraint c = this.readFKReferences(table, constName, set);
                    constraintList.add(c);
                    break;
                }
                case 37: {
                    this.read();
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    this.readCheckConstraintCondition(c);
                    OrderedHashSet set = c.getCheckColumnExpressions();
                    for (int i = 0; i < set.size(); ++i) {
                        ExpressionColumn e = (ExpressionColumn)set.get(i);
                        if (column.getName().name.equals(e.getColumnName())) {
                            if (e.getSchemaName() == null || e.getSchemaName() == table.getSchemaName().name) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    constraintList.add(c);
                    break;
                }
                case 183: {
                    if (hasNotNullConstraint || hasNullNoiseWord) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(186);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    c.check = new ExpressionLogical(column);
                    constraintList.add(c);
                    hasNotNullConstraint = true;
                    break;
                }
                case 186: {
                    if (hasNotNullConstraint || hasNullNoiseWord || hasPrimaryKey) {
                        throw this.unexpectedToken();
                    }
                    if (constName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    hasNullNoiseWord = true;
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
    }

    void readCheckConstraintCondition(Constraint c) {
        this.readThis(786);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression condition = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokens = this.getRecordedStatement();
        this.readThis(772);
        c.check = condition;
    }

    StatementSchema compileCreateIndex(boolean unique) {
        String[] qualifiers = null;
        HsqlArrayList list = new HsqlArrayList();
        this.read();
        HsqlNameManager.HsqlName indexHsqlName = this.readNewSchemaObjectName(20, true);
        while (this.token.tokenType != 194) {
            this.checkIsIdentifier();
            list.add(this.token.tokenString);
            this.read();
        }
        qualifiers = new String[list.size()];
        list.toArray(qualifiers);
        this.readThis(194);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName tableSchema = table.getSchemaName();
        indexHsqlName.setSchemaIfNull(tableSchema);
        indexHsqlName.parent = table.getName();
        if (indexHsqlName.schema != tableSchema) {
            throw Error.error(5505);
        }
        indexHsqlName.schema = table.getSchemaName();
        int[] indexColumns = this.readColumnList(table, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, indexColumns, indexHsqlName, unique, qualifiers};
        return new StatementSchema(sql, 1073, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean swapped;
        Grantee owner;
        HsqlNameManager.HsqlName schemaName = null;
        String authorisation = null;
        HsqlNameManager.HsqlName characterSetName = null;
        this.read();
        if (this.token.tokenType != 15) {
            schemaName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 15) {
            this.read();
            this.checkIsSimpleName();
            authorisation = this.token.tokenString;
            this.read();
            if (schemaName == null) {
                owner = this.database.getGranteeManager().get(authorisation);
                if (owner == null) {
                    throw Error.error(4001, authorisation);
                }
                schemaName = this.database.nameManager.newHsqlName(owner.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(authorisation)) {
            throw Error.error(4002, authorisation);
        }
        Grantee grantee = owner = authorisation == null ? this.session.getGrantee() : this.database.getGranteeManager().get(authorisation);
        if (owner == null) {
            throw Error.error(4001, authorisation);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (owner instanceof User && ((User)owner).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (this.database.schemaManager.schemaExists(schemaName.name)) {
            throw Error.error(5504, schemaName.name);
        }
        if (schemaName.name.equals("SYSTEM_LOBS")) {
            schemaName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            owner = schemaName.owner;
        }
        if (this.readIfThis(78)) {
            this.readThis(35);
            this.readThis(254);
            characterSetName = this.readNewSchemaObjectName(14, false);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{schemaName, owner};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        StatementSchema cs = new StatementSchema(sql, 64, args, null, writeTableNames);
        cs.setSchemaHsqlName(schemaName);
        HsqlArrayList list = new HsqlArrayList();
        list.add(cs);
        this.getCompiledStatementBody(list);
        StatementSchema[] array = new StatementSchema[list.size()];
        list.toArray(array);
        do {
            swapped = false;
            for (int i = 0; i < array.length - 1; ++i) {
                if (array[i].order <= array[i + 1].order) continue;
                StatementSchema temp = array[i + 1];
                array[i + 1] = array[i];
                array[i] = temp;
                swapped = true;
            }
        } while (swapped);
        return new StatementSchemaDefinition(array);
    }

    void getCompiledStatementBody(HsqlList list) {
        boolean end = false;
        while (!end) {
            StatementSchema cs = null;
            int position = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 55: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 299: 
                        case 305: 
                        case 497: {
                            throw this.unexpectedToken();
                        }
                        case 595: {
                            int statementType = 1073;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 505: {
                            cs = this.compileCreateSequence();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 490: {
                            cs = this.compileCreateRole();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 393: {
                            int statementType = 23;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 535: {
                            cs = this.compileCreateType();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 35: {
                            cs = this.compileCreateCharacterSet();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 339: {
                            throw this.unexpectedToken();
                        }
                        case 120: 
                        case 278: 
                        case 523: 
                        case 570: 
                        case 605: 
                        case 627: 
                        case 628: {
                            int statementType = 77;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 291: {
                            int statementType = 80;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 545: {
                            int statementType = 84;
                            String sql = this.getStatement(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 117: {
                            int statementType = 14;
                            String sql = this.getStatementForRoutine(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                        case 215: {
                            int statementType = 14;
                            String sql = this.getStatementForRoutine(position, startStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 121: {
                    cs = this.compileGrantOrRevoke();
                    cs.sql = this.getLastPart(position);
                    break;
                }
                case 791: {
                    this.read();
                    end = true;
                    break;
                }
                case 848: {
                    end = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (cs == null) continue;
            cs.isSchemaDefinition = true;
            list.add(cs);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 61, args, null, writeTableNames);
    }

    StatementSchema compileCreateUser() {
        Boolean admin = Boolean.FALSE;
        Boolean isDigest = Boolean.FALSE;
        Grantee grantor = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        this.readThis(613);
        if (this.readIfThis(584)) {
            isDigest = Boolean.TRUE;
        }
        String password = this.readPassword();
        if (this.token.tokenType == 335) {
            this.read();
            admin = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, password, grantor, admin, isDigest};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1074, args, null, writeTableNames);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String tokenS = this.token.tokenString;
        boolean isQuoted = this.isDelimitedIdentifier();
        if (tokenS.equalsIgnoreCase("SA")) {
            tokenS = "SA";
            isQuoted = false;
        }
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(tokenS, isQuoted, 11);
        this.read();
        return name;
    }

    String readPassword() {
        String tokenS = this.token.tokenString;
        this.read();
        return tokenS;
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName name, int type) {
        HsqlNameManager.HsqlName newName = this.readNewSchemaObjectName(type, true);
        String sql = this.getLastPart();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, name);
                break;
            }
            default: {
                name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, name.schema);
            }
        }
        Object[] args = new Object[]{name, newName};
        HsqlNameManager.HsqlName[] writeTableNames = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 1192, args, null, writeTableNames);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        HsqlNameManager.HsqlName indexname = this.database.nameManager.newAutoName("IDX", name.name, table.getSchemaName(), table.getName(), 20);
        Index index = table.createIndexStructure(indexname, cols, null, null, true, true, false);
        Constraint c = new Constraint(name, table, index, 2);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1082, table, c};
        return new StatementSchema(sql, 4, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint c = this.readFKReferences(table, name, set);
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        c.core.mainTable = this.database.schemaManager.getTable(this.session, mainTableName.name, mainTableName.schema.name);
        c.setColumnsIndexes(table);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1082, table, c};
        HsqlNameManager.HsqlName[] names = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName(), mainTableName};
        return new StatementSchema(sql, 4, args, null, names);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint check = new Constraint(name, null, 3);
        this.readCheckConstraintCondition(check);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1082, table, check};
        return new StatementSchema(sql, 4, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    Statement compileAlterTableAddColumn(Table table) {
        int colIndex = table.getColumnCount();
        HsqlArrayList list = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        list.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema column = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (column == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1081, table, column, new Integer(colIndex), list};
        return new StatementSchema(sql, 4, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint constraint = new Constraint(name, set, 4);
        constraint.setColumnsIndexes(table);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1082, table, constraint};
        return new StatementSchema(sql, 4, args, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    Statement compileAlterTableDropColumn(Table table, String colName, boolean cascade) {
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        int colindex = table.getColumnIndex(colName);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table.getColumn(colindex).getName(), ValuePool.getInt(9), cascade, false};
        return new StatementSchema(sql, 1076, args, null, writeLockNames);
    }

    Statement compileAlterColumn(Table table, ColumnSchema column, int columnIndex) {
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 619: {
                this.read();
                this.readThis(285);
                return this.compileAlterColumnRename(table, column);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1088, table, column, columnIndex};
                    return new StatementSchema(sql, 4, args, null, writeLockNames);
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1089, table, column, columnIndex};
                    return new StatementSchema(sql, 4, args, null, writeLockNames);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(535);
                        return this.compileAlterColumnDataType(table, column);
                    }
                    case 78: {
                        this.read();
                        Type type = column.getDataType();
                        Expression expr = this.readDefaultClause(type);
                        String sql = this.getLastPart();
                        Object[] args = new Object[]{1087, table, column, columnIndex, expr};
                        return new StatementSchema(sql, 4, args, null, writeLockNames);
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        return this.compileAlterColumnSetNullability(table, column, false);
                    }
                    case 186: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, column, true);
                    }
                    case 407: {
                        return this.compileAlterColumnAddSequence(table, column, columnIndex);
                    }
                }
                this.rewind(position);
                this.read();
            }
            case 407: {
                return this.compileAlterColumnAddSequence(table, column, columnIndex);
            }
        }
        if (this.token.tokenType == 254 || this.token.tokenType == 484) {
            if (!column.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, column, columnIndex);
        }
        return this.compileAlterColumnDataTypeIdentity(table, column);
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema column) {
        if (column.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence sequence = column.getIdentitySequence();
        Type type = column.getDataType();
        if (this.token.tokenType == 128) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (sequence == null) {
                sequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(false, true);
            switch (this.token.tokenType) {
                case 128: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (sequence != null) break;
                    sequence = new NumberSequence(null, type);
                    break;
                }
                case 407: {
                    sequence = this.readSequence(column);
                    break;
                }
                default: {
                    sequence = null;
                }
            }
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1090, table, column, type, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema column) {
        if (column.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(false, true);
        if (column.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{1084, table, column, type};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema column, boolean b) {
        String sql = this.getLastPart();
        Object[] args = new Object[]{1086, table, column, b};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(this.token.tokenString, schema.name, true);
        this.read();
        if (this.token.tokenType == 619) {
            this.read();
            this.readThis(285);
            return this.compileRenameObject(sequence.getName(), 7);
        }
        this.checkSchemaUpdateAuthorisation(this.session, sequence.getName().schema);
        NumberSequence copy = sequence.duplicate();
        this.readSequenceOptions(copy, false, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence, copy};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(sql, 134, args, null, writeLockNames);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema column, int colIndex) {
        if (!column.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (column.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence sequence = this.readSequence(column);
        String sql = this.getLastPart();
        Object[] args = new Object[]{1085, table, column, colIndex, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    NumberSequence readSequence(ColumnSchema column) {
        this.readThis(407);
        NumberSequence sequence = new NumberSequence(null, column.getDataType());
        boolean generatedAlways = false;
        if (this.token.tokenType == 24) {
            this.read();
            this.readThis(78);
        } else {
            this.readThis(337);
            generatedAlways = true;
        }
        this.readThis(10);
        this.readThis(128);
        sequence.setAlways(generatedAlways);
        if (this.token.tokenType == 786) {
            this.read();
            this.readSequenceOptions(sequence, false, false);
            this.readThis(772);
        }
        sequence.checkValues();
        return sequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema column, int columnIndex) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        NumberSequence sequence = column.getIdentitySequence().duplicate();
        do {
            end = false;
            block0 : switch (this.token.tokenType) {
                case 484: {
                    long value;
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(319)) {
                        value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.reset();
                    break;
                }
                case 254: {
                    long value;
                    this.read();
                    switch (this.token.tokenType) {
                        case 417: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(24);
                            value = this.readBigint();
                            sequence.setIncrement(value);
                            break block0;
                        }
                        case 180: {
                            this.read();
                            if (this.token.tokenType == 438) {
                                sequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 442) {
                                sequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 71) {
                                sequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 438: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMaxValueNoCheck(value);
                            break block0;
                        }
                        case 442: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMinValueNoCheck(value);
                            break block0;
                        }
                        case 71: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            sequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw super.unexpectedToken();
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
        String sql = this.getLastPart();
        Object[] args = new Object[]{1085, table, column, columnIndex, sequence};
        HsqlNameManager.HsqlName[] writeLockNames = new HsqlNameManager.HsqlName[]{table.getName()};
        return new StatementSchema(sql, 4, args, null, writeLockNames);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema column) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(name.name) > -1) {
            throw Error.error(5504, name.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), column.getName());
        String sql = this.getLastPart();
        Object[] args = new Object[]{column.getName(), name};
        HsqlNameManager.HsqlName[] names = new HsqlNameManager.HsqlName[]{table.getName()};
        return new StatementSchema(sql, 1192, args, null, names);
    }

    Statement compileAlterSchemaRename() {
        HsqlNameManager.HsqlName name = this.readSchemaName();
        this.checkSchemaUpdateAuthorisation(name);
        this.readThis(619);
        this.readThis(285);
        HsqlNameManager.HsqlName newName = this.readNewSchemaName();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, newName};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames();
        return new StatementSchema(sql, 1192, args, null, writeLockNames);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName userName = this.readNewUserIdentifier();
        User userObject = this.database.getUserManager().get(userName.name);
        if (userName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        this.readThis(254);
        switch (this.token.tokenType) {
            case 157: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{userObject, mode};
                return new StatementCommand(1060, args);
            }
            case 613: {
                this.read();
                boolean isDigest = false;
                if (this.readIfThis(584)) {
                    isDigest = Boolean.TRUE;
                }
                String password = this.readPassword();
                Object[] args = new Object[]{userObject, password, isDigest};
                StatementCommand cs = new StatementCommand(1062, args);
                String sql = userObject.getSetPasswordDigestSQL();
                cs.setSQL(sql);
                return cs;
            }
            case 596: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName schemaName = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{userObject, schemaName};
                return new StatementCommand(1061, args);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Type domain = this.database.schemaManager.getDomain(this.token.tokenString, schema.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 619: {
                this.read();
                this.readThis(285);
                return this.compileRenameObject(domain.getName(), 13);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1080, domain};
                    HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
                    return new StatementSchema(sql, 3, args, null, writeLockNames);
                }
                if (this.token.tokenType == 48) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaObjectName(domain.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String sql = this.getLastPart();
                    Object[] args = new Object[]{1078, domain, name};
                    HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
                    return new StatementSchema(sql, 3, args, null, writeLockNames);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                this.readThis(78);
                Expression e = this.readDefaultClause(domain);
                String sql = this.getLastPart();
                Object[] args = new Object[]{1083, domain, e};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
                return new StatementSchema(sql, 3, args, null, writeLockNames);
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 48 && this.token.tokenType != 37) break;
                HsqlArrayList tempConstraints = new HsqlArrayList();
                this.compileContext.currentDomain = domain;
                this.readConstraint(domain, tempConstraints);
                this.compileContext.currentDomain = null;
                Constraint c = (Constraint)tempConstraints.get(0);
                String sql = this.getLastPart();
                Object[] args = new Object[]{1082, domain, c};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
                return new StatementSchema(sql, 3, args, null, writeLockNames);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 79: 
            case 100: 
            case 135: 
            case 222: 
            case 251: 
            case 303: 
            case 540: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean grant = this.token.tokenType == 121;
        this.read();
        if (this.isGrantToken() || !grant && (this.token.tokenType == 121 || this.token.tokenType == 411)) {
            return this.compileRightGrantOrRevoke(grant);
        }
        return this.compileRoleGrantOrRevoke(grant);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean grant) {
        OrderedHashSet granteeList = new OrderedHashSet();
        Grantee grantor = null;
        Right right = null;
        HsqlNameManager.HsqlName objectName = null;
        boolean isTable = false;
        boolean isUsage = false;
        boolean isExec = false;
        boolean isAll = false;
        boolean isGrantOption = false;
        boolean cascade = false;
        if (!grant) {
            if (this.token.tokenType == 121) {
                this.read();
                this.readThis(455);
                this.readThis(112);
                isGrantOption = true;
            } else if (this.token.tokenType == 411) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 478) {
                this.read();
            }
            right = Right.fullRights;
            isAll = true;
        } else {
            right = new Right();
            boolean loop = true;
            block21: while (loop) {
                this.checkIsNotQuoted();
                int rightType = GranteeManager.getCheckSingleRight(this.token.tokenString);
                int grantType = this.token.tokenType;
                OrderedHashSet columnSet = null;
                this.read();
                switch (grantType) {
                    case 135: 
                    case 222: 
                    case 251: 
                    case 303: {
                        if (this.token.tokenType == 786) {
                            columnSet = this.readColumnNames(false);
                        }
                    }
                    case 291: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(rightType, columnSet);
                        isTable = true;
                        break;
                    }
                    case 79: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(rightType, null);
                        isTable = true;
                        break;
                    }
                    case 540: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isUsage = true;
                        loop = false;
                        continue block21;
                    }
                    case 100: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isExec = true;
                        loop = false;
                        continue block21;
                    }
                }
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        this.readThis(194);
        int objectType = 0;
        switch (this.token.tokenType) {
            case 573: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                objectType = 16;
                objectName = this.readNewSchemaObjectName(16, false);
                break;
            }
            case 259: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                objectType = 24;
                break;
            }
            case 117: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 16;
                break;
            }
            case 215: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 17;
                break;
            }
            case 491: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 18;
                break;
            }
            case 535: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 12;
                break;
            }
            case 393: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 13;
                break;
            }
            case 505: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 7;
                break;
            }
            case 35: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(254);
                objectType = 14;
                break;
            }
            default: {
                if (!isTable && !isAll) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(278);
                objectType = 3;
            }
        }
        objectName = this.readNewSchemaObjectName(objectType, false);
        if (grant) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (grant) {
            if (this.token.tokenType == 319) {
                this.read();
                this.readThis(121);
                this.readThis(455);
                isGrantOption = true;
            }
            if (this.token.tokenType == 410) {
                this.read();
                this.readThis(24);
                if (this.token.tokenType == 69) {
                    this.read();
                } else {
                    this.readThis(64);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantor = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 347) {
            cascade = true;
            this.read();
        } else {
            this.readThis(485);
        }
        String sql = this.getLastPart();
        int type = grant ? 48 : 59;
        Object[] args = new Object[]{granteeList, objectName, right, grantor, cascade, isGrantOption};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        StatementSchema cs = new StatementSchema(sql, type, args, null, writeLockNames);
        return cs;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean grant) {
        Grantee grantor = this.session.getGrantee();
        OrderedHashSet roleList = new OrderedHashSet();
        OrderedHashSet granteeList = new OrderedHashSet();
        boolean cascade = false;
        if (!grant && this.token.tokenType == 335) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            roleList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (grant) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (grant && this.token.tokenType == 319) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 410) {
            this.read();
            this.readThis(24);
            if (this.token.tokenType == 69) {
                this.read();
            } else {
                this.readThis(64);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantor = this.session.getRole();
            }
        }
        if (!grant) {
            if (this.token.tokenType == 347) {
                cascade = true;
                this.read();
            } else {
                this.readThis(485);
            }
        }
        String sql = this.getLastPart();
        int type = grant ? 49 : 129;
        Object[] args = new Object[]{granteeList, roleList, grantor, cascade};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        StatementSchema cs = new StatementSchema(sql, type, args, null, writeLockNames);
        return cs;
    }

    void checkSchemaUpdateAuthorisation(HsqlNameManager.HsqlName schema) {
        if (this.session.isProcessingLog) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(schema.name);
        if (this.isSchemaDefinition) {
            if (schema != this.session.getCurrentSchemaHsqlName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        }
        this.session.checkDDLWrite();
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        HsqlNameManager.HsqlName name;
        this.readThis(575);
        this.readThis(194);
        switch (this.token.tokenType) {
            case 278: 
            case 491: {
                int type = this.token.tokenType == 491 ? 18 : 3;
                this.read();
                this.checkIsSchemaObjectName();
                name = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, type);
                name.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
                this.read();
                break;
            }
            case 43: {
                this.read();
                this.checkIsSchemaObjectName();
                name = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, 9);
                if (this.token.namePrefix == null) {
                    throw Error.error(5501);
                }
                name.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
                name.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 3);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(142);
        String comment = this.readQuotedString();
        Object[] arguments = new Object[]{name, comment};
        return new StatementSchema(null, 1071, arguments);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 620) {
            this.read();
            int action = this.token.tokenType;
            switch (this.token.tokenType) {
                case 2: {
                    this.read();
                    break;
                }
                case 236: {
                    this.read();
                    this.readThis(510);
                    break;
                }
                case 278: {
                    this.read();
                    this.readThis(378);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] args = new Object[]{this.session.getId(), action};
            return new StatementCommand(1005, args);
        }
        long sessionID = this.readBigint();
        Session targetSession = this.database.sessionManager.getSession(sessionID);
        if (targetSession == null) {
            throw Error.error(4500);
        }
        int action = this.token.tokenType;
        switch (this.token.tokenType) {
            case 39: {
                this.read();
                break;
            }
            case 233: {
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{sessionID, action};
        return new StatementCommand(1005, args);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 294) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 106) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName schema) {
        if (session.isProcessingLog) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        session.checkDDLWrite();
    }
}

