/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

class Like {
    private static final BinaryData maxByteValue = new BinaryData(new byte[]{-128}, false);
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    int escapeChar;
    boolean hasCollation;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;
    boolean isVariable = true;
    boolean isBinary = false;
    Type dataType;

    Like() {
    }

    void setParams(boolean collation) {
        this.hasCollation = collation;
    }

    void setIgnoreCase(boolean flag) {
        this.isIgnoreCase = flag;
    }

    private Object getStartsWith() {
        int i;
        if (this.iLen == 0) {
            return this.isBinary ? BinaryData.zeroLengthBinary : "";
        }
        StringBuffer sb = null;
        HsqlByteArrayOutputStream os = null;
        if (this.isBinary) {
            os = new HsqlByteArrayOutputStream();
        } else {
            sb = new StringBuffer();
        }
        for (i = 0; i < this.iLen && this.wildCardType[i] == 0; ++i) {
            if (this.isBinary) {
                os.writeByte(this.cLike[i]);
                continue;
            }
            sb.append(this.cLike[i]);
        }
        if (i == 0) {
            return null;
        }
        return this.isBinary ? new BinaryData(os.toByteArray(), false) : sb.toString();
    }

    Boolean compare(Session session, Object o) {
        if (o == null) {
            return null;
        }
        if (this.isNull) {
            return null;
        }
        int length = this.getLength(session, o);
        if (this.isIgnoreCase) {
            o = ((CharacterType)this.dataType).upper(session, o);
        }
        if (o instanceof ClobData) {
            o = ((ClobData)o).getChars(session, 0L, (int)((ClobData)o).length(session));
        }
        return this.compareAt(o, 0, 0, this.iLen, length, this.cLike, this.wildCardType) ? Boolean.TRUE : Boolean.FALSE;
    }

    char getChar(Object o, int i) {
        char c = this.isBinary ? (char)((BlobData)o).getBytes()[i] : (o instanceof char[] ? ((char[])o)[i] : ((String)o).charAt(i));
        return c;
    }

    int getLength(SessionInterface session, Object o) {
        int l = o instanceof LobData ? (int)((LobData)o).length(session) : ((String)o).length();
        return l;
    }

    private boolean compareAt(Object o, int i, int j, int iLen, int jLen, char[] cLike, int[] wildCardType) {
        while (i < iLen) {
            switch (wildCardType[i]) {
                case 0: {
                    if (j < jLen && cLike[i] == this.getChar(o, j++)) break;
                    return false;
                }
                case 1: {
                    if (j++ < jLen) break;
                    return false;
                }
                case 2: {
                    if (++i >= iLen) {
                        return true;
                    }
                    while (j < jLen) {
                        if (cLike[i] == this.getChar(o, j) && this.compareAt(o, i, j, iLen, jLen, cLike, wildCardType)) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
            }
            ++i;
        }
        return j == jLen;
    }

    void setPattern(Session session, Object pattern, Object escape, boolean hasEscape) {
        int i;
        boolean bl = this.isNull = pattern == null;
        if (!hasEscape) {
            this.escapeChar = -1;
        } else {
            if (escape == null) {
                this.isNull = true;
                return;
            }
            int length = this.getLength(session, escape);
            if (length != 1) {
                if (this.isBinary) {
                    throw Error.error(3412);
                }
                throw Error.error(3439);
            }
            this.escapeChar = this.getChar(escape, 0);
        }
        if (this.isNull) {
            return;
        }
        if (this.isIgnoreCase) {
            pattern = (String)((CharacterType)this.dataType).upper(null, pattern);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int l = this.getLength(session, pattern);
        this.cLike = new char[l];
        this.wildCardType = new int[l];
        boolean bEscaping = false;
        boolean bPercent = false;
        for (i = 0; i < l; ++i) {
            char c = this.getChar(pattern, i);
            if (!bEscaping) {
                if (this.escapeChar == c) {
                    bEscaping = true;
                    continue;
                }
                if (c == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c == '%') {
                    if (bPercent) continue;
                    bPercent = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bPercent = false;
                }
            } else if (c == this.escapeChar || c == '_' || c == '%') {
                bPercent = false;
                bEscaping = false;
            } else {
                throw Error.error(3458);
            }
            this.cLike[this.iLen++] = c;
        }
        if (bEscaping) {
            throw Error.error(3458);
        }
        for (i = 0; i < this.iLen - 1; ++i) {
            if (this.wildCardType[i] != 2 || this.wildCardType[i + 1] != 1) continue;
            this.wildCardType[i] = 1;
            this.wildCardType[i + 1] = 2;
        }
    }

    boolean isEquivalentToUnknownPredicate() {
        return !this.isVariable && this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return !this.isVariable && this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isVariable || this.isNull || this.iFirstWildCard == -1) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    int getFirstWildCardIndex() {
        return this.iFirstWildCard;
    }

    Object getRangeLow() {
        return this.getStartsWith();
    }

    Object getRangeHigh(Session session) {
        Object o = this.getStartsWith();
        if (o == null) {
            return null;
        }
        if (this.isBinary) {
            return new BinaryData(session, (BinaryData)o, maxByteValue);
        }
        return this.dataType.concat(session, o, "\uffff");
    }

    public String describe(Session session) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        sb.append("escapeChar=").append(this.escapeChar).append('\n');
        sb.append("isNull=").append(this.isNull).append('\n');
        sb.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        sb.append("iLen=").append(this.iLen).append('\n');
        sb.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        sb.append("cLike=");
        sb.append(StringUtil.arrayToString(this.cLike));
        sb.append('\n');
        sb.append("wildCardType=");
        sb.append(StringUtil.arrayToString(this.wildCardType));
        sb.append(']');
        return sb.toString();
    }
}

