/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Crypto;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ASCII = 73;
    private static final int FUNC_ASIN = 74;
    private static final int FUNC_ATAN = 75;
    private static final int FUNC_ATAN2 = 76;
    private static final int FUNC_BITAND = 77;
    private static final int FUNC_BITOR = 78;
    private static final int FUNC_BITXOR = 79;
    private static final int FUNC_CHAR = 80;
    private static final int FUNC_CONCAT = 81;
    private static final int FUNC_COS = 82;
    private static final int FUNC_COT = 83;
    private static final int FUNC_CRYPT_KEY = 84;
    private static final int FUNC_DATABASE = 85;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 86;
    private static final int FUNC_DATABASE_NAME = 87;
    private static final int FUNC_DATABASE_TIMEZONE = 88;
    private static final int FUNC_DATABASE_VERSION = 89;
    private static final int FUNC_DATEADD = 90;
    private static final int FUNC_DATEDIFF = 91;
    private static final int FUNC_DEGREES = 92;
    private static final int FUNC_DIAGNOSTICS = 93;
    private static final int FUNC_DIFFERENCE = 94;
    private static final int FUNC_HEXTORAW = 95;
    private static final int FUNC_IDENTITY = 96;
    private static final int FUNC_ISAUTOCOMMIT = 97;
    private static final int FUNC_ISOLATION_LEVEL = 98;
    private static final int FUNC_ISREADONLYDATABASE = 99;
    private static final int FUNC_ISREADONLYDATABASEFILES = 100;
    private static final int FUNC_ISREADONLYSESSION = 101;
    private static final int FUNC_LEFT = 102;
    private static final int FUNC_LOAD_FILE = 103;
    private static final int FUNC_LOB_ID = 104;
    private static final int FUNC_LOCATE = 105;
    private static final int FUNC_LOG10 = 106;
    private static final int FUNC_LPAD = 107;
    private static final int FUNC_LTRIM = 108;
    private static final int FUNC_PI = 109;
    private static final int FUNC_POSITION_ARRAY = 110;
    private static final int FUNC_RADIANS = 111;
    private static final int FUNC_RAND = 112;
    private static final int FUNC_RAWTOHEX = 113;
    private static final int FUNC_REGEXP_MATCHES = 114;
    private static final int FUNC_REGEXP_SUBSTRING = 115;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 116;
    private static final int FUNC_REPEAT = 117;
    private static final int FUNC_REPLACE = 118;
    private static final int FUNC_REVERSE = 119;
    private static final int FUNC_RIGHT = 120;
    private static final int FUNC_ROUND = 121;
    private static final int FUNC_ROUNDMAGIC = 122;
    private static final int FUNC_RPAD = 123;
    private static final int FUNC_RTRIM = 124;
    private static final int FUNC_SECONDS_MIDNIGHT = 125;
    private static final int FUNC_SEQUENCE_ARRAY = 126;
    private static final int FUNC_SESSION_ID = 127;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 128;
    private static final int FUNC_SESSION_TIMEZONE = 129;
    private static final int FUNC_SIGN = 130;
    private static final int FUNC_SIN = 131;
    private static final int FUNC_SOUNDEX = 132;
    private static final int FUNC_SORT_ARRAY = 133;
    private static final int FUNC_SPACE = 134;
    private static final int FUNC_SUBSTR = 135;
    private static final int FUNC_SYSDATE = 136;
    private static final int FUNC_TAN = 137;
    private static final int FUNC_TIMESTAMP = 138;
    private static final int FUNC_TIMESTAMPADD = 139;
    private static final int FUNC_TIMESTAMPDIFF = 140;
    private static final int FUNC_TIMEZONE = 141;
    private static final int FUNC_TO_CHAR = 142;
    private static final int FUNC_TO_DATE = 143;
    private static final int FUNC_TO_NUMBER = 144;
    private static final int FUNC_TO_TIMESTAMP = 145;
    private static final int FUNC_TRANSACTION_CONTROL = 146;
    private static final int FUNC_TRANSACTION_ID = 147;
    private static final int FUNC_TRANSACTION_SIZE = 148;
    private static final int FUNC_TRUNC = 149;
    private static final int FUNC_TRUNCATE = 150;
    private static final int FUNC_UUID = 151;
    private static final int FUNC_UNIX_TIMESTAMP = 152;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;

    public static FunctionSQL newCustomFunction(String token, int tokenType) {
        int id = customRegularFuncMap.get(tokenType, -1);
        if (id == -1) {
            id = customValueFuncMap.get(tokenType, -1);
        }
        if (id == -1) {
            return null;
        }
        switch (tokenType) {
            case 431: 
            case 649: 
            case 687: 
            case 692: 
            case 703: 
            case 730: 
            case 731: 
            case 740: 
            case 756: {
                return new FunctionSQL(id);
            }
            case 702: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = optionalNoParamList;
                return function;
            }
            case 657: 
            case 658: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = emptyParamList;
                return function;
            }
            case 729: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = tripleParamList;
                return function;
            }
        }
        FunctionCustom function = new FunctionCustom(id);
        if (id == 31) {
            switch (tokenType) {
                case 695: {
                    function.extractSpec = 151;
                    break;
                }
                case 717: {
                    function.extractSpec = 286;
                }
            }
        }
        if (id == 5) {
            switch (tokenType) {
                case 669: {
                    function.extractSpec = 665;
                    break;
                }
                case 698: {
                    function.extractSpec = 697;
                    break;
                }
                case 670: {
                    function.extractSpec = 666;
                    break;
                }
                case 671: {
                    function.extractSpec = 667;
                    break;
                }
                case 672: {
                    function.extractSpec = 668;
                    break;
                }
                case 759: {
                    function.extractSpec = 760;
                    break;
                }
                default: {
                    function.extractSpec = tokenType;
                }
            }
        }
        if (function.name == null) {
            function.name = token;
        }
        return function;
    }

    public static boolean isRegularFunction(int tokenType) {
        return customRegularFuncMap.get(tokenType, -1) != -1;
    }

    public static boolean isValueFunction(int tokenType) {
        return customValueFuncMap.get(tokenType, -1) != -1;
    }

    private FunctionCustom(int id) {
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 72: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 146: 
            case 147: 
            case 148: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 82: 
            case 83: 
            case 92: 
            case 95: 
            case 104: 
            case 106: 
            case 111: 
            case 113: 
            case 119: 
            case 122: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 137: 
            case 144: {
                this.parseList = singleParamList;
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 84: 
            case 94: 
            case 102: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 142: 
            case 143: 
            case 145: {
                this.parseList = doubleParamList;
                break;
            }
            case 90: 
            case 91: 
            case 118: 
            case 126: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 107: 
            case 123: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 151: 
            case 152: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 96: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 93: {
                this.parseList = new short[]{786, 495, 772};
                break;
            }
            case 110: {
                this.parseList = new short[]{786, 788, 130, 788, 842, 2, 115, 788, 772};
                break;
            }
            case 133: {
                this.parseList = new short[]{786, 788, 842, 4, 841, 2, 338, 389, 842, 5, 451, 841, 2, 401, 430, 772};
                break;
            }
            case 139: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 140: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 103: 
            case 121: 
            case 138: 
            case 149: 
            case 150: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 112: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    public void setArguments(Expression[] nodes) {
        switch (this.funcType) {
            case 1: {
                Expression[] newNodes = new Expression[4];
                newNodes[0] = nodes[0];
                newNodes[1] = nodes[1];
                newNodes[3] = nodes[2];
                nodes = newNodes;
                break;
            }
            case 32: {
                Expression start = nodes[1];
                Expression length = nodes[2];
                nodes[1] = nodes[3];
                nodes[2] = start;
                nodes[3] = length;
                break;
            }
            case 5: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[0]};
                nodes = newNodes;
                break;
            }
            case 31: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), nodes[0]};
                nodes = newNodes;
            }
        }
        super.setArguments(nodes);
    }

    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 81: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, data);
            }
            case 85: {
                return session.getDatabase().getPath();
            }
            case 87: {
                return session.getDatabase().getUniqueName();
            }
            case 97: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 101: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 99: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 100: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 98: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 128: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 86: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 146: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 141: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 129: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 88: {
                int sec = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(sec, 0);
            }
            case 89: {
                return "2.2.5";
            }
            case 127: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 147: {
                return session.transactionTimestamp;
            }
            case 148: {
                return (long)session.actionIndex;
            }
            case 104: {
                LobData lob = (LobData)data[0];
                if (lob == null) {
                    return null;
                }
                return lob.getId();
            }
            case 96: {
                Number id = session.getLastIdentity();
                if (id instanceof Long) {
                    return id;
                }
                return ValuePool.getLong(id.longValue());
            }
            case 93: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 126: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                HsqlArrayList list = new HsqlArrayList();
                Object current = data[0];
                Type type = this.nodes[0].getDataType();
                boolean ascending = type.compare(session, data[1], data[0]) >= 0;
                while (true) {
                    int compare = type.compare(session, current, data[1]);
                    if (ascending ? compare > 0 : compare < 0) break;
                    list.add(current);
                    Object newValue = type.add(current, data[2], this.nodes[2].getDataType());
                    compare = type.compare(session, current, newValue);
                    if (ascending ? compare >= 0 : compare <= 0) break;
                    current = newValue;
                }
                Object[] array = list.toArray();
                return array;
            }
            case 139: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                int part = ((Number)this.nodes[0].valueData).intValue();
                long units = ((Number)data[1]).longValue();
                TimestampData source = (TimestampData)data[2];
                switch (part) {
                    case 831: {
                        long seconds = units / 1000000000L;
                        int nanos = (int)(units % 1000000000L);
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 832: {
                        long seconds = units / 1000L;
                        int nanos = (int)(units % 1000L) * 1000000;
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 833: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalSeconds(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 834: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalMinute(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 835: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalHour(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 836: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 837: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units * 7L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 838: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 839: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 3L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 840: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 12L, t);
                        return this.dataType.add(source, o, t);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 140: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                TimestampData a = (TimestampData)data[2];
                TimestampData b = (TimestampData)data[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    a = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, a, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    b = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, b, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (part) {
                    case 831: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000000000L * interval.getSeconds() + (long)interval.getNanos());
                    }
                    case 832: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000L * interval.getSeconds() + (long)(interval.getNanos() / 1000000));
                    }
                    case 833: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 834: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 835: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 836: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 837: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 7L);
                    }
                    case 838: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 839: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 3L);
                    }
                    case 840: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 121: 
            case 149: {
                int interval = 103;
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType type = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (data[1] == null) {
                            return null;
                        }
                        interval = HsqlDateTime.toStandardIntervalPart((String)data[1]);
                    }
                    if (interval < 0) {
                        throw Error.error(5566, (String)data[1]);
                    }
                    return this.funcType == 121 ? type.round(data[0], interval) : type.truncate(data[0], interval);
                }
            }
            case 150: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                    offset = ((Number)data[1]).intValue();
                }
                return this.funcType == 121 ? ((NumberType)this.dataType).round(data[0], offset) : ((NumberType)this.dataType).truncate(data[0], offset);
            }
            case 142: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, data[0]);
                return HsqlDateTime.toFormattedDate(date, (String)data[1], format);
            }
            case 144: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 143: 
            case 145: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                Date date = HsqlDateTime.toDate((String)data[0], (String)data[1], format);
                long millis = date.getTime();
                int nanos = 0;
                if (this.funcType == 143) {
                    millis = HsqlDateTime.convertToNormalisedDate(millis, format.getCalendar());
                } else {
                    nanos = (int)(millis % 1000L) * 100000;
                }
                return new TimestampData(millis / 1000L, nanos);
            }
            case 138: {
                boolean unary;
                boolean bl = unary = this.nodes[1] == null;
                if (data[0] == null) {
                    return null;
                }
                if (unary) {
                    return Type.SQL_TIMESTAMP.convertToType(session, data[0], this.nodes[0].dataType);
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData date = (TimestampData)Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                TimeData time = (TimeData)Type.SQL_TIME.convertToType(session, data[1], this.nodes[1].dataType);
                return new TimestampData(date.getSeconds() + (long)time.getSeconds(), time.getNanos());
            }
            case 109: {
                return new Double(Math.PI);
            }
            case 112: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                long seed = ((Number)data[0]).longValue();
                return new Double(session.random(seed));
            }
            case 151: {
                if (this.nodes[0] == null) {
                    UUID uuid = UUID.randomUUID();
                    long hi = uuid.getMostSignificantBits();
                    long lo = uuid.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
                }
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isBinaryType()) {
                    return new BinaryData(StringConverter.toBinaryUUID((String)data[0]), false);
                }
                return StringConverter.toStringUUID(((BinaryData)data[0]).getBytes());
            }
            case 152: {
                if (this.nodes[0] == null) {
                    TimestampData ts = session.getCurrentTimestamp(false);
                    return ts.getSeconds();
                }
                if (data[0] == null) {
                    return null;
                }
                return ((TimestampData)data[0]).getSeconds();
            }
            case 71: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.acos(d));
            }
            case 74: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.asin(d));
            }
            case 75: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.atan(d));
            }
            case 82: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.cos(d));
            }
            case 83: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                double c = 1.0 / Math.tan(d);
                return new Double(c);
            }
            case 92: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.toDegrees(d));
            }
            case 131: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.sin(d));
            }
            case 137: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.tan(d));
            }
            case 106: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.log10(d));
            }
            case 111: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.toRadians(d));
            }
            case 130: {
                if (data[0] == null) {
                    return null;
                }
                int val = ((NumberType)this.nodes[0].dataType).compareToZero(data[0]);
                return ValuePool.getInt(val);
            }
            case 76: {
                if (data[0] == null) {
                    return null;
                }
                double a = NumberType.toDouble(data[0]);
                double b = NumberType.toDouble(data[1]);
                return new Double(Math.atan2(a, b));
            }
            case 73: {
                if (data[0] == null) {
                    return null;
                }
                String arg = this.nodes[0].dataType.isLobType() ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                if (arg.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(arg.charAt(0));
            }
            case 80: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int arg = ((Number)data[0]).intValue();
                if (Character.isValidCodePoint(arg) && Character.isValidCodePoint((char)arg)) {
                    return String.valueOf((char)arg);
                }
                throw Error.error(3472);
            }
            case 122: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    offset = ((Number)data[1]).intValue();
                }
                return ((NumberType)this.dataType).round(data[0], offset);
            }
            case 132: {
                if (data[0] == null) {
                    return null;
                }
                String s = (String)data[0];
                return new String(FunctionCustom.soundex(s), 0, 4);
            }
            case 77: 
            case 78: 
            case 79: {
                byte[] v;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                    data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                    long v2 = 0L;
                    long a = ((Number)data[0]).longValue();
                    long b = ((Number)data[1]).longValue();
                    switch (this.funcType) {
                        case 77: {
                            v2 = a & b;
                            break;
                        }
                        case 78: {
                            v2 = a | b;
                            break;
                        }
                        case 79: {
                            v2 = a ^ b;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(v2);
                        }
                        case 25: {
                            return ValuePool.getLong(v2);
                        }
                        case 4: {
                            return ValuePool.getInt((int)v2);
                        }
                        case 5: {
                            return ValuePool.getInt((int)v2 & 0xFFFF);
                        }
                        case -6: {
                            return ValuePool.getInt((int)v2 & 0xFF);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] a = ((BinaryData)data[0]).getBytes();
                byte[] b = ((BinaryData)data[1]).getBytes();
                switch (this.funcType) {
                    case 77: {
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 78: {
                        v = BitMap.or(a, b);
                        break;
                    }
                    case 79: {
                        v = BitMap.xor(a, b);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(v, this.dataType.precision);
            }
            case 94: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                char[] s1 = FunctionCustom.soundex((String)data[0]);
                char[] s2 = FunctionCustom.soundex((String)data[1]);
                int e = 0;
                if (s1[0] == s2[0]) {
                    ++e;
                }
                if (e == 4) {
                    return ValuePool.getInt(e);
                }
                int js = 1;
                for (int i = 1; i < 4; ++i) {
                    for (int j = js; j < 4; ++j) {
                        if (s1[j] != s2[i]) continue;
                        ++e;
                        ++i;
                        ++js;
                    }
                }
                e = 0;
                return ValuePool.getInt(e);
            }
            case 95: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 113: {
                if (data[0] == null) {
                    return null;
                }
                BlobData binary = (BlobData)data[0];
                byte[] bytes = binary.getBytes(session, 0L, (int)binary.length(session));
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 117: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                String string = (String)data[0];
                int i = ((Number)data[1]).intValue();
                StringBuffer sb = new StringBuffer(string.length() * i);
                while (i-- > 0) {
                    sb.append(string);
                }
                return sb.toString();
            }
            case 118: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                String string = (String)data[0];
                String find = (String)data[1];
                String replace = (String)data[2];
                StringBuffer sb = new StringBuffer();
                int start = 0;
                while (true) {
                    int i;
                    if ((i = string.indexOf(find, start)) == -1) break;
                    sb.append(string.substring(start, i));
                    sb.append(replace);
                    start = i + find.length();
                }
                sb.append(string.substring(start));
                return sb.toString();
            }
            case 102: 
            case 120: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                int count = ((Number)data[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, data[0], 0L, count, true, this.funcType == 120);
            }
            case 134: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int count = ((Number)data[0]).intValue();
                char[] array = new char[count];
                ArrayUtil.fillArray(array, 0, ' ');
                return String.valueOf(array);
            }
            case 119: {
                if (data[0] == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer((String)data[0]);
                sb = sb.reverse();
                return sb.toString();
            }
            case 114: 
            case 115: 
            case 116: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                Pattern currentPattern = this.pattern;
                if (currentPattern == null) {
                    String matchPattern = (String)data[1];
                    currentPattern = Pattern.compile(matchPattern);
                }
                Matcher matcher = currentPattern.matcher((String)data[0]);
                switch (this.funcType) {
                    case 114: {
                        boolean match = matcher.matches();
                        return match;
                    }
                    case 115: {
                        boolean match = matcher.find();
                        if (match) {
                            return matcher.group();
                        }
                        return null;
                    }
                    case 116: {
                        HsqlArrayList list = new HsqlArrayList();
                        while (matcher.find()) {
                            list.add(matcher.group());
                        }
                        return list.toArray();
                    }
                }
            }
            case 84: {
                byte[] bytes = Crypto.getNewKey((String)data[0], (String)data[1]);
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 103: {
                String fileName = (String)data[0];
                if (fileName == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(fileName, (String)data[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(fileName);
            }
            case 107: 
            case 123: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                String value = this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isLobType() ? (String)data[0] : this.nodes[0].dataType.convertToString(data[0]);
                int length = (Integer)Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].dataType);
                String pad = " ";
                if (this.nodes[2] != null && (pad = this.nodes[2].dataType.convertToString(data[2])).length() == 0) {
                    pad = " ";
                }
                value = (String)Type.SQL_VARCHAR.trim(session, value, 32, true, true);
                value = StringUtil.toPaddedString(value, length, pad, this.funcType == 123);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, value, Type.SQL_VARCHAR);
                }
                return value;
            }
            case 110: {
                if (data[1] == null) {
                    return null;
                }
                if (data[2] == null) {
                    return null;
                }
                Object[] array = (Object[])data[1];
                ArrayType dt = (ArrayType)this.nodes[1].dataType;
                Type elementType = dt.collectionBaseType();
                int start = ((Number)Type.SQL_INTEGER.convertToType(session, data[2], this.nodes[2].dataType)).intValue();
                if (start <= 0) {
                    throw Error.error(3403);
                }
                for (int i = --start; i < array.length; ++i) {
                    if (elementType.compare(session, data[0], array[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 133: {
                if (data[0] == null) {
                    return null;
                }
                ArrayType dt = (ArrayType)this.dataType;
                SortAndSlice exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                exprSort.sortDescending[0] = ((Number)data[1]).intValue() == 389;
                exprSort.sortNullsLast[0] = ((Number)data[2]).intValue() == 430;
                Object array = ArrayUtil.duplicateArray(data[0]);
                dt.sort(session, array, exprSort);
                return array;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, parent);
                return;
            }
            case 85: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 87: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 97: 
            case 99: 
            case 100: 
            case 101: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 86: 
            case 89: 
            case 98: 
            case 128: 
            case 146: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 88: 
            case 129: 
            case 141: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 96: 
            case 104: 
            case 127: 
            case 147: 
            case 148: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 93: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), 0x100000);
                return;
            }
            case 90: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                int part = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 139;
            }
            case 139: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 91: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                int part = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 140;
            }
            case 140: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block46 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode != 91) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 836: 
                            case 837: 
                            case 838: 
                            case 839: 
                            case 840: {
                                break block46;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode == 93 || this.nodes[2].dataType.typeCode == 95) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 121: 
            case 149: {
                boolean single;
                boolean bl = single = this.nodes.length == 1 || this.nodes[1] == null;
                if (this.nodes[0].dataType == null) {
                    if (single) {
                        this.nodes[0].dataType = Type.SQL_DECIMAL;
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (!single && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 150: {
                Number offset = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    offset = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        offset = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (offset != null) {
                    int scale = offset;
                    if (scale < 0) {
                        scale = 0;
                    } else if (scale > this.dataType.scale) {
                        scale = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && scale != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)scale, scale);
                    }
                }
                return;
            }
            case 142: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 144: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 143: 
            case 145: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = this.funcType == 143 ? Type.SQL_DATE : Type.SQL_TIMESTAMP;
                return;
            }
            case 138: {
                Type argType = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (argType == null) {
                        argType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!argType.isCharacterType() && argType.typeCode != 93 && argType.typeCode != 95) {
                        throw Error.error(5561);
                    }
                } else {
                    if (argType == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            argType = this.nodes[1].dataType;
                        } else {
                            argType = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (argType.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (argType.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(argType.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || argType.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 109: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 151: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_16;
                    break;
                }
                throw Error.error(5563);
            }
            case 152: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 112: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 92: 
            case 106: 
            case 111: 
            case 122: 
            case 131: 
            case 137: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 130: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 76: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType != null) continue;
                    this.nodes[i].dataType = Type.SQL_INTEGER;
                }
                this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 80: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 94: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 95: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 113: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 117: {
                boolean isChar;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!(isChar = this.nodes[0].dataType.isCharacterType()) && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = isChar ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 118: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 102: 
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 134: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 119: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 114: 
            case 115: 
            case 116: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String matchPattern = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(matchPattern);
                }
                switch (this.funcType) {
                    case 114: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break;
                    }
                    case 115: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break;
                    }
                    case 116: {
                        this.dataType = Type.getDefaultArrayType(12);
                    }
                }
                break;
            }
            case 84: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 107: 
            case 123: {
                Number value;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (value = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(value.longValue());
                break;
            }
            case 110: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = ((ArrayType)this.nodes[1].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[1].dataType).collectionBaseType().typeComparisonGroup != this.nodes[0].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 133: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(338), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(401), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer sb = new StringBuffer("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 107: 
            case 123: {
                StringBuffer sb = new StringBuffer(this.name);
                sb.append("(").append(this.nodes[0].getSQL());
                sb.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(",").append(this.nodes[2].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 110: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(' ').append("IN");
                sb.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    sb.append(' ').append("FROM");
                    sb.append(' ').append(this.nodes[2].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 133: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    sb.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 430) {
                    sb.append(' ').append("NULLS").append(' ');
                    sb.append("LAST");
                }
                sb.append(')');
                return sb.toString();
            }
            case 72: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 146: 
            case 147: 
            case 148: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 139: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 140: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 112: 
            case 152: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    sb.append(this.nodes[0].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 103: 
            case 121: 
            case 144: 
            case 149: 
            case 150: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (this.nodes[0] != null) {
                    sb.append(',').append(this.nodes[0].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 82: 
            case 83: 
            case 92: 
            case 95: 
            case 104: 
            case 106: 
            case 111: 
            case 113: 
            case 119: 
            case 122: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 137: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 84: 
            case 94: 
            case 102: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 138: 
            case 142: 
            case 143: 
            case 145: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 93: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append("ROW_COUNT");
                sb.append(')');
                return sb.toString();
            }
            case 118: 
            case 126: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
        }
        return super.getSQL();
    }

    public static char[] soundex(String s) {
        if (s == null) {
            return null;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return b;
    }

    int getTSIToken(String string) {
        int part;
        if ("yy".equalsIgnoreCase(string)) {
            part = 840;
        } else if ("mm".equalsIgnoreCase(string)) {
            part = 838;
        } else if ("dd".equalsIgnoreCase(string)) {
            part = 836;
        } else if ("hh".equalsIgnoreCase(string)) {
            part = 835;
        } else if ("mi".equalsIgnoreCase(string)) {
            part = 834;
        } else if ("ss".equalsIgnoreCase(string)) {
            part = 833;
        } else if ("ms".equalsIgnoreCase(string)) {
            part = 832;
        } else {
            throw Error.error(5566, string);
        }
        return part;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(84);
        nonDeterministicFuncSet.add(85);
        nonDeterministicFuncSet.add(86);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(96);
        nonDeterministicFuncSet.add(97);
        nonDeterministicFuncSet.add(101);
        nonDeterministicFuncSet.add(99);
        nonDeterministicFuncSet.add(100);
        nonDeterministicFuncSet.add(98);
        nonDeterministicFuncSet.add(127);
        nonDeterministicFuncSet.add(128);
        nonDeterministicFuncSet.add(129);
        nonDeterministicFuncSet.add(138);
        nonDeterministicFuncSet.add(141);
        nonDeterministicFuncSet.add(146);
        nonDeterministicFuncSet.add(147);
        nonDeterministicFuncSet.add(148);
        nonDeterministicFuncSet.add(151);
        nonDeterministicFuncSet.add(152);
        customRegularFuncMap.put(640, 71);
        customRegularFuncMap.put(641, 72);
        customRegularFuncMap.put(642, 133);
        customRegularFuncMap.put(643, 73);
        customRegularFuncMap.put(644, 74);
        customRegularFuncMap.put(645, 75);
        customRegularFuncMap.put(646, 76);
        customRegularFuncMap.put(648, 77);
        customRegularFuncMap.put(649, 6);
        customRegularFuncMap.put(650, 78);
        customRegularFuncMap.put(651, 79);
        customRegularFuncMap.put(33, 80);
        customRegularFuncMap.put(652, 80);
        customRegularFuncMap.put(653, 81);
        customRegularFuncMap.put(654, 82);
        customRegularFuncMap.put(655, 83);
        customRegularFuncMap.put(656, 84);
        customRegularFuncMap.put(657, 43);
        customRegularFuncMap.put(658, 51);
        customRegularFuncMap.put(580, 85);
        customRegularFuncMap.put(660, 87);
        customRegularFuncMap.put(659, 86);
        customRegularFuncMap.put(661, 88);
        customRegularFuncMap.put(662, 89);
        customRegularFuncMap.put(663, 90);
        customRegularFuncMap.put(664, 91);
        customRegularFuncMap.put(73, 5);
        customRegularFuncMap.put(669, 5);
        customRegularFuncMap.put(670, 5);
        customRegularFuncMap.put(671, 5);
        customRegularFuncMap.put(672, 5);
        customRegularFuncMap.put(674, 92);
        customRegularFuncMap.put(391, 93);
        customRegularFuncMap.put(675, 94);
        customRegularFuncMap.put(677, 95);
        customRegularFuncMap.put(127, 5);
        customRegularFuncMap.put(128, 96);
        customRegularFuncMap.put(135, 32);
        customRegularFuncMap.put(681, 97);
        customRegularFuncMap.put(682, 99);
        customRegularFuncMap.put(683, 100);
        customRegularFuncMap.put(684, 101);
        customRegularFuncMap.put(685, 98);
        customRegularFuncMap.put(687, 26);
        customRegularFuncMap.put(153, 102);
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(689, 103);
        customRegularFuncMap.put(696, 104);
        customRegularFuncMap.put(690, 1);
        customRegularFuncMap.put(692, 14);
        customRegularFuncMap.put(693, 106);
        customRegularFuncMap.put(694, 107);
        customRegularFuncMap.put(695, 31);
        customRegularFuncMap.put(169, 5);
        customRegularFuncMap.put(173, 5);
        customRegularFuncMap.put(698, 5);
        customRegularFuncMap.put(703, 8);
        customRegularFuncMap.put(704, 109);
        customRegularFuncMap.put(705, 110);
        customRegularFuncMap.put(706, 5);
        customRegularFuncMap.put(707, 111);
        customRegularFuncMap.put(708, 112);
        customRegularFuncMap.put(709, 113);
        customRegularFuncMap.put(710, 114);
        customRegularFuncMap.put(711, 115);
        customRegularFuncMap.put(712, 116);
        customRegularFuncMap.put(234, 117);
        customRegularFuncMap.put(713, 118);
        customRegularFuncMap.put(714, 119);
        customRegularFuncMap.put(240, 120);
        customRegularFuncMap.put(715, 121);
        customRegularFuncMap.put(716, 122);
        customRegularFuncMap.put(718, 123);
        customRegularFuncMap.put(717, 31);
        customRegularFuncMap.put(250, 5);
        customRegularFuncMap.put(719, 5);
        customRegularFuncMap.put(720, 126);
        customRegularFuncMap.put(721, 127);
        customRegularFuncMap.put(722, 128);
        customRegularFuncMap.put(723, 129);
        customRegularFuncMap.put(724, 130);
        customRegularFuncMap.put(725, 131);
        customRegularFuncMap.put(726, 133);
        customRegularFuncMap.put(727, 132);
        customRegularFuncMap.put(514, 134);
        customRegularFuncMap.put(729, 23);
        customRegularFuncMap.put(732, 137);
        customRegularFuncMap.put(282, 138);
        customRegularFuncMap.put(733, 139);
        customRegularFuncMap.put(734, 140);
        customRegularFuncMap.put(735, 141);
        customRegularFuncMap.put(736, 142);
        customRegularFuncMap.put(737, 143);
        customRegularFuncMap.put(738, 144);
        customRegularFuncMap.put(739, 145);
        customRegularFuncMap.put(742, 146);
        customRegularFuncMap.put(743, 147);
        customRegularFuncMap.put(744, 148);
        customRegularFuncMap.put(755, 149);
        customRegularFuncMap.put(295, 150);
        customRegularFuncMap.put(756, 27);
        customRegularFuncMap.put(757, 152);
        customRegularFuncMap.put(758, 151);
        customRegularFuncMap.put(759, 5);
        customRegularFuncMap.put(323, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(730, 52);
        customValueFuncMap.put(731, 50);
        customValueFuncMap.put(740, 43);
        customValueFuncMap.put(702, 52);
    }
}

