/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.types.Type;

public class ExpressionValue
extends Expression {
    ExpressionValue(Object o, Type datatype) {
        super(1);
        this.nodes = Expression.emptyArray;
        this.dataType = datatype;
        this.valueData = o;
    }

    public byte getNullability() {
        return this.valueData == null ? (byte)1 : 0;
    }

    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    Object getValue(Session session, Type type) {
        if (this.dataType == type || this.valueData == null) {
            return this.valueData;
        }
        return type.convertToType(session, this.valueData, this.dataType);
    }

    public Object getValue(Session session) {
        return this.valueData;
    }
}

