/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class ExpressionOp
extends Expression {
    static final ExpressionOp limitOneExpression = new ExpressionOp(95, new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER), new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER));

    ExpressionOp(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 37: 
            case 92: 
            case 93: 
            case 95: 
            case 96: {
                return;
            }
            case 84: {
                this.dataType = left.dataType;
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    ExpressionOp(Expression e, Type dataType) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        this.dataType = dataType;
        this.alias = e.alias;
    }

    ExpressionOp(Expression e) {
        super(e.dataType.isDateTimeTypeWithZone() ? 91 : 92);
        switch (e.dataType.typeCode) {
            case 94: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, e, null);
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(92, e.dataType.scale);
                break;
            }
            case 95: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, e, null);
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(93, e.dataType.scale);
                break;
            }
            case 92: {
                this.nodes = new Expression[2];
                this.nodes[0] = e;
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(94, e.dataType.scale);
                break;
            }
            case 93: {
                this.nodes = new Expression[2];
                this.nodes[0] = e;
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(95, e.dataType.scale);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        this.alias = e.alias;
    }

    public static Expression getCastExpression(Session session, Expression e, Type dataType) {
        if (e.getType() == 1) {
            Object value = dataType.castToType(session, e.getValue(session), e.getDataType());
            return new ExpressionValue(value, dataType);
        }
        return new ExpressionOp(e, dataType);
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionOp.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String right = ExpressionOp.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "ExpressionOp");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 37: {
                sb.append(' ').append("LIKE").append(' ');
                sb.append(left).append(' ').append(right).append(' ');
            }
            case 91: {
                sb.append(' ').append("CAST").append('(');
                sb.append(left).append(' ').append("AS").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(')');
                return sb.toString();
            }
            case 93: {
                sb.append(' ').append("CASEWHEN").append('(');
                sb.append(left).append(',').append(right).append(')');
                return sb.toString();
            }
            case 96: {
                sb.append(left).append(',').append(right);
                return sb.toString();
            }
            case 95: {
                if (left != null) {
                    sb.append(' ').append("OFFSET").append(' ');
                    sb.append(left).append(' ');
                }
                if (right == null) break;
                sb.append(' ').append("FETCH").append(' ');
                sb.append("FIRST");
                sb.append(right).append(' ').append(right).append(' ');
                sb.append("ROWS").append(' ').append("ONLY");
                sb.append(' ');
                break;
            }
            case 92: {
                sb.append(left).append(' ').append("AT").append(' ');
                if (this.nodes[1] == null) {
                    sb.append("LOCAL").append(' ');
                    break;
                }
                sb.append("TIME").append(' ').append("ZONE");
                sb.append(' ');
                sb.append(right);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE").append(' ').append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 37: {
                sb.append("LIKE").append(' ').append("ARG ");
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
                break;
            }
            case 26: {
                sb.append("VALUE").append(' ').append("LIST ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                return sb.toString();
            }
            case 91: {
                sb.append("CAST").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
                break;
            }
            case 93: {
                sb.append("CASEWHEN").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.getRightNode() != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        switch (this.opType) {
            case 93: {
                acceptsSequences = false;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        switch (this.opType) {
            case 93: {
                break;
            }
            default: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    this.nodes[i].resolveTypes(session, this);
                }
            }
        }
        block3 : switch (this.opType) {
            case 1: {
                break;
            }
            case 37: {
                this.dataType = this.nodes[0].dataType;
                if (this.nodes[0].opType != 1 || this.nodes[1] != null && this.nodes[1].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 91: {
                Expression node = this.nodes[0];
                Type nodeType = node.dataType;
                if (nodeType != null && !this.dataType.canConvertFrom(nodeType)) {
                    throw Error.error(5561);
                }
                if (node.opType == 1) {
                    this.setAsConstantValue(session);
                    node.dataType = this.dataType;
                    node.valueData = this.valueData;
                    if (parent == null) break;
                    parent.replaceNode(this, node);
                    break;
                }
                if (this.nodes[0].opType != 8) break;
                node.dataType = this.dataType;
                break;
            }
            case 92: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                    }
                    if (this.nodes[1].dataType.typeCode != 111) {
                        if (this.nodes[1].opType == 1) {
                            this.nodes[1].valueData = Type.SQL_INTERVAL_HOUR_TO_MINUTE.castToType(session, this.nodes[1].valueData, this.nodes[1].dataType);
                            this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                        } else {
                            throw Error.error(5563);
                        }
                    }
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 92: {
                        this.dataType = DateTimeType.getDateTimeType(94, this.nodes[0].dataType.scale);
                        break block3;
                    }
                    case 93: {
                        this.dataType = DateTimeType.getDateTimeType(95, this.nodes[0].dataType.scale);
                        break block3;
                    }
                    case 94: 
                    case 95: {
                        this.dataType = this.nodes[0].dataType;
                        break block3;
                    }
                }
                throw Error.error(5563);
            }
            case 93: {
                this.resolveTypesForCaseWhen(session);
                break;
            }
            case 96: {
                break;
            }
            case 95: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        throw Error.error(5567);
                    }
                    if (!this.nodes[0].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                if (this.nodes[1] == null) break;
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType.isIntegralType()) break;
                throw Error.error(5563);
            }
            case 84: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
    }

    void resolveTypesForCaseWhen(Session session) {
        if (this.dataType != null) {
            return;
        }
        Expression expr = this;
        while (expr.opType == 93) {
            expr.nodes[0].resolveTypes(session, expr);
            if (expr.nodes[0].isUnresolvedParam()) {
                expr.nodes[0].dataType = Type.SQL_BOOLEAN;
            }
            expr.nodes[1].nodes[0].resolveTypes(session, expr.nodes[1]);
            if (expr.nodes[1].nodes[1].opType != 93) {
                expr.nodes[1].nodes[1].resolveTypes(session, expr.nodes[1]);
            }
            expr = expr.nodes[1].nodes[1];
        }
        if (this.exprSubType == 91 && this.nodes[1].nodes[1].dataType != null && this.nodes[1].nodes[1].dataType != this.nodes[1].nodes[0].dataType) {
            Type castType = this.nodes[1].nodes[1].dataType;
            if (castType.isCharacterType()) {
                castType = Type.SQL_VARCHAR_DEFAULT;
            }
            this.nodes[1].nodes[0] = new ExpressionOp(this.nodes[1].nodes[0], castType);
        }
        expr = this;
        while (expr.opType == 93) {
            this.dataType = Type.getAggregateType(expr.nodes[1].nodes[0].dataType, this.dataType);
            this.dataType = Type.getAggregateType(expr.nodes[1].nodes[1].dataType, this.dataType);
            expr = expr.nodes[1].nodes[1];
        }
        expr = this;
        while (expr.opType == 93) {
            if (expr.nodes[1].nodes[0].dataType == null) {
                expr.nodes[1].nodes[0].dataType = this.dataType;
            }
            if (expr.nodes[1].nodes[1].dataType == null) {
                expr.nodes[1].nodes[1].dataType = this.dataType;
            }
            if (expr.nodes[1].dataType == null) {
                expr.nodes[1].dataType = this.dataType;
            }
            expr = expr.nodes[1].nodes[1];
        }
        if (this.dataType == null) {
            throw Error.error(5567);
        }
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 37: {
                byte by;
                boolean hasEscape = this.nodes[1] != null;
                int n = Integer.MAX_VALUE;
                if (this.dataType.isBinaryType()) {
                    byte by2;
                    BinaryData left = (BinaryData)this.nodes[0].getValue(session);
                    if (left == null) {
                        return null;
                    }
                    if (hasEscape) {
                        BinaryData right = (BinaryData)this.nodes[1].getValue(session);
                        if (right == null) {
                            return null;
                        }
                        if (right.length(session) != 1L) {
                            throw Error.error(3412);
                        }
                        by2 = right.getBytes()[0];
                    }
                    byte[] array = left.getBytes();
                    byte[] newArray = new byte[array.length];
                    boolean wasEscape = false;
                    int escapeCount = 0;
                    int j = 0;
                    for (int i = 0; i < array.length; ++i) {
                        if (array[i] == by2) {
                            if (wasEscape) {
                                ++escapeCount;
                                newArray[j++] = array[i];
                                wasEscape = false;
                                continue;
                            }
                            wasEscape = true;
                            if (i != array.length - 1) continue;
                            throw Error.error(3458);
                        }
                        if (array[i] == 95 || array[i] == 37) {
                            if (!wasEscape) break;
                            ++escapeCount;
                            newArray[j++] = array[i];
                            wasEscape = false;
                            continue;
                        }
                        if (wasEscape) {
                            throw Error.error(3458);
                        }
                        newArray[j++] = array[i];
                    }
                    newArray = (byte[])ArrayUtil.resizeArrayIfDifferent(newArray, j);
                    return new BinaryData(newArray, false);
                }
                String left = (String)this.nodes[0].getValue(session);
                if (left == null) {
                    return null;
                }
                if (hasEscape) {
                    String right = (String)this.nodes[1].getValue(session);
                    if (right == null) {
                        return null;
                    }
                    if (right.length() != 1) {
                        throw Error.error(3439);
                    }
                    by = right.getBytes()[0];
                }
                char[] array = left.toCharArray();
                char[] newArray = new char[array.length];
                boolean wasEscape = false;
                int escapeCount = 0;
                int j = 0;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == by) {
                        if (wasEscape) {
                            ++escapeCount;
                            newArray[j++] = array[i];
                            wasEscape = false;
                            continue;
                        }
                        wasEscape = true;
                        if (i != array.length - 1) continue;
                        throw Error.error(3458);
                    }
                    if (array[i] == '_' || array[i] == '%') {
                        if (!wasEscape) break;
                        ++escapeCount;
                        newArray[j++] = array[i];
                        wasEscape = false;
                        continue;
                    }
                    if (wasEscape) {
                        throw Error.error(3458);
                    }
                    newArray[j++] = array[i];
                }
                return new String(newArray, 0, j);
            }
            case 5: {
                Object value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return value;
            }
            case 94: {
                return this.nodes[0].getValue(session);
            }
            case 84: {
                if (this.nodes[0].dataType.isCharacterType()) {
                    Object value = this.nodes[1].getValue(session);
                    CharacterType characterType = (CharacterType)this.nodes[1].dataType;
                    long length = ((CharacterType)this.nodes[1].dataType).size(session, value);
                    CharacterType characterType2 = (CharacterType)this.nodes[0].dataType;
                    value = this.nodes[0].getValue(session);
                    return characterType2.substring(session, value, 0L, length, true, false);
                }
                BinaryData value = (BinaryData)this.nodes[1].getValue(session);
                long l = value.length(session);
                BinaryType type = (BinaryType)this.nodes[0].dataType;
                value = (BinaryData)this.nodes[0].getValue(session);
                return type.substring(session, value, 0L, l, true);
            }
            case 91: {
                Object value = this.dataType.castToType(session, this.nodes[0].getValue(session), this.nodes[0].dataType);
                if (this.dataType.userTypeModifier != null) {
                    Constraint[] constraintArray = this.dataType.userTypeModifier.getConstraints();
                    for (int i = 0; i < constraintArray.length; ++i) {
                        constraintArray[i].checkCheckConstraint(session, null, null, value);
                    }
                }
                return value;
            }
            case 93: {
                Boolean result = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(result)) {
                    return this.nodes[1].nodes[0].getValue(session, this.dataType);
                }
                return this.nodes[1].nodes[1].getValue(session, this.dataType);
            }
            case 92: {
                Object object;
                Object leftValue = this.nodes[0].getValue(session);
                Object object2 = object = this.nodes[1] == null ? null : this.nodes[1].getValue(session);
                if (leftValue == null) {
                    return null;
                }
                if (this.nodes[1] != null && object == null) {
                    return null;
                }
                long zoneSeconds = this.nodes[1] == null ? (long)session.getZoneSeconds() : ((IntervalType)this.nodes[1].dataType).getSeconds(object);
                return ((DateTimeType)this.dataType).changeZone(leftValue, this.nodes[0].dataType, (int)zoneSeconds, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }
}

