/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.store.ValuePool;

public class ExpressionAggregate
extends Expression {
    boolean isDistinctAggregate;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionAggregate(int type, boolean distinct, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.isDistinctAggregate = distinct;
        this.nodes[0] = e;
    }

    boolean isSelfAggregate() {
        return true;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 71: {
                sb.append(' ').append("COUNT").append('(');
                break;
            }
            case 72: {
                sb.append(' ').append("SUM").append('(');
                sb.append(left).append(')');
                break;
            }
            case 73: {
                sb.append(' ').append("MIN").append('(');
                sb.append(left).append(')');
                break;
            }
            case 74: {
                sb.append(' ').append("MAX").append('(');
                sb.append(left).append(')');
                break;
            }
            case 75: {
                sb.append(' ').append("AVG").append('(');
                sb.append(left).append(')');
                break;
            }
            case 76: {
                sb.append(' ').append("EVERY").append('(');
                sb.append(left).append(')');
                break;
            }
            case 77: {
                sb.append(' ').append("SOME").append('(');
                sb.append(left).append(')');
                break;
            }
            case 78: {
                sb.append(' ').append("STDDEV_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 79: {
                sb.append(' ').append("STDDEV_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 80: {
                sb.append(' ').append("VAR_POP").append('(');
                sb.append(left).append(')');
                break;
            }
            case 81: {
                sb.append(' ').append("VAR_SAMP").append('(');
                sb.append(left).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 71: {
                sb.append("COUNT").append(' ');
                break;
            }
            case 72: {
                sb.append("SUM").append(' ');
                break;
            }
            case 73: {
                sb.append("MIN").append(' ');
                break;
            }
            case 74: {
                sb.append("MAX").append(' ');
                break;
            }
            case 75: {
                sb.append("AVG").append(' ');
                break;
            }
            case 76: {
                sb.append("EVERY").append(' ');
                break;
            }
            case 77: {
                sb.append("SOME").append(' ');
                break;
            }
            case 78: {
                sb.append("STDDEV_POP").append(' ');
                break;
            }
            case 79: {
                sb.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 80: {
                sb.append("VAR_POP").append(' ');
                break;
            }
            case 81: {
                sb.append("VAR_SAMP").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            sb.append(" arg=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.condition.resolveColumnReferences(session, rangeVarArray, rangeCount, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (unresolvedSet == null) {
            unresolvedSet = new ArrayListIdentity();
        }
        unresolvedSet.add(this);
        return unresolvedSet;
    }

    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate && this.nodes[0].dataType.isLobType()) {
            throw Error.error(5534);
        }
        this.dataType = SetFunction.getType(this.opType, this.nodes[0].dataType);
        this.condition.resolveTypes(session, null);
    }

    public boolean equals(Expression other) {
        if (!(other instanceof ExpressionAggregate)) {
            return false;
        }
        ExpressionAggregate o = (ExpressionAggregate)other;
        if (this.opType == other.opType && this.exprSubType == other.exprSubType && this.isDistinctAggregate == o.isDistinctAggregate && this.condition.equals(o.condition)) {
            return super.equals(other);
        }
        return false;
    }

    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        if (currValue == null) {
            currValue = new SetFunction(this.opType, this.nodes[0].dataType, this.isDistinctAggregate);
        }
        Integer newValue = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        ((SetFunction)currValue).add(session, newValue);
        return currValue;
    }

    public Object getAggregatedValue(Session session, Object currValue) {
        if (currValue == null) {
            return this.opType == 71 ? ValuePool.INTEGER_0 : null;
        }
        return ((SetFunction)currValue).getValue(session);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    public void setCondition(Expression e) {
        this.condition = e;
    }
}

