/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserCommand;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LobManager;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.PersistentStoreCollectionDatabase;
import org.hsqldb.result.Result;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;
import org.hsqldb.rights.UserManager;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Collation;

public class Database {
    int databaseID;
    String databaseUniqueName;
    String databaseType;
    private final String canonicalPath;
    public HsqlProperties urlProperties;
    private final String path;
    public Collation collation;
    public DatabaseInformation dbInfo;
    private volatile int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public boolean sqlEnforceTypes = false;
    public boolean sqlEnforceRefs = false;
    public boolean sqlEnforceSize = true;
    public boolean sqlEnforceNames = false;
    public boolean sqlEnforceTDCD = true;
    public boolean sqlEnforceTDCU = true;
    public boolean sqlTranslateTTI = true;
    public boolean sqlConcatNulls = true;
    public boolean sqlUniqueNulls = true;
    public boolean sqlConvertTruncate = true;
    public boolean sqlDoubleNaN = true;
    public boolean sqlLongvarIsLob = false;
    public boolean sqlSyntaxMss = false;
    public boolean sqlSyntaxMys = false;
    public boolean sqlSyntaxOra = false;
    public boolean sqlSyntaxPgs = false;
    private boolean isReferentialIntegrity = true;
    public HsqlDatabaseProperties databaseProperties;
    private final boolean shutdownOnNoConnection;
    int resultMaxMemoryRows;
    public UserManager userManager;
    public GranteeManager granteeManager;
    public HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    public int defaultIsolationLevel = 2;
    public boolean defaultDeadlockRollback = true;
    public SchemaManager schemaManager;
    public PersistentStoreCollectionDatabase persistentStoreCollection;
    public LobManager lobManager;
    public CheckpointRunner checkpointRunner;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 2;
    public static final int DATABASE_CLOSING = 3;
    public static final int DATABASE_SHUTDOWN = 4;
    public static final int CLOSEMODE_IMMEDIATELY = 1;
    public static final int CLOSEMODE_NORMAL = 2;
    public static final int CLOSEMODE_COMPACT = 3;
    public static final int CLOSEMODE_SCRIPT = 4;

    Database(String type, String path, String canonicalPath, HsqlProperties props) {
        this.setState(4);
        this.databaseType = type;
        this.path = path;
        this.canonicalPath = canonicalPath;
        this.urlProperties = props;
        if (this.databaseType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        this.logger = new Logger(this);
        this.shutdownOnNoConnection = this.urlProperties.isPropertyTrue("shutdown");
        this.lobManager = new LobManager(this);
    }

    synchronized void open() {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() {
        boolean isNew = false;
        this.setState(2);
        try {
            this.nameManager = new HsqlNameManager(this);
            this.granteeManager = new GranteeManager(this);
            this.userManager = new UserManager(this);
            this.schemaManager = new SchemaManager(this);
            this.persistentStoreCollection = new PersistentStoreCollectionDatabase();
            this.isReferentialIntegrity = true;
            this.sessionManager = new SessionManager(this);
            Database database = this;
            this.collation = database.collation.getDatabaseInstance();
            this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
            this.txManager = new TransactionManager2PL(this);
            this.lobManager.createSchema();
            this.sessionManager.getSysLobSession().setSchema("SYSTEM_LOBS");
            this.schemaManager.setSchemaChangeTimestamp();
            this.schemaManager.createSystemTables();
            this.logger.openPersistence();
            isNew = this.logger.isNewDatabase;
            if (isNew) {
                String username = this.urlProperties.getProperty("user", "SA");
                String password = this.urlProperties.getProperty("password", "");
                this.userManager.createFirstUser(username, password);
                this.schemaManager.createPublicSchema();
                this.lobManager.initialiseLobSpace();
                this.logger.checkpoint(false);
            }
            this.lobManager.open();
            this.dbInfo.setWithContent(true);
            this.checkpointRunner = new CheckpointRunner();
        }
        catch (Throwable e2) {
            HsqlException e2;
            this.logger.closePersistence(1);
            this.logger.releaseLock();
            this.setState(4);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (!(e2 instanceof HsqlException)) {
                e2 = Error.error(458, e2);
            }
            this.logger.logSevereEvent("could not reopen database", e2);
            throw e2;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.clearStructures();
        }
        this.granteeManager = null;
        this.userManager = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
        this.checkpointRunner = null;
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public String getUniqueName() {
        return this.databaseUniqueName;
    }

    public void setUniqueName(String name) {
        this.databaseUniqueName = name;
    }

    public String getType() {
        return this.databaseType;
    }

    public String getPath() {
        return this.path;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.nameManager.getCatalogName();
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isReadOnly() {
        return this.databaseReadOnly;
    }

    boolean isShutdown() {
        return this.dbState == 4;
    }

    synchronized Session connect(String username, String password, String zoneString, int timeZoneSeconds) {
        if (username.equalsIgnoreCase("SA")) {
            username = "SA";
        }
        User user = this.userManager.getUser(username, password);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, true, zoneString, timeZoneSeconds);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setReferentialIntegrity(boolean ref) {
        this.isReferentialIntegrity = ref;
    }

    public boolean isReferentialIntegrity() {
        return this.isReferentialIntegrity;
    }

    public int getResultMaxMemoryRows() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMaxMemoryRows(int size) {
        this.resultMaxMemoryRows = size;
    }

    public void setStrictNames(boolean mode) {
        this.sqlEnforceNames = mode;
    }

    public void setStrictColumnSize(boolean mode) {
        this.sqlEnforceSize = mode;
    }

    public void setStrictReferences(boolean mode) {
        this.sqlEnforceRefs = mode;
    }

    public void setStrictTypes(boolean mode) {
        this.sqlEnforceTypes = mode;
    }

    public void setStrictTDCD(boolean mode) {
        this.sqlEnforceTDCD = mode;
    }

    public void setStrictTDCU(boolean mode) {
        this.sqlEnforceTDCU = mode;
    }

    public void setTranslateTTI(boolean mode) {
        this.sqlTranslateTTI = mode;
    }

    public void setConcatNulls(boolean mode) {
        this.sqlConcatNulls = mode;
    }

    public void setUniqueNulls(boolean mode) {
        this.sqlUniqueNulls = mode;
    }

    public void setConvertTrunc(boolean mode) {
        this.sqlConvertTruncate = mode;
    }

    public void setDoubleNaN(boolean mode) {
        this.sqlDoubleNaN = mode;
    }

    public void setLongVarIsLob(boolean mode) {
        this.sqlLongvarIsLob = mode;
    }

    public void setSyntaxMss(boolean mode) {
        this.sqlSyntaxMss = mode;
    }

    public void setSyntaxOra(boolean mode) {
        this.sqlSyntaxOra = mode;
    }

    public void setSyntaxMys(boolean mode) {
        this.sqlSyntaxMys = mode;
    }

    public void setSyntaxPgs(boolean mode) {
        this.sqlSyntaxPgs = mode;
    }

    protected void finalize() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.close(1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void closeIfLast() {
        if (this.shutdownOnNoConnection && this.sessionManager.isEmpty()) {
            if (this.dbState == 1) {
                try {
                    this.close(2);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closemode) {
        HsqlException he = null;
        Database database = this;
        synchronized (database) {
            if (this.getState() != 1) {
                return;
            }
            this.setState(3);
        }
        this.sessionManager.closeAllSessions();
        if (this.filesReadOnly) {
            closemode = 1;
        }
        this.logger.closePersistence(closemode);
        this.lobManager.close();
        this.sessionManager.close();
        try {
            if (closemode == 3) {
                this.clearStructures();
                this.reopen();
                this.setState(3);
                this.logger.closePersistence(2);
                this.lobManager.close();
            }
        }
        catch (Throwable t) {
            he = t instanceof HsqlException ? (HsqlException)t : Error.error(458, t);
        }
        this.checkpointRunner.stop();
        this.logger.releaseLock();
        this.setState(4);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        FrameworkLogger.clearLoggers("hsqldb.db." + this.getUniqueName());
        if (he != null) {
            throw he;
        }
    }

    private void setState(int state) {
        this.dbState = state;
    }

    int getState() {
        return this.dbState;
    }

    String getStateString() {
        int state = this.getState();
        switch (state) {
            case 3: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 2: {
                return "DATABASE_OPENING";
            }
            case 4: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String[] getSettingsSQL() {
        String name;
        HsqlArrayList list = new HsqlArrayList();
        if (!this.getCatalogName().name.equals("PUBLIC")) {
            name = this.getCatalogName().statementName;
            list.add("ALTER CATALOG PUBLIC RENAME TO " + name);
        }
        if (!this.collation.isDefaultCollation()) {
            name = this.collation.getName().statementName;
            list.add("SET DATABASE COLLATION " + name);
        }
        HashMappedList lobTables = this.schemaManager.getTables("SYSTEM_LOBS");
        for (int i = 0; i < lobTables.size(); ++i) {
            Table table = (Table)lobTables.get(i);
            if (!table.isCached()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("SET").append(' ').append("TABLE");
            sb.append(' ');
            sb.append(table.getName().getSchemaQualifiedStatementName());
            sb.append(' ').append("TYPE").append(' ');
            sb.append("CACHED");
            list.add(sb.toString());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public Result getScript(boolean indexRoots) {
        Result r = Result.newSingleColumnResult("COMMAND");
        String[] list = this.logger.getPropertiesSQL();
        Database.addRows(r, list);
        list = this.getSettingsSQL();
        Database.addRows(r, list);
        list = this.getGranteeManager().getSQL();
        Database.addRows(r, list);
        list = this.schemaManager.getSQLArray();
        Database.addRows(r, list);
        list = this.schemaManager.getCommentsArray();
        Database.addRows(r, list);
        if (indexRoots) {
            list = this.schemaManager.getIndexRootsSQL();
            Database.addRows(r, list);
        }
        list = this.schemaManager.getTablePropsSQL(!indexRoots);
        Database.addRows(r, list);
        list = this.getUserManager().getAuthenticationSQL();
        Database.addRows(r, list);
        list = this.getUserManager().getInitialSchemaSQL();
        Database.addRows(r, list);
        list = this.getGranteeManager().getRightstSQL();
        Database.addRows(r, list);
        return r;
    }

    private static void addRows(Result r, String[] sql) {
        if (sql == null) {
            return;
        }
        for (int i = 0; i < sql.length; ++i) {
            Object[] s = new String[]{sql[i]};
            r.initialiseNavigator().add(s);
        }
    }

    public String getURI() {
        return this.databaseType + this.canonicalPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }

    class CheckpointRunner
    implements Runnable {
        private volatile boolean waiting;
        private Object timerTask;

        CheckpointRunner() {
        }

        public void run() {
            try {
                Session sysSession = Database.this.sessionManager.newSysSession();
                Statement checkpoint = ParserCommand.getAutoCheckpointStatement(Database.this);
                sysSession.executeCompiledStatement(checkpoint, ValuePool.emptyObjectArray);
                sysSession.close();
                this.waiting = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            if (!Database.this.logger.isLogged()) {
                return;
            }
            CheckpointRunner checkpointRunner = this;
            synchronized (checkpointRunner) {
                if (this.waiting) {
                    return;
                }
                this.waiting = true;
            }
            this.timerTask = DatabaseManager.getTimer().scheduleAfter(0L, this);
        }

        public void stop() {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
            this.waiting = false;
        }
    }
}

