/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.edit;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.MapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDPageContentStream {
    private static final Log log = LogFactory.getLog(PDPageContentStream.class);
    private PDPage page;
    private OutputStream output;
    private boolean inTextMode = false;
    private Map<PDFont, String> fontMappings;
    private Map<PDXObject, String> xobjectMappings;
    private PDResources resources;
    private Map fonts;
    private Map xobjects;
    private PDColorSpace currentStrokingColorSpace = new PDDeviceGray();
    private PDColorSpace currentNonStrokingColorSpace = new PDDeviceGray();
    private float[] colorComponents = new float[4];
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private static final String BEGIN_TEXT = "BT\n";
    private static final String END_TEXT = "ET\n";
    private static final String SET_FONT = "Tf\n";
    private static final String MOVE_TEXT_POSITION = "Td\n";
    private static final String SET_TEXT_MATRIX = "Tm\n";
    private static final String SHOW_TEXT = "Tj\n";
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String RG_STROKING = "RG\n";
    private static final String RG_NON_STROKING = "rg\n";
    private static final String K_STROKING = "K\n";
    private static final String K_NON_STROKING = "k\n";
    private static final String G_STROKING = "G\n";
    private static final String G_NON_STROKING = "g\n";
    private static final String RECTANGLE = "re\n";
    private static final String FILL_NON_ZERO = "f\n";
    private static final String FILL_EVEN_ODD = "f*\n";
    private static final String LINE_TO = "l\n";
    private static final String MOVE_TO = "m\n";
    private static final String CLOSE_STROKE = "s\n";
    private static final String STROKE = "S\n";
    private static final String LINE_WIDTH = "w\n";
    private static final String CLOSE_SUBPATH = "h\n";
    private static final String CLIP_PATH_NON_ZERO = "W\n";
    private static final String CLIP_PATH_EVEN_ODD = "W*\n";
    private static final String NOP = "n\n";
    private static final String BEZIER_312 = "c\n";
    private static final String BEZIER_32 = "v\n";
    private static final String BEZIER_313 = "y\n";
    private static final String MP = "MP\n";
    private static final String DP = "DP\n";
    private static final String BMC = "BMC\n";
    private static final String BDC = "BDC\n";
    private static final String EMC = "EMC\n";
    private static final String SET_STROKING_COLORSPACE = "CS\n";
    private static final String SET_NON_STROKING_COLORSPACE = "cs\n";
    private static final String SET_STROKING_COLOR_SIMPLE = "SC\n";
    private static final String SET_STROKING_COLOR_COMPLEX = "SCN\n";
    private static final String SET_NON_STROKING_COLOR_SIMPLE = "sc\n";
    private static final String SET_NON_STROKING_COLOR_COMPLEX = "scn\n";
    private static final int SPACE = 32;

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, false, true);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress) throws IOException {
        this(document, sourcePage, appendContent, compress, false);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress, boolean resetContext) throws IOException {
        boolean hasContent;
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
            this.page.setResources(this.resources);
        }
        this.fonts = this.resources.getFonts();
        this.fontMappings = this.reverseMap(this.fonts, PDFont.class);
        this.xobjects = this.resources.getXObjects();
        this.xobjectMappings = this.reverseMap(this.xobjects, PDXObject.class);
        PDStream contents = sourcePage.getContents();
        boolean bl = hasContent = contents != null;
        if (appendContent && hasContent) {
            PDStream contentsToAppend = new PDStream(document);
            COSStreamArray compoundStream = null;
            if (contents.getStream() instanceof COSStreamArray) {
                compoundStream = (COSStreamArray)contents.getStream();
                compoundStream.appendStream(contentsToAppend.getStream());
            } else {
                COSArray newArray = new COSArray();
                newArray.add(contents.getCOSObject());
                newArray.add(contentsToAppend.getCOSObject());
                compoundStream = new COSStreamArray(newArray);
            }
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contentsToAppend.setFilters(filters);
            }
            if (resetContext) {
                PDStream saveGraphics = new PDStream(document);
                this.output = saveGraphics.createOutputStream();
                this.saveGraphicsState();
                this.close();
                if (compress) {
                    ArrayList<COSName> filters = new ArrayList<COSName>();
                    filters.add(COSName.FLATE_DECODE);
                    saveGraphics.setFilters(filters);
                }
                compoundStream.insertCOSStream(saveGraphics);
            }
            sourcePage.setContents(new PDStream(compoundStream));
            this.output = contentsToAppend.createOutputStream();
            if (resetContext) {
                this.restoreGraphicsState();
            }
        } else {
            if (hasContent) {
                log.warn("You are overwriting an existing content, you should use the append mode");
            }
            contents = new PDStream(document);
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contents.setFilters(filters);
            }
            sourcePage.setContents(contents);
            this.output = contents.createOutputStream();
        }
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    private <T> Map<T, String> reverseMap(Map map, Class<T> keyClass) {
        HashMap<T, String> reversed = new HashMap<T, String>();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            reversed.put(keyClass.cast(entry.getValue()), (String)entry.getKey());
        }
        return reversed;
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.appendRawCommands(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.appendRawCommands(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        String fontMapping = this.fontMappings.get(font);
        if (fontMapping == null) {
            fontMapping = MapUtil.getNextUniqueKey(this.fonts, "F");
            this.fontMappings.put(font, fontMapping);
            this.fonts.put(fontMapping, font);
        }
        this.appendRawCommands("/");
        this.appendRawCommands(fontMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(fontSize));
        this.appendRawCommands(32);
        this.appendRawCommands(SET_FONT);
    }

    public void drawImage(PDXObjectImage image, float x, float y) throws IOException {
        this.drawXObject(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawXObject(PDXObject xobject, float x, float y, float width, float height) throws IOException {
        AffineTransform transform = new AffineTransform(width, 0.0f, 0.0f, height, x, y);
        this.drawXObject(xobject, transform);
    }

    public void drawXObject(PDXObject xobject, AffineTransform transform) throws IOException {
        String xObjectPrefix = null;
        xObjectPrefix = xobject instanceof PDXObjectImage ? "Im" : "Form";
        String objMapping = this.xobjectMappings.get(xobject);
        if (objMapping == null) {
            objMapping = MapUtil.getNextUniqueKey(this.xobjects, xObjectPrefix);
            this.xobjectMappings.put(xobject, objMapping);
            this.xobjects.put(objMapping, xobject);
        }
        this.saveGraphicsState();
        this.appendRawCommands(32);
        this.concatenate2CTM(transform);
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(objMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(XOBJECT_DO);
        this.restoreGraphicsState();
    }

    public void moveTextPositionByAmount(float x, float y) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before moveTextPositionByAmount");
        }
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TEXT_POSITION);
    }

    public void setTextMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before setTextMatrix");
        }
        this.appendRawCommands(this.formatDecimal.format(a));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(b));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(d));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(e));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(f));
        this.appendRawCommands(32);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextMatrix(AffineTransform matrix) throws IOException {
        this.appendMatrix(matrix);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextScaling(double sx, double sy, double tx, double ty) throws IOException {
        this.setTextMatrix(sx, 0.0, 0.0, sy, tx, ty);
    }

    public void setTextTranslation(double tx, double ty) throws IOException {
        this.setTextMatrix(1.0, 0.0, 0.0, 1.0, tx, ty);
    }

    public void setTextRotation(double angle, double tx, double ty) throws IOException {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        this.setTextMatrix(angleCos, angleSin, -angleSin, angleCos, tx, ty);
    }

    public void concatenate2CTM(double a, double b, double c, double d, double e, double f) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(a));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(b));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(d));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(e));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(f));
        this.appendRawCommands(32);
        this.appendRawCommands(CONCATENATE_MATRIX);
    }

    public void concatenate2CTM(AffineTransform at) throws IOException {
        this.appendMatrix(at);
        this.appendRawCommands(CONCATENATE_MATRIX);
    }

    public void drawString(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before drawString");
        }
        COSString string = new COSString(text);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(new String(buffer.toByteArray(), "ISO-8859-1"));
        this.appendRawCommands(32);
        this.appendRawCommands(SHOW_TEXT);
    }

    public void setStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.currentStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_STROKING_COLORSPACE);
    }

    public void setNonStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.currentNonStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_NON_STROKING_COLORSPACE);
    }

    private void writeColorSpace(PDColorSpace colorSpace) throws IOException {
        COSName key = null;
        if (colorSpace instanceof PDDeviceGray || colorSpace instanceof PDDeviceRGB || colorSpace instanceof PDDeviceCMYK) {
            key = COSName.getPDFName(colorSpace.getName());
        } else {
            COSDictionary colorSpaces = (COSDictionary)this.resources.getCOSDictionary().getDictionaryObject(COSName.COLORSPACE);
            if (colorSpaces == null) {
                colorSpaces = new COSDictionary();
                this.resources.getCOSDictionary().setItem(COSName.COLORSPACE, (COSBase)colorSpaces);
            }
            if ((key = colorSpaces.getKeyForValue(colorSpace.getCOSObject())) == null) {
                int counter = 0;
                String csName = "CS";
                while (colorSpaces.containsValue(csName + counter)) {
                    ++counter;
                }
                key = COSName.getPDFName(csName + counter);
                colorSpaces.setItem(key, (COSObjectable)colorSpace);
            }
        }
        key.writePDF(this.output);
        this.appendRawCommands(32);
    }

    public void setStrokingColor(float[] components) throws IOException {
        for (int i = 0; i < components.length; ++i) {
            this.appendRawCommands(this.formatDecimal.format(components[i]));
            this.appendRawCommands(32);
        }
        if (this.currentStrokingColorSpace instanceof PDSeparation || this.currentStrokingColorSpace instanceof PDPattern || this.currentStrokingColorSpace instanceof PDDeviceN || this.currentStrokingColorSpace instanceof PDICCBased) {
            this.appendRawCommands(SET_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_STROKING_COLOR_SIMPLE);
        }
    }

    public void setStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(RG_STROKING);
    }

    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setNonStrokingColor(float[] components) throws IOException {
        for (int i = 0; i < components.length; ++i) {
            this.appendRawCommands(this.formatDecimal.format(components[i]));
            this.appendRawCommands(32);
        }
        if (this.currentNonStrokingColorSpace instanceof PDSeparation || this.currentNonStrokingColorSpace instanceof PDPattern || this.currentNonStrokingColorSpace instanceof PDDeviceN || this.currentNonStrokingColorSpace instanceof PDICCBased) {
            this.appendRawCommands(SET_NON_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_NON_STROKING_COLOR_SIMPLE);
        }
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(RG_NON_STROKING);
    }

    public void setNonStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void setNonStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(RECTANGLE);
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        this.addRect(x, y, width, height);
        this.fill(1);
    }

    public void addBezier312(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_312);
    }

    public void addBezier32(float x2, float y2, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y2));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_32);
    }

    public void addBezier31(float x1, float y1, float x3, float y3) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y1));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x3));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y3));
        this.appendRawCommands(32);
        this.appendRawCommands(BEZIER_313);
    }

    public void moveTo(float x, float y) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
    }

    public void lineTo(float x, float y) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
    }

    public void addLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        this.moveTo(xStart, yStart);
        this.lineTo(xEnd, yEnd);
    }

    public void drawLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        this.addLine(xStart, yStart, xEnd, yEnd);
        this.stroke();
    }

    public void addPolygon(float[] x, float[] y) throws IOException {
        if (x.length != y.length) {
            throw new IOException("Error: some points are missing coordinate");
        }
        for (int i = 0; i < x.length; ++i) {
            if (i == 0) {
                this.moveTo(x[i], y[i]);
                continue;
            }
            this.lineTo(x[i], y[i]);
        }
        this.closeSubPath();
    }

    public void drawPolygon(float[] x, float[] y) throws IOException {
        this.addPolygon(x, y);
        this.stroke();
    }

    public void fillPolygon(float[] x, float[] y) throws IOException {
        this.addPolygon(x, y);
        this.fill(1);
    }

    public void stroke() throws IOException {
        this.appendRawCommands(STROKE);
    }

    public void closeAndStroke() throws IOException {
        this.appendRawCommands(CLOSE_STROKE);
    }

    public void fill(int windingRule) throws IOException {
        if (windingRule == 1) {
            this.appendRawCommands(FILL_NON_ZERO);
        } else if (windingRule == 0) {
            this.appendRawCommands(FILL_EVEN_ODD);
        } else {
            throw new IOException("Error: unknown value for winding rule");
        }
    }

    public void closeSubPath() throws IOException {
        this.appendRawCommands(CLOSE_SUBPATH);
    }

    public void clipPath(int windingRule) throws IOException {
        if (windingRule == 1) {
            this.appendRawCommands(CLIP_PATH_NON_ZERO);
            this.appendRawCommands(NOP);
        } else if (windingRule == 0) {
            this.appendRawCommands(CLIP_PATH_EVEN_ODD);
            this.appendRawCommands(NOP);
        } else {
            throw new IOException("Error: unknown value for winding rule");
        }
    }

    public void setLineWidth(float lineWidth) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(lineWidth));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_WIDTH);
    }

    public void beginMarkedContentSequence(COSName tag) throws IOException {
        this.appendCOSName(tag);
        this.appendRawCommands(32);
        this.appendRawCommands(BMC);
    }

    public void beginMarkedContentSequence(COSName tag, COSName propsName) throws IOException {
        this.appendCOSName(tag);
        this.appendRawCommands(32);
        this.appendCOSName(propsName);
        this.appendRawCommands(32);
        this.appendRawCommands(BDC);
    }

    public void endMarkedContentSequence() throws IOException {
        this.appendRawCommands(EMC);
    }

    public void saveGraphicsState() throws IOException {
        this.appendRawCommands(SAVE_GRAPHICS_STATE);
    }

    public void restoreGraphicsState() throws IOException {
        this.appendRawCommands(RESTORE_GRAPHICS_STATE);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.appendRawCommands(commands.getBytes("ISO-8859-1"));
    }

    public void appendRawCommands(byte[] commands) throws IOException {
        this.output.write(commands);
    }

    public void appendRawCommands(int data) throws IOException {
        this.output.write(data);
    }

    public void appendCOSName(COSName name) throws IOException {
        name.writePDF(this.output);
    }

    private void appendMatrix(AffineTransform transform) throws IOException {
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            this.appendRawCommands(this.formatDecimal.format(v));
            this.appendRawCommands(32);
        }
    }

    public void close() throws IOException {
        this.output.close();
    }
}

