/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class IcoEncoder {
    private static byte ICON_SIZE = (byte)32;
    private static byte NUM_COLORS = 0;
    private static int BYTE_SIZE = 8;
    private OutputStream _outputStream;
    private Image _awtImage;

    private IcoEncoder(OutputStream outputStream, Image image) {
        this._outputStream = new BufferedOutputStream(outputStream, 8192);
        this._awtImage = image;
    }

    public static String getIconPath(LaunchDesc launchDesc) {
        return IcoEncoder.getIconPath(launchDesc, true);
    }

    public static String getIconPath(LaunchDesc launchDesc, boolean bl) {
        int n = bl ? 1 : 0;
        IconDesc iconDesc = launchDesc.getInformation().getIconLocation(n, 5);
        if (iconDesc == null) {
            iconDesc = launchDesc.getInformation().getIconLocation(n, 0);
        }
        if (iconDesc != null) {
            return IcoEncoder.getIconPath(iconDesc.getLocation(), iconDesc.getVersion());
        }
        return null;
    }

    public static String getIconPath(URL uRL, String string) {
        try {
            File file = DownloadEngine.getCachedShortcutImage((URL)uRL, (String)string);
            if (file == null) {
                file = DownloadEngine.getUpdatedShortcutImage((URL)uRL, (String)string);
            }
            File file2 = null;
            String string2 = null;
            if (file == null) {
                return null;
            }
            if (Config.getInstance().isPlatformIconType(uRL.toString())) {
                file2 = file;
            } else {
                string2 = file.getPath() + ".ico";
                file2 = new File(string2);
            }
            if (file2 == null || !file2.exists()) {
                file2 = null;
                Image image = ImageLoader.getInstance().loadImage(file.getPath());
                file2 = IcoEncoder.saveICOfile(image, string2);
                Trace.println((String)("ico file generated: " + file2), (TraceLevel)TraceLevel.BASIC);
            }
            if (file2 != null) {
                return file2.getPath();
            }
        }
        catch (IOException iOException) {
            Trace.println((String)("exception creating BMP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
        return null;
    }

    private void flush() {
        try {
            if (this._outputStream != null) {
                this._outputStream.flush();
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
    }

    private static File saveICOfile(Image image, String string) {
        FileOutputStream fileOutputStream = null;
        File file = new File(string);
        try {
            fileOutputStream = new FileOutputStream(file);
            IcoEncoder icoEncoder = new IcoEncoder(fileOutputStream, image);
            icoEncoder.encode();
            icoEncoder.flush();
            fileOutputStream.close();
            return file;
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (file != null) {
                file.delete();
            }
            return null;
        }
    }

    private void createBitmap() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 32;
        int n7 = 32;
        int n8 = 0;
        int[] nArray = new int[n6 * n7];
        byte[] byArray = new byte[n6 * n7 * 3];
        byte[] byArray2 = new byte[n6 * n7 * 3];
        byte[] byArray3 = new byte[n6 * 4];
        byte[] byArray4 = new byte[n6 * 4];
        PixelGrabber pixelGrabber = new PixelGrabber(this._awtImage.getScaledInstance(32, 32, 1), 0, 0, n6, n7, nArray, 0, n6);
        try {
            if (pixelGrabber.grabPixels()) {
                Trace.println((String)"pixels grabbed successfully", (TraceLevel)TraceLevel.TEMP);
            } else {
                Trace.println((String)"cannot grab pixels!", (TraceLevel)TraceLevel.TEMP);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (n5 = 0; n5 < n6 * n7; ++n5) {
            n4 = nArray[n5] >> 24 & 0xFF;
            n3 = nArray[n5] >> 16 & 0xFF;
            n2 = nArray[n5] >> 8 & 0xFF;
            n = nArray[n5] & 0xFF;
            if (n4 != 0) {
                // empty if block
            }
            if (++n12 == 32) {
                n12 = 0;
            }
            if (n4 == 0) {
                n9 = (byte)(n9 | 128 >> n11);
            }
            if (++n11 == 8) {
                byArray3[n10++] = n9;
                n9 = 0;
                n11 = 0;
            }
            byArray[n8++] = (byte)n;
            byArray[n8++] = (byte)n2;
            byArray[n8++] = (byte)n3;
        }
        n5 = 0;
        for (n4 = 0; n4 < 128; ++n4) {
            for (n3 = 0; n3 < 8; n3 = (int)((byte)(n3 + 1))) {
                if ((byArray3[n4] & 128 >> n3) == 0) continue;
            }
            if (++n5 != 4) continue;
            n5 = 0;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            n3 = n2 * n6 * 3;
            n4 = (n7 - n2 - 1) * n6 * 3;
            for (n = 0; n < n6 * 3; ++n) {
                byArray2[n3 + n] = byArray[n4 + n];
            }
            n3 = n2 * (n6 / 8);
            n4 = (n7 - n2 - 1) * (n6 / 8);
            for (n = 0; n < n6 / 8; ++n) {
                byArray4[n3 + n] = byArray3[n4 + n];
            }
        }
        this._outputStream.write(byArray2);
        this._outputStream.write(byArray4);
    }

    public void encode() {
        this.writeIcoHeader();
        this.writeIconDirEntry();
        try {
            this.writeInfoHeader(40, 24);
            this.createBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(32);
        this.writeDWord(64);
        this.writeWord(1);
        this.writeWord(n2);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
    }

    private void writeIconDirEntry() {
        try {
            int n = ICON_SIZE;
            this._outputStream.write(n);
            this._outputStream.write(n);
            n = NUM_COLORS;
            this._outputStream.write(n);
            n = 0;
            this._outputStream.write(n);
            n = 1;
            this.writeWord(n);
            n = 24;
            this.writeWord(n);
            int n2 = 3240;
            this.writeDWord(n2);
            int n3 = 22;
            this.writeDWord(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeIcoHeader() {
        try {
            int n = 0;
            this.writeWord(n);
            n = 1;
            this.writeWord(n);
            this.writeWord(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeWord(int n) throws IOException {
        this._outputStream.write(n & 0xFF);
        this._outputStream.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this._outputStream.write(n & 0xFF);
        this._outputStream.write((n & 0xFF00) >> 8);
        this._outputStream.write((n & 0xFF0000) >> 16);
        this._outputStream.write((n & 0xFF000000) >> 24);
    }
}

