/*
 * Decompiled with CFR 0.152.
 */
package com.solucionfactible.ws.cfdi;

import com.solucionfactible.ws.cfdi.CFDIPortType;
import com.solucionfactible.ws.cfdi.CFDISoap11BindingStub;
import com.solucionfactible.ws.cfdi.CFDISoap12BindingStub;
import com.solucionfactible.ws.cfdi.CFDI_Service;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class CFDI_ServiceLocator
extends Service
implements CFDI_Service {
    private String CFDIHttpsSoap12Endpoint_address = "https://solucionfactible.com/ws/services/CFDI.CFDIHttpsSoap12Endpoint/";
    private String CFDIHttpsSoap12EndpointWSDDServiceName = "CFDIHttpsSoap12Endpoint";
    private String CFDIHttpsSoap11Endpoint_address = "https://solucionfactible.com/ws/services/CFDI.CFDIHttpsSoap11Endpoint/";
    private String CFDIHttpsSoap11EndpointWSDDServiceName = "CFDIHttpsSoap11Endpoint";
    private HashSet ports = null;

    public CFDI_ServiceLocator() {
    }

    public CFDI_ServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public CFDI_ServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getCFDIHttpsSoap12EndpointAddress() {
        return this.CFDIHttpsSoap12Endpoint_address;
    }

    public String getCFDIHttpsSoap12EndpointWSDDServiceName() {
        return this.CFDIHttpsSoap12EndpointWSDDServiceName;
    }

    public void setCFDIHttpsSoap12EndpointWSDDServiceName(String name) {
        this.CFDIHttpsSoap12EndpointWSDDServiceName = name;
    }

    @Override
    public CFDIPortType getCFDIHttpsSoap12Endpoint() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.CFDIHttpsSoap12Endpoint_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException(e);
        }
        return this.getCFDIHttpsSoap12Endpoint(endpoint);
    }

    @Override
    public CFDIPortType getCFDIHttpsSoap12Endpoint(URL portAddress) throws ServiceException {
        try {
            CFDISoap12BindingStub _stub = new CFDISoap12BindingStub(portAddress, this);
            _stub.setPortName(this.getCFDIHttpsSoap12EndpointWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setCFDIHttpsSoap12EndpointEndpointAddress(String address) {
        this.CFDIHttpsSoap12Endpoint_address = address;
    }

    @Override
    public String getCFDIHttpsSoap11EndpointAddress() {
        return this.CFDIHttpsSoap11Endpoint_address;
    }

    public String getCFDIHttpsSoap11EndpointWSDDServiceName() {
        return this.CFDIHttpsSoap11EndpointWSDDServiceName;
    }

    public void setCFDIHttpsSoap11EndpointWSDDServiceName(String name) {
        this.CFDIHttpsSoap11EndpointWSDDServiceName = name;
    }

    @Override
    public CFDIPortType getCFDIHttpsSoap11Endpoint() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.CFDIHttpsSoap11Endpoint_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException(e);
        }
        return this.getCFDIHttpsSoap11Endpoint(endpoint);
    }

    @Override
    public CFDIPortType getCFDIHttpsSoap11Endpoint(URL portAddress) throws ServiceException {
        try {
            CFDISoap11BindingStub _stub = new CFDISoap11BindingStub(portAddress, this);
            _stub.setPortName(this.getCFDIHttpsSoap11EndpointWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setCFDIHttpsSoap11EndpointEndpointAddress(String address) {
        this.CFDIHttpsSoap11Endpoint_address = address;
    }

    @Override
    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (CFDIPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                CFDISoap12BindingStub _stub = new CFDISoap12BindingStub(new URL(this.CFDIHttpsSoap12Endpoint_address), this);
                _stub.setPortName(this.getCFDIHttpsSoap12EndpointWSDDServiceName());
                return _stub;
            }
            if (CFDIPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                CFDISoap11BindingStub _stub = new CFDISoap11BindingStub(new URL(this.CFDIHttpsSoap11Endpoint_address), this);
                _stub.setPortName(this.getCFDIHttpsSoap11EndpointWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    @Override
    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("CFDIHttpsSoap12Endpoint".equals(inputPortName)) {
            return this.getCFDIHttpsSoap12Endpoint();
        }
        if ("CFDIHttpsSoap11Endpoint".equals(inputPortName)) {
            return this.getCFDIHttpsSoap11Endpoint();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)((Object)_stub)).setPortName(portName);
        return _stub;
    }

    @Override
    public QName getServiceName() {
        return new QName("http://cfdi.ws.erp.f.s", "CFDI");
    }

    @Override
    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://cfdi.ws.erp.f.s", "CFDIHttpsSoap12Endpoint"));
            this.ports.add(new QName("http://cfdi.ws.erp.f.s", "CFDIHttpsSoap11Endpoint"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if ("CFDIHttpsSoap12Endpoint".equals(portName)) {
            this.setCFDIHttpsSoap12EndpointEndpointAddress(address);
        } else if ("CFDIHttpsSoap11Endpoint".equals(portName)) {
            this.setCFDIHttpsSoap11EndpointEndpointAddress(address);
        } else {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

